/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.resources.ScreenSize;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.dom.ActivityAttributesSnapshot;
import com.android.tools.idea.configurations.MainManifestIndexNotReadyException;
import com.android.tools.idea.configurations.ThemeUtils;
import com.android.tools.idea.model.AndroidManifestIndexQueryUtils;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.android.tools.idea.util.DumbServiceUtilKt;
import com.android.tools.module.AndroidModuleInfo;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.util.SlowOperations;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0006\u001a\u0010\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b*\u00020\u0006\u001a\u0014\u0010\t\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\n\u001a\u00020\u0005\u001a\u0012\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f*\u00020\u0006\u001a+\u0010\u000e\u001a\u0004\u0018\u0001H\u000f\"\u0004\b\u0000\u0010\u000f*\u00020\u00062\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u0002H\u000f0\u0001\u00a2\u0006\u0002\u0010\u0012\u001a(\u0010\u0013\u001a\u00020\u0005*\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u001a.\u0010\u0013\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\"\u0010\u0000\"\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a8\u0006\u001c"}, d2={"ThemeStyleFilter", "Lkotlin/Function1;", "Lcom/android/tools/idea/editors/theme/datamodels/ConfiguredThemeEditorStyle;", "", "getAppThemeName", "", "Lcom/intellij/openapi/module/Module;", "getAllActivityThemeNames", "", "getThemeNameForActivity", "activityFqcn", "safeQueryActivitiesFromManifestIndex", "", "Lcom/android/tools/idea/run/activity/DefaultActivityLocator$ActivityWrapper;", "safeQueryManifestIndex", "T", "manifestIndexQueryAction", "Lorg/jetbrains/android/facet/AndroidFacet;", "(Lcom/intellij/openapi/module/Module;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getDeviceDefaultTheme", "renderingTarget", "Lcom/android/sdklib/IAndroidTarget;", "screenSize", "Lcom/android/resources/ScreenSize;", "device", "Lcom/android/sdklib/devices/Device;", "moduleInfo", "Lcom/android/tools/module/AndroidModuleInfo;", "intellij.android.core"})
@JvmName(name="ThemeUtils")
@SourceDebugExtension(value={"SMAP\nThemeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThemeUtils.kt\ncom/android/tools/idea/configurations/ThemeUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,242:1\n1#2:243\n*E\n"})
public final class ThemeUtils {
    @Nullable
    public static final String getAppThemeName(@NotNull Module $this$getAppThemeName) {
        Intrinsics.checkNotNullParameter((Object)$this$getAppThemeName, (String)"<this>");
        try {
            AndroidFacet facet = AndroidFacet.getInstance((Module)$this$getAppThemeName);
            if (facet != null) {
                Project project = $this$getAppThemeName.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                return (String)DumbServiceUtilKt.uiSafeRunReadActionInSmartMode(project, () -> ThemeUtils.getAppThemeName$lambda$0(facet));
            }
        }
        catch (MainManifestIndexNotReadyException facet) {
        }
        catch (IndexNotReadyException e) {
            AndroidManifestIndexQueryUtils.logManifestIndexQueryError((Exception)((Object)e));
        }
        return MergedManifestManager.Companion.getFreshSnapshot($this$getAppThemeName).getManifestTheme();
    }

    @NotNull
    public static final Set<String> getAllActivityThemeNames(@NotNull Module $this$getAllActivityThemeNames) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllActivityThemeNames, (String)"<this>");
        List<DefaultActivityLocator.ActivityWrapper> activities = ThemeUtils.safeQueryActivitiesFromManifestIndex($this$getAllActivityThemeNames);
        if (activities != null) {
            return SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)activities), (Function1)getAllActivityThemeNames.1.INSTANCE));
        }
        MergedManifestSnapshot manifest = MergedManifestManager.Companion.getSnapshot($this$getAllActivityThemeNames);
        return SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)manifest.getActivityAttributesMap().values()), (Function1)getAllActivityThemeNames.2.INSTANCE));
    }

    @Nullable
    public static final String getThemeNameForActivity(@NotNull Module $this$getThemeNameForActivity, @NotNull String activityFqcn) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$getThemeNameForActivity, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)activityFqcn, (String)"activityFqcn");
        List<DefaultActivityLocator.ActivityWrapper> activities = ThemeUtils.safeQueryActivitiesFromManifestIndex($this$getThemeNameForActivity);
        if (activities != null) {
            return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)activities), arg_0 -> ThemeUtils.getThemeNameForActivity$lambda$0(activityFqcn, arg_0)), (Function1)getThemeNameForActivity.2.INSTANCE), ThemeUtils::getThemeNameForActivity$lambda$1));
        }
        MergedManifestSnapshot manifest = MergedManifestManager.Companion.getSnapshot($this$getThemeNameForActivity);
        ActivityAttributesSnapshot activityAttributesSnapshot = manifest.getActivityAttributes(activityFqcn);
        if (activityAttributesSnapshot != null && (string2 = activityAttributesSnapshot.getTheme()) != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            string = StringsKt.startsWith$default((String)it, (String)"@", (boolean)false, (int)2, null) ? string3 : null;
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public static final List<DefaultActivityLocator.ActivityWrapper> safeQueryActivitiesFromManifestIndex(@NotNull Module $this$safeQueryActivitiesFromManifestIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$safeQueryActivitiesFromManifestIndex, (String)"<this>");
        return (List)ThemeUtils.safeQueryManifestIndex($this$safeQueryActivitiesFromManifestIndex, ThemeUtils::safeQueryActivitiesFromManifestIndex$lambda$0);
    }

    @Nullable
    public static final <T> T safeQueryManifestIndex(@NotNull Module $this$safeQueryManifestIndex, @NotNull Function1<? super AndroidFacet, ? extends T> manifestIndexQueryAction) {
        Intrinsics.checkNotNullParameter((Object)$this$safeQueryManifestIndex, (String)"<this>");
        Intrinsics.checkNotNullParameter(manifestIndexQueryAction, (String)"manifestIndexQueryAction");
        try {
            AndroidFacet facet = AndroidFacet.getInstance((Module)$this$safeQueryManifestIndex);
            if (facet != null) {
                Project project = $this$safeQueryManifestIndex.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                return DumbServiceUtilKt.uiSafeRunReadActionInSmartMode(project, () -> ThemeUtils.safeQueryManifestIndex$lambda$0(facet, manifestIndexQueryAction));
            }
        }
        catch (MainManifestIndexNotReadyException facet) {
        }
        catch (IndexNotReadyException e) {
            AndroidManifestIndexQueryUtils.logManifestIndexQueryError((Exception)((Object)e));
        }
        return null;
    }

    @NotNull
    public static final String getDeviceDefaultTheme(@NotNull Module $this$getDeviceDefaultTheme, @Nullable IAndroidTarget renderingTarget, @Nullable ScreenSize screenSize, @Nullable Device device2) {
        AndroidModuleInfo androidModuleInfo;
        Intrinsics.checkNotNullParameter((Object)$this$getDeviceDefaultTheme, (String)"<this>");
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)$this$getDeviceDefaultTheme);
        if (androidFacet != null) {
            AndroidFacet it = androidFacet;
            boolean bl = false;
            androidModuleInfo = StudioAndroidModuleInfo.getInstance(it);
        } else {
            androidModuleInfo = null;
        }
        AndroidModuleInfo moduleInfo = androidModuleInfo;
        return ThemeUtils.getDeviceDefaultTheme(moduleInfo, renderingTarget, screenSize, device2);
    }

    @NotNull
    public static final String getDeviceDefaultTheme(@Nullable AndroidModuleInfo moduleInfo, @Nullable IAndroidTarget renderingTarget, @Nullable ScreenSize screenSize, @Nullable Device device2) {
        if (device2 != null) {
            if (Device.isWear((Device)device2)) {
                return "@android:style/Theme.DeviceDefault";
            }
            if (Device.isTv((Device)device2)) {
                return "@style/Theme.Leanback";
            }
        }
        if (moduleInfo == null) {
            return "@android:style/Theme.Material.Light";
        }
        int targetOrMinSdk = Math.max(moduleInfo.getTargetSdkVersion().getApiLevel(), moduleInfo.getMinSdkVersion().getApiLevel());
        IAndroidTarget iAndroidTarget = renderingTarget;
        int renderingTargetSdk = iAndroidTarget != null && (iAndroidTarget = iAndroidTarget.getVersion()) != null ? iAndroidTarget.getApiLevel() : targetOrMinSdk;
        int apiLevel = RangesKt.coerceAtMost((int)targetOrMinSdk, (int)renderingTargetSdk);
        return "@android:style/" + (apiLevel >= 21 ? "Theme.Material.Light" : (apiLevel >= 14 || apiLevel >= 11 && screenSize == ScreenSize.XLARGE ? "Theme.Holo" : "Theme"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getAppThemeName$lambda$0(AndroidFacet $facet) {
        String string;
        AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.knownIssue((String)"b/448322683");
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            if (!AndroidManifestIndexQueryUtils.queryIsMainManifestIndexReady($facet)) {
                throw new MainManifestIndexNotReadyException();
            }
            string = AndroidManifestIndexQueryUtils.queryApplicationThemeFromManifestIndex($facet);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return string;
    }

    private static final boolean getThemeNameForActivity$lambda$0(String $activityFqcn, DefaultActivityLocator.ActivityWrapper it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)$activityFqcn);
    }

    private static final boolean getThemeNameForActivity$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.startsWith$default((String)it, (String)"@", (boolean)false, (int)2, null);
    }

    private static final List safeQueryActivitiesFromManifestIndex$lambda$0(AndroidFacet facet) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        return AndroidManifestIndexQueryUtils.queryActivitiesFromManifestIndex(facet).getActivities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object safeQueryManifestIndex$lambda$0(AndroidFacet $facet, Function1 $manifestIndexQueryAction) {
        Object object;
        AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.knownIssue((String)"b/448322683");
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            if (!AndroidManifestIndexQueryUtils.queryIsMainManifestIndexReady($facet)) {
                throw new MainManifestIndexNotReadyException();
            }
            object = $manifestIndexQueryAction.invoke((Object)$facet);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return object;
    }
}

