/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.tools.configurations.Configuration;
import com.android.tools.configurations.ConfigurationModelModule;
import com.android.tools.idea.configurations.CanonicalDeviceType;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.DeviceGroup;
import com.android.tools.idea.configurations.ReferenceDeviceType;
import com.android.tools.idea.configurations.StudioConfigurationModelModule;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.dom.manifest.AndroidManifestUtils;
import org.jetbrains.android.dom.manifest.AndroidManifestXmlFile;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00052\u0006\u0010\u000b\u001a\u00020\u0002\u001a&\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b\u001a\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b\u001a\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bH\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007\u001a*\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00052\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u0018\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u001d\u001a*\u0010\u001b\u001a\u0004\u0018\u00010\b2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00052\u0006\u0010\u0019\u001a\u00020\u001d\u001a\u000e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0002\"\u00a3\u0001\u0010\u0000\u001a\u0096\u0001\u0012\u000e\u0012\f0\u0002\u00a2\u0006\u0002\b\u0003\u00a2\u0006\u0002\b\u0004\u00120\u0012.\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007 \t*\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\u00050\u0005 \t*I\u0012\u000e\u0012\f0\u0002\u00a2\u0006\u0002\b\u0003\u00a2\u0006\u0002\b\u0004\u00120\u0012.\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007 \t*\u0016\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0018\u00010\u00050\u00050\u0005\u00a2\u0006\u0002\b\u00030\u0001\u00a2\u0006\u0002\b\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0014X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001e\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001f\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010 \u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010!\u001a\u00020\u0014X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"DEVICE_CACHES", "", "Lcom/android/tools/configurations/Configuration;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "Lcom/android/tools/idea/configurations/DeviceGroup;", "", "Lcom/android/sdklib/devices/Device;", "kotlin.jvm.PlatformType", "getSuitableDevices", "configuration", "groupDevices", "devices", "isCanonicalDevice", "", "device", "isReferenceDevice", "sizeGroupNexus", "WEAR_OS_USE_FEATURE_TAG", "", "isUseWearDeviceAsDefault", "module", "Lcom/intellij/openapi/module/Module;", "getCanonicalDevice", "type", "Lcom/android/tools/idea/configurations/CanonicalDeviceType;", "getReferenceDevice", "config", "Lcom/android/tools/idea/configurations/ReferenceDeviceType;", "DEVICE_CLASS_PHONE_TOOLTIP", "DEVICE_CLASS_FOLDABLE_TOOLTIP", "DEVICE_CLASS_TABLET_TOOLTIP", "DEVICE_CLASS_DESKTOP_TOOLTIP", "intellij.android.core"})
@JvmName(name="DeviceUtils")
@SourceDebugExtension(value={"SMAP\nDeviceUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceUtils.kt\ncom/android/tools/idea/configurations/DeviceUtils\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,220:1\n382#2,7:221\n382#2,7:236\n827#3:228\n855#3,2:229\n1068#3:231\n1491#3:232\n1516#3,3:233\n1519#3,3:243\n295#3,2:246\n295#3,2:248\n295#3,2:250\n295#3,2:252\n295#3,2:254\n*S KotlinDebug\n*F\n+ 1 DeviceUtils.kt\ncom/android/tools/idea/configurations/DeviceUtils\n*L\n70#1:221,7\n95#1:236,7\n93#1:228\n93#1:229,2\n94#1:231\n95#1:232\n95#1:233,3\n95#1:243,3\n175#1:246,2\n196#1:248,2\n198#1:250,2\n200#1:252,2\n202#1:254,2\n*E\n"})
public final class DeviceUtils {
    @NotNull
    private static final Map<Configuration, Map<DeviceGroup, List<Device>>> DEVICE_CACHES;
    @NotNull
    private static final String WEAR_OS_USE_FEATURE_TAG = "android.hardware.type.watch";
    @NotNull
    public static final String DEVICE_CLASS_PHONE_TOOLTIP = "This reference device uses the COMPACT width size class, which represents 99% of Android phones in portrait orientation.";
    @NotNull
    public static final String DEVICE_CLASS_FOLDABLE_TOOLTIP = "This reference device uses the MEDIUM width size class, which represents foldables in unfolded portrait orientation, or 94% of all tablets in portrait orientation.";
    @NotNull
    public static final String DEVICE_CLASS_TABLET_TOOLTIP = "This reference device uses the EXPANDED width size class, which represents 97% of Android tablets in landscape orientation.";
    @NotNull
    public static final String DEVICE_CLASS_DESKTOP_TOOLTIP = "This reference device uses the EXPANDED width size class, which represents 97% of Android desktops in landscape orientation.";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<DeviceGroup, List<Device>> getSuitableDevices(@NotNull Configuration configuration2) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Map<Configuration, Map<DeviceGroup, List<Device>>> map2 = DEVICE_CACHES;
        Configuration key$iv = configuration2;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            return DeviceUtils.groupDevices((List)configuration2.getSettings().getDevices());
        }
        return (Map)value$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<DeviceGroup, List<Device>> groupDevices(@NotNull List<Device> devices2) {
        void $this$groupByTo$iv$iv;
        Device it;
        Iterable $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(devices2, (String)"devices");
        Iterable $this$filterNot$iv = devices2;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Device)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)"Custom", (Object)it.getId()) || ConfigurationManager.isAvdDevice(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        List sorted = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Device it = (Device)b;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getDisplayName());
                it = (Device)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getDisplayName())));
            }
        });
        Iterable $this$groupBy$iv = sorted;
        boolean $i$f$groupBy = false;
        $this$filterNotTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (Device)element$iv$iv;
            boolean bl = false;
            DeviceGroup key$iv$iv = DeviceUtils.isCanonicalDevice(it) ? DeviceGroup.CANONICAL_DEVICE : (DeviceUtils.isReferenceDevice(it) ? DeviceGroup.ADDITIONAL_DEVICE : (Device.isAutomotive((Device)it) ? DeviceGroup.AUTOMOTIVE : (Device.isWear((Device)it) ? DeviceGroup.WEAR : (Device.isDesktop((Device)it) ? DeviceGroup.DESKTOP : (Device.isTv((Device)it) ? DeviceGroup.TV : (Device.isXr((Device)it) ? DeviceGroup.XR : (HardwareConfigHelper.isNexus((Device)it) && !Intrinsics.areEqual((Object)it.getManufacturer(), (Object)"Generic") ? DeviceUtils.sizeGroupNexus(it) : (Device.isMobile((Device)it) && Intrinsics.areEqual((Object)it.getManufacturer(), (Object)"Generic") ? DeviceGroup.GENERIC : DeviceGroup.OTHER))))))));
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return MapsKt.toSortedMap((Map)destination$iv$iv);
    }

    public static final boolean isCanonicalDevice(@NotNull Device device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        String id2 = device2.getId();
        return Intrinsics.areEqual((Object)id2, (Object)"SmallPhone") || Intrinsics.areEqual((Object)id2, (Object)"MediumPhone") || Intrinsics.areEqual((Object)id2, (Object)"MediumTablet");
    }

    public static final boolean isReferenceDevice(@NotNull Device device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        String id2 = device2.getId();
        return Intrinsics.areEqual((Object)id2, (Object)"_device_class_phone") || Intrinsics.areEqual((Object)id2, (Object)"_device_class_foldable") || Intrinsics.areEqual((Object)id2, (Object)"_device_class_tablet") || Intrinsics.areEqual((Object)id2, (Object)"_device_class_desktop");
    }

    private static final DeviceGroup sizeGroupNexus(Device device2) {
        Screen screen = device2.getDefaultHardware().getScreen();
        double diagonalLength = !screen.isFoldable() ? screen.getDiagonalLength() : Math.hypot((double)screen.getFoldedWidth() / (double)screen.getPixelDensity().getDpiValue(), (double)screen.getFoldedHeight() / (double)screen.getPixelDensity().getDpiValue());
        return diagonalLength < 5.0 ? DeviceGroup.NEXUS : (diagonalLength < 7.0 ? DeviceGroup.NEXUS_XL : DeviceGroup.NEXUS_TABLET);
    }

    @Slow
    public static final boolean isUseWearDeviceAsDefault(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet == null || facet.isDisposed()) {
            return false;
        }
        AndroidManifestXmlFile androidManifestXmlFile = (AndroidManifestXmlFile)ActionsKt.runReadAction(() -> DeviceUtils.isUseWearDeviceAsDefault$lambda$0(facet));
        if (androidManifestXmlFile == null) {
            return false;
        }
        AndroidManifestXmlFile manifestXml = androidManifestXmlFile;
        return ((Collection)ActionsKt.runReadAction(() -> DeviceUtils.isUseWearDeviceAsDefault$lambda$1(manifestXml))).contains(WEAR_OS_USE_FEATURE_TAG);
    }

    @Nullable
    public static final Device getCanonicalDevice(@NotNull Map<DeviceGroup, ? extends List<Device>> devices2, @NotNull CanonicalDeviceType type) {
        Device device2;
        Intrinsics.checkNotNullParameter(devices2, (String)"devices");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        List<Device> list2 = devices2.get((Object)DeviceGroup.CANONICAL_DEVICE);
        if (list2 != null) {
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = list2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Device it = (Device)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)type.getId())) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            device2 = v1;
        } else {
            device2 = null;
        }
        return device2;
    }

    @Nullable
    public static final Device getReferenceDevice(@NotNull Configuration config, @NotNull ReferenceDeviceType type) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return DeviceUtils.getReferenceDevice(DeviceUtils.getSuitableDevices(config), type);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Device getReferenceDevice(@NotNull Map<DeviceGroup, ? extends List<Device>> devices, @NotNull ReferenceDeviceType type) {
        Intrinsics.checkNotNullParameter(devices, (String)"devices");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                v0 = devices.get((Object)DeviceGroup.ADDITIONAL_DEVICE);
                if (v0 == null) ** GOTO lbl18
                $this$firstOrNull$iv = v0;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (Device)element$iv;
                    $i$a$-firstOrNull-DeviceUtils$getReferenceDevice$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"_device_class_phone")) continue;
                    v1 = element$iv;
                    ** GOTO lbl16
                }
                v1 = null;
lbl16:
                // 2 sources

                v2 = v1;
                break;
lbl18:
                // 1 sources

                v2 = null;
                break;
            }
            case 2: {
                v3 = devices.get((Object)DeviceGroup.ADDITIONAL_DEVICE);
                if (v3 == null) ** GOTO lbl34
                $this$firstOrNull$iv = v3;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (Device)element$iv;
                    $i$a$-firstOrNull-DeviceUtils$getReferenceDevice$2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"_device_class_foldable")) continue;
                    v4 = element$iv;
                    ** GOTO lbl32
                }
                v4 = null;
lbl32:
                // 2 sources

                v2 = v4;
                break;
lbl34:
                // 1 sources

                v2 = null;
                break;
            }
            case 3: {
                v5 = devices.get((Object)DeviceGroup.ADDITIONAL_DEVICE);
                if (v5 == null) ** GOTO lbl50
                $this$firstOrNull$iv = v5;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (Device)element$iv;
                    $i$a$-firstOrNull-DeviceUtils$getReferenceDevice$3 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"_device_class_tablet")) continue;
                    v6 = element$iv;
                    ** GOTO lbl48
                }
                v6 = null;
lbl48:
                // 2 sources

                v2 = v6;
                break;
lbl50:
                // 1 sources

                v2 = null;
                break;
            }
            case 4: {
                v7 = devices.get((Object)DeviceGroup.ADDITIONAL_DEVICE);
                if (v7 == null) ** GOTO lbl66
                $this$firstOrNull$iv = v7;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (Device)element$iv;
                    $i$a$-firstOrNull-DeviceUtils$getReferenceDevice$4 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"_device_class_desktop")) continue;
                    v8 = element$iv;
                    ** GOTO lbl64
                }
                v8 = null;
lbl64:
                // 2 sources

                v2 = v8;
                break;
lbl66:
                // 1 sources

                v2 = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return v2;
    }

    public static final boolean isUseWearDeviceAsDefault(@NotNull Configuration configuration2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        ConfigurationModelModule configurationModelModule = configuration2.getConfigModule();
        Intrinsics.checkNotNull((Object)configurationModelModule, (String)"null cannot be cast to non-null type com.android.tools.idea.configurations.StudioConfigurationModelModule");
        Module module = ((StudioConfigurationModelModule)configurationModelModule).getModule();
        return DeviceUtils.isUseWearDeviceAsDefault(module);
    }

    private static final AndroidManifestXmlFile isUseWearDeviceAsDefault$lambda$0(AndroidFacet $facet) {
        return AndroidManifestUtils.getPrimaryManifestXml($facet);
    }

    private static final Collection isUseWearDeviceAsDefault$lambda$1(AndroidManifestXmlFile $manifestXml) {
        return $manifestXml.getUsesFeature();
    }

    static {
        Map map2 = ContainerUtil.createSoftMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createSoftMap(...)");
        DEVICE_CACHES = map2;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReferenceDeviceType.values().length];
            try {
                nArray[ReferenceDeviceType.MEDIUM_PHONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReferenceDeviceType.FOLDABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReferenceDeviceType.MEDIUM_TABLET.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReferenceDeviceType.DESKTOP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

