/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.codenavigation;

import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.idea.codenavigation.NavSource;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.ClassUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/codenavigation/PsiOuterClassAndLine;", "Lcom/android/tools/idea/codenavigation/NavSource;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "manager", "Lcom/intellij/psi/PsiManager;", "Lorg/jetbrains/annotations/NotNull;", "lookUp", "Lcom/intellij/pom/Navigatable;", "location", "Lcom/android/tools/idea/codenavigation/CodeLocation;", "arch", "", "codenavigation"})
public final class PsiOuterClassAndLine
implements NavSource {
    @NotNull
    private final Project project;
    @NotNull
    private final PsiManager manager;

    public PsiOuterClassAndLine(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        PsiManager psiManager = PsiManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        this.manager = psiManager;
    }

    @Override
    @Nullable
    public Navigatable lookUp(@NotNull CodeLocation location, @Nullable String arch) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        CharSequence charSequence = location.getClassName();
        if (charSequence == null || charSequence.length() == 0 || location.getLineNumber() == -1) {
            return null;
        }
        PsiClass psiClass = ClassUtil.findPsiClassByJVMName((PsiManager)this.manager, (String)location.getOuterClass());
        if (psiClass == null) {
            return null;
        }
        PsiClass outerClass = psiClass;
        return (Navigatable)new OpenFileDescriptor(this.project, outerClass.getNavigationElement().getContainingFile().getVirtualFile(), location.getLineNumber(), 0);
    }
}

