/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.backup;

import com.android.backup.BackupService;
import com.android.tools.idea.backup.BackupBundle;
import com.android.tools.idea.backup.BackupFileTextField;
import com.android.tools.idea.backup.RestoreRunConfigSectionKt;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.RunConfigSection;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.util.PathExtensionsKt;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.observable.properties.GraphProperty;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.observable.properties.PropertyGraph;
import com.intellij.openapi.project.Project;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\fH\u0016J\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 *\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/backup/RestoreRunConfigSection;", "Lcom/android/tools/idea/run/RunConfigSection;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "projectSystem", "Lcom/android/tools/idea/projectsystem/AndroidProjectSystem;", "propertyGraph", "Lcom/intellij/openapi/observable/properties/PropertyGraph;", "restoreApp", "Lcom/intellij/openapi/observable/properties/GraphProperty;", "", "freshInstall", "backupFile", "", "restoreSupported", "getComponent", "Ljava/awt/Component;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "resetFrom", "", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "applyTo", "validate", "", "Lcom/android/tools/idea/run/ValidationError;", "updateBasedOnInstantState", "instantAppDeploy", "backupFileChooser", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/android/tools/idea/backup/BackupFileTextField;", "Lcom/intellij/ui/dsl/builder/Row;", "width", "", "intellij.android.backup"})
public final class RestoreRunConfigSection
implements RunConfigSection {
    @NotNull
    private final Project project;
    @NotNull
    private final AndroidProjectSystem projectSystem;
    @NotNull
    private final PropertyGraph propertyGraph;
    @NotNull
    private final GraphProperty<Boolean> restoreApp;
    @NotNull
    private final GraphProperty<Boolean> freshInstall;
    @NotNull
    private GraphProperty<String> backupFile;
    @NotNull
    private GraphProperty<Boolean> restoreSupported;

    public RestoreRunConfigSection(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.projectSystem = ProjectSystemUtil.getProjectSystem(this.project);
        this.propertyGraph = new PropertyGraph(null, false, 3, null);
        this.restoreApp = this.propertyGraph.property((Object)false);
        this.freshInstall = this.propertyGraph.property((Object)false);
        this.backupFile = this.propertyGraph.property((Object)"");
        this.restoreSupported = this.propertyGraph.property((Object)true);
    }

    @Override
    @NotNull
    public Component getComponent(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        return (Component)BuilderKt.panel(arg_0 -> RestoreRunConfigSection.getComponent$lambda$0(this, arg_0));
    }

    @Override
    public void resetFrom(@NotNull RunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        AndroidRunConfiguration androidRunConfiguration = runConfiguration instanceof AndroidRunConfiguration ? (AndroidRunConfiguration)runConfiguration : null;
        if (androidRunConfiguration == null) {
            return;
        }
        AndroidRunConfiguration config = androidRunConfiguration;
        this.restoreSupported.set((Object)config.DEPLOY_AS_INSTANT);
        this.restoreApp.set((Object)config.RESTORE_ENABLED);
        this.backupFile.set((Object)config.RESTORE_FILE);
        this.freshInstall.set((Object)config.RESTORE_FRESH_INSTALL_ONLY);
        this.restoreSupported.set((Object)(!config.DEPLOY_AS_INSTANT ? 1 : 0));
    }

    @Override
    public void applyTo(@NotNull RunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        AndroidRunConfiguration androidRunConfiguration = runConfiguration instanceof AndroidRunConfiguration ? (AndroidRunConfiguration)runConfiguration : null;
        if (androidRunConfiguration == null) {
            return;
        }
        AndroidRunConfiguration config = androidRunConfiguration;
        config.RESTORE_ENABLED = (Boolean)this.restoreApp.get();
        config.RESTORE_FILE = (String)this.backupFile.get();
        config.RESTORE_FRESH_INSTALL_ONLY = (Boolean)this.freshInstall.get();
    }

    @Override
    @NotNull
    public List<ValidationError> validate(@NotNull RunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        AndroidRunConfiguration androidRunConfiguration = runConfiguration instanceof AndroidRunConfiguration ? (AndroidRunConfiguration)runConfiguration : null;
        if (androidRunConfiguration == null) {
            return CollectionsKt.emptyList();
        }
        AndroidRunConfiguration config = androidRunConfiguration;
        if (!config.RESTORE_ENABLED || config.DEPLOY_AS_INSTANT) {
            return CollectionsKt.emptyList();
        }
        String file = config.RESTORE_FILE;
        if (StringsKt.isBlank((CharSequence)file)) {
            return CollectionsKt.listOf((Object)ValidationError.warning(BackupBundle.message("backup.file.missing", new Object[0])));
        }
        Path path = Path.of(file, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        Path path2 = PathExtensionsKt.absoluteInProject((Path)path, (Project)this.project);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return CollectionsKt.listOf((Object)ValidationError.warning(BackupBundle.message("backup.file.not.exist", new Object[0])));
        }
        try {
            String packageName;
            String fileApplicationId = BackupService.Companion.validateBackupFile(path2).getApplicationId();
            ApplicationIdProvider applicationIdProvider = this.projectSystem.getApplicationIdProvider(runConfiguration);
            String string = packageName = applicationIdProvider != null ? applicationIdProvider.getPackageName() : null;
            if (packageName != null && !Intrinsics.areEqual((Object)fileApplicationId, (Object)packageName)) {
                Object[] objectArray = new Object[]{fileApplicationId};
                return CollectionsKt.listOf((Object)ValidationError.warning(BackupBundle.message("backup.file.mismatch", objectArray)));
            }
        }
        catch (Exception exception) {
            return CollectionsKt.listOf((Object)ValidationError.warning(BackupBundle.message("backup.file.invalid", new Object[0])));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public void updateBasedOnInstantState(boolean instantAppDeploy) {
        this.restoreSupported.set((Object)(!instantAppDeploy ? 1 : 0));
    }

    private final Cell<BackupFileTextField> backupFileChooser(Row $this$backupFileChooser, int width) {
        return $this$backupFileChooser.cell((JComponent)((Object)BackupFileTextField.Companion.createFileChooser(this.project))).applyToComponent(arg_0 -> RestoreRunConfigSection.backupFileChooser$lambda$0(width, arg_0));
    }

    private static final Unit getComponent$lambda$0(RestoreRunConfigSection this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.group$default((Panel)$this$panel, (String)BackupBundle.message("restore.run.config.group", new Object[0]), (boolean)false, arg_0 -> RestoreRunConfigSection.getComponent$lambda$0$0(this$0, arg_0), (int)2, null).enabledIf((ObservableProperty)this$0.restoreSupported);
        return Unit.INSTANCE;
    }

    private static final Unit getComponent$lambda$0$0(RestoreRunConfigSection this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, arg_0 -> RestoreRunConfigSection.getComponent$lambda$0$0$0(this$0, arg_0), (int)1, null);
        $this$group.indent(arg_0 -> RestoreRunConfigSection.getComponent$lambda$0$0$1(this$0, arg_0)).enabledIf((ObservableProperty)this$0.restoreApp);
        return Unit.INSTANCE;
    }

    private static final Unit getComponent$lambda$0$0$0(RestoreRunConfigSection this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(BackupBundle.message("restore.run.config.checkbox", new Object[0])), (ObservableMutableProperty)((ObservableMutableProperty)this$0.restoreApp));
        return Unit.INSTANCE;
    }

    private static final Unit getComponent$lambda$0$0$1(RestoreRunConfigSection this$0, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Panel.row$default((Panel)$this$indent, null, arg_0 -> RestoreRunConfigSection.getComponent$lambda$0$0$1$0(this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$indent, null, arg_0 -> RestoreRunConfigSection.getComponent$lambda$0$0$1$1(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit getComponent$lambda$0$0$1$0(RestoreRunConfigSection this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        RestoreRunConfigSectionKt.bindText(this$0.backupFileChooser($this$row, 500), (ObservableMutableProperty<String>)((ObservableMutableProperty)this$0.backupFile));
        return Unit.INSTANCE;
    }

    private static final Unit getComponent$lambda$0$0$1$1(RestoreRunConfigSection this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(BackupBundle.message("restore.run.config.fresh.install.checkbox", new Object[0])), (ObservableMutableProperty)((ObservableMutableProperty)this$0.freshInstall));
        return Unit.INSTANCE;
    }

    private static final Unit backupFileChooser$lambda$0(int $width, BackupFileTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$applyToComponent), (String)"$this$applyToComponent");
        $this$applyToComponent.setPreferredSize(new Dimension(JBUI.scale((int)$width), $this$applyToComponent.getPreferredSize().height));
        return Unit.INSTANCE;
    }
}

