/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.backup;

import com.android.tools.idea.actions.ActionUtils;
import com.android.tools.idea.backup.BackupBundle;
import com.android.tools.idea.backup.BackupManager;
import com.android.tools.idea.backup.DeviceChecker;
import com.android.tools.idea.backup.DialogFactory;
import com.android.tools.idea.backup.DialogFactoryImpl;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.streaming.RunningDevicesConstants;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\u000f\u001a\u00020\t*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/backup/BackupForegroundAppAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "dialogFactory", "Lcom/android/tools/idea/backup/DialogFactory;", "<init>", "(Lcom/android/tools/idea/backup/DialogFactory;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "getDeviceSerialNumber", "", "showDialog", "Lcom/intellij/openapi/project/Project;", "message", "intellij.android.backup"})
public final class BackupForegroundAppAction
extends AnAction {
    @NotNull
    private final DialogFactory dialogFactory;

    public BackupForegroundAppAction(@NotNull DialogFactory dialogFactory) {
        Intrinsics.checkNotNullParameter((Object)dialogFactory, (String)"dialogFactory");
        this.dialogFactory = dialogFactory;
    }

    public /* synthetic */ BackupForegroundAppAction(DialogFactory dialogFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dialogFactory = new DialogFactoryImpl();
        }
        this(dialogFactory);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(false);
        if (!((Boolean)StudioFlags.BACKUP_ENABLED.get()).booleanValue()) {
            return;
        }
        boolean ok2 = DeviceChecker.Companion.checkEventDeviceType(this, e);
        if (!ok2) {
            return;
        }
        e.getPresentation().setVisible(true);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        ActionUtils.disableRichTooltip((Presentation)presentation);
        e.getPresentation().setEnabled(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        BackupManager backupManager = BackupManager.Companion.getInstance(project2);
        String serialNumber = this.getDeviceSerialNumber(e);
        if (serialNumber == null) {
            this.showDialog(project2, BackupBundle.message("error.device.not.ready", new Object[0]));
            return;
        }
        BackupManager.showBackupDialog$default(backupManager, serialNumber, null, BackupManager.Source.BACKUP_FOREGROUND_APP_ACTION, false, 8, null);
    }

    private final String getDeviceSerialNumber(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        return (String)RunningDevicesConstants.SERIAL_NUMBER_KEY.getData(dataContext);
    }

    private final void showDialog(Project $this$showDialog, String message) {
        DialogFactory.showDialog$default(this.dialogFactory, $this$showDialog, BackupBundle.message("backup.app.action.error.title", new Object[0]), message, null, 8, null);
    }

    public BackupForegroundAppAction() {
        this(null, 1, null);
    }
}

