/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager.ui;

import com.android.sdklib.devices.Device;
import com.android.tools.idea.avdmanager.DeviceManagerConnection;
import com.android.tools.idea.avdmanager.ui.DeviceUiAction;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExportDeviceAction
extends DeviceUiAction {
    public ExportDeviceAction(@NotNull DeviceUiAction.DeviceProvider provider) {
        super(provider, "Export");
    }

    @Override
    public boolean isEnabled() {
        Device device2 = this.myProvider.getDevice();
        return device2 != null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileSaverDescriptor descriptor2 = new FileSaverDescriptor("Export Location", "Select a location for the exported device", "xml");
        String homePath = System.getProperty("user.home");
        File parentPath = homePath == null ? new File("/") : new File(homePath);
        VirtualFile parent = LocalFileSystem.getInstance().findFileByIoFile(parentPath);
        VirtualFileWrapper fileWrapper2 = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, this.myProvider.getProject()).save(parent, "device.xml");
        Device device2 = this.myProvider.getDevice();
        if (device2 != null && fileWrapper2 != null) {
            DeviceManagerConnection.writeDevicesToFile((List<Device>)ImmutableList.of((Object)device2), fileWrapper2.getFile());
        }
    }
}

