/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Shell32;
import com.sun.jna.platform.win32.ShellAPI;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.jetbrains.annotations.NotNull;

public class ElevatedCommandLine
extends GeneralCommandLine {
    private static final int SEE_MASK_NO_CLOSE_PROCESS = 64;
    private static final int INFINITE = -1;
    private String myTempFilePrefix = "temp";

    public ElevatedCommandLine(String ... command) {
        super(command);
    }

    public ElevatedCommandLine withTempFilePrefix(@NotNull String tempFilePrefix) {
        this.myTempFilePrefix = tempFilePrefix;
        return this;
    }

    @NotNull
    protected Process createProcess(@NotNull ProcessBuilder processBuilder) throws IOException {
        if (SystemInfo.isWindows) {
            return this.executeAsShellCommand();
        }
        return super.createProcess(processBuilder);
    }

    private Process executeAsShellCommand() throws IOException {
        File outFile = FileUtil.createTempFile((String)(this.myTempFilePrefix + "_out"), (String)".txt", (boolean)true);
        File errFile = FileUtil.createTempFile((String)(this.myTempFilePrefix + "_err"), (String)".txt", (boolean)true);
        this.addParameters(new String[]{">", outFile.getPath(), "2>", errFile.getPath()});
        ShellAPI.SHELLEXECUTEINFO info = new ShellAPI.SHELLEXECUTEINFO();
        info.cbSize = info.size();
        info.lpFile = this.getExePath();
        info.lpVerb = "runas";
        info.lpParameters = this.getParametersList().getParametersString();
        info.lpDirectory = this.getWorkDirectory().getPath();
        info.nShow = 0;
        info.fMask = 64;
        boolean returnValue = Shell32.INSTANCE.ShellExecuteEx(info);
        int errorCode = returnValue ? 0 : Kernel32.INSTANCE.GetLastError();
        Logger.getInstance(ElevatedCommandLine.class).info("ShellExecuteEx: \"" + this.getExePath() + this.getParametersList().getParametersString() + "\" returned " + errorCode);
        return new ProcessWrapper(info.hProcess, errorCode, outFile, errFile);
    }

    private static class ProcessWrapper
    extends Process {
        private WinNT.HANDLE myProcess;
        private final IntByReference myExitCode;
        private final File myOutFile;
        private final File myErrFile;

        private ProcessWrapper(@NotNull WinNT.HANDLE hProcess, int errorCode, @NotNull File outFile, @NotNull File errFile) {
            this.myProcess = hProcess;
            this.myExitCode = new IntByReference(errorCode);
            this.myOutFile = outFile;
            this.myErrFile = errFile;
        }

        @Override
        public OutputStream getOutputStream() {
            return NullOutputStream.INSTANCE;
        }

        @Override
        public InputStream getInputStream() {
            return this.toInputStream(this.myOutFile);
        }

        @Override
        public InputStream getErrorStream() {
            return this.toInputStream(this.myErrFile);
        }

        @Override
        public int waitFor() {
            if (this.myProcess != null) {
                Kernel32.INSTANCE.WaitForSingleObject(this.myProcess, -1);
                Kernel32.INSTANCE.GetExitCodeProcess(this.myProcess, this.myExitCode);
                Kernel32.INSTANCE.CloseHandle(this.myProcess);
                this.myProcess = null;
            }
            return this.myExitCode.getValue();
        }

        @Override
        public int exitValue() {
            return this.waitFor();
        }

        @Override
        public void destroy() {
            this.waitFor();
        }

        private InputStream toInputStream(@NotNull File file) {
            try {
                this.waitFor();
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

