/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.annotations.concurrency.Slow;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.adtui.device.DeviceArtDescriptor;
import com.android.tools.idea.avdmanager.DeviceSkinUpdater;
import com.android.tools.idea.avdmanager.SystemImageDescription;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.utils.FileUtils;
import com.android.utils.PathUtils;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0007J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0007J \u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/avdmanager/DeviceSkinUpdater;", "", "<init>", "()V", "updateSkin", "Ljava/nio/file/Path;", "skin", "image", "Lcom/android/tools/idea/avdmanager/SystemImageDescription;", "imageSkins", "", "studioSkins", "sdkLocation", "areAllFilesUpToDate", "", "targetDir", "sourceDir", "updateSkinImpl", "skinFolder", "getStudioDeviceSkin", "skinName", "", "getStudioSkinName", "intellij.android.core"})
@SourceDebugExtension(value={"SMAP\nDeviceSkinUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceSkinUpdater.kt\ncom/android/tools/idea/avdmanager/DeviceSkinUpdater\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n24#2:163\n1#3:164\n*S KotlinDebug\n*F\n+ 1 DeviceSkinUpdater.kt\ncom/android/tools/idea/avdmanager/DeviceSkinUpdater\n*L\n143#1:163\n*E\n"})
public final class DeviceSkinUpdater {
    @NotNull
    public static final DeviceSkinUpdater INSTANCE = new DeviceSkinUpdater();

    private DeviceSkinUpdater() {
    }

    @JvmStatic
    @Slow
    @JvmOverloads
    @NotNull
    public static final Path updateSkin(@NotNull Path skin, @Nullable SystemImageDescription image) {
        List<Path> list2;
        Intrinsics.checkNotNullParameter((Object)skin, (String)"skin");
        SystemImageDescription systemImageDescription = image;
        if (systemImageDescription == null) {
            list2 = CollectionsKt.emptyList();
        } else {
            List<Path> list3 = systemImageDescription.getSkins();
            list2 = list3;
            Intrinsics.checkNotNullExpressionValue(list3, (String)"getSkins(...)");
        }
        return INSTANCE.updateSkin(skin, (Collection<? extends Path>)list2);
    }

    public static /* synthetic */ Path updateSkin$default(Path path, SystemImageDescription systemImageDescription, int n, Object object) {
        if ((n & 2) != 0) {
            systemImageDescription = null;
        }
        return DeviceSkinUpdater.updateSkin(path, systemImageDescription);
    }

    @Slow
    @NotNull
    public final Path updateSkin(@NotNull Path skin, @NotNull Collection<? extends Path> imageSkins) {
        Intrinsics.checkNotNullParameter((Object)skin, (String)"skin");
        Intrinsics.checkNotNullParameter(imageSkins, (String)"imageSkins");
        if (skin.isAbsolute()) {
            return skin;
        }
        String skinName = ((Object)skin).toString();
        if (((CharSequence)skinName).length() == 0 || Intrinsics.areEqual((Object)skinName, (Object)"_no_skin")) {
            return skin;
        }
        File file = DeviceArtDescriptor.getBundledDescriptorsFolder();
        Path studioSkins = file != null ? file.toPath() : null;
        AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"tryToChooseSdkHandler(...)");
        AndroidSdkHandler sdk = androidSdkHandler;
        return this.updateSkin(skin, imageSkins, studioSkins, sdk.getLocation());
    }

    @VisibleForTesting
    @NotNull
    public final Path updateSkin(@NotNull Path skin, @NotNull Collection<? extends Path> imageSkins, @Nullable Path studioSkins, @Nullable Path sdkLocation) {
        Path sdkSkins;
        Intrinsics.checkNotNullParameter((Object)skin, (String)"skin");
        Intrinsics.checkNotNullParameter(imageSkins, (String)"imageSkins");
        for (Path path : imageSkins) {
            if (!path.endsWith(skin)) continue;
            return path;
        }
        Path path = sdkLocation;
        Path path2 = sdkSkins = path != null ? path.resolve("skins") : null;
        if (studioSkins == null) {
            Path path3 = sdkSkins;
            if (path3 == null || (path3 = path3.resolve(skin)) == null) {
                path3 = skin;
            }
            return path3;
        }
        if (sdkSkins == null) {
            Path path4 = studioSkins.resolve(this.getStudioSkinName(((Object)skin.getFileName()).toString()));
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"resolve(...)");
            return path4;
        }
        return this.updateSkinImpl(skin, studioSkins, sdkSkins);
    }

    @VisibleForTesting
    public final boolean areAllFilesUpToDate(@NotNull Path targetDir, @NotNull Path sourceDir) {
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        Intrinsics.checkNotNullParameter((Object)sourceDir, (String)"sourceDir");
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000/\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002*\u0001\u0000\b\n\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"com/android/tools/idea/avdmanager/DeviceSkinUpdater$areAllFilesUpToDate$UpToDateChecker", "Ljava/nio/file/SimpleFileVisitor;", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "targetOlder", "", "getTargetOlder", "()Z", "setTargetOlder", "(Z)V", "visitFile", "Ljava/nio/file/FileVisitResult;", "sourceFile", "attrs", "Ljava/nio/file/attribute/BasicFileAttributes;", "getLastModifiedTimeMillis", "", "file", "intellij.android.core"})
        public final class UpToDateChecker
        extends SimpleFileVisitor<Path> {
            private boolean targetOlder;
            final /* synthetic */ Path $targetDir;
            final /* synthetic */ Path $sourceDir;

            public UpToDateChecker(Path $targetDir, Path $sourceDir) {
                this.$targetDir = $targetDir;
                this.$sourceDir = $sourceDir;
            }

            public final boolean getTargetOlder() {
                return this.targetOlder;
            }

            public final void setTargetOlder(boolean bl) {
                this.targetOlder = bl;
            }

            public FileVisitResult visitFile(Path sourceFile, BasicFileAttributes attrs) throws IOException {
                Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                if (!StringsKt.startsWith$default((String)((Object)sourceFile.getFileName()).toString(), (String)".", (boolean)false, (int)2, null)) {
                    Path targetFile = this.$targetDir.resolve(((Object)this.$sourceDir.relativize(sourceFile)).toString());
                    Intrinsics.checkNotNull((Object)targetFile);
                    if (this.getLastModifiedTimeMillis(targetFile) < this.getLastModifiedTimeMillis(sourceFile)) {
                        this.targetOlder = true;
                        return FileVisitResult.TERMINATE;
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            private final long getLastModifiedTimeMillis(Path file) {
                return Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
            }
        }
        UpToDateChecker checker = new UpToDateChecker(targetDir, sourceDir);
        try {
            Files.walkFileTree(sourceDir, checker);
        }
        catch (IOException e) {
            return false;
        }
        return !checker.getTargetOlder();
    }

    private final Path updateSkinImpl(Path skin, Path studioSkins, Path skinFolder) {
        boolean bl;
        boolean bl2 = bl = ((CharSequence)((Object)skin).toString()).length() > 0 && !Intrinsics.areEqual((Object)((Object)skin).toString(), (Object)"_no_skin");
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Path sdkDeviceSkin = skinFolder.resolve(skin);
        Path path = this.getStudioDeviceSkin(((Object)skin.getFileName()).toString(), studioSkins);
        if (path == null) {
            return skin;
        }
        Path studioDeviceSkin = path;
        try {
            Intrinsics.checkNotNull((Object)sdkDeviceSkin);
            if (this.areAllFilesUpToDate(sdkDeviceSkin, studioDeviceSkin)) {
                return sdkDeviceSkin;
            }
            PathUtils.deleteRecursivelyIfExists((Path)sdkDeviceSkin);
            FileUtils.copyDirectory((Path)studioDeviceSkin, (Path)sdkDeviceSkin, (boolean)false);
            return sdkDeviceSkin;
        }
        catch (IOException e) {
            DeviceSkinUpdater $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(DeviceSkinUpdater.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)e);
            return studioDeviceSkin;
        }
    }

    private final Path getStudioDeviceSkin(String skinName, Path studioSkins) {
        Path path;
        Path it = path = studioSkins.resolve(this.getStudioSkinName(skinName));
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? path : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getStudioSkinName(String skinName) {
        String string = skinName;
        switch (string.hashCode()) {
            case 48162204: {
                if (string.equals("WearSquare")) return "wearos_square";
                break;
            }
            case -744395322: {
                if (string.equals("WearSmallRound")) return "wearos_small_round";
                break;
            }
            case -665912797: {
                if (string.equals("WearRect")) return "wearos_rect";
                break;
            }
            case 65865746: {
                if (!string.equals("WearLargeRound")) break;
                return "wearos_large_round";
            }
        }
        String string2 = skinName;
        return string2;
    }

    @JvmStatic
    @Slow
    @JvmOverloads
    @NotNull
    public static final Path updateSkin(@NotNull Path skin) {
        Intrinsics.checkNotNullParameter((Object)skin, (String)"skin");
        return DeviceSkinUpdater.updateSkin$default(skin, null, 2, null);
    }
}

