/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.sdklib.devices.DeviceParser;
import com.android.tools.idea.downloads.DownloadService;
import com.android.tools.idea.flags.StudioFlags;
import com.google.common.collect.Table;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.Objects;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXException;

@Service
public final class DeviceDefinitionDownloadService
extends DownloadService {
    private DeviceDefinitionDownloadService() {
        super("device definitions", (String)StudioFlags.DEVICE_DEFINITION_DOWNLOAD_SERVICE_URL.get(), Objects.requireNonNull(DeviceDefinitionDownloadService.class.getClassLoader().getResource("devices/devices.xml")), Path.of(PathManager.getSystemPath(), "devices").toFile(), "devices_temp.xml", "devices.xml");
    }

    @NotNull
    public static DeviceDefinitionDownloadService getInstance() {
        return (DeviceDefinitionDownloadService)((Object)ApplicationManager.getApplication().getService(DeviceDefinitionDownloadService.class));
    }

    public void downloadDefinitionsAsync() {
        this.refresh(() -> {}, () -> {});
    }

    public void loadFromFile(@NotNull URL url) {
        try (InputStream in = url.openStream();){
            Table table2 = DeviceParser.parse((InputStream)in);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            Logger.getInstance(DeviceDefinitionDownloadService.class).warn((Throwable)exception);
        }
    }
}

