/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant.view;

import com.android.tools.idea.assistant.AssistActionHandler;
import com.android.tools.idea.assistant.AssistNavListener;
import com.android.tools.idea.assistant.datamodel.AnalyticsProvider;
import com.android.tools.idea.assistant.datamodel.FeatureData;
import com.android.tools.idea.assistant.datamodel.TutorialBundleData;
import com.android.tools.idea.assistant.datamodel.TutorialData;
import com.android.tools.idea.assistant.view.NavigationButton;
import com.android.tools.idea.assistant.view.StatefulButton;
import com.android.tools.idea.assistant.view.TutorialCard;
import com.android.tools.idea.assistant.view.TutorialChooser;
import com.android.tools.idea.assistant.view.UIUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002\"#B+\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u000bH\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/assistant/view/FeaturesPanel;", "Ljavax/swing/JPanel;", "Ljava/awt/event/ItemListener;", "Ljava/awt/event/ActionListener;", "bundle", "Lcom/android/tools/idea/assistant/datamodel/TutorialBundleData;", "project", "Lcom/intellij/openapi/project/Project;", "myAnalyticsProvider", "Lcom/android/tools/idea/assistant/datamodel/AnalyticsProvider;", "defaultCardId", "", "<init>", "(Lcom/android/tools/idea/assistant/datamodel/TutorialBundleData;Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/assistant/datamodel/AnalyticsProvider;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "cardKeys", "", "cardsPanel", "cardLayout", "Ljava/awt/CardLayout;", "myOpenTutorial", "Lcom/android/tools/idea/assistant/view/FeaturesPanel$TutorialMetadata;", "addCard", "", "c", "Ljava/awt/Component;", "key", "itemStateChanged", "e", "Ljava/awt/event/ItemEvent;", "actionPerformed", "Ljava/awt/event/ActionEvent;", "showCard", "TutorialMetadata", "Companion", "assistant"})
@SourceDebugExtension(value={"SMAP\nFeaturesPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeaturesPanel.kt\ncom/android/tools/idea/assistant/view/FeaturesPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n1869#2:168\n1869#2,2:169\n1870#2:171\n1869#2,2:175\n3829#3:172\n4344#3,2:173\n1137#3,2:177\n1#4:179\n*S KotlinDebug\n*F\n+ 1 FeaturesPanel.kt\ncom/android/tools/idea/assistant/view/FeaturesPanel\n*L\n75#1:168\n76#1:169,2\n75#1:171\n124#1:175,2\n123#1:172\n123#1:173,2\n129#1:177,2\n*E\n"})
public final class FeaturesPanel
extends JPanel
implements ItemListener,
ActionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AnalyticsProvider myAnalyticsProvider;
    @NotNull
    private final Set<String> cardKeys;
    @NotNull
    private final JPanel cardsPanel;
    @NotNull
    private final CardLayout cardLayout;
    @Nullable
    private TutorialMetadata myOpenTutorial;

    public FeaturesPanel(@NotNull TutorialBundleData bundle, @NotNull Project project, @NotNull AnalyticsProvider myAnalyticsProvider, @Nullable String defaultCardId) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)myAnalyticsProvider, (String)"myAnalyticsProvider");
        super(new BorderLayout());
        this.project = project;
        this.myAnalyticsProvider = myAnalyticsProvider;
        this.cardKeys = new LinkedHashSet();
        this.setBackground(UIUtils.getBackgroundColor());
        this.cardLayout = new CardLayout();
        this.cardLayout.setVgap(0);
        this.cardsPanel = new JPanel(this.cardLayout);
        this.cardsPanel.setOpaque(false);
        List<? extends FeatureData> list2 = bundle.getFeatures();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getFeatures(...)");
        List<? extends FeatureData> featureList = list2;
        boolean hideChooserAndNavigationalBar = false;
        if (featureList.size() == 1 && featureList.get(0).getTutorials().size() == 1) {
            hideChooserAndNavigationalBar = true;
            FeaturesPanel.Companion.getLog().debug("Tutorial chooser and head/bottom navigation bars are hidden because the assistant panel contains only one tutorial.");
        } else {
            this.addCard(new TutorialChooser(this, bundle, this.myAnalyticsProvider, this.project), "studio_tutorial_chooser");
        }
        List<? extends FeatureData> list3 = bundle.getFeatures();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getFeatures(...)");
        Iterable $this$forEach$iv = list3;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FeatureData feature = (FeatureData)element$iv;
            boolean bl = false;
            List<? extends TutorialData> list4 = feature.getTutorials();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"getTutorials(...)");
            Iterable $this$forEach$iv2 = list4;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                TutorialData tutorialData = (TutorialData)element$iv2;
                boolean bl2 = false;
                Component component = new TutorialCard(this, tutorialData, feature, hideChooserAndNavigationalBar, bundle);
                String string = tutorialData.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKey(...)");
                this.addCard(component, string);
            }
        }
        this.add(this.cardsPanel);
        if (defaultCardId != null && this.cardKeys.contains(defaultCardId)) {
            this.showCard(defaultCardId);
        }
    }

    public /* synthetic */ FeaturesPanel(TutorialBundleData tutorialBundleData, Project project, AnalyticsProvider analyticsProvider, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = null;
        }
        this(tutorialBundleData, project, analyticsProvider, string);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final void addCard(Component c, String key) {
        this.cardsPanel.add(c, key);
        this.cardKeys.add(key);
    }

    @Override
    public void itemStateChanged(@NotNull ItemEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LayoutManager layoutManager = this.cardsPanel.getLayout();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.CardLayout");
        CardLayout cl = (CardLayout)layoutManager;
        Container container = this.cardsPanel;
        Object object = e.getItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        cl.show(container, (String)object);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void actionPerformed(@NotNull ActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object source2 = e.getSource();
        if (source2 instanceof NavigationButton) {
            void $this$forEach$iv;
            Iterator $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            if (this.myOpenTutorial != null) {
                TutorialMetadata tutorialMetadata = this.myOpenTutorial;
                Intrinsics.checkNotNull((Object)tutorialMetadata);
                String string = tutorialMetadata.getKey();
                TutorialMetadata tutorialMetadata2 = this.myOpenTutorial;
                Intrinsics.checkNotNull((Object)tutorialMetadata2);
                this.myAnalyticsProvider.trackTutorialClosed(string, tutorialMetadata2.getReadDuration(), this.project);
                this.myOpenTutorial = null;
            }
            String key = ((NavigationButton)source2).getKey();
            Intrinsics.checkNotNull((Object)key);
            this.showCard(key);
            Object[] objectArray = AssistNavListener.EP_NAME.getExtensions();
            boolean $i$f$filter = false;
            void var6_11 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                AssistNavListener listener2 = (AssistNavListener)element$iv$iv;
                boolean bl = false;
                String string = listener2.getIdPrefix();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdPrefix(...)");
                if (!StringsKt.startsWith$default((String)key, (String)string, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AssistNavListener listener3 = (AssistNavListener)element$iv;
                boolean bl = false;
                listener3.onActionPerformed(key, e);
            }
        } else if (source2 instanceof StatefulButton.ActionButton) {
            Object element$iv2;
            String actionId;
            block10: {
                actionId = ((StatefulButton.ActionButton)source2).getKey();
                Object[] $this$first$iv = AssistActionHandler.EP_NAME.getExtensions();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    AssistActionHandler handler2 = (AssistActionHandler)element$iv2;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)handler2.getId(), (Object)actionId)) {
                        continue;
                    }
                    break block10;
                }
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            AssistActionHandler handler3 = (AssistActionHandler)element$iv2;
            if (handler3 == null) {
                boolean bl = false;
                String string = "Unhandled action, no handler found for key \"" + actionId + "\".";
                throw new IllegalArgumentException(string.toString());
            }
            handler3.handleAction(((StatefulButton.ActionButton)source2).getActionData(), ((StatefulButton.ActionButton)source2).getProject());
            ((StatefulButton.ActionButton)source2).updateState();
        } else {
            throw new RuntimeException("Unhandled action, \"" + e.getActionCommand() + "\".");
        }
    }

    private final void showCard(String key) {
        if (!this.cardKeys.contains(key)) {
            boolean bl = false;
            String string = "No views exist with key: " + key;
            throw new IllegalArgumentException(string.toString());
        }
        FeaturesPanel.Companion.getLog().debug("Received request to navigate to view with key: " + key);
        if (!Intrinsics.areEqual((Object)key, (Object)"studio_tutorial_chooser")) {
            this.myAnalyticsProvider.trackTutorialOpen(key, this.project);
            this.myOpenTutorial = new TutorialMetadata(key);
        }
        this.cardLayout.show(this.cardsPanel, key);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/assistant/view/FeaturesPanel$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "assistant"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Logger logger = Logger.getInstance(FeaturesPanel.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/assistant/view/FeaturesPanel$TutorialMetadata;", "", "key", "", "<init>", "(Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "myTimeOpenedMs", "", "readDuration", "getReadDuration", "()J", "assistant"})
    private static final class TutorialMetadata {
        @NotNull
        private final String key;
        private final long myTimeOpenedMs;

        public TutorialMetadata(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
            this.myTimeOpenedMs = System.currentTimeMillis();
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        public final long getReadDuration() {
            return System.currentTimeMillis() - this.myTimeOpenedMs;
        }
    }
}

