/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.network.view.connectionsview;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.stdui.TimelineTable;
import com.android.tools.adtui.table.ConfigColumnTableAspect;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorAspect;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorModel;
import com.android.tools.idea.appinspection.inspectors.network.model.connections.ConnectionData;
import com.android.tools.idea.appinspection.inspectors.network.model.connections.GrpcData;
import com.android.tools.idea.appinspection.inspectors.network.model.connections.HttpData;
import com.android.tools.idea.appinspection.inspectors.network.view.NetworkInspectorViewState;
import com.android.tools.idea.appinspection.inspectors.network.view.connectionsview.ConnectionColumn;
import com.android.tools.idea.appinspection.inspectors.network.view.connectionsview.ConnectionsTableModel;
import com.android.tools.idea.appinspection.inspectors.network.view.connectionsview.ConnectionsViewKt;
import com.android.tools.idea.appinspection.inspectors.network.view.constants.ColorsKt;
import com.android.tools.idea.appinspection.inspectors.network.view.constants.LayoutKt;
import com.android.tools.idea.appinspection.inspectors.network.view.rules.TableDecoraterUtilKt;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.table.JBTable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Closeable;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001c*\u00020\u0015H\u0002J\b\u0010\u001d\u001a\u00020\u0012H\u0002J\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/connectionsview/ConnectionsView;", "Lcom/android/tools/adtui/model/AspectObserver;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;)V", "tableModel", "Lcom/android/tools/idea/appinspection/inspectors/network/view/connectionsview/ConnectionsTableModel;", "connectionsTable", "Lcom/intellij/ui/table/JBTable;", "Lorg/jetbrains/annotations/NotNull;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "customizeConnectionsTable", "", "openContextMenu", "e", "Ljava/awt/event/MouseEvent;", "setRenderer", "column", "Lcom/android/tools/idea/appinspection/inspectors/network/view/connectionsview/ConnectionColumn;", "renderer", "Ljavax/swing/table/TableCellRenderer;", "getConnectionData", "Lcom/android/tools/idea/appinspection/inspectors/network/model/connections/ConnectionData;", "updateTableSelection", "exportConnections", "path", "Ljava/nio/file/Path;", "app-inspection.inspectors.network.view"})
@SourceDebugExtension(value={"SMAP\nConnectionsView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionsView.kt\ncom/android/tools/idea/appinspection/inspectors/network/view/connectionsview/ConnectionsView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n1869#2,2:251\n1617#2,9:253\n1869#2:262\n1870#2:264\n1626#2:265\n1#3:263\n1#3:266\n*S KotlinDebug\n*F\n+ 1 ConnectionsView.kt\ncom/android/tools/idea/appinspection/inspectors/network/view/connectionsview/ConnectionsView\n*L\n76#1:251,2\n185#1:253,9\n185#1:262\n185#1:264\n185#1:265\n185#1:263\n*E\n"})
public final class ConnectionsView
extends AspectObserver {
    @NotNull
    private final NetworkInspectorModel model;
    @NotNull
    private final ConnectionsTableModel tableModel;
    @NotNull
    private final JBTable connectionsTable;

    public ConnectionsView(@NotNull Project project, @NotNull NetworkInspectorModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        this.model = model;
        this.tableModel = new ConnectionsTableModel(this.model.getSelectionRangeDataFetcher());
        JBTable jBTable = TimelineTable.create((TableModel)this.tableModel, (Timeline)this.model.getTimeline(), (String)ConnectionColumn.TIMELINE.getDisplayString(), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)jBTable, (String)"create(...)");
        this.connectionsTable = jBTable;
        this.customizeConnectionsTable();
        ConfigColumnTableAspect.Companion.apply(project, (JTable)this.connectionsTable, NetworkInspectorViewState.Companion.getInstance().getColumns());
        this.model.getAspect().addDependency((AspectObserver)this).onChange((Enum)NetworkInspectorAspect.SELECTED_CONNECTION, () -> ConnectionsView._init_$lambda$0(this));
    }

    @NotNull
    public final JComponent getComponent() {
        return (JComponent)this.connectionsTable;
    }

    private final void customizeConnectionsTable() {
        this.connectionsTable.setAutoCreateRowSorter(true);
        Iterable $this$forEach$iv = (Iterable)ConnectionColumn.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConnectionColumn it = (ConnectionColumn)((Object)element$iv);
            boolean bl = false;
            this.setRenderer(it, it.getCellRenderer((JTable)this.connectionsTable, this.model));
        }
        this.connectionsTable.setSelectionMode(0);
        this.connectionsTable.addMouseListener((MouseListener)new MouseAdapter(this){
            final /* synthetic */ ConnectionsView this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseMoved(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ConnectionData connectionData = ConnectionsView.access$getConnectionData(this.this$0, e);
                ConnectionsView.access$getConnectionsTable$p(this.this$0).setToolTipText(connectionData != null ? connectionData.getUrl() : null);
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int row = ConnectionsView.access$getConnectionsTable$p(this.this$0).rowAtPoint(e.getPoint());
                if (row != -1) {
                    ConnectionsView.access$getModel$p(this.this$0).setDetailContent(NetworkInspectorModel.DetailContent.CONNECTION);
                }
            }

            public void mouseReleased(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ConnectionsView.access$openContextMenu(this.this$0, e);
            }

            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ConnectionsView.access$openContextMenu(this.this$0, e);
            }
        });
        TableDecoraterUtilKt.registerEnterKeyAction((JTable)this.connectionsTable, (Function1<? super ActionEvent, Unit>)((Function1)arg_0 -> ConnectionsView.customizeConnectionsTable$lambda$1(this, arg_0)));
        this.connectionsTable.getSelectionModel().addListSelectionListener(arg_0 -> ConnectionsView.customizeConnectionsTable$lambda$2(this, arg_0));
        this.connectionsTable.setBackground(ColorsKt.getDEFAULT_BACKGROUND());
        this.connectionsTable.setShowVerticalLines(true);
        this.connectionsTable.setShowHorizontalLines(false);
        int defaultFontHeight = this.connectionsTable.getFontMetrics(this.connectionsTable.getFont()).getHeight();
        this.connectionsTable.setRowMargin(0);
        this.connectionsTable.setRowHeight(defaultFontHeight + LayoutKt.getROW_HEIGHT_PADDING());
        this.connectionsTable.setFocusTraversalKeys(0, null);
        this.connectionsTable.setFocusTraversalKeys(1, null);
        this.model.getSelectionRangeDataFetcher().addOnChangedListener((Function1<? super List<? extends ConnectionData>, Unit>)((Function1)arg_0 -> ConnectionsView.customizeConnectionsTable$lambda$3(this, arg_0)));
    }

    private final void openContextMenu(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        ConnectionData connectionData = this.getConnectionData(e);
        if (connectionData == null) {
            return;
        }
        ConnectionData connectionData2 = connectionData;
        List actions2 = ConnectionsViewKt.access$getActions(connectionData2);
        if (actions2.isEmpty()) {
            return;
        }
        JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new DefaultActionGroup(actions2), DataContext.EMPTY_CONTEXT, true, null, -1).show(new RelativePoint(e));
    }

    private final void setRenderer(ConnectionColumn column2, TableCellRenderer renderer2) {
        this.connectionsTable.getColumnModel().getColumn(column2.ordinal()).setCellRenderer(renderer2);
    }

    private final ConnectionData getConnectionData(MouseEvent $this$getConnectionData) {
        int row = this.connectionsTable.rowAtPoint($this$getConnectionData.getPoint());
        return row < 0 ? null : this.tableModel.getConnectionData(this.connectionsTable.convertRowIndexToModel(row));
    }

    private final void updateTableSelection() {
        ConnectionData selectedData = this.model.getSelectedConnection();
        if (selectedData != null) {
            int n = this.tableModel.getRowCount();
            for (int i = 0; i < n; ++i) {
                if (this.tableModel.getConnectionData(i).getId() != selectedData.getId()) continue;
                int row = this.connectionsTable.convertRowIndexToView(i);
                this.connectionsTable.setRowSelectionInterval(row, row);
                return;
            }
        } else {
            this.connectionsTable.clearSelection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void exportConnections(@NotNull Path path) {
        OpenOption[] $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Gson gson2 = new GsonBuilder().setPrettyPrinting().create();
        Iterable $this$mapNotNull$iv = this.tableModel.getConnectionDataList();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Map it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ConnectionData it = (ConnectionData)element$iv$iv;
            boolean bl2 = false;
            ConnectionData connectionData = it;
            if ((connectionData instanceof HttpData ? ConnectionsViewKt.access$forExport((HttpData)it) : (connectionData instanceof GrpcData ? ConnectionsViewKt.access$forExport((GrpcData)it) : null)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List export2 = (List)destination$iv$iv;
        Object object = path;
        $this$mapNotNullTo$iv$iv = new OpenOption[]{};
        Object object2 = Charsets.UTF_8;
        object = new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf($this$mapNotNullTo$iv$iv, $this$mapNotNullTo$iv$iv.length)), (Charset)object2);
        object2 = null;
        try {
            OutputStreamWriter it = (OutputStreamWriter)object;
            boolean bl = false;
            it.write(gson2.toJson((Object)export2));
            iterable = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    private static final void _init_$lambda$0(ConnectionsView this$0) {
        this$0.updateTableSelection();
    }

    private static final Unit customizeConnectionsTable$lambda$1(ConnectionsView this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.connectionsTable.getSelectedRow() != -1) {
            this$0.model.setDetailContent(NetworkInspectorModel.DetailContent.CONNECTION);
        }
        return Unit.INSTANCE;
    }

    private static final void customizeConnectionsTable$lambda$2(ConnectionsView this$0, ListSelectionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getValueIsAdjusting()) {
            return;
        }
        int selectedRow = this$0.connectionsTable.getSelectedRow();
        if (0 <= selectedRow && selectedRow < this$0.tableModel.getRowCount()) {
            int modelRow = this$0.connectionsTable.convertRowIndexToModel(selectedRow);
            this$0.model.setSelectedConnection(this$0.tableModel.getConnectionData(modelRow));
        }
    }

    private static final Unit customizeConnectionsTable$lambda$3(ConnectionsView this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateTableSelection();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ JBTable access$getConnectionsTable$p(ConnectionsView $this) {
        return $this.connectionsTable;
    }

    public static final /* synthetic */ ConnectionData access$getConnectionData(ConnectionsView $this, MouseEvent $receiver) {
        return $this.getConnectionData($receiver);
    }

    public static final /* synthetic */ NetworkInspectorModel access$getModel$p(ConnectionsView $this) {
        return $this.model;
    }

    public static final /* synthetic */ void access$openContextMenu(ConnectionsView $this, MouseEvent e) {
        $this.openContextMenu(e);
    }
}

