/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.network.model;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangeSelectionModel;
import com.android.tools.adtui.model.StreamingTimeline;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.idea.appinspection.inspectors.network.model.LegendsModel;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorAspect;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorDataSource;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorModelKt;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkInspectorServices;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkSpeedLineChartModel;
import com.android.tools.idea.appinspection.inspectors.network.model.NetworkTimeline;
import com.android.tools.idea.appinspection.inspectors.network.model.connections.ConnectionData;
import com.android.tools.idea.appinspection.inspectors.network.model.connections.ConnectionDataModel;
import com.android.tools.idea.appinspection.inspectors.network.model.connections.ConnectionDataModelImpl;
import com.android.tools.idea.appinspection.inspectors.network.model.connections.SelectionRangeDataFetcher;
import com.android.tools.idea.appinspection.inspectors.network.model.rules.RuleData;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.inspectors.common.api.stacktrace.StackTraceModel;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001PB)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010H\u001a\u00020I2\b\u0010J\u001a\u0004\u0018\u00010\u0018J\u0010\u0010K\u001a\u00020I2\b\u0010L\u001a\u0004\u0018\u00010\u001cJ\u0006\u0010M\u001a\u00020NJ\b\u0010O\u001a\u00020IH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\r\u001a\u0004\u0018\u00010\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\"\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\b\u0010\r\u001a\u0004\u0018\u00010\u001c@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010+\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u00020,\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010.R\u0016\u00101\u001a\u000702\u00a2\u0006\u0002\b3\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0011\u00106\u001a\u000207\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0011\u0010:\u001a\u00020;\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0011\u0010>\u001a\u00020?\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR(\u0010C\u001a\u0004\u0018\u00010B2\b\u0010\r\u001a\u0004\u0018\u00010B@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010G\u00a8\u0006Q"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel;", "Lcom/android/tools/adtui/model/AspectModel;", "Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorAspect;", "services", "Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorServices;", "dataSource", "Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorDataSource;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "connectionsModel", "Lcom/android/tools/idea/appinspection/inspectors/network/model/connections/ConnectionDataModel;", "<init>", "(Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorServices;Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorDataSource;Lkotlinx/coroutines/CoroutineScope;Lcom/android/tools/idea/appinspection/inspectors/network/model/connections/ConnectionDataModel;)V", "value", "Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel$DetailContent;", "detailContent", "getDetailContent", "()Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel$DetailContent;", "setDetailContent", "(Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel$DetailContent;)V", "name", "", "getName", "()Ljava/lang/String;", "Lcom/android/tools/idea/appinspection/inspectors/network/model/connections/ConnectionData;", "selectedConnection", "getSelectedConnection", "()Lcom/android/tools/idea/appinspection/inspectors/network/model/connections/ConnectionData;", "Lcom/android/tools/idea/appinspection/inspectors/network/model/rules/RuleData;", "selectedRule", "getSelectedRule", "()Lcom/android/tools/idea/appinspection/inspectors/network/model/rules/RuleData;", "aspect", "getAspect", "()Lcom/android/tools/adtui/model/AspectModel;", "timeline", "Lcom/android/tools/adtui/model/Timeline;", "getTimeline", "()Lcom/android/tools/adtui/model/Timeline;", "networkUsage", "Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkSpeedLineChartModel;", "getNetworkUsage", "()Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkSpeedLineChartModel;", "legends", "Lcom/android/tools/idea/appinspection/inspectors/network/model/LegendsModel;", "getLegends", "()Lcom/android/tools/idea/appinspection/inspectors/network/model/LegendsModel;", "tooltipLegends", "getTooltipLegends", "trafficAxis", "Lcom/android/tools/adtui/model/axis/ClampedAxisComponentModel;", "Lorg/jetbrains/annotations/NotNull;", "getTrafficAxis", "()Lcom/android/tools/adtui/model/axis/ClampedAxisComponentModel;", "stackTraceModel", "Lcom/android/tools/inspectors/common/api/stacktrace/StackTraceModel;", "getStackTraceModel", "()Lcom/android/tools/inspectors/common/api/stacktrace/StackTraceModel;", "rangeSelectionModel", "Lcom/android/tools/adtui/model/RangeSelectionModel;", "getRangeSelectionModel", "()Lcom/android/tools/adtui/model/RangeSelectionModel;", "selectionRangeDataFetcher", "Lcom/android/tools/idea/appinspection/inspectors/network/model/connections/SelectionRangeDataFetcher;", "getSelectionRangeDataFetcher", "()Lcom/android/tools/idea/appinspection/inspectors/network/model/connections/SelectionRangeDataFetcher;", "Lcom/android/tools/adtui/model/TooltipModel;", "tooltip", "getTooltip", "()Lcom/android/tools/adtui/model/TooltipModel;", "setTooltip", "(Lcom/android/tools/adtui/model/TooltipModel;)V", "setSelectedConnection", "", "data", "setSelectedRule", "rule", "reset", "", "isLive", "DetailContent", "app-inspection.inspectors.network.model"})
public final class NetworkInspectorModel
extends AspectModel<NetworkInspectorAspect> {
    @NotNull
    private final NetworkInspectorDataSource dataSource;
    @NotNull
    private DetailContent detailContent;
    @NotNull
    private final String name;
    @Nullable
    private ConnectionData selectedConnection;
    @Nullable
    private RuleData selectedRule;
    @NotNull
    private final AspectModel<NetworkInspectorAspect> aspect;
    @NotNull
    private final Timeline timeline;
    @NotNull
    private final NetworkSpeedLineChartModel networkUsage;
    @NotNull
    private final LegendsModel legends;
    @NotNull
    private final LegendsModel tooltipLegends;
    @NotNull
    private final ClampedAxisComponentModel trafficAxis;
    @NotNull
    private final StackTraceModel stackTraceModel;
    @NotNull
    private final RangeSelectionModel rangeSelectionModel;
    @NotNull
    private final SelectionRangeDataFetcher selectionRangeDataFetcher;
    @Nullable
    private TooltipModel tooltip;

    public NetworkInspectorModel(@NotNull NetworkInspectorServices services, @NotNull NetworkInspectorDataSource dataSource, @NotNull CoroutineScope scope, @NotNull ConnectionDataModel connectionsModel) {
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)connectionsModel, (String)"connectionsModel");
        this.dataSource = dataSource;
        this.detailContent = DetailContent.EMPTY;
        this.name = "NETWORK";
        this.aspect = new AspectModel();
        this.timeline = Intrinsics.areEqual((Object)((Boolean)StudioFlags.NETWORK_INSPECTOR_STATIC_TIMELINE.get()), (Object)true) ? (Timeline)new NetworkTimeline(services.getUpdater()) : (Timeline)new StreamingTimeline(services.getUpdater());
        this.networkUsage = new NetworkSpeedLineChartModel(this.timeline, this.dataSource, ExecutorsKt.asExecutor((CoroutineDispatcher)services.getWorkerDispatcher()));
        Range range = this.timeline.getDataRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getDataRange(...)");
        this.legends = new LegendsModel(this.networkUsage, range, false);
        Range range2 = this.timeline.getTooltipRange();
        Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"getTooltipRange(...)");
        this.tooltipLegends = new LegendsModel(this.networkUsage, range2, true);
        ClampedAxisComponentModel clampedAxisComponentModel = new ClampedAxisComponentModel.Builder(this.networkUsage.getTrafficRange(), NetworkInspectorModelKt.access$getTRAFFIC_AXIS_FORMATTER$p()).build();
        Intrinsics.checkNotNullExpressionValue((Object)clampedAxisComponentModel, (String)"build(...)");
        this.trafficAxis = clampedAxisComponentModel;
        this.stackTraceModel = new StackTraceModel(services.getNavigationProvider().getCodeNavigator());
        this.rangeSelectionModel = new RangeSelectionModel(this.timeline.getSelectionRange(), this.timeline.getViewRange());
        Range range3 = this.timeline.getSelectionRange();
        Intrinsics.checkNotNullExpressionValue((Object)range3, (String)"getSelectionRange(...)");
        Range range4 = this.timeline.getDataRange();
        Intrinsics.checkNotNullExpressionValue((Object)range4, (String)"getDataRange(...)");
        this.selectionRangeDataFetcher = new SelectionRangeDataFetcher(connectionsModel, range3, range4);
        services.getUpdater().register((Updatable)this.networkUsage);
        services.getUpdater().register((Updatable)this.trafficAxis);
        if (((Boolean)StudioFlags.NETWORK_INSPECTOR_STATIC_TIMELINE.get()).booleanValue()) {
            this.dataSource.addOnExtendTimelineListener((Function1<? super Long, Unit>)((Function1)arg_0 -> NetworkInspectorModel._init_$lambda$0(scope, services, this, arg_0)));
        }
        this.dataSource.start();
    }

    public /* synthetic */ NetworkInspectorModel(NetworkInspectorServices networkInspectorServices, NetworkInspectorDataSource networkInspectorDataSource, CoroutineScope coroutineScope, ConnectionDataModel connectionDataModel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            connectionDataModel = new ConnectionDataModelImpl(networkInspectorDataSource);
        }
        this(networkInspectorServices, networkInspectorDataSource, coroutineScope, connectionDataModel);
    }

    @NotNull
    public final DetailContent getDetailContent() {
        return this.detailContent;
    }

    public final void setDetailContent(@NotNull DetailContent value2) {
        Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
        if (this.detailContent != value2) {
            this.detailContent = value2;
            this.aspect.changed((Enum)NetworkInspectorAspect.DETAILS);
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final ConnectionData getSelectedConnection() {
        return this.selectedConnection;
    }

    @Nullable
    public final RuleData getSelectedRule() {
        return this.selectedRule;
    }

    @NotNull
    public final AspectModel<NetworkInspectorAspect> getAspect() {
        return this.aspect;
    }

    @NotNull
    public final Timeline getTimeline() {
        return this.timeline;
    }

    @NotNull
    public final NetworkSpeedLineChartModel getNetworkUsage() {
        return this.networkUsage;
    }

    @NotNull
    public final LegendsModel getLegends() {
        return this.legends;
    }

    @NotNull
    public final LegendsModel getTooltipLegends() {
        return this.tooltipLegends;
    }

    @NotNull
    public final ClampedAxisComponentModel getTrafficAxis() {
        return this.trafficAxis;
    }

    @NotNull
    public final StackTraceModel getStackTraceModel() {
        return this.stackTraceModel;
    }

    @NotNull
    public final RangeSelectionModel getRangeSelectionModel() {
        return this.rangeSelectionModel;
    }

    @NotNull
    public final SelectionRangeDataFetcher getSelectionRangeDataFetcher() {
        return this.selectionRangeDataFetcher;
    }

    @Nullable
    public final TooltipModel getTooltip() {
        return this.tooltip;
    }

    public final void setTooltip(@Nullable TooltipModel value2) {
        if (value2 != null && this.tooltip != null) {
            Class<?> clazz2 = value2.getClass();
            TooltipModel tooltipModel = this.tooltip;
            Intrinsics.checkNotNull((Object)tooltipModel);
            if (Intrinsics.areEqual(clazz2, tooltipModel.getClass())) {
                return;
            }
        }
        TooltipModel tooltipModel = this.tooltip;
        if (tooltipModel != null) {
            tooltipModel.dispose();
        }
        this.tooltip = value2;
        this.changed(NetworkInspectorAspect.TOOLTIP);
    }

    public final boolean setSelectedConnection(@Nullable ConnectionData data2) {
        if (Intrinsics.areEqual((Object)this.selectedConnection, (Object)data2)) {
            return false;
        }
        this.selectedConnection = data2;
        if (data2 == null && this.detailContent == DetailContent.CONNECTION) {
            this.setDetailContent(DetailContent.EMPTY);
        }
        this.aspect.changed((Enum)NetworkInspectorAspect.SELECTED_CONNECTION);
        return true;
    }

    public final boolean setSelectedRule(@Nullable RuleData rule) {
        if (Intrinsics.areEqual((Object)this.selectedRule, (Object)rule)) {
            return false;
        }
        this.selectedRule = rule;
        if (rule == null && this.detailContent == DetailContent.RULE) {
            this.setDetailContent(DetailContent.EMPTY);
        }
        this.aspect.changed((Enum)NetworkInspectorAspect.SELECTED_RULE);
        return true;
    }

    public final void reset() {
        this.dataSource.reset();
        this.timeline.getDataRange().clear();
        this.timeline.getSelectionRange().clear();
        this.timeline.getViewRange().clear();
        this.timeline.getTooltipRange().clear();
    }

    private final boolean isLive() {
        return this.timeline.getViewRange().getMax() < 0.0 || this.timeline.getViewRange().getMax() == this.timeline.getDataRange().getMax();
    }

    private static final Unit _init_$lambda$0(CoroutineScope $scope, NetworkInspectorServices $services, NetworkInspectorModel this$0, long it) {
        BuildersKt.launch$default((CoroutineScope)$scope, (CoroutineContext)((CoroutineContext)$services.getUiDispatcher()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, it, null){
            int label;
            final /* synthetic */ NetworkInspectorModel this$0;
            final /* synthetic */ long $it;
            {
                this.this$0 = $receiver;
                this.$it = $it;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        boolean isLive = NetworkInspectorModel.access$isLive(this.this$0);
                        double timestampUs = TimeUnit.NANOSECONDS.toMicros(this.$it);
                        if (this.this$0.getTimeline().getDataRange().isPoint()) {
                            this.this$0.getTimeline().getDataRange().setMin(timestampUs - (double)NetworkInspectorModelKt.access$getTIMELINE_PADDING_MS$p());
                        }
                        this.this$0.getTimeline().getDataRange().setMax(Math.max(timestampUs + (double)NetworkInspectorModelKt.access$getTIMELINE_PADDING_MS$p(), this.this$0.getTimeline().getDataRange().getMin() + (double)NetworkTimeline.Companion.getVIEW_LENGTH_US()));
                        if (isLive) {
                            this.this$0.getTimeline().resetZoom();
                        }
                        this.this$0.getNetworkUsage().invalidate();
                        this.this$0.getTimeline().getDataRange().changed((Enum)Range.Aspect.RANGE);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$isLive(NetworkInspectorModel $this) {
        return $this.isLive();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/model/NetworkInspectorModel$DetailContent;", "", "<init>", "(Ljava/lang/String;I)V", "CONNECTION", "RULE", "EMPTY", "app-inspection.inspectors.network.model"})
    public static final class DetailContent
    extends Enum<DetailContent> {
        public static final /* enum */ DetailContent CONNECTION = new DetailContent();
        public static final /* enum */ DetailContent RULE = new DetailContent();
        public static final /* enum */ DetailContent EMPTY = new DetailContent();
        private static final /* synthetic */ DetailContent[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DetailContent[] values() {
            return (DetailContent[])$VALUES.clone();
        }

        public static DetailContent valueOf(String value2) {
            return Enum.valueOf(DetailContent.class, value2);
        }

        @NotNull
        public static EnumEntries<DetailContent> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = detailContentArray = new DetailContent[]{DetailContent.CONNECTION, DetailContent.RULE, DetailContent.EMPTY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

