/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.backgroundtask.view;

import androidx.work.inspection.WorkManagerInspectorProtocol;
import backgroundtask.inspection.BackgroundTaskInspectorProtocol;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TreeWalker;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.ui.HideablePanel;
import com.android.tools.idea.appinspection.inspector.api.AppInspectionIdeServices;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.BackgroundTaskInspectorClient;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.BackgroundTaskTreeModel;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.EntrySelectionModel;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.EntryUpdateEventType;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.AlarmEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.BackgroundTaskCallStack;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.BackgroundTaskEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.JobEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.WakeLockEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.WorkEntry;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.BackgroundTaskEntriesView;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.BackgroundTaskInspectorTab;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.ClassNameProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.CloseButton;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.ComponentProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.EnqueuedAtProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.EntryDetailsStackTraceView;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.EntryIdProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.FlagsFormatter;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.IdListProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.JobConstraintProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.OutputDataProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.StateProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.StringListProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.TimeProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.ToStringProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.UiComponentsProvider;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.view.WorkConstraintProvider;
import com.android.tools.idea.protobuf.ProtocolStringList;
import com.google.wireless.android.sdk.stats.AppInspectionEvent;
import com.intellij.openapi.roots.ui.componentsList.components.ScrollablePanel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020\u0001*\u00060-j\u0002`.H\u0002J\u0018\u0010/\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u00100\u001a\u000201H\u0002J\u0018\u00104\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u00105\u001a\u000206H\u0002J\u0018\u00107\u001a\u00020$2\u0006\u0010(\u001a\u00020)2\u0006\u00108\u001a\u000209H\u0002J\u001e\u0010:\u001a\u00020\u00012\u0006\u0010;\u001a\u00020<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u001fH\u0002J3\u0010?\u001a\u00020\u0001\"\u0004\b\u0000\u0010@2\u0006\u0010A\u001a\u00020<2\u0006\u0010B\u001a\u0002H@2\u000e\b\u0002\u0010C\u001a\b\u0012\u0004\u0012\u0002H@0DH\u0002\u00a2\u0006\u0002\u0010EJ(\u0010F\u001a\u00020$*\u00020)2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020H0\u001f2\f\u0010I\u001a\b\u0012\u0004\u0012\u00020<0\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u00102\u001a\u000203X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/EntryDetailsView;", "Ljavax/swing/JPanel;", "tab", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/BackgroundTaskInspectorTab;", "client", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/BackgroundTaskInspectorClient;", "ideServices", "Lcom/android/tools/idea/appinspection/inspector/api/AppInspectionIdeServices;", "selectionModel", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/EntrySelectionModel;", "entriesView", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/BackgroundTaskEntriesView;", "uiComponentsProvider", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/UiComponentsProvider;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "uiDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "<init>", "(Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/BackgroundTaskInspectorTab;Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/BackgroundTaskInspectorClient;Lcom/android/tools/idea/appinspection/inspector/api/AppInspectionIdeServices;Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/EntrySelectionModel;Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/BackgroundTaskEntriesView;Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/UiComponentsProvider;Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/CoroutineDispatcher;)V", "getSelectionModel", "()Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/EntrySelectionModel;", "extraBottomPaddingMap", "", "Ljava/awt/Component;", "", "scrollPane", "Lcom/intellij/ui/components/JBScrollPane;", "entryIdProvider", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/EntryIdProvider;", "stackTraceViews", "", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/EntryDetailsStackTraceView;", "getStackTraceViews", "()Ljava/util/List;", "updateSelectedTask", "", "isSelectionChanged", "", "updateSelectedAlarm", "detailsPanel", "Lcom/intellij/openapi/roots/ui/componentsList/components/ScrollablePanel;", "alarm", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/AlarmEntry;", "createPendingIntentPanel", "Lbackgroundtask/inspection/BackgroundTaskInspectorProtocol$PendingIntent;", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/PendingIntentProto;", "updateSelectedWakeLock", "wakeLock", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/WakeLockEntry;", "classNameProvider", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/ClassNameProvider;", "updateSelectedJob", "jobEntry", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/JobEntry;", "updateSelectedWork", "workEntry", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/WorkEntry;", "buildCategoryPanel", "name", "", "entryComponents", "Ljavax/swing/JComponent;", "buildKeyValuePair", "T", "key", "value", "componentProvider", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/ComponentProvider;", "(Ljava/lang/String;Ljava/lang/Object;Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/view/ComponentProvider;)Ljavax/swing/JPanel;", "addStackTraceViews", "callStacks", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/BackgroundTaskCallStack;", "labels", "app-inspection.inspectors.backgroundtask.view"})
@SourceDebugExtension(value={"SMAP\nEntryDetailsView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntryDetailsView.kt\ncom/android/tools/idea/appinspection/inspectors/backgroundtask/view/EntryDetailsView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,544:1\n1878#2,3:545\n1869#2:548\n1870#2:550\n1573#2:551\n1604#2,4:552\n1563#2:556\n1634#2,3:557\n774#2:560\n865#2,2:561\n1563#2:563\n1634#2,3:564\n1583#2,11:567\n1878#2,2:578\n1880#2:581\n1594#2:582\n1869#2,2:583\n1#3:549\n1#3:580\n*S KotlinDebug\n*F\n+ 1 EntryDetailsView.kt\ncom/android/tools/idea/appinspection/inspectors/backgroundtask/view/EntryDetailsView\n*L\n200#1:545,3\n241#1:548\n241#1:550\n299#1:551\n299#1:552,4\n440#1:556\n440#1:557,3\n501#1:560\n501#1:561,2\n502#1:563\n502#1:564,3\n509#1:567,11\n509#1:578,2\n509#1:581\n509#1:582\n527#1:583,2\n509#1:580\n*E\n"})
public final class EntryDetailsView
extends JPanel {
    @NotNull
    private final BackgroundTaskInspectorTab tab;
    @NotNull
    private final BackgroundTaskInspectorClient client;
    @NotNull
    private final AppInspectionIdeServices ideServices;
    @NotNull
    private final EntrySelectionModel selectionModel;
    @NotNull
    private final BackgroundTaskEntriesView entriesView;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final CoroutineDispatcher uiDispatcher;
    @NotNull
    private final Map<Component, Integer> extraBottomPaddingMap;
    @NotNull
    private final JBScrollPane scrollPane;
    @NotNull
    private final EntryIdProvider entryIdProvider;
    @VisibleForTesting
    @NotNull
    private final List<EntryDetailsStackTraceView> stackTraceViews;
    @NotNull
    private final ClassNameProvider classNameProvider;

    public EntryDetailsView(@NotNull BackgroundTaskInspectorTab tab, @NotNull BackgroundTaskInspectorClient client, @NotNull AppInspectionIdeServices ideServices2, @NotNull EntrySelectionModel selectionModel, @NotNull BackgroundTaskEntriesView entriesView, @NotNull UiComponentsProvider uiComponentsProvider, @NotNull CoroutineScope scope, @NotNull CoroutineDispatcher uiDispatcher) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)ideServices2, (String)"ideServices");
        Intrinsics.checkNotNullParameter((Object)selectionModel, (String)"selectionModel");
        Intrinsics.checkNotNullParameter((Object)entriesView, (String)"entriesView");
        Intrinsics.checkNotNullParameter((Object)uiComponentsProvider, (String)"uiComponentsProvider");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)uiDispatcher, (String)"uiDispatcher");
        this.tab = tab;
        this.client = client;
        this.ideServices = ideServices2;
        this.selectionModel = selectionModel;
        this.entriesView = entriesView;
        this.scope = scope;
        this.uiDispatcher = uiDispatcher;
        this.extraBottomPaddingMap = new LinkedHashMap();
        this.scrollPane = new JBScrollPane();
        Object[] objectArray = new EntryDetailsStackTraceView[]{new EntryDetailsStackTraceView(uiComponentsProvider), new EntryDetailsStackTraceView(uiComponentsProvider)};
        this.stackTraceViews = CollectionsKt.listOf((Object[])objectArray);
        this.setLayout((LayoutManager)new TabularLayout("*", "28px,*"));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setMinimumSize(new Dimension(400, this.getMinimumSize().height));
        JPanel headingPanel = new JPanel(new BorderLayout());
        JLabel instanceViewLabel = new JLabel("Task Details");
        instanceViewLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        headingPanel.add((Component)instanceViewLabel, "West");
        CloseButton closeButton = new CloseButton(arg_0 -> EntryDetailsView._init_$lambda$0(this, arg_0));
        headingPanel.add((Component)((Object)closeButton), "East");
        this.add((Component)headingPanel, new TabularLayout.Constraint(0, 0, 0, 4, null));
        this.scrollPane.setBorder(AdtUiUtils.DEFAULT_TOP_BORDER);
        this.add((Component)this.scrollPane, new TabularLayout.Constraint(1, 0, 0, 4, null));
        this.entryIdProvider = new EntryIdProvider((Function1<? super BackgroundTaskEntry, Unit>)((Function1)arg_0 -> EntryDetailsView._init_$lambda$1(this, arg_0)));
        this.selectionModel.registerEntrySelectionListener((Function1<? super BackgroundTaskEntry, Unit>)((Function1)arg_0 -> EntryDetailsView._init_$lambda$2(this, arg_0)));
        this.client.addEntryUpdateEventListener((Function2<? super EntryUpdateEventType, ? super BackgroundTaskEntry, Unit>)((Function2)(arg_0, arg_1) -> EntryDetailsView._init_$lambda$3(this, arg_0, arg_1)));
        this.entriesView.addContentModeChangedListener((Function1<? super BackgroundTaskEntriesView.Mode, Unit>)((Function1)arg_0 -> EntryDetailsView._init_$lambda$4(this, arg_0)));
        this.classNameProvider = new ClassNameProvider(this.ideServices, this.client.getScope(), this.client.getTracker());
    }

    @NotNull
    public final EntrySelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @NotNull
    public final List<EntryDetailsStackTraceView> getStackTraceViews() {
        return this.stackTraceViews;
    }

    private final void updateSelectedTask(boolean isSelectionChanged) {
        VerticalLayout verticalLayout = new VerticalLayout(18);
        ScrollablePanel detailsPanel2 = new ScrollablePanel(verticalLayout){

            public boolean getScrollableTracksViewportWidth() {
                Container parent = SwingUtilities.getUnwrappedParent((Component)((Object)this));
                JViewport jViewport = parent instanceof JViewport ? (JViewport)parent : null;
                return (jViewport != null ? jViewport.getWidth() : 0) > this.getPreferredSize().width;
            }
        };
        detailsPanel2.setBorder(BorderFactory.createEmptyBorder(6, 16, 20, 30));
        BackgroundTaskEntry entry = this.selectionModel.getSelectedEntry();
        if (entry instanceof WorkEntry) {
            this.updateSelectedWork(detailsPanel2, (WorkEntry)entry);
        } else if (entry instanceof JobEntry) {
            this.updateSelectedJob(detailsPanel2, (JobEntry)entry);
        } else if (entry instanceof AlarmEntry) {
            this.updateSelectedAlarm(detailsPanel2, (AlarmEntry)entry);
        } else if (entry instanceof WakeLockEntry) {
            this.updateSelectedWakeLock(detailsPanel2, (WakeLockEntry)entry);
        }
        new TreeWalker((Component)detailsPanel2).descendantStream().forEach(arg_0 -> EntryDetailsView.updateSelectedTask$lambda$1(EntryDetailsView::updateSelectedTask$lambda$0, arg_0));
        detailsPanel2.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        int scrollBarPosition = this.scrollPane.getVerticalScrollBar().getValue();
        this.scrollPane.setViewportView((Component)detailsPanel2);
        if (!isSelectionChanged) {
            this.scrollPane.getVerticalScrollBar().setValue(scrollBarPosition);
        }
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSelectedAlarm(ScrollablePanel detailsPanel2, AlarmEntry alarm) {
        BackgroundTaskInspectorProtocol.AlarmSet alarmSet = alarm.getAlarmSet();
        if (alarmSet == null) {
            return;
        }
        BackgroundTaskInspectorProtocol.AlarmSet alarmSet2 = alarmSet;
        Object[] objectArray = new JPanel[]{EntryDetailsView.buildKeyValuePair$default(this, "Type", alarmSet2.getType(), null, 4, null)};
        List descriptions = CollectionsKt.mutableListOf((Object[])objectArray);
        if (alarmSet2.getIntervalMs() > 0L) {
            descriptions.add(EntryDetailsView.buildKeyValuePair$default(this, "Interval time", StringUtil.formatDuration((long)alarmSet2.getIntervalMs()), null, 4, null));
        }
        if (alarmSet2.getTriggerMs() > 0L) {
            descriptions.add(this.buildKeyValuePair("Trigger time", alarmSet2.getTriggerMs(), TimeProvider.INSTANCE));
        }
        String string = alarmSet2.getWindowMs() > 0L ? StringUtil.formatDuration((long)alarmSet2.getWindowMs()) : "Exact";
        Intrinsics.checkNotNull((Object)string);
        String windowTime = string;
        descriptions.add(EntryDetailsView.buildKeyValuePair$default(this, "Window time", windowTime, null, 4, null));
        if (alarmSet2.hasListener()) {
            descriptions.add(EntryDetailsView.buildKeyValuePair$default(this, "Listener tag", alarmSet2.getListener().getTag(), null, 4, null));
        }
        if (alarmSet2.hasOperation()) {
            BackgroundTaskInspectorProtocol.PendingIntent pendingIntent = alarmSet2.getOperation();
            Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"getOperation(...)");
            descriptions.add(this.createPendingIntentPanel(pendingIntent));
        }
        detailsPanel2.add((Component)this.buildCategoryPanel("Description", descriptions));
        Object[] objectArray2 = new JPanel[]{this.buildKeyValuePair("Time started", alarm.getStartTimeMs(), TimeProvider.INSTANCE)};
        List results2 = CollectionsKt.mutableListOf((Object[])objectArray2);
        BackgroundTaskInspectorProtocol.Event event = alarm.getLatestEvent();
        if (event != null) {
            BackgroundTaskInspectorProtocol.Event latestEvent = event;
            boolean bl = false;
            if (latestEvent.getBackgroundTaskEvent().hasAlarmFired() || latestEvent.getBackgroundTaskEvent().hasAlarmCancelled()) {
                long completeTimeMs = latestEvent.getTimestamp();
                Iterable $this$forEachIndexed$iv = alarm.getAlarmFiredTimestamps();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void timestamp;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    long l = ((Number)item$iv).longValue();
                    int index = n;
                    boolean bl2 = false;
                    results2.add(alarmSet2.getIntervalMs() > 0L ? this.buildKeyValuePair("Time fired #" + (index + 1), (long)timestamp, TimeProvider.INSTANCE) : this.buildKeyValuePair("Time fired", (long)timestamp, TimeProvider.INSTANCE));
                }
                if (Intrinsics.areEqual((Object)alarm.getStatus(), (Object)"CANCELLED")) {
                    results2.add(this.buildKeyValuePair("Time cancelled", completeTimeMs, TimeProvider.INSTANCE));
                }
                results2.add(EntryDetailsView.buildKeyValuePair$default(this, "Elapsed time", StringUtil.formatDuration((long)(completeTimeMs - alarm.getStartTimeMs())), null, 4, null));
            }
        }
        detailsPanel2.add((Component)this.buildCategoryPanel("Results", results2));
        objectArray2 = new String[]{"Set", "Cancelled"};
        this.addStackTraceViews(detailsPanel2, alarm.getCallstacks(), CollectionsKt.listOf((Object[])objectArray2));
    }

    private final JPanel createPendingIntentPanel(BackgroundTaskInspectorProtocol.PendingIntent $this$createPendingIntentPanel) {
        JPanel jPanel;
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.emptyLeft((int)20);
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"emptyLeft(...)");
        JBEmptyBorder indentBorder = jBEmptyBorder;
        JPanel panel2 = new JPanel((LayoutManager)new VerticalLayout(JBUI.scale((int)6)));
        panel2.add(new JLabel("Pending Intent:"));
        JPanel $this$createPendingIntentPanel_u24lambda_u240 = jPanel = new JPanel((LayoutManager)new VerticalLayout(JBUI.scale((int)6)));
        boolean bl = false;
        $this$createPendingIntentPanel_u24lambda_u240.setBorder((Border)indentBorder);
        $this$createPendingIntentPanel_u24lambda_u240.setName("PendingIntent");
        JPanel pendingIntentPanel = jPanel;
        panel2.add(pendingIntentPanel);
        pendingIntentPanel.add(EntryDetailsView.buildKeyValuePair$default(this, "Type", String.valueOf($this$createPendingIntentPanel.getType()), null, 4, null));
        String string = $this$createPendingIntentPanel.getCreatorPackage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCreatorPackage(...)");
        if (((CharSequence)string).length() > 0) {
            pendingIntentPanel.add(EntryDetailsView.buildKeyValuePair$default(this, "Creator", $this$createPendingIntentPanel.getCreatorPackage() + " (UID: " + $this$createPendingIntentPanel.getCreatorUid() + ")", null, 4, null));
        }
        if ($this$createPendingIntentPanel.getFlags() != 0) {
            String hexString = Integer.toHexString($this$createPendingIntentPanel.getFlags());
            String flagsString = FlagsFormatter.INSTANCE.pendingIntentFlagsAsString($this$createPendingIntentPanel.getFlags());
            pendingIntentPanel.add(EntryDetailsView.buildKeyValuePair$default(this, "Flags", "0x" + hexString + " (" + flagsString + ")", null, 4, null));
        }
        pendingIntentPanel.add(EntryDetailsView.buildKeyValuePair$default(this, "Request code", String.valueOf($this$createPendingIntentPanel.getRequestCode()), null, 4, null));
        List list2 = $this$createPendingIntentPanel.getIntentList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getIntentList(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JTextArea jTextArea;
            Object flagsString;
            JPanel jPanel2;
            BackgroundTaskInspectorProtocol.Intent intent = (BackgroundTaskInspectorProtocol.Intent)element$iv;
            boolean bl2 = false;
            pendingIntentPanel.add(new JLabel("Intent:"));
            JPanel $this$createPendingIntentPanel_u24lambda_u241_u240 = jPanel2 = new JPanel((LayoutManager)new VerticalLayout(JBUI.scale((int)6)));
            boolean bl3 = false;
            $this$createPendingIntentPanel_u24lambda_u241_u240.setBorder((Border)indentBorder);
            $this$createPendingIntentPanel_u24lambda_u241_u240.setName("Intent");
            JPanel intentPanel = jPanel2;
            pendingIntentPanel.add(intentPanel);
            if (intent.hasAction()) {
                intentPanel.add(EntryDetailsView.buildKeyValuePair$default(this, "Action", intent.getAction(), null, 4, null));
            }
            if (intent.hasData()) {
                intentPanel.add(EntryDetailsView.buildKeyValuePair$default(this, "Data", intent.getData(), null, 4, null));
            }
            if (intent.getCategoriesCount() > 0) {
                ProtocolStringList protocolStringList = intent.getCategoriesList();
                Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getCategoriesList(...)");
                intentPanel.add(EntryDetailsView.buildKeyValuePair$default(this, "Categories", CollectionsKt.joinToString$default((Iterable)((Iterable)protocolStringList), null, null, null, (int)0, null, EntryDetailsView::createPendingIntentPanel$lambda$1$1, (int)31, null), null, 4, null));
            }
            if (intent.hasComponentName()) {
                intentPanel.add(EntryDetailsView.buildKeyValuePair$default(this, "Component package", intent.getComponentName().getPackageName(), null, 4, null));
                intentPanel.add(this.buildKeyValuePair("Component class", intent.getComponentName().getClassName(), this.classNameProvider));
            }
            if (intent.hasIdentifier()) {
                intentPanel.add(EntryDetailsView.buildKeyValuePair$default(this, "Identifier", intent.getIdentifier(), null, 4, null));
            }
            if (intent.hasPackage()) {
                intentPanel.add(EntryDetailsView.buildKeyValuePair$default(this, "Package", intent.getPackage(), null, 4, null));
            }
            if (intent.hasType()) {
                intentPanel.add(EntryDetailsView.buildKeyValuePair$default(this, "Type", intent.getType(), null, 4, null));
            }
            if (intent.getFlags() != 0) {
                String hexString = Integer.toHexString(intent.getFlags());
                flagsString = FlagsFormatter.INSTANCE.intentFlagsAsString(intent.getFlags());
                intentPanel.add(EntryDetailsView.buildKeyValuePair$default(this, "Flags", "0x" + hexString + " (" + (String)flagsString + ")", null, 4, null));
            }
            if (!intent.hasExtras()) continue;
            Object $this$createPendingIntentPanel_u24lambda_u241_u242 = flagsString = new JPanel((LayoutManager)new TabularLayout("155px,*"));
            boolean bl4 = false;
            ((JComponent)$this$createPendingIntentPanel_u24lambda_u241_u242).setBorder((Border)JBUI.Borders.empty());
            Object extrasPanel = flagsString;
            Object $this$createPendingIntentPanel_u24lambda_u241_u243 = $this$createPendingIntentPanel_u24lambda_u241_u242 = new JLabel("Extras");
            boolean bl5 = false;
            ((JLabel)$this$createPendingIntentPanel_u24lambda_u241_u243).setVerticalAlignment(1);
            Object label2 = $this$createPendingIntentPanel_u24lambda_u241_u242;
            ((Container)extrasPanel).add((Component)label2, new TabularLayout.Constraint(0, 0, 0, 4, null));
            JTextArea $this$createPendingIntentPanel_u24lambda_u241_u244 = jTextArea = new JTextArea(intent.getExtras());
            boolean bl6 = false;
            $this$createPendingIntentPanel_u24lambda_u241_u244.setName("Extras");
            JTextArea extras = jTextArea;
            ((Container)extrasPanel).add((Component)extras, new TabularLayout.Constraint(0, 1, 0, 4, null));
            intentPanel.add((Component)extrasPanel);
        }
        return panel2;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSelectedWakeLock(ScrollablePanel detailsPanel2, WakeLockEntry wakeLock) {
        void $this$mapIndexedTo$iv$iv;
        Object[] objectArray = new JPanel[]{EntryDetailsView.buildKeyValuePair$default(this, "Tag", wakeLock.getTag(), null, 4, null), EntryDetailsView.buildKeyValuePair$default(this, "Level", wakeLock.getLevel(), null, 4, null)};
        detailsPanel2.add((Component)this.buildCategoryPanel("Description", CollectionsKt.listOf((Object[])objectArray)));
        Iterable $this$mapIndexed$iv = wakeLock.getEvents();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void event;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            BackgroundTaskInspectorProtocol.Event event2 = (BackgroundTaskInspectorProtocol.Event)item$iv$iv;
            int n2 = n;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            BackgroundTaskInspectorProtocol.BackgroundTaskEvent.MetadataCase metadataCase = event.getBackgroundTaskEvent().getMetadataCase();
            collection2.add(switch (metadataCase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[metadataCase.ordinal()]) {
                case 1 -> this.buildKeyValuePair("Acquired", event.getTimestamp(), TimeProvider.INSTANCE);
                case 2 -> this.buildKeyValuePair("Released", event.getTimestamp(), TimeProvider.INSTANCE);
                default -> throw new IllegalStateException("Unexpected event: " + event.getBackgroundTaskEvent().getMetadataCase());
            });
        }
        List results2 = (List)destination$iv$iv;
        detailsPanel2.add((Component)this.buildCategoryPanel("Results", results2));
        Object[] objectArray2 = new String[]{"Acquired", "Released"};
        this.addStackTraceViews(detailsPanel2, wakeLock.getCallstacks(), CollectionsKt.listOf((Object[])objectArray2));
    }

    private final void updateSelectedJob(ScrollablePanel detailsPanel2, JobEntry jobEntry) {
        Object[] objectArray;
        BackgroundTaskInspectorProtocol.JobInfo jobInfo = jobEntry.getJobInfo();
        if (jobInfo == null) {
            return;
        }
        BackgroundTaskInspectorProtocol.JobInfo job2 = jobInfo;
        detailsPanel2.add((Component)this.buildCategoryPanel("Description", CollectionsKt.listOf((Object)this.buildKeyValuePair("Service", job2.getServiceName(), this.classNameProvider))));
        Object object = new JPanel[]{this.buildKeyValuePair("Constraints", job2, JobConstraintProvider.INSTANCE), EntryDetailsView.buildKeyValuePair$default(this, "Frequency", job2.getIsPeriodic() ? "Periodic" : "OneTime", null, 4, null), this.buildKeyValuePair("State", jobEntry, StateProvider.INSTANCE)};
        List executions = CollectionsKt.mutableListOf((Object[])object);
        object = jobEntry.getTargetWorkId();
        if (object != null) {
            Object id2 = object;
            boolean bl = false;
            objectArray = this.client.getEntry((String)id2);
            if (objectArray != null) {
                Object[] workEntry = objectArray;
                boolean bl2 = false;
                executions.add(this.buildKeyValuePair("Related Worker", workEntry, this.entryIdProvider));
            }
        }
        detailsPanel2.add((Component)this.buildCategoryPanel("Execution", executions));
        objectArray = new JPanel[]{this.buildKeyValuePair("Time started", jobEntry.getStartTimeMs(), TimeProvider.INSTANCE)};
        List results2 = CollectionsKt.mutableListOf((Object[])objectArray);
        BackgroundTaskInspectorProtocol.Event event = jobEntry.getLatestEvent();
        if (event != null) {
            BackgroundTaskInspectorProtocol.Event latestEvent = event;
            boolean bl = false;
            if (latestEvent.getBackgroundTaskEvent().hasJobStopped() || latestEvent.getBackgroundTaskEvent().hasJobFinished()) {
                long completeTimeMs = latestEvent.getTimestamp();
                results2.add(this.buildKeyValuePair("Time completed", completeTimeMs, TimeProvider.INSTANCE));
                results2.add(EntryDetailsView.buildKeyValuePair$default(this, "Elapsed time", StringUtil.formatDuration((long)(completeTimeMs - jobEntry.getStartTimeMs())), null, 4, null));
                if (latestEvent.getBackgroundTaskEvent().hasJobFinished()) {
                    results2.add(EntryDetailsView.buildKeyValuePair$default(this, "Needs reschedule", latestEvent.getBackgroundTaskEvent().getJobFinished().getNeedsReschedule(), null, 4, null));
                }
                if (latestEvent.getBackgroundTaskEvent().hasJobStopped()) {
                    results2.add(EntryDetailsView.buildKeyValuePair$default(this, "Reschedule", latestEvent.getBackgroundTaskEvent().getJobStopped().getReschedule(), null, 4, null));
                }
            }
        }
        detailsPanel2.add((Component)this.buildCategoryPanel("Results", results2));
        objectArray = new String[]{"Scheduled", "Finished"};
        this.addStackTraceViews(detailsPanel2, jobEntry.getCallstacks(), CollectionsKt.listOf((Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSelectedWork(ScrollablePanel detailsPanel2, WorkEntry workEntry) {
        Object jobEntry;
        WorkManagerInspectorProtocol.WorkInfo work = workEntry.getWorkInfo();
        IdListProvider idListProvider2 = new IdListProvider(this.client, work, (Function1<? super WorkEntry, Unit>)((Function1)arg_0 -> EntryDetailsView.updateSelectedWork$lambda$0(this, arg_0)));
        Object[] objectArray = new JPanel[3];
        objectArray[0] = this.buildKeyValuePair("Class", work.getWorkerClassName(), this.classNameProvider);
        ProtocolStringList protocolStringList = work.getTagsList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getTagsList(...)");
        objectArray[1] = this.buildKeyValuePair("Tags", CollectionsKt.toList((Iterable)((Iterable)protocolStringList)), StringListProvider.INSTANCE);
        objectArray[2] = EntryDetailsView.buildKeyValuePair$default(this, "UUID", work.getId(), null, 4, null);
        detailsPanel2.add((Component)this.buildCategoryPanel("Description", CollectionsKt.listOf((Object[])objectArray)));
        Object[] objectArray2 = new JPanel[]{this.buildKeyValuePair("Enqueued by", work.getCallStack(), new EnqueuedAtProvider(this.ideServices, this.client.getScope(), this.client.getTracker())), this.buildKeyValuePair("Constraints", work.getConstraints(), WorkConstraintProvider.INSTANCE), EntryDetailsView.buildKeyValuePair$default(this, "Frequency", work.getIsPeriodic() ? "Periodic" : "OneTime", null, 4, null), this.buildKeyValuePair("State", workEntry, StateProvider.INSTANCE)};
        List executions = CollectionsKt.mutableListOf((Object[])objectArray2);
        BackgroundTaskTreeModel backgroundTaskTreeModel = this.entriesView.getTableView().getTreeModel();
        String string = work.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        JobEntry jobEntry2 = backgroundTaskTreeModel.getJobUnderWork(string);
        if (jobEntry2 != null) {
            jobEntry = jobEntry2;
            boolean bl = false;
            executions.add(this.buildKeyValuePair("Related Job", jobEntry, this.entryIdProvider));
        }
        detailsPanel2.add((Component)this.buildCategoryPanel("Execution", executions));
        if (workEntry.isValid()) {
            Collection<String> collection2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$updateSelectedWork_u24lambda_u245;
            Object $this$updateSelectedWork_u24lambda_u244;
            ActionLink switchContentModeLabel = this.entriesView.getContentMode() == BackgroundTaskEntriesView.Mode.TABLE ? new ActionLink("Show in graph", arg_0 -> EntryDetailsView.updateSelectedWork$lambda$2(this, arg_0)) : new ActionLink("Show in table", arg_0 -> EntryDetailsView.updateSelectedWork$lambda$3(this, arg_0));
            Object[] objectArray3 = new Object[4];
            jobEntry = switchContentModeLabel;
            JobEntry bl = jobEntry;
            int n = 0;
            Object[] objectArray4 = objectArray3;
            String string2 = "WorkContinuation";
            EntryDetailsView entryDetailsView = this;
            ScrollablePanel scrollablePanel = detailsPanel2;
            boolean bl2 = false;
            this.extraBottomPaddingMap.put((Component)$this$updateSelectedWork_u24lambda_u244, 10);
            Object object = Unit.INSTANCE;
            objectArray4[n] = jobEntry;
            ProtocolStringList protocolStringList2 = work.getPrerequisitesList();
            Intrinsics.checkNotNullExpressionValue((Object)protocolStringList2, (String)"getPrerequisitesList(...)");
            objectArray3[1] = this.buildKeyValuePair("Previous", CollectionsKt.toList((Iterable)((Iterable)protocolStringList2)), idListProvider2);
            ProtocolStringList protocolStringList3 = work.getDependentsList();
            Intrinsics.checkNotNullExpressionValue((Object)protocolStringList3, (String)"getDependentsList(...)");
            $this$updateSelectedWork_u24lambda_u244 = jobEntry = this.buildKeyValuePair("Next", CollectionsKt.toList((Iterable)((Iterable)protocolStringList3)), idListProvider2);
            n = 2;
            objectArray4 = objectArray3;
            boolean $i$a$-apply-EntryDetailsView$updateSelectedWork$42 = false;
            this.extraBottomPaddingMap.put((Component)$this$updateSelectedWork_u24lambda_u245, 14);
            object = Unit.INSTANCE;
            objectArray4[n] = jobEntry;
            String string3 = work.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getId(...)");
            jobEntry = this.client.getOrderedWorkChain(string3);
            String string4 = "Unique work chain";
            object = this;
            n = 3;
            objectArray4 = objectArray3;
            boolean $i$f$map = false;
            void $i$a$-apply-EntryDetailsView$updateSelectedWork$42 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                WorkManagerInspectorProtocol.WorkInfo workInfo = (WorkManagerInspectorProtocol.WorkInfo)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl3 = false;
                collection2.add(it.getId());
            }
            collection2 = (List)destination$iv$iv;
            objectArray4[n] = super.buildKeyValuePair(string4, collection2, idListProvider2);
            scrollablePanel.add((Component)entryDetailsView.buildCategoryPanel(string2, CollectionsKt.listOf((Object[])objectArray3)));
        }
        objectArray2 = new JPanel[]{this.buildKeyValuePair("Time started", work.getScheduleRequestedAt(), TimeProvider.INSTANCE), EntryDetailsView.buildKeyValuePair$default(this, "Run count", work.getRunAttemptCount(), null, 4, null), this.buildKeyValuePair("Output data", work, OutputDataProvider.INSTANCE)};
        detailsPanel2.add((Component)this.buildCategoryPanel("Results", CollectionsKt.listOf((Object[])objectArray2)));
    }

    private final JPanel buildCategoryPanel(String name2, List<? extends JComponent> entryComponents) {
        JPanel panel2 = new JPanel((LayoutManager)new VerticalLayout(6));
        TitledSeparator headingPanel = new TitledSeparator(name2);
        headingPanel.setMinimumSize(new Dimension(0, 34));
        panel2.add((Component)headingPanel);
        for (JComponent jComponent : entryComponents) {
            jComponent.setBorder(BorderFactory.createEmptyBorder(0, 18, ((Number)this.extraBottomPaddingMap.getOrDefault(jComponent, 0)).intValue(), 0));
            panel2.add(jComponent);
        }
        return panel2;
    }

    private final <T> JPanel buildKeyValuePair(String key, T value2, ComponentProvider<T> componentProvider) {
        JComponent jComponent;
        JPanel jPanel;
        JPanel $this$buildKeyValuePair_u24lambda_u240 = jPanel = new JPanel((LayoutManager)new TabularLayout("155px,*"));
        boolean bl = false;
        $this$buildKeyValuePair_u24lambda_u240.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel panel2 = jPanel;
        JPanel keyPanel = new JPanel(new BorderLayout());
        keyPanel.add((Component)new JBLabel(key), "North");
        panel2.add((Component)keyPanel, new TabularLayout.Constraint(0, 0, 0, 4, null));
        JComponent $this$buildKeyValuePair_u24lambda_u241 = jComponent = componentProvider.convert(value2);
        boolean bl2 = false;
        $this$buildKeyValuePair_u24lambda_u241.setName(key);
        JComponent valueComponent = jComponent;
        panel2.add((Component)valueComponent, new TabularLayout.Constraint(0, 1, 0, 4, null));
        return panel2;
    }

    static /* synthetic */ JPanel buildKeyValuePair$default(EntryDetailsView entryDetailsView, String string, Object object, ComponentProvider componentProvider, int n, Object object2) {
        if ((n & 4) != 0) {
            componentProvider = new ToStringProvider();
        }
        return entryDetailsView.buildKeyValuePair(string, object, componentProvider);
    }

    /*
     * WARNING - void declaration
     */
    private final void addStackTraceViews(ScrollablePanel $this$addStackTraceViews, List<BackgroundTaskCallStack> callStacks, List<String> labels) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable iterable = CollectionsKt.zip((Iterable)labels, (Iterable)callStacks);
        boolean $i$f$filter = false;
        void var7_7 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)((BackgroundTaskCallStack)it.getSecond()).getStack()).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(TuplesKt.to((Object)(new SimpleDateFormat("H:mm:ss.SSS", Locale.getDefault()).format(((BackgroundTaskCallStack)it.getSecond()).getTriggerTime()) + " " + it.getFirst()), (Object)((BackgroundTaskCallStack)it.getSecond()).getStack()));
        }
        List labelsToStackTraces = (List)destination$iv$iv;
        if (!((Collection)labelsToStackTraces).isEmpty()) {
            void $this$mapIndexedNotNullTo$iv$iv;
            Iterable $this$mapIndexedNotNull$iv = labelsToStackTraces;
            boolean $i$f$mapIndexedNotNull = false;
            destination$iv$iv = $this$mapIndexedNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapIndexedNotNullTo = false;
            void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv$iv = 0;
            for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                HideablePanel hideablePanel;
                void element$iv$iv;
                int n;
                if ((n = index$iv$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv$iv;
                int index$iv$iv = n;
                boolean bl = false;
                Pair pair = (Pair)element$iv$iv;
                int i = index$iv$iv;
                boolean bl3 = false;
                switch (i) {
                    case 0: 
                    case 1: {
                        HideablePanel hideablePanel2;
                        void pair2;
                        this.stackTraceViews.get(i).updateTrace((String)pair2.getSecond());
                        Intrinsics.checkNotNullExpressionValue((Object)new HideablePanel.Builder((String)pair2.getFirst(), this.stackTraceViews.get(i).getComponent()).setContentBorder((Border)new JBEmptyBorder(5, 0, 0, 0)).setPanelBorder((Border)new JBEmptyBorder(0, 0, 0, 0)).setTitleRightPadding(0).build(), (String)"build(...)");
                        hideablePanel = hideablePanel2;
                        break;
                    }
                    default: {
                        hideablePanel = null;
                    }
                }
                if (hideablePanel == null) continue;
                HideablePanel it$iv$iv = hideablePanel;
                boolean bl4 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List stackTraceComponents = (List)destination$iv$iv2;
            JPanel containerPanel = new JPanel((LayoutManager)new VerticalLayout(6));
            Iterable $this$forEach$iv = stackTraceComponents;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HideablePanel it2 = (HideablePanel)element$iv;
                boolean bl = false;
                containerPanel.add((Component)it2);
            }
            $this$addStackTraceViews.add((Component)this.buildCategoryPanel("Callstacks", CollectionsKt.listOf((Object)containerPanel)));
        }
    }

    private static final void _init_$lambda$0(EntryDetailsView this$0, ActionEvent it) {
        this$0.tab.setDetailsViewVisible(false);
    }

    private static final Unit _init_$lambda$1(EntryDetailsView this$0, BackgroundTaskEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this$0.selectionModel.setSelectedEntry(entry);
        this$0.client.getTracker().trackWorkSelected(AppInspectionEvent.BackgroundTaskInspectorEvent.Context.DETAILS_CONTEXT);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(EntryDetailsView this$0, BackgroundTaskEntry entry) {
        if (entry == null) {
            this$0.tab.setDetailsViewVisible(false);
        } else {
            this$0.updateSelectedTask(true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(EntryDetailsView this$0, EntryUpdateEventType type, BackgroundTaskEntry backgroundTaskEntry) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)backgroundTaskEntry, (String)"<unused var>");
        BuildersKt.launch$default((CoroutineScope)this$0.scope, (CoroutineContext)((CoroutineContext)this$0.uiDispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(type, this$0, null){
            int label;
            final /* synthetic */ EntryUpdateEventType $type;
            final /* synthetic */ EntryDetailsView this$0;
            {
                this.$type = $type;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (this.$type == EntryUpdateEventType.UPDATE || this.$type == EntryUpdateEventType.REMOVE) {
                            EntryDetailsView.access$updateSelectedTask(this.this$0, false);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(EntryDetailsView this$0, BackgroundTaskEntriesView.Mode it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        if (this$0.selectionModel.getSelectedEntry() instanceof WorkEntry) {
            this$0.updateSelectedTask(false);
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateSelectedTask$lambda$0(Component it) {
        it.setBackground(null);
        return Unit.INSTANCE;
    }

    private static final void updateSelectedTask$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final CharSequence createPendingIntentPanel$lambda$1$1(String it) {
        Intrinsics.checkNotNull((Object)it);
        return it;
    }

    private static final Unit updateSelectedWork$lambda$0(EntryDetailsView this$0, WorkEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.selectionModel.setSelectedEntry(it);
        BuildersKt.launch$default((CoroutineScope)this$0.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, it, null){
            int label;
            final /* synthetic */ EntryDetailsView this$0;
            final /* synthetic */ WorkEntry $it;
            {
                this.this$0 = $receiver;
                this.$it = $it;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = EntryDetailsView.access$getIdeServices$p(this.this$0).navigateTo(AppInspectionIdeServices.CodeLocation.Companion.forClass(this.$it.getClassName()), (Continuation<? super Unit>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        EntryDetailsView.access$getClient$p(this.this$0).getTracker().trackJumpedToSource();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this$0.client.getTracker().trackWorkSelected(AppInspectionEvent.BackgroundTaskInspectorEvent.Context.DETAILS_CONTEXT);
        return Unit.INSTANCE;
    }

    private static final Unit updateSelectedWork$lambda$2(EntryDetailsView this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.entriesView.setContentMode(BackgroundTaskEntriesView.Mode.GRAPH);
        return Unit.INSTANCE;
    }

    private static final Unit updateSelectedWork$lambda$3(EntryDetailsView this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.entriesView.setContentMode(BackgroundTaskEntriesView.Mode.TABLE);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$updateSelectedTask(EntryDetailsView $this, boolean isSelectionChanged) {
        $this.updateSelectedTask(isSelectionChanged);
    }

    public static final /* synthetic */ AppInspectionIdeServices access$getIdeServices$p(EntryDetailsView $this) {
        return $this.ideServices;
    }

    public static final /* synthetic */ BackgroundTaskInspectorClient access$getClient$p(EntryDetailsView $this) {
        return $this.client;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BackgroundTaskInspectorProtocol.BackgroundTaskEvent.MetadataCase.values().length];
            try {
                nArray[BackgroundTaskInspectorProtocol.BackgroundTaskEvent.MetadataCase.WAKE_LOCK_ACQUIRED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackgroundTaskInspectorProtocol.BackgroundTaskEvent.MetadataCase.WAKE_LOCK_RELEASED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

