/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.pagealign;

import com.android.ide.common.pagealign.PageAlignUtilsKt;
import com.android.tools.apk.analyzer.ArchiveEntry;
import com.android.tools.apk.analyzer.ArchiveNode;
import com.android.tools.apk.analyzer.ZipEntryInfo;
import com.android.tools.idea.apk.viewer.pagealign.AlignmentFinding;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0019\u0010\u0006\u001a\u00020\u0007*\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\n\u001a7\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010\u001a#\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\t\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0016\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"IS_PAGE_ALIGN_ENABLED", "", "getHumanReadablePageSize", "", "sizeInBytes", "", "getAlignmentFinding", "Lcom/android/tools/idea/apk/viewer/pagealign/AlignmentFinding;", "Lcom/android/tools/apk/analyzer/ArchiveEntry;", "extractNativeLibs", "(Lcom/android/tools/apk/analyzer/ArchiveEntry;Ljava/lang/Boolean;)Lcom/android/tools/idea/apk/viewer/pagealign/AlignmentFinding;", "path", "elfMinimumLoadSectionAlignment", "selfOrChildLoadSectionIncompatible", "zipAlignment", "Lcom/android/tools/apk/analyzer/ZipEntryInfo$Alignment;", "(Ljava/lang/String;Ljava/lang/Boolean;JZLcom/android/tools/apk/analyzer/ZipEntryInfo$Alignment;)Lcom/android/tools/idea/apk/viewer/pagealign/AlignmentFinding;", "findPageAlignWarningsPaths", "", "Ljavax/swing/tree/TreePath;", "root", "Lcom/android/tools/apk/analyzer/ArchiveNode;", "(Lcom/android/tools/apk/analyzer/ArchiveNode;Ljava/lang/Boolean;)Ljava/util/List;", "intellij.android.apkanalyzer"})
public final class AlignmentFindingKt {
    public static final boolean IS_PAGE_ALIGN_ENABLED = true;

    private static final String getHumanReadablePageSize(long sizeInBytes) {
        if (sizeInBytes == -1L) {
            return "";
        }
        if (sizeInBytes >= 1024L && sizeInBytes % 1024L == 0L) {
            return sizeInBytes / (long)1024 + " KB";
        }
        return sizeInBytes + " B";
    }

    @NotNull
    public static final AlignmentFinding getAlignmentFinding(@NotNull ArchiveEntry $this$getAlignmentFinding, @Nullable Boolean extractNativeLibs) {
        Intrinsics.checkNotNullParameter((Object)$this$getAlignmentFinding, (String)"<this>");
        String string = String.valueOf($this$getAlignmentFinding.getPath());
        long l = $this$getAlignmentFinding.getElfMinimumLoadSectionAlignment();
        boolean bl = $this$getAlignmentFinding.getSelfOrChild16kbIncompatible();
        ZipEntryInfo.Alignment alignment = $this$getAlignmentFinding.getFileAlignment();
        Intrinsics.checkNotNullExpressionValue((Object)alignment, (String)"getFileAlignment(...)");
        return AlignmentFindingKt.getAlignmentFinding(string, extractNativeLibs, l, bl, alignment);
    }

    @VisibleForTesting
    @NotNull
    public static final AlignmentFinding getAlignmentFinding(@NotNull String path, @Nullable Boolean extractNativeLibs, long elfMinimumLoadSectionAlignment, boolean selfOrChildLoadSectionIncompatible, @NotNull ZipEntryInfo.Alignment zipAlignment) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)zipAlignment, (String)"zipAlignment");
        StringBuilder sb = new StringBuilder();
        boolean hasWarning = false;
        String pageAlignText = AlignmentFindingKt.getHumanReadablePageSize(elfMinimumLoadSectionAlignment);
        String zipAlignText = zipAlignment.text;
        if (selfOrChildLoadSectionIncompatible) {
            String warning;
            boolean isLoadSectionAligned = PageAlignUtilsKt.is16kAligned((long)elfMinimumLoadSectionAlignment);
            boolean isZipAligned = zipAlignment != ZipEntryInfo.Alignment.ALIGNMENT_4K;
            Object object = Intrinsics.areEqual((Object)extractNativeLibs, (Object)true) ? "" : (Intrinsics.areEqual((Object)path, (Object)"/") ? "APK does not support 16 KB devices" : (elfMinimumLoadSectionAlignment == -1L ? "" : (!isLoadSectionAligned && !isZipAligned ? zipAlignText + " zip and " + pageAlignText + " LOAD section, but 16 KB is required for both" : (warning = !isLoadSectionAligned ? pageAlignText + " LOAD section alignment, but 16 KB is required" : (!isZipAligned ? zipAlignment.text + " zip alignment, but 16 KB is required" : "")))));
            if (((CharSequence)warning).length() > 0) {
                sb.append(warning);
                hasWarning = true;
            }
        } else if (Intrinsics.areEqual((Object)pageAlignText, (Object)zipAlignText) || ((CharSequence)pageAlignText).length() == 0) {
            sb.append(zipAlignText);
        } else {
            Intrinsics.checkNotNull((Object)zipAlignText);
            if (((CharSequence)zipAlignText).length() > 0) {
                sb.append(zipAlignText + " zip|" + pageAlignText + " LOAD section");
            }
        }
        return new AlignmentFinding(String.valueOf(sb), hasWarning);
    }

    @NotNull
    public static final List<TreePath> findPageAlignWarningsPaths(@NotNull ArchiveNode root, @Nullable Boolean extractNativeLibs) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        List expand = new ArrayList();
        AlignmentFindingKt.findPageAlignWarningsPaths$findPageAlignWarningsPaths(extractNativeLibs, expand, new TreePath(root), root);
        return expand;
    }

    private static final void findPageAlignWarningsPaths$findPageAlignWarningsPaths(Boolean $extractNativeLibs, List<TreePath> expand, TreePath path, ArchiveNode node) {
        ArchiveEntry archiveEntry = node.getData();
        Intrinsics.checkNotNullExpressionValue((Object)archiveEntry, (String)"getData(...)");
        AlignmentFinding alignment = AlignmentFindingKt.getAlignmentFinding(archiveEntry, $extractNativeLibs);
        if (alignment.getHasWarning()) {
            expand.add(path);
        }
        for (ArchiveNode child : node.getChildren()) {
            TreePath treePath = path.pathByAddingChild(child);
            Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"pathByAddingChild(...)");
            Intrinsics.checkNotNull((Object)child);
            AlignmentFindingKt.findPageAlignWarningsPaths$findPageAlignWarningsPaths($extractNativeLibs, expand, treePath, child);
        }
    }
}

