/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.arsc;

import com.android.tools.apk.analyzer.BinaryXmlParser;
import com.google.common.collect.ImmutableList;
import com.google.devrel.gmscore.tools.apk.arsc.PackageChunk;
import com.google.devrel.gmscore.tools.apk.arsc.ResourceIdentifier;
import com.google.devrel.gmscore.tools.apk.arsc.ResourceValue;
import com.google.devrel.gmscore.tools.apk.arsc.StringPoolChunk;
import com.google.devrel.gmscore.tools.apk.arsc.TypeChunk;
import com.google.devrel.gmscore.tools.apk.arsc.TypeSpecChunk;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;

public class ResourceTypeTableModel
extends AbstractTableModel {
    private final StringPoolChunk myStringPool;
    private final PackageChunk myPackageChunk;
    private final TypeSpecChunk myTypeSpec;
    private final List<TypeChunk> myTypes;

    public ResourceTypeTableModel(@NotNull StringPoolChunk stringPool, @NotNull PackageChunk packageChunk, @NotNull TypeSpecChunk typeSpec) {
        this.myStringPool = stringPool;
        this.myPackageChunk = packageChunk;
        this.myTypeSpec = typeSpec;
        this.myTypes = ImmutableList.copyOf((Collection)packageChunk.getTypeChunks(typeSpec.getId()));
    }

    @Override
    public int getRowCount() {
        return this.myTypeSpec.getResourceCount();
    }

    @Override
    public int getColumnCount() {
        return this.myTypes.size() + 2;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            ResourceIdentifier id2 = ResourceIdentifier.create((int)this.myPackageChunk.getId(), (int)this.myTypeSpec.getId(), (int)row);
            return id2.toString();
        }
        if (col == 1) {
            String key = "unknown";
            for (TypeChunk type : this.myTypes) {
                TypeChunk.Entry entry = (TypeChunk.Entry)type.getEntries().get(row);
                if (entry == null) continue;
                key = entry.key();
                break;
            }
            return key;
        }
        TypeChunk typeChunk = this.myTypes.get(col - 2);
        if (typeChunk.getEntries().containsKey(row)) {
            TypeChunk.Entry entry = (TypeChunk.Entry)typeChunk.getEntries().get(row);
            ResourceValue value2 = entry.value();
            if (value2 != null) {
                return this.formatValue(value2);
            }
            Map values = entry.values();
            if (values != null) {
                return values.values().stream().map(this::formatValue).collect(Collectors.joining(", "));
            }
            return "?";
        }
        return "";
    }

    @NotNull
    private String formatValue(@NotNull ResourceValue value2) {
        if (value2.type() == ResourceValue.Type.STRING) {
            return this.myStringPool.getString(value2.data());
        }
        return BinaryXmlParser.formatValue((ResourceValue)value2, (StringPoolChunk)this.myStringPool);
    }

    @Override
    public String getColumnName(int column2) {
        if (column2 == 0) {
            return "ID";
        }
        if (column2 == 1) {
            return "Name";
        }
        TypeChunk typeChunk = this.myTypes.get(column2 - 2);
        return typeChunk.getConfiguration().toString();
    }
}

