/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.ide.common.process.ProcessException;
import com.android.ide.common.xml.AndroidManifestParser;
import com.android.ide.common.xml.ManifestData;
import com.android.tools.apk.analyzer.AaptInvoker;
import com.android.tools.apk.analyzer.AndroidApplicationInfo;
import com.android.tools.apk.analyzer.ApkSizeCalculator;
import com.android.tools.apk.analyzer.Archive;
import com.android.tools.apk.analyzer.ArchiveContext;
import com.android.tools.apk.analyzer.ArchiveEntry;
import com.android.tools.apk.analyzer.ArchiveNode;
import com.android.tools.apk.analyzer.ArchivePathEntry;
import com.android.tools.apk.analyzer.ArchiveTreeStructure;
import com.android.tools.apk.analyzer.ZipEntryInfo;
import com.android.tools.apk.analyzer.internal.AppBundleArchive;
import com.android.tools.idea.apk.viewer.ApkViewPanel;
import com.android.tools.idea.apk.viewer.ProtoXmlPrettyPrinterImpl;
import com.android.tools.idea.log.LogWrapper;
import com.android.utils.ILogger;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.diagnostic.Logger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ApkParser {
    private static final ListeningExecutorService ourExecutorService = MoreExecutors.listeningDecorator((ExecutorService)PooledThreadExecutor.INSTANCE);
    private final ArchiveContext myArchiveContext;
    private final ApkSizeCalculator myApkSizeCalculator;
    @Nullable
    private ListenableFuture<ArchiveNode> myTreeStructure;
    @Nullable
    private ListenableFuture<ArchiveNode> myTreeStructureWithDownloadSizes;
    @Nullable
    private ListenableFuture<Long> myRawFullApkSize;
    @Nullable
    private ListenableFuture<Long> myCompressedFullApkSize;
    @Nullable
    private ListenableFuture<Align16kbCompliance> myAlign16kbCompliance;

    public ApkParser(@NotNull ArchiveContext archiveContext, @NotNull ApkSizeCalculator sizeCalculator) {
        this.myArchiveContext = archiveContext;
        this.myApkSizeCalculator = sizeCalculator;
    }

    @NotNull
    public Archive getArchive() {
        return this.myArchiveContext.getArchive();
    }

    public synchronized void cancelAll() {
        ListenableFuture[] futures;
        for (ListenableFuture future2 : futures = new ListenableFuture[]{this.myTreeStructureWithDownloadSizes, this.myTreeStructure, this.myRawFullApkSize, this.myCompressedFullApkSize, this.myAlign16kbCompliance}) {
            if (future2 == null) continue;
            future2.cancel(true);
        }
    }

    @NotNull
    public synchronized ListenableFuture<ArchiveNode> constructTreeStructure() {
        if (this.myTreeStructure == null) {
            this.myTreeStructure = ourExecutorService.submit(this::createTreeNode);
        }
        return this.myTreeStructure;
    }

    @NotNull
    public synchronized ListenableFuture<ArchiveNode> updateTreeWithDownloadSizes() {
        if (this.myTreeStructureWithDownloadSizes == null) {
            this.myTreeStructureWithDownloadSizes = Futures.transform(this.constructTreeStructure(), input2 -> {
                ArchiveTreeStructure.updateDownloadFileSizes((ArchiveNode)input2, (ApkSizeCalculator)this.myApkSizeCalculator);
                return input2;
            }, (Executor)PooledThreadExecutor.INSTANCE);
        }
        return this.myTreeStructureWithDownloadSizes;
    }

    @NotNull
    public synchronized ListenableFuture<AndroidApplicationInfo> getApplicationInfo(@NotNull Path pathToAapt, @Nullable ArchiveEntry entry) {
        return ourExecutorService.submit(() -> ApkParser.getAppInfo(pathToAapt, entry));
    }

    @NotNull
    public synchronized ListenableFuture<Long> getUncompressedApkSize() {
        if (this.myRawFullApkSize == null) {
            this.myRawFullApkSize = ourExecutorService.submit(() -> this.myApkSizeCalculator.getFullApkRawSize(this.myArchiveContext.getArchive().getPath()));
        }
        return this.myRawFullApkSize;
    }

    @NotNull
    public synchronized ListenableFuture<Long> getCompressedFullApkSize() {
        if (this.myCompressedFullApkSize == null) {
            this.myCompressedFullApkSize = ourExecutorService.submit(() -> this.myApkSizeCalculator.getFullApkDownloadSize(this.myArchiveContext.getArchive().getPath()));
        }
        return this.myCompressedFullApkSize;
    }

    @NotNull
    public synchronized ListenableFuture<Align16kbCompliance> getAlign16kbCompliance() {
        if (this.myAlign16kbCompliance == null) {
            this.myAlign16kbCompliance = ourExecutorService.submit(() -> {
                boolean hasElfFiles = false;
                boolean hasNonCompliantElfFiles = false;
                for (ZipEntryInfo info : this.myApkSizeCalculator.getInfoPerFile(this.myArchiveContext.getArchive().getPath()).values()) {
                    if (!info.isElf) continue;
                    hasElfFiles = true;
                    if (info.elfLoadSectionAlignment % 16384L == 0L && (info.isCompressed || info.zipAlignment == ZipEntryInfo.Alignment.ALIGNMENT_16K)) continue;
                    hasNonCompliantElfFiles = true;
                    break;
                }
                if (!hasElfFiles) {
                    return Align16kbCompliance.NO_ELF_FILES;
                }
                if (hasNonCompliantElfFiles) {
                    return Align16kbCompliance.NON_COMPLIANT;
                }
                return Align16kbCompliance.COMPLIANT;
            });
        }
        return this.myAlign16kbCompliance;
    }

    @NotNull
    private ArchiveNode createTreeNode() {
        ArchiveNode node = ArchiveTreeStructure.create((ArchiveContext)this.myArchiveContext);
        ArchiveTreeStructure.updateFileInfo((ArchiveNode)node, (ApkSizeCalculator)this.myApkSizeCalculator);
        return node;
    }

    @NotNull
    public static AndroidApplicationInfo getAppInfo(Path pathToAapt, @Nullable Archive archive) {
        if (archive == null) {
            return AndroidApplicationInfo.UNKNOWN;
        }
        Path path = archive.getContentRoot().resolve("AndroidManifest.xml");
        return ApkParser.getAppInfo(pathToAapt, (ArchiveEntry)new ArchivePathEntry(archive, path, ""));
    }

    @NotNull
    public static AndroidApplicationInfo getAppInfo(Path pathToAapt, @Nullable ArchiveEntry archiveEntry) {
        if (archiveEntry == null) {
            return AndroidApplicationInfo.UNKNOWN;
        }
        Archive archive = archiveEntry.getArchive();
        try {
            if (archive instanceof AppBundleArchive) {
                return ApkParser.getAppInfoFromAppBundle(archiveEntry);
            }
            return ApkParser.getAppInfoFromApk(pathToAapt, archiveEntry);
        }
        catch (Throwable e) {
            if (Files.exists(archive.getPath(), new LinkOption[0])) {
                Logger.getInstance(ApkViewPanel.class).warn("Unable to retrieve application info from artifact", e);
            }
            return AndroidApplicationInfo.UNKNOWN;
        }
    }

    private static AndroidApplicationInfo getAppInfoFromAppBundle(@NotNull ArchiveEntry entry) throws Exception {
        byte[] content2 = Files.readAllBytes(entry.getPath());
        String doc = new ProtoXmlPrettyPrinterImpl().prettyPrint(content2);
        byte[] decodedContent = doc.getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream stream = new ByteArrayInputStream(decodedContent);){
            ManifestData data2 = AndroidManifestParser.parse((InputStream)stream);
            AndroidApplicationInfo androidApplicationInfo = new AndroidApplicationInfo(data2.getPackage(), data2.getVersionName(), (long)data2.getVersionCode().intValue(), data2.getExtractNativeLibs());
            return androidApplicationInfo;
        }
    }

    @NotNull
    private static AndroidApplicationInfo getAppInfoFromApk(Path pathToAapt, @NotNull ArchiveEntry archiveEntry) throws ProcessException {
        AaptInvoker invoker = new AaptInvoker(pathToAapt, (ILogger)new LogWrapper(ApkParser.class));
        File archiveFile = archiveEntry.getArchive().getPath().toFile();
        String entryPath = archiveEntry.getPath().toString();
        if (entryPath.startsWith("/")) {
            entryPath = entryPath.substring(1);
        }
        List xmlTree = invoker.getXmlTree(archiveFile, entryPath);
        return AndroidApplicationInfo.parse((List)xmlTree);
    }

    public static enum Align16kbCompliance {
        NO_ELF_FILES,
        COMPLIANT,
        NON_COMPLIANT;

    }
}

