/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.apk.analyzer.ApkSizeCalculator;
import com.android.tools.apk.analyzer.Archive;
import com.android.tools.apk.analyzer.ArchiveContext;
import com.android.tools.apk.analyzer.ArchiveEntry;
import com.android.tools.apk.analyzer.Archives;
import com.android.tools.apk.analyzer.BinaryXmlParser;
import com.android.tools.apk.analyzer.dex.ProguardMappings;
import com.android.tools.apk.analyzer.internal.AppBundleArchive;
import com.android.tools.apk.analyzer.internal.ArchiveTreeNode;
import com.android.tools.idea.FileEditorUtil;
import com.android.tools.idea.apk.viewer.AndroidApplicationInfoProvider;
import com.android.tools.idea.apk.viewer.ApkEditor;
import com.android.tools.idea.apk.viewer.ApkFileEditorComponent;
import com.android.tools.idea.apk.viewer.ApkFileSystem;
import com.android.tools.idea.apk.viewer.ApkParser;
import com.android.tools.idea.apk.viewer.ApkViewPanel;
import com.android.tools.idea.apk.viewer.ApkVirtualFile;
import com.android.tools.idea.apk.viewer.BaselineProfilePrettyPrinter;
import com.android.tools.idea.apk.viewer.EmptyPanel;
import com.android.tools.idea.apk.viewer.FileEditorComponent;
import com.android.tools.idea.apk.viewer.ProtoXmlPrettyPrinter;
import com.android.tools.idea.apk.viewer.ProtoXmlPrettyPrinterImpl;
import com.android.tools.idea.apk.viewer.arsc.ArscViewer;
import com.android.tools.idea.apk.viewer.dex.DexFileViewer;
import com.android.tools.idea.apk.viewer.diff.ApkDiffPanel;
import com.android.tools.idea.apk.viewer.pagealign.AlignmentFinding;
import com.android.tools.idea.apk.viewer.pagealign.AlignmentFindingKt;
import com.android.tools.idea.apk.viewer.pagealign.AlignmentWarningViewer;
import com.android.tools.idea.log.LogWrapper;
import com.android.tools.instrumentation.threading.agent.callback.ThreadingCheckerUtil;
import com.android.tools.proguard.ProguardMap;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.limits.FileSizeLimit;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.FocusTraversalPolicy;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.LayoutFocusTraversalPolicy;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 D2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001DB/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0007H\u0002J\u001d\u0010\"\u001a\u00020 2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$H\u0016\u00a2\u0006\u0002\u0010&J\b\u0010'\u001a\u00020 H\u0016J\b\u0010(\u001a\u00020)H\u0016J\n\u0010*\u001a\u0004\u0018\u00010)H\u0016J\b\u0010+\u001a\u00020\u0010H\u0016J\u0010\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\fH\u0016J\b\u00100\u001a\u00020\fH\u0016J\u0010\u00101\u001a\u00020 2\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020 2\u0006\u00102\u001a\u000203H\u0016J\b\u00105\u001a\u00020\u0007H\u0016J\b\u00106\u001a\u00020 H\u0016J\b\u00107\u001a\u00020 H\u0002J\u001f\u00108\u001a\u00020\u00182\u0010\u00109\u001a\f\u0012\u0006\b\u0001\u0012\u00020%\u0018\u00010$H\u0007\u00a2\u0006\u0002\u0010:J\u001a\u0010;\u001a\u0004\u0018\u00010\u00072\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0002J\u0018\u0010@\u001a\b\u0012\u0004\u0012\u00020B0A2\b\u0010C\u001a\u0004\u0018\u00010\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0019\u001a\u0004\u0018\u00010\u001a8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006E"}, d2={"Lcom/android/tools/idea/apk/viewer/ApkEditor;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Lcom/android/tools/idea/apk/viewer/ApkViewPanel$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "baseFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "root", "applicationInfoProvider", "Lcom/android/tools/idea/apk/viewer/AndroidApplicationInfoProvider;", "isPageAlignFeatureEnabled", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/android/tools/idea/apk/viewer/AndroidApplicationInfoProvider;Z)V", "baseFileHash", "", "apkViewPanel", "Lcom/android/tools/idea/apk/viewer/ApkViewPanel;", "archiveContext", "Lcom/android/tools/apk/analyzer/ArchiveContext;", "splitter", "Lcom/intellij/ui/JBSplitter;", "currentEditor", "Lcom/android/tools/idea/apk/viewer/ApkFileEditorComponent;", "proguardMapping", "Lcom/android/tools/apk/analyzer/dex/ProguardMappings;", "getProguardMapping", "()Lcom/android/tools/apk/analyzer/dex/ProguardMappings;", "setProguardMapping", "(Lcom/android/tools/apk/analyzer/dex/ProguardMappings;)V", "refreshApk", "", "apkVirtualFile", "selectionChanged", "entries", "", "Lcom/android/tools/apk/analyzer/internal/ArchiveTreeNode;", "([Lcom/android/tools/apk/analyzer/internal/ArchiveTreeNode;)V", "selectApkAndCompare", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "getName", "setState", "state", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "isModified", "isValid", "addPropertyChangeListener", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "getFile", "dispose", "disposeArchive", "getEditor", "nodes", "([Lcom/android/tools/apk/analyzer/internal/ArchiveTreeNode;)Lcom/android/tools/idea/apk/viewer/ApkFileEditorComponent;", "createVirtualFile", "archive", "Lcom/android/tools/apk/analyzer/Archive;", "p", "Ljava/nio/file/Path;", "getFileEditorProviders", "Ljava/util/Optional;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "file", "Companion", "intellij.android.apkanalyzer"})
@SourceDebugExtension(value={"SMAP\nApkEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApkEditor.kt\ncom/android/tools/idea/apk/viewer/ApkEditor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,508:1\n11228#2:509\n11563#2,3:510\n37#3:513\n36#3,3:514\n*S KotlinDebug\n*F\n+ 1 ApkEditor.kt\ncom/android/tools/idea/apk/viewer/ApkEditor\n*L\n301#1:509\n301#1:510,3\n301#1:513\n301#1:514,3\n*E\n"})
public final class ApkEditor
extends UserDataHolderBase
implements FileEditor,
ApkViewPanel.Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile baseFile;
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final AndroidApplicationInfoProvider applicationInfoProvider;
    private final boolean isPageAlignFeatureEnabled;
    @NotNull
    private String baseFileHash;
    @Nullable
    private ApkViewPanel apkViewPanel;
    @Nullable
    private ArchiveContext archiveContext;
    @NotNull
    private final JBSplitter splitter;
    @Nullable
    private ApkFileEditorComponent currentEditor;
    @VisibleForTesting
    @Nullable
    private ProguardMappings proguardMapping;

    public ApkEditor(@NotNull Project project, @NotNull VirtualFile baseFile, @NotNull VirtualFile root, @NotNull AndroidApplicationInfoProvider applicationInfoProvider, boolean isPageAlignFeatureEnabled) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)baseFile, (String)"baseFile");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)applicationInfoProvider, (String)"applicationInfoProvider");
        this.project = project;
        this.baseFile = baseFile;
        this.root = root;
        this.applicationInfoProvider = applicationInfoProvider;
        this.isPageAlignFeatureEnabled = isPageAlignFeatureEnabled;
        this.baseFileHash = "";
        FileEditorUtil.DISABLE_GENERATED_FILE_NOTIFICATION_KEY.set((UserDataHolder)this, (Object)true);
        this.splitter = new JBSplitter(true, "android.apk.viewer", 0.62f);
        this.splitter.setName("apkViewerContainer");
        this.splitter.setFocusCycleRoot(true);
        this.splitter.setFocusTraversalPolicy((FocusTraversalPolicy)new LayoutFocusTraversalPolicy());
        MessageBusConnection connection2 = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        connection2.subscribe(topic, (Object)new BulkFileListener(){

            public void after(List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                String string = baseFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                String basePath = string;
                for (VFileEvent vFileEvent : events) {
                    if (!FileUtil.pathsEqual((String)basePath, (String)vFileEvent.getPath()) || !baseFile.isValid()) continue;
                    String string2 = baseFileHash;
                    Path path = Path.of(vFileEvent.getPath(), new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
                    if (Intrinsics.areEqual((Object)string2, (Object)Companion.generateHash(path))) continue;
                    this.refreshApk(baseFile);
                }
            }
        });
        this.refreshApk(this.baseFile);
        this.splitter.setSecondComponent(new EmptyPanel().getComponent());
    }

    @Nullable
    public final ProguardMappings getProguardMapping() {
        return this.proguardMapping;
    }

    public final void setProguardMapping(@Nullable ProguardMappings proguardMappings) {
        this.proguardMapping = proguardMappings;
    }

    private final void refreshApk(VirtualFile apkVirtualFile) {
        Project project = this.project;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, apkVirtualFile, project){
            final /* synthetic */ ApkEditor this$0;
            final /* synthetic */ VirtualFile $apkVirtualFile;
            {
                this.this$0 = $receiver;
                this.$apkVirtualFile = $apkVirtualFile;
                super($super_call_param$1, "Reading APK contents");
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ApkEditor.access$disposeArchive(this.this$0);
                try {
                    Path copyOfApk = Files.createTempFile(this.$apkVirtualFile.getNameWithoutExtension(), "." + this.$apkVirtualFile.getExtension(), new FileAttribute[0]);
                    FileUtils.copyFile((Path)VfsUtilCore.virtualToIoFile((VirtualFile)this.$apkVirtualFile).toPath(), (Path)copyOfApk);
                    ArchiveContext archiveContext = Archives.open((Path)copyOfApk, (ILogger)((ILogger)new LogWrapper(com.android.tools.idea.apk.viewer.ApkEditor$Companion.access$getLog(ApkEditor.Companion))));
                    Intrinsics.checkNotNullExpressionValue((Object)archiveContext, (String)"open(...)");
                    ArchiveContext context = archiveContext;
                    ApkEditor.access$setArchiveContext$p(this.this$0, context);
                    Archive archive = context.getArchive();
                    Intrinsics.checkNotNullExpressionValue((Object)archive, (String)"getArchive(...)");
                    Path path = this.$apkVirtualFile.toNioPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
                    this.this$0.setProguardMapping(com.android.tools.idea.apk.viewer.ApkEditor$Companion.access$loadProguardMapping(ApkEditor.Companion, archive, path));
                    ApkViewPanel panel2 = (ApkViewPanel)ThreadingCheckerUtil.withChecksDisabledForSupplier(() -> refreshApk.1.run$lambda$0(context, this.$apkVirtualFile, this.this$0));
                    ApkEditor.access$setApkViewPanel$p(this.this$0, panel2);
                    panel2.setListener(this.this$0);
                    ApplicationManager.getApplication().invokeLater(() -> refreshApk.1.run$lambda$1(this.this$0, panel2));
                    Path path2 = this.$apkVirtualFile.toNioPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toNioPath(...)");
                    String hash = com.android.tools.idea.apk.viewer.ApkEditor$Companion.access$generateHash(ApkEditor.Companion, path2);
                    if (hash != null) {
                        ApkEditor.access$setBaseFileHash$p(this.this$0, hash);
                    }
                }
                catch (IOException e) {
                    com.android.tools.idea.apk.viewer.ApkEditor$Companion.access$getLog(ApkEditor.Companion).error((Throwable)e);
                    ApkEditor.access$disposeArchive(this.this$0);
                    ApkEditor.access$getSplitter$p(this.this$0).setFirstComponent((JComponent)new JBLabel(e.toString()));
                }
            }

            private static final ApkViewPanel run$lambda$0(ArchiveContext $context, VirtualFile $apkVirtualFile, ApkEditor this$0) {
                return new ApkViewPanel(new ApkParser($context, ApkSizeCalculator.getDefault()), $apkVirtualFile.getName(), ApkEditor.access$getApplicationInfoProvider$p(this$0), ApkEditor.access$isPageAlignFeatureEnabled$p(this$0));
            }

            private static final void run$lambda$1(ApkEditor this$0, ApkViewPanel $panel) {
                ApkEditor.access$getSplitter$p(this$0).setFirstComponent($panel.getContainer());
                this$0.selectionChanged(null);
            }
        });
    }

    @Override
    public void selectionChanged(@Nullable ArchiveTreeNode[] entries2) {
        if (this.currentEditor != null) {
            ApkFileEditorComponent apkFileEditorComponent = this.currentEditor;
            Intrinsics.checkNotNull((Object)apkFileEditorComponent);
            Disposer.dispose((Disposable)apkFileEditorComponent);
            this.currentEditor = null;
        }
        ApkFileEditorComponent editor = this.getEditor(entries2);
        this.splitter.setSecondComponent(editor.getComponent());
        this.currentEditor = editor;
    }

    @Override
    public void selectApkAndCompare() {
        FileChooserDescriptor desc = new FileChooserDescriptor(true, false, false, false, false, false);
        desc.withFileFilter(ApkEditor::selectApkAndCompare$lambda$0);
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)desc, (Project)this.project, null);
        if (file == null) {
            return;
        }
        VirtualFile virtualFile = ApkFileSystem.getInstance().getRootByLocal(file);
        if (virtualFile == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        VirtualFile oldApk = virtualFile;
        DialogBuilder builder = new DialogBuilder(this.project);
        builder.setTitle(oldApk.getName() + " (old) vs " + this.root.getName() + " (new)");
        ApkDiffPanel panel2 = new ApkDiffPanel(oldApk, this.root);
        builder.setCenterPanel(panel2.getContainer());
        builder.setPreferredFocusComponent(panel2.getPreferredFocusedComponent());
        builder.addCloseButton();
        builder.show();
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)this.splitter;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (this.apkViewPanel == null) {
            return null;
        }
        ApkViewPanel apkViewPanel = this.apkViewPanel;
        Intrinsics.checkNotNull((Object)apkViewPanel);
        return apkViewPanel.getPreferredFocusedComponent();
    }

    @NotNull
    public String getName() {
        String string = this.baseFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    public void setState(@NotNull FileEditorState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return this.baseFile.isValid();
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    @NotNull
    public VirtualFile getFile() {
        return this.baseFile;
    }

    public void dispose() {
        if (this.currentEditor != null) {
            ApkFileEditorComponent apkFileEditorComponent = this.currentEditor;
            Intrinsics.checkNotNull((Object)apkFileEditorComponent);
            Disposer.dispose((Disposable)apkFileEditorComponent);
            this.currentEditor = null;
        }
        ApkEditor.Companion.getLog().info("Disposing ApkEditor with ApkViewPanel: " + this.apkViewPanel);
        this.disposeArchive();
    }

    private final void disposeArchive() {
        if (this.apkViewPanel != null) {
            ApkViewPanel apkViewPanel = this.apkViewPanel;
            Intrinsics.checkNotNull((Object)apkViewPanel);
            apkViewPanel.clearArchive();
        }
        if (this.archiveContext != null) {
            try {
                ArchiveContext archiveContext = this.archiveContext;
                Intrinsics.checkNotNull((Object)archiveContext);
                archiveContext.close();
                ArchiveContext archiveContext2 = this.archiveContext;
                Intrinsics.checkNotNull((Object)archiveContext2);
                Files.deleteIfExists(archiveContext2.getArchive().getPath());
            }
            catch (IOException e) {
                ApkEditor.Companion.getLog().warn((Throwable)e);
            }
            this.archiveContext = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final ApkFileEditorComponent getEditor(@Nullable ArchiveTreeNode[] nodes) {
        ArchiveEntry archiveEntry = nodes;
        if (archiveEntry == null || ((ArchiveTreeNode[])archiveEntry).length == 0) {
            return new EmptyPanel();
        }
        if (this.isPageAlignFeatureEnabled) {
            Boolean extractNativeLibs;
            Object object = this.apkViewPanel;
            Boolean bl = object != null && (object = ((ApkViewPanel)object).getTreeModel()) != null ? ((ApkViewPanel.ApkTreeModel)object).getExtractNativeLibs() : (extractNativeLibs = null);
            if (extractNativeLibs != null && ((ArchiveTreeNode[])nodes).length == 1) {
                ArchiveEntry archiveEntry2 = nodes[0].getData();
                Intrinsics.checkNotNullExpressionValue((Object)archiveEntry2, (String)"getData(...)");
                ArchiveEntry archiveEntry3 = archiveEntry2;
                AlignmentFinding alignment = AlignmentFindingKt.getAlignmentFinding(archiveEntry3, extractNativeLibs);
                if (alignment.getHasWarning()) {
                    return new AlignmentWarningViewer();
                }
            }
        }
        boolean allDex = true;
        for (ArchiveEntry path : nodes) {
            Path dataPath;
            Intrinsics.checkNotNullExpressionValue((Object)path.getData().getPath(), (String)"getPath(...)");
            Path fileName = dataPath.getFileName();
            if (fileName != null && !Files.isDirectory(dataPath, new LinkOption[0]) && StringsKt.endsWith$default((String)((Object)fileName).toString(), (String)".dex", (boolean)false, (int)2, null)) continue;
            allDex = false;
            break;
        }
        if (allDex) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            ArchiveEntry path;
            Object $this$map$iv = nodes;
            boolean $i$f$map = false;
            path = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((ArchiveEntry)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var12_19 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getData().getPath());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Path[] paths = thisCollection$iv.toArray(new Path[0]);
            return new DexFileViewer(this.project, paths, this.baseFile.getParent(), this.proguardMapping);
        }
        ArchiveTreeNode n = nodes[0];
        Path path = n.getData().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        Path p = path;
        Path fileName = p.getFileName();
        if (fileName == null) {
            return new EmptyPanel();
        }
        if (Intrinsics.areEqual((Object)"resources.arsc", (Object)((Object)fileName).toString())) {
            byte[] arscContent = null;
            try {
                arscContent = Files.readAllBytes(p);
            }
            catch (IOException iOException) {
                return new EmptyPanel();
            }
            return new ArscViewer(arscContent);
        }
        if (StringsKt.endsWith$default((String)((Object)p).toString(), (String)"kotlin_builtins", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)((Object)p).toString(), (String)"kotlin_metadata", (boolean)false, (int)2, null)) {
            return new EmptyPanel();
        }
        Archive archive = n.getData().getArchive();
        Intrinsics.checkNotNullExpressionValue((Object)archive, (String)"getArchive(...)");
        VirtualFile file = this.createVirtualFile(archive, p);
        Optional<FileEditorProvider> providers = this.getFileEditorProviders(file);
        if (providers.isEmpty()) {
            return new EmptyPanel();
        }
        if (file != null) {
            FileEditor fileEditor = providers.get().createEditor(this.project, file);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditor, (String)"createEditor(...)");
            FileEditor editor = fileEditor;
            return new FileEditorComponent(editor);
        }
        return new EmptyPanel();
    }

    private final VirtualFile createVirtualFile(Archive archive, Path p) {
        Path name2 = p.getFileName();
        if (name2 == null) {
            return null;
        }
        if (Files.isDirectory(p, new LinkOption[0])) {
            return null;
        }
        byte[] content2 = null;
        try {
            content2 = Files.readAllBytes(p);
        }
        catch (IOException e) {
            Logger logger = ApkEditor.Companion.getLog();
            String string = "Error loading entry \"%s\" from archive";
            Object[] objectArray = new Object[]{p};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            logger.warn(string2, (Throwable)e);
            return null;
        }
        if (archive.isBinaryXml(p, content2)) {
            content2 = BinaryXmlParser.decodeXml((byte[])content2);
            return ApkVirtualFile.create(p, content2);
        }
        if (archive.isProtoXml(p, content2)) {
            try {
                ProtoXmlPrettyPrinter prettyPrinter = new ProtoXmlPrettyPrinterImpl();
                String string = prettyPrinter.prettyPrint(content2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"prettyPrint(...)");
                String text2 = string;
                return ApkVirtualFile.createText(p, text2);
            }
            catch (IOException e) {
                Logger logger = ApkEditor.Companion.getLog();
                String string = "Error decoding XML entry \"%s\" from archive";
                Object[] objectArray = new Object[]{p};
                String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                logger.warn(string3, (Throwable)e);
                return ApkVirtualFile.create(p, content2);
            }
        }
        if (archive.isBaselineProfile(p, content2)) {
            byte[] byArray = content2;
            Intrinsics.checkNotNull((Object)byArray);
            String text3 = Companion.getPrettyPrintedBaseline(this.baseFile, byArray, p, FileSizeLimit.Companion.getContentLoadLimit(this.baseFile.getExtension()));
            return text3 == null ? ApkVirtualFile.create(p, content2) : ApkVirtualFile.createText(p, text3);
        }
        VirtualFile file = JarFileSystem.getInstance().findFileByPath(((Object)archive.getPath()).toString());
        VirtualFile virtualFile = file;
        if (virtualFile == null || (virtualFile = virtualFile.findFileByRelativePath(((Object)p).toString())) == null) {
            virtualFile = ApkVirtualFile.create(p, content2);
        }
        return virtualFile;
    }

    private final Optional<FileEditorProvider> getFileEditorProviders(VirtualFile file) {
        if (file == null || file.isDirectory()) {
            Optional<FileEditorProvider> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }
        List providers = FileEditorProviderManager.Companion.getInstance().getProviderList(this.project, file);
        Optional<Object> optional = providers.stream().filter(arg_0 -> ApkEditor.getFileEditorProviders$lambda$1(ApkEditor::getFileEditorProviders$lambda$0, arg_0)).findFirst();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"findFirst(...)");
        return optional;
    }

    private static final boolean selectApkAndCompare$lambda$0(VirtualFile file) {
        VirtualFile virtualFile = file;
        Intrinsics.checkNotNull((Object)virtualFile);
        return ApkFileSystem.EXTENSIONS.contains(virtualFile.getExtension());
    }

    private static final boolean getFileEditorProviders$lambda$0(FileEditorProvider fileEditorProvider) {
        FileEditorProvider fileEditorProvider2 = fileEditorProvider;
        Intrinsics.checkNotNull((Object)fileEditorProvider2);
        return !Intrinsics.areEqual((Object)fileEditorProvider2.getClass().getName(), (Object)"com.android.tools.idea.editors.NinePatchEditorProvider");
    }

    private static final boolean getFileEditorProviders$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$disposeArchive(ApkEditor $this) {
        $this.disposeArchive();
    }

    public static final /* synthetic */ void access$setArchiveContext$p(ApkEditor $this, ArchiveContext archiveContext) {
        $this.archiveContext = archiveContext;
    }

    public static final /* synthetic */ void access$setApkViewPanel$p(ApkEditor $this, ApkViewPanel apkViewPanel) {
        $this.apkViewPanel = apkViewPanel;
    }

    public static final /* synthetic */ void access$setBaseFileHash$p(ApkEditor $this, String string) {
        $this.baseFileHash = string;
    }

    public static final /* synthetic */ JBSplitter access$getSplitter$p(ApkEditor $this) {
        return $this.splitter;
    }

    public static final /* synthetic */ AndroidApplicationInfoProvider access$getApplicationInfoProvider$p(ApkEditor $this) {
        return $this.applicationInfoProvider;
    }

    public static final /* synthetic */ boolean access$isPageAlignFeatureEnabled$p(ApkEditor $this) {
        return $this.isPageAlignFeatureEnabled;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J*\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/apk/viewer/ApkEditor$Companion;", "", "<init>", "()V", "generateHash", "", "path", "Ljava/nio/file/Path;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "getPrettyPrintedBaseline", "basefile", "Lcom/intellij/openapi/vfs/VirtualFile;", "content", "", "maxChars", "", "loadProguardMapping", "Lcom/android/tools/apk/analyzer/dex/ProguardMappings;", "archive", "Lcom/android/tools/apk/analyzer/Archive;", "intellij.android.apkanalyzer"})
    public static final class Companion {
        private Companion() {
        }

        private final String generateHash(Path path) {
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                byte[] bytes2 = Files.readAllBytes(path);
                byte[] hashBytes = digest.digest(bytes2);
                StringBuilder hashString = new StringBuilder();
                Intrinsics.checkNotNull((Object)hashBytes);
                for (byte b : hashBytes) {
                    String string = "%02x";
                    Object[] objectArray = new Object[]{b};
                    String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    hashString.append(string2);
                }
                return hashString.toString();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }

        private final Logger getLog() {
            Logger logger = Logger.getInstance(ApkEditor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            return logger;
        }

        @VisibleForTesting
        @Nullable
        public final String getPrettyPrintedBaseline(@NotNull VirtualFile basefile, @NotNull byte[] content2, @NotNull Path path, int maxChars) {
            Intrinsics.checkNotNullParameter((Object)basefile, (String)"basefile");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String text2 = null;
            try {
                text2 = BaselineProfilePrettyPrinter.prettyPrint(basefile, path, content2);
            }
            catch (IOException e) {
                Logger logger = this.getLog();
                String string = "Error decoding baseline entry \"%s\" from archive";
                Object[] objectArray = new Object[]{path};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                logger.warn(string2, (Throwable)e);
                return null;
            }
            if (text2.length() > maxChars) {
                StringBuilder truncated = new StringBuilder(100000);
                byte[] byArray = text2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                int length = byArray.length;
                truncated.append(StringsKt.trimIndent((String)("\n              The contents of this baseline file is too large to show by default.\n              You can increase the maximum buffer size by setting the property\n                  idea.max.content.load.filesize=" + length + "\n              (or higher)\n              \n              \n          ")));
                try {
                    File file = File.createTempFile("baseline", ".txt");
                    Intrinsics.checkNotNull((Object)file);
                    FilesKt.writeText((File)file, (String)text2, (Charset)Charsets.UTF_8);
                    truncated.append(StringsKt.trimIndent((String)("\n              Alternatively, the full contents have been written to the following\n              temp file:\n              " + file.getPath() + "\n              \n              \n            ")));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                int truncateAt = Math.max(0, maxChars - 450);
                truncated.append(text2, 0, truncateAt).append("\n....truncated ").append(length - truncateAt).append(" characters.");
                return truncated.toString();
            }
            return text2;
        }

        private final ProguardMappings loadProguardMapping(Archive archive, Path path) {
            ProguardMappings proguardMappings;
            if (archive instanceof AppBundleArchive) {
                return ((AppBundleArchive)archive).loadProguardMapping();
            }
            Path path2 = path.getParent();
            if (path2 == null) {
                return null;
            }
            Path parent = path2;
            String variant = PathsKt.getName((Path)parent);
            Path path3 = parent.getParent();
            if (path3 == null || (path3 = path3.getParent()) == null || (path3 = path3.resolve("mapping/" + variant + "/mapping.txt")) == null) {
                return null;
            }
            Path mapping = path3;
            try {
                if (!Files.isRegularFile(mapping, new LinkOption[0])) {
                    this.getLog().info("No mapping file found at: " + mapping);
                    return null;
                }
                ProguardMap proguardMap = new ProguardMap();
                proguardMap.readFromFile(mapping.toFile());
                proguardMappings = new ProguardMappings(proguardMap, null, null);
            }
            catch (IOException e) {
                this.getLog().warn("Error loading Proguard mapping from " + mapping, (Throwable)e);
                proguardMappings = null;
            }
            return proguardMappings;
        }

        public static final /* synthetic */ ProguardMappings access$loadProguardMapping(Companion $this, Archive archive, Path path) {
            return $this.loadProguardMapping(archive, path);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

