/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.paths;

import com.android.tools.idea.apk.paths.PathNodeParent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class PathNode
extends PathNodeParent {
    @NotNull
    private final String myPathSegment;
    @NotNull
    private final String myPath;
    @Nullable
    private final PathNodeParent myParent;

    PathNode(@NotNull String pathSegment, @NotNull String path, @Nullable PathNodeParent parent) {
        this.myPathSegment = pathSegment;
        this.myPath = path;
        this.myParent = parent;
    }

    @NotNull
    public String getPathSegment() {
        return this.myPathSegment;
    }

    @NotNull
    public String getPath() {
        return this.myPath;
    }

    @Nullable
    public PathNodeParent getParent() {
        return this.myParent;
    }

    @TestOnly
    void print(@NotNull StringBuilder buffer, int level) {
        int spaceCount = level * 2;
        for (int i = 0; i < spaceCount; ++i) {
            buffer.append(' ');
        }
        buffer.append(this.getPathSegment()).append(System.lineSeparator());
        for (PathNode child : this.getChildren()) {
            child.print(buffer, level + 1);
        }
    }

    public String toString() {
        return this.myPath;
    }
}

