/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.adb.wireless.AdbDevicePairingModelListener;
import com.android.tools.idea.adb.wireless.AdbOnlineDevice;
import com.android.tools.idea.adb.wireless.PairingMdnsService;
import com.android.tools.idea.adb.wireless.PairingResult;
import com.android.tools.idea.adb.wireless.QrCodeImage;
import com.android.tools.idea.adb.wireless.TrackingMdnsService;
import com.android.tools.idea.adb.wireless.WiFiPairingDialog;
import com.android.tools.idea.adb.wireless.WiFiPairingModel;
import com.android.tools.idea.adb.wireless.WiFiPairingNotificationService;
import com.android.tools.idea.adb.wireless.WiFiPairingNotificationServiceKt;
import com.android.tools.idea.adb.wireless.WiFiPairingView;
import com.android.utils.HtmlBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u00019B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u0017H\u0016J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0017H\u0016J\b\u0010\u001e\u001a\u00020\u0017H\u0016J!\u0010\u001f\u001a\u00020 2\u0017\u0010!\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00170\"\u00a2\u0006\u0002\b#H\u0002J\b\u0010$\u001a\u00020\u0017H\u0016J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*H\u0016J\u0018\u0010+\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'2\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\u00172\u0006\u0010&\u001a\u00020'2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020\u0017H\u0016J\b\u00102\u001a\u00020\u0017H\u0016J\u0010\u00103\u001a\u00020\u00172\u0006\u00104\u001a\u00020\u0014H\u0016J\u0010\u00105\u001a\u00020\u00172\u0006\u00104\u001a\u00020\u0014H\u0016J\u0012\u00106\u001a\u00020\u00172\b\u00107\u001a\u0004\u0018\u000108H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/android/tools/idea/adb/wireless/WiFiPairingViewImpl;", "Lcom/android/tools/idea/adb/wireless/WiFiPairingView;", "project", "Lcom/intellij/openapi/project/Project;", "notificationService", "Lcom/android/tools/idea/adb/wireless/WiFiPairingNotificationService;", "model", "Lcom/android/tools/idea/adb/wireless/WiFiPairingModel;", "hyperlinkListener", "Ljavax/swing/event/HyperlinkListener;", "mdnsServiceUnderPairing", "Lcom/android/tools/idea/adb/wireless/TrackingMdnsService;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/adb/wireless/WiFiPairingNotificationService;Lcom/android/tools/idea/adb/wireless/WiFiPairingModel;Ljavax/swing/event/HyperlinkListener;Lcom/android/tools/idea/adb/wireless/TrackingMdnsService;)V", "getModel", "()Lcom/android/tools/idea/adb/wireless/WiFiPairingModel;", "dlg", "Lcom/android/tools/idea/adb/wireless/WiFiPairingDialog;", "listeners", "Ljava/util/ArrayList;", "Lcom/android/tools/idea/adb/wireless/WiFiPairingView$Listener;", "Lkotlin/collections/ArrayList;", "showDialog", "", "startMdnsCheck", "showMdnsCheckSuccess", "showMdnsNotSupportedError", "message", "", "showMdnsNotSupportedByAdbError", "showMdnsCheckError", "buildErrorHtml", "Lcom/android/utils/HtmlBuilder;", "build", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "showQrCodePairingStarted", "showQrCodePairingInProgress", "pairingMdnsService", "Lcom/android/tools/idea/adb/wireless/PairingMdnsService;", "showQrCodePairingWaitForDevice", "pairingResult", "Lcom/android/tools/idea/adb/wireless/PairingResult;", "showQrCodePairingSuccess", "device", "Lcom/android/tools/idea/adb/wireless/AdbOnlineDevice;", "showQrCodePairingError", "error", "", "showMacMdnsEnvironmentIsBroken", "showMdnsDisabledOnAdbServer", "addListener", "listener", "removeListener", "updateQrCodeImage", "image", "Lcom/android/tools/idea/adb/wireless/QrCodeImage;", "ModelListener", "intellij.android.adb"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nWiFiPairingViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WiFiPairingViewImpl.kt\ncom/android/tools/idea/adb/wireless/WiFiPairingViewImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n1#2:203\n1869#3,2:204\n1869#3,2:206\n1869#3,2:208\n*S KotlinDebug\n*F\n+ 1 WiFiPairingViewImpl.kt\ncom/android/tools/idea/adb/wireless/WiFiPairingViewImpl\n*L\n49#1:204,2\n51#1:206,2\n57#1:208,2\n*E\n"})
public final class WiFiPairingViewImpl
implements WiFiPairingView {
    @NotNull
    private final WiFiPairingNotificationService notificationService;
    @NotNull
    private final WiFiPairingModel model;
    @NotNull
    private final WiFiPairingDialog dlg;
    @NotNull
    private final ArrayList<WiFiPairingView.Listener> listeners;
    public static final int $stable = 8;

    public WiFiPairingViewImpl(@NotNull Project project, @NotNull WiFiPairingNotificationService notificationService, @NotNull WiFiPairingModel model, @NotNull HyperlinkListener hyperlinkListener, @Nullable TrackingMdnsService mdnsServiceUnderPairing) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notificationService, (String)"notificationService");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)hyperlinkListener, (String)"hyperlinkListener");
        this.notificationService = notificationService;
        this.model = model;
        this.listeners = new ArrayList();
        this.getModel().addListener(new ModelListener());
        this.dlg = new WiFiPairingDialog(project, true, DialogWrapper.IdeModalityType.IDE, hyperlinkListener, mdnsServiceUnderPairing);
        this.dlg.setPairingCodePairInvoked((Function1<? super PairingMdnsService, Unit>)((Function1)arg_0 -> WiFiPairingViewImpl._init_$lambda$0(this, arg_0)));
        this.dlg.setQrCodeScanAgainInvoked((Function0<Unit>)((Function0)() -> WiFiPairingViewImpl._init_$lambda$1(this)));
        Disposer.register((Disposable)this.dlg.getDisposable(), () -> WiFiPairingViewImpl._init_$lambda$2(this));
    }

    @Override
    @NotNull
    public WiFiPairingModel getModel() {
        return this.model;
    }

    @Override
    public void showDialog() {
        this.dlg.show();
    }

    @Override
    public void startMdnsCheck() {
        this.dlg.startLoading("Preparing Wi-Fi pairing...");
    }

    @Override
    public void showMdnsCheckSuccess() {
        this.updateQrCodeImage(this.getModel().getQrCodeImage());
        this.dlg.stopLoading();
    }

    @Override
    public void showMdnsNotSupportedError() {
        this.showMdnsNotSupportedError("This system does not meet the requirements to support Wi-Fi pairing.");
    }

    private final void showMdnsNotSupportedError(String message) {
        this.dlg.showLoadingError(this.buildErrorHtml((Function1<? super HtmlBuilder, Unit>)((Function1)arg_0 -> WiFiPairingViewImpl.showMdnsNotSupportedError$lambda$0(message, arg_0))));
    }

    @Override
    public void showMdnsNotSupportedByAdbError() {
        this.showMdnsNotSupportedError("The currently installed version of the \"Android Debug Bridge\" (adb) does not support Wi-Fi pairing.");
    }

    @Override
    public void showMdnsCheckError() {
        this.dlg.showLoadingError(this.buildErrorHtml((Function1<? super HtmlBuilder, Unit>)((Function1)WiFiPairingViewImpl::showMdnsCheckError$lambda$0)));
    }

    private final HtmlBuilder buildErrorHtml(Function1<? super HtmlBuilder, Unit> build2) {
        HtmlBuilder htmlBuilder;
        HtmlBuilder $this$buildErrorHtml_u24lambda_u240 = htmlBuilder = new HtmlBuilder();
        boolean bl = false;
        $this$buildErrorHtml_u24lambda_u240.beginDiv("text-align: center;");
        build2.invoke((Object)$this$buildErrorHtml_u24lambda_u240);
        $this$buildErrorHtml_u24lambda_u240.newline();
        $this$buildErrorHtml_u24lambda_u240.newline();
        $this$buildErrorHtml_u24lambda_u240.addLink("Learn more", "https://d.android.com/r/studio-ui/wifi-pairing");
        $this$buildErrorHtml_u24lambda_u240.endDiv();
        return htmlBuilder;
    }

    @Override
    public void showQrCodePairingStarted() {
        this.dlg.showQrCodePairingStarted();
    }

    @Override
    public void showQrCodePairingInProgress(@NotNull PairingMdnsService pairingMdnsService) {
        Intrinsics.checkNotNullParameter((Object)pairingMdnsService, (String)"pairingMdnsService");
        this.dlg.showQrCodePairingInProgress();
    }

    @Override
    public void showQrCodePairingWaitForDevice(@NotNull PairingResult pairingResult) {
        Intrinsics.checkNotNullParameter((Object)pairingResult, (String)"pairingResult");
        this.dlg.showQrCodePairingWaitForDevice();
    }

    @Override
    public void showQrCodePairingSuccess(@NotNull PairingMdnsService pairingMdnsService, @NotNull AdbOnlineDevice device2) {
        Intrinsics.checkNotNullParameter((Object)pairingMdnsService, (String)"pairingMdnsService");
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.dlg.showQrCodePairingSuccess(device2);
        WiFiPairingNotificationServiceKt.showPairingSuccessBalloon(this.notificationService, device2);
    }

    @Override
    public void showQrCodePairingError(@NotNull PairingMdnsService pairingMdnsService, @NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)pairingMdnsService, (String)"pairingMdnsService");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.dlg.showQrCodePairingError(error);
    }

    @Override
    public void showMacMdnsEnvironmentIsBroken() {
        this.dlg.showLoadingError(this.buildErrorHtml((Function1<? super HtmlBuilder, Unit>)((Function1)WiFiPairingViewImpl::showMacMdnsEnvironmentIsBroken$lambda$0)));
    }

    @Override
    public void showMdnsDisabledOnAdbServer() {
        this.dlg.showLoadingError(this.buildErrorHtml((Function1<? super HtmlBuilder, Unit>)((Function1)WiFiPairingViewImpl::showMdnsDisabledOnAdbServer$lambda$0)));
    }

    @Override
    public void addListener(@NotNull WiFiPairingView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull WiFiPairingView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    private final void updateQrCodeImage(QrCodeImage image) {
        block0: {
            QrCodeImage qrCodeImage = image;
            if (qrCodeImage == null) break block0;
            QrCodeImage it = qrCodeImage;
            boolean bl = false;
            this.dlg.setQrCodeImage(it);
        }
    }

    private static final Unit _init_$lambda$0(WiFiPairingViewImpl this$0, PairingMdnsService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Iterable $this$forEach$iv = this$0.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WiFiPairingView.Listener it = (WiFiPairingView.Listener)element$iv;
            boolean bl = false;
            it.onPairingCodePairAction(service);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(WiFiPairingViewImpl this$0) {
        Iterable $this$forEach$iv = this$0.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WiFiPairingView.Listener it = (WiFiPairingView.Listener)element$iv;
            boolean bl = false;
            it.onScanAnotherQrCodeDeviceAction();
        }
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$2(WiFiPairingViewImpl this$0) {
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this$0.listeners);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WiFiPairingView.Listener it = (WiFiPairingView.Listener)element$iv;
            boolean bl = false;
            it.onClose();
        }
    }

    private static final Unit showMdnsNotSupportedError$lambda$0(String $message, HtmlBuilder $this$buildErrorHtml) {
        Intrinsics.checkNotNullParameter((Object)$this$buildErrorHtml, (String)"$this$buildErrorHtml");
        $this$buildErrorHtml.add($message);
        $this$buildErrorHtml.newline();
        $this$buildErrorHtml.add("Please update to the latest version of \"platform-tools\" using the SDK manager.");
        $this$buildErrorHtml.newline();
        $this$buildErrorHtml.newline();
        $this$buildErrorHtml.addLink("Open SDK manager", "open-sdk-manager");
        return Unit.INSTANCE;
    }

    private static final Unit showMdnsCheckError$lambda$0(HtmlBuilder $this$buildErrorHtml) {
        Intrinsics.checkNotNullParameter((Object)$this$buildErrorHtml, (String)"$this$buildErrorHtml");
        $this$buildErrorHtml.add("There was an unexpected error during Wi-Fi pairing initialization.");
        return Unit.INSTANCE;
    }

    private static final Unit showMacMdnsEnvironmentIsBroken$lambda$0(HtmlBuilder $this$buildErrorHtml) {
        Intrinsics.checkNotNullParameter((Object)$this$buildErrorHtml, (String)"$this$buildErrorHtml");
        $this$buildErrorHtml.add("Please update to the latest version of \"platform-tools\" (minimum 35.0.2) with the ");
        $this$buildErrorHtml.addLink("SDK manager", "open-sdk-manager");
        $this$buildErrorHtml.add(".");
        $this$buildErrorHtml.newline();
        $this$buildErrorHtml.newline();
        $this$buildErrorHtml.add("Make sure mDNS backend 'default' is selected in ");
        $this$buildErrorHtml.addLink("ADB Settings", "open-adb-settings");
        $this$buildErrorHtml.add(".");
        $this$buildErrorHtml.newline();
        $this$buildErrorHtml.newline();
        return Unit.INSTANCE;
    }

    private static final Unit showMdnsDisabledOnAdbServer$lambda$0(HtmlBuilder $this$buildErrorHtml) {
        Intrinsics.checkNotNullParameter((Object)$this$buildErrorHtml, (String)"$this$buildErrorHtml");
        $this$buildErrorHtml.add("mDNS backend is disabled");
        $this$buildErrorHtml.newline();
        $this$buildErrorHtml.newline();
        $this$buildErrorHtml.add("1. Make sure it is enabled in ");
        $this$buildErrorHtml.addLink("ADB Settings", "open-adb-settings");
        $this$buildErrorHtml.add(".");
        $this$buildErrorHtml.newline();
        $this$buildErrorHtml.add("2. Make sure you are not using a manually managed ADB server.");
        $this$buildErrorHtml.newline();
        return Unit.INSTANCE;
    }

    @UiThread
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0083\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0016\u0010\f\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/adb/wireless/WiFiPairingViewImpl$ModelListener;", "Lcom/android/tools/idea/adb/wireless/AdbDevicePairingModelListener;", "<init>", "(Lcom/android/tools/idea/adb/wireless/WiFiPairingViewImpl;)V", "qrCodeGenerated", "", "newImage", "Lcom/android/tools/idea/adb/wireless/QrCodeImage;", "qrCodeServicesDiscovered", "services", "", "Lcom/android/tools/idea/adb/wireless/PairingMdnsService;", "pairingCodeServicesDiscovered", "intellij.android.adb"})
    private final class ModelListener
    implements AdbDevicePairingModelListener {
        @Override
        public void qrCodeGenerated(@NotNull QrCodeImage newImage) {
            Intrinsics.checkNotNullParameter((Object)newImage, (String)"newImage");
            WiFiPairingViewImpl.this.updateQrCodeImage(newImage);
        }

        @Override
        public void qrCodeServicesDiscovered(@NotNull List<PairingMdnsService> services) {
            Intrinsics.checkNotNullParameter(services, (String)"services");
        }

        @Override
        public void pairingCodeServicesDiscovered(@NotNull List<PairingMdnsService> services) {
            Intrinsics.checkNotNullParameter(services, (String)"services");
            WiFiPairingViewImpl.this.dlg.showPairingCodeServices(services);
        }
    }
}

