/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.adb.wireless.AdbOnlineDevice;
import com.android.tools.idea.adb.wireless.PairingMdnsService;
import com.android.tools.idea.adb.wireless.QrCodeImage;
import com.android.tools.idea.adb.wireless.TrackingMdnsService;
import com.android.tools.idea.adb.wireless.WiFiPairingPanel;
import com.android.tools.idea.ui.SimpleDialog;
import com.android.tools.idea.ui.SimpleDialogOptions;
import com.android.utils.HtmlBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020\u0017J\u000e\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020.J\u0006\u0010/\u001a\u00020\u0017J\u0014\u00100\u001a\u00020\u00172\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u001602J\u000e\u00103\u001a\u00020\u00172\u0006\u00104\u001a\u000205J\u0006\u00106\u001a\u00020\u0017J\u0006\u00107\u001a\u00020\u0017J\u0006\u00108\u001a\u00020\u0017J\u000e\u00109\u001a\u00020\u00172\u0006\u0010:\u001a\u00020;J\u000e\u0010<\u001a\u00020\u00172\u0006\u0010=\u001a\u00020>R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR \u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00170\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010?\u001a\u00020@8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010B\u00a8\u0006C"}, d2={"Lcom/android/tools/idea/adb/wireless/WiFiPairingDialog;", "", "project", "Lcom/intellij/openapi/project/Project;", "canBeParent", "", "ideModalityType", "Lcom/intellij/openapi/ui/DialogWrapper$IdeModalityType;", "hyperlinkListener", "Ljavax/swing/event/HyperlinkListener;", "mdnsServiceUnderPairing", "Lcom/android/tools/idea/adb/wireless/TrackingMdnsService;", "<init>", "(Lcom/intellij/openapi/project/Project;ZLcom/intellij/openapi/ui/DialogWrapper$IdeModalityType;Ljavax/swing/event/HyperlinkListener;Lcom/android/tools/idea/adb/wireless/TrackingMdnsService;)V", "getMdnsServiceUnderPairing", "()Lcom/android/tools/idea/adb/wireless/TrackingMdnsService;", "dialog", "Lcom/android/tools/idea/ui/SimpleDialog;", "pairingPanel", "Lcom/android/tools/idea/adb/wireless/WiFiPairingPanel;", "pairingCodePairInvoked", "Lkotlin/Function1;", "Lcom/android/tools/idea/adb/wireless/PairingMdnsService;", "", "getPairingCodePairInvoked", "()Lkotlin/jvm/functions/Function1;", "setPairingCodePairInvoked", "(Lkotlin/jvm/functions/Function1;)V", "qrCodeScanAgainInvoked", "Lkotlin/Function0;", "getQrCodeScanAgainInvoked", "()Lkotlin/jvm/functions/Function0;", "setQrCodeScanAgainInvoked", "(Lkotlin/jvm/functions/Function0;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "createCenterPanel", "Ljavax/swing/JComponent;", "show", "startLoading", "text", "", "showLoadingError", "html", "Lcom/android/utils/HtmlBuilder;", "stopLoading", "showPairingCodeServices", "services", "", "setQrCodeImage", "qrCodeImage", "Lcom/android/tools/idea/adb/wireless/QrCodeImage;", "showQrCodePairingStarted", "showQrCodePairingInProgress", "showQrCodePairingWaitForDevice", "showQrCodePairingSuccess", "device", "Lcom/android/tools/idea/adb/wireless/AdbOnlineDevice;", "showQrCodePairingError", "error", "", "panelPreferredSize", "Lcom/intellij/util/ui/JBDimension;", "getPanelPreferredSize", "()Lcom/intellij/util/ui/JBDimension;", "intellij.android.adb"})
@StabilityInferred(parameters=0)
public final class WiFiPairingDialog {
    @Nullable
    private final TrackingMdnsService mdnsServiceUnderPairing;
    @NotNull
    private final SimpleDialog dialog;
    @NotNull
    private final WiFiPairingPanel pairingPanel;
    @NotNull
    private Function1<? super PairingMdnsService, Unit> pairingCodePairInvoked;
    @NotNull
    private Function0<Unit> qrCodeScanAgainInvoked;
    public static final int $stable = 8;

    public WiFiPairingDialog(@NotNull Project project, boolean canBeParent, @NotNull DialogWrapper.IdeModalityType ideModalityType, @NotNull HyperlinkListener hyperlinkListener, @Nullable TrackingMdnsService mdnsServiceUnderPairing) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ideModalityType, (String)"ideModalityType");
        Intrinsics.checkNotNullParameter((Object)hyperlinkListener, (String)"hyperlinkListener");
        this.mdnsServiceUnderPairing = mdnsServiceUnderPairing;
        Object object = this.mdnsServiceUnderPairing;
        if (object == null || (object = ((TrackingMdnsService)object).getDisplayString()) == null) {
            object = "devices";
        }
        String string = "Pair " + (String)object + " over Wi-Fi";
        SimpleDialogOptions options = new SimpleDialogOptions(project, canBeParent, ideModalityType, string, true, () -> WiFiPairingDialog._init_$lambda$0(this), null, false, null, null, "Close", null, 2880, null);
        this.dialog = new SimpleDialog(options);
        this.pairingPanel = new WiFiPairingPanel(this.dialog.getDisposable(), hyperlinkListener, this.mdnsServiceUnderPairing);
        this.dialog.init();
        JComponent dialogPanel = this.dialog.getContentPanel();
        Border existingBorder = dialogPanel.getBorder();
        dialogPanel.setBorder((Border)JBUI.Borders.empty());
        if (dialogPanel.getLayout() instanceof BorderLayout) {
            JComponent southComponent;
            LayoutManager layoutManager = dialogPanel.getLayout();
            Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.BorderLayout");
            BorderLayout layout = (BorderLayout)layoutManager;
            Component component = layout.getLayoutComponent("South");
            JComponent jComponent = southComponent = component instanceof JComponent ? (JComponent)component : null;
            if (jComponent != null) {
                jComponent.setBorder(existingBorder);
            }
        }
        this.pairingCodePairInvoked = WiFiPairingDialog::pairingCodePairInvoked$lambda$0;
        this.qrCodeScanAgainInvoked = WiFiPairingDialog::qrCodeScanAgainInvoked$lambda$0;
    }

    @Nullable
    public final TrackingMdnsService getMdnsServiceUnderPairing() {
        return this.mdnsServiceUnderPairing;
    }

    @NotNull
    public final Function1<PairingMdnsService, Unit> getPairingCodePairInvoked() {
        return this.pairingCodePairInvoked;
    }

    public final void setPairingCodePairInvoked(@NotNull Function1<? super PairingMdnsService, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.pairingCodePairInvoked = function1;
    }

    @NotNull
    public final Function0<Unit> getQrCodeScanAgainInvoked() {
        return this.qrCodeScanAgainInvoked;
    }

    public final void setQrCodeScanAgainInvoked(@NotNull Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.qrCodeScanAgainInvoked = function0;
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.dialog.getDisposable();
    }

    @NotNull
    public final JComponent createCenterPanel() {
        this.pairingPanel.getRootComponent().setPreferredSize((Dimension)this.getPanelPreferredSize());
        if (SystemInfo.isMac) {
            this.pairingPanel.getRootComponent().setMinimumSize((Dimension)this.getPanelPreferredSize());
        }
        this.pairingPanel.setPairingCodePairInvoked((Function1<? super PairingMdnsService, Unit>)((Function1)arg_0 -> WiFiPairingDialog.createCenterPanel$lambda$0(this, arg_0)));
        this.pairingPanel.setQrCodeScanAgainInvoked((Function0<Unit>)((Function0)() -> WiFiPairingDialog.createCenterPanel$lambda$1(this)));
        return this.pairingPanel.getRootComponent();
    }

    public final void show() {
        this.dialog.show();
    }

    public final void startLoading(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.pairingPanel.setLoading(true);
        this.pairingPanel.setLoadingText(text2);
    }

    public final void showLoadingError(@NotNull HtmlBuilder html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        this.pairingPanel.setLoading(false);
        this.pairingPanel.setLoadingError(html);
    }

    public final void stopLoading() {
        this.pairingPanel.setLoading(false);
    }

    public final void showPairingCodeServices(@NotNull List<PairingMdnsService> services) {
        Intrinsics.checkNotNullParameter(services, (String)"services");
        this.pairingPanel.getPairingCodePanel().showAvailableServices(services);
    }

    public final void setQrCodeImage(@NotNull QrCodeImage qrCodeImage) {
        Intrinsics.checkNotNullParameter((Object)qrCodeImage, (String)"qrCodeImage");
        this.pairingPanel.getQrCodePanel().setQrCode(qrCodeImage);
    }

    public final void showQrCodePairingStarted() {
        this.pairingPanel.getQrCodePanel().showQrCodePairingStarted();
    }

    public final void showQrCodePairingInProgress() {
        this.pairingPanel.getQrCodePanel().showQrCodePairingInProgress();
    }

    public final void showQrCodePairingWaitForDevice() {
        this.pairingPanel.getQrCodePanel().showQrCodePairingWaitForDevice();
    }

    public final void showQrCodePairingSuccess(@NotNull AdbOnlineDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.pairingPanel.getQrCodePanel().showQrCodePairingSuccess(device2);
    }

    public final void showQrCodePairingError(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.pairingPanel.getQrCodePanel().showQrCodePairingError();
    }

    private final JBDimension getPanelPreferredSize() {
        return new JBDimension(600, 600);
    }

    private static final JComponent _init_$lambda$0(WiFiPairingDialog this$0) {
        return this$0.createCenterPanel();
    }

    private static final Unit pairingCodePairInvoked$lambda$0(PairingMdnsService it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit qrCodeScanAgainInvoked$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0(WiFiPairingDialog this$0, PairingMdnsService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        this$0.pairingCodePairInvoked.invoke((Object)service);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$1(WiFiPairingDialog this$0) {
        this$0.qrCodeScanAgainInvoked.invoke();
        return Unit.INSTANCE;
    }
}

