/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.adb.wireless.EditorPaneUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.NotNull;

@UiThread
public class WiFiPairingContentTabbedPaneContainer {
    @NotNull
    private JPanel myRootComponent;
    @NotNull
    private JPanel myTopRow;
    @NotNull
    private JPanel myCenterRow;
    @NotNull
    private JPanel myBottomRow;
    @NotNull
    private AsyncProcessIcon myAsyncProcessIcon;
    @NotNull
    private JBLabel myAsyncProcessText;

    public WiFiPairingContentTabbedPaneContainer() {
        this.setupUI();
        EditorPaneUtils.setTitlePanelBorder(this.myTopRow);
        EditorPaneUtils.setBottomPanelBorder(this.myBottomRow);
        this.myAsyncProcessIcon.suspend();
        this.myAsyncProcessIcon.setVisible(false);
    }

    private void createUIComponents() {
        this.myAsyncProcessIcon = new AsyncProcessIcon("available devices progress");
    }

    public void setParentDisposable(@NotNull Disposable parentDisposable) {
        Disposer.register((Disposable)parentDisposable, (Disposable)this.myAsyncProcessIcon);
    }

    public void setAsyncProcessText(@NotNull String text2) {
        this.myAsyncProcessText.setText(text2);
        this.myAsyncProcessIcon.setVisible(true);
        this.myAsyncProcessIcon.resume();
    }

    public void setContent(@NotNull JComponent component) {
        this.myCenterRow.removeAll();
        this.myCenterRow.add((Component)component, "Center");
    }

    private void setupUI() {
        this.createUIComponents();
        this.myRootComponent = new JPanel();
        this.myRootComponent.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myTopRow = new JPanel();
        this.myTopRow.setLayout(new BorderLayout(0, 0));
        this.myRootComponent.add((Component)this.myTopRow, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null, 0, false));
        this.myTopRow.add((Component)this.myAsyncProcessIcon, "East");
        this.myAsyncProcessText = new JBLabel();
        Font myAsyncProcessTextFont = this.getFont(null, 1, -1, this.myAsyncProcessText.getFont());
        if (myAsyncProcessTextFont != null) {
            this.myAsyncProcessText.setFont(myAsyncProcessTextFont);
        }
        this.myTopRow.add((Component)this.myAsyncProcessText, "Center");
        this.myCenterRow = new JPanel();
        this.myCenterRow.setLayout(new BorderLayout(0, 0));
        this.myRootComponent.add((Component)this.myCenterRow, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 5, null, null, null, 0, false));
        this.myBottomRow = new JPanel();
        this.myBottomRow.setLayout(new BorderLayout(0, 0));
        this.myRootComponent.add((Component)this.myBottomRow, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, null, null, null, 0, false));
    }

    private Font getFont(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }

    public JComponent getRootComponent() {
        return this.myRootComponent;
    }
}

