/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.adb.wireless.PairingCodeContentPanel;
import com.android.tools.idea.adb.wireless.PairingMdnsService;
import com.android.tools.idea.adb.wireless.TrackingMdnsService;
import com.android.tools.idea.adb.wireless.UIColors;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
public class PairingCodeTabPanel {
    @NotNull
    private final Consumer<PairingMdnsService> myPairingCodePairInvoked;
    @NotNull
    private final PairingCodeContentPanel myContentPanel;
    @NotNull
    private JBLabel myFirstLineLabel;
    @NotNull
    private JBLabel mySecondLineLabel;
    @NotNull
    private JPanel myRootComponent;
    @NotNull
    private JPanel myContentPanelContainer;
    @Nullable
    private final TrackingMdnsService mdnsServiceUnderPairing;

    public PairingCodeTabPanel(@NotNull Consumer<PairingMdnsService> pairingCodePairInvoked, @Nullable TrackingMdnsService mdnsServiceUnderPairing) {
        this.mdnsServiceUnderPairing = mdnsServiceUnderPairing;
        this.setupUI();
        this.myPairingCodePairInvoked = pairingCodePairInvoked;
        this.myContentPanelContainer.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myRootComponent.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myFirstLineLabel.setForeground(UIColors.PAIRING_HINT_LABEL);
        this.mySecondLineLabel.setForeground(UIColors.PAIRING_HINT_LABEL);
        this.myContentPanel = new PairingCodeContentPanel(mdnsServiceUnderPairing);
        this.myContentPanelContainer.add((Component)this.myContentPanel.getComponent(), "Center");
        this.showAvailableServices(new ArrayList<PairingMdnsService>());
    }

    public void showAvailableServices(@NotNull List<PairingMdnsService> devices2) {
        this.myContentPanel.showDevices(devices2, this.myPairingCodePairInvoked);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myRootComponent;
    }

    private void setupUI() {
        this.myRootComponent = new JPanel();
        this.myRootComponent.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myFirstLineLabel = new JBLabel();
        Font myFirstLineLabelFont = this.getFont(null, 1, -1, this.myFirstLineLabel.getFont());
        if (myFirstLineLabelFont != null) {
            this.myFirstLineLabel.setFont(myFirstLineLabelFont);
        }
        String deviceName = "Android 11+ device";
        if (this.mdnsServiceUnderPairing != null) {
            deviceName = this.mdnsServiceUnderPairing.getDisplayString();
        }
        this.myFirstLineLabel.setText(String.format("Set your %s to pairing mode", deviceName));
        this.myRootComponent.add((Component)this.myFirstLineLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        this.mySecondLineLabel = new JBLabel();
        this.mySecondLineLabel.setText("Go to Developer options > Wireless debugging > Pair device with pairing code");
        this.myRootComponent.add((Component)this.mySecondLineLabel, new GridConstraints(3, 0, 1, 1, 0, 0, 0, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myRootComponent.add((Component)spacer1, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 0, new Dimension(5, 20), null, null, 0, false));
        Spacer spacer2 = new Spacer();
        this.myRootComponent.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, new Dimension(0, 4), null, null, 0, false));
        this.myContentPanelContainer = new JPanel();
        this.myContentPanelContainer.setLayout(new BorderLayout(0, 0));
        this.myRootComponent.add((Component)this.myContentPanelContainer, new GridConstraints(0, 0, 1, 1, 0, 3, 5, 5, null, null, null, 0, false));
    }

    private Font getFont(String fontName, int style, int size, Font currentFont) {
        Font testFont;
        if (currentFont == null) {
            return null;
        }
        String resultName = fontName == null ? currentFont.getName() : ((testFont = new Font(fontName, 0, 10)).canDisplay('a') && testFont.canDisplay('1') ? fontName : currentFont.getName());
        Font font = new Font(resultName, style >= 0 ? style : currentFont.getStyle(), size >= 0 ? size : currentFont.getSize());
        boolean isMac = System.getProperty("os.name", "").toLowerCase(Locale.ENGLISH).startsWith("mac");
        Font fontWithFallback = isMac ? new Font(font.getFamily(), font.getStyle(), font.getSize()) : new StyleContext().getFont(font.getFamily(), font.getStyle(), font.getSize());
        return fontWithFallback instanceof FontUIResource ? fontWithFallback : new FontUIResource(fontWithFallback);
    }
}

