/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.adb.wireless.PairingCodeDevicePanel;
import com.android.tools.idea.adb.wireless.PairingMdnsService;
import com.android.tools.idea.adb.wireless.TrackingMdnsService;
import com.android.tools.idea.adb.wireless.UIColors;
import com.android.utils.TraceUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
public class PairingCodeContentPanel {
    @NotNull
    private JPanel myRootComponent;
    @NotNull
    private JPanel myEmptyPanel;
    @NotNull
    private JPanel myDevicesPanel;
    @NotNull
    private JPanel myDeviceList;
    @NotNull
    private JBScrollPane myDeviceListScrollPane;
    private JBLabel myDeviceLineupLabel;
    @NotNull
    List<PairingCodeDevicePanel> myPanels = new ArrayList<PairingCodeDevicePanel>();
    private final TrackingMdnsService mdnsServiceUnderPairing;

    public PairingCodeContentPanel() {
        this(null);
    }

    public PairingCodeContentPanel(@Nullable TrackingMdnsService mdnsServiceUnderPairing) {
        this.mdnsServiceUnderPairing = mdnsServiceUnderPairing;
        this.setupUI();
        this.myDeviceList.setLayout((LayoutManager)new VerticalFlowLayout());
        this.myEmptyPanel.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
        this.myDeviceListScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myDeviceList.setBackground(UIColors.PAIRING_CONTENT_BACKGROUND);
    }

    @NotNull
    public JComponent getComponent() {
        return this.myRootComponent;
    }

    public void showDevices(@NotNull List<PairingMdnsService> services, @NotNull Consumer<PairingMdnsService> pairingCodePairInvoked) {
        if (services.isEmpty()) {
            this.myEmptyPanel.setVisible(true);
            this.myDevicesPanel.setVisible(false);
            this.myDeviceList.removeAll();
            this.myDeviceList.revalidate();
            this.myDeviceList.repaint();
            this.myPanels.clear();
        } else {
            this.myEmptyPanel.setVisible(false);
            this.myDevicesPanel.setVisible(true);
            boolean needRepaint = false;
            for (PairingMdnsService service : services) {
                if (PairingCodeContentPanel.isPanelPresent(this.myPanels, service)) continue;
                PairingCodeDevicePanel devicePanel = new PairingCodeDevicePanel(service, () -> pairingCodePairInvoked.accept(service));
                this.myDeviceList.add(devicePanel.getComponent());
                this.myPanels.add(devicePanel);
                needRepaint = true;
            }
            ArrayList<Integer> indicesToRemove = new ArrayList<Integer>();
            int index = 0;
            for (PairingCodeDevicePanel panel2 : this.myPanels) {
                if (PairingCodeContentPanel.isPanelDeleted(services, panel2)) {
                    indicesToRemove.add(index);
                }
                ++index;
            }
            for (int i = indicesToRemove.size() - 1; i >= 0; --i) {
                int indexToRemove = (Integer)indicesToRemove.get(i);
                this.myPanels.remove(indexToRemove);
                this.myDeviceList.remove(indexToRemove);
                needRepaint = true;
            }
            if (needRepaint) {
                this.myDeviceList.revalidate();
                this.myDeviceList.repaint();
            }
            if (!this.checkConsistency(services)) {
                Logger.getInstance(PairingCodeContentPanel.class).error("Detected internal inconsistency:\n" + this.getDataStructuresDump(services));
            }
        }
    }

    private boolean checkConsistency(@NotNull List<PairingMdnsService> services) {
        if (this.myPanels.size() != this.myDeviceList.getComponentCount() || services.size() != this.myDeviceList.getComponentCount()) {
            return false;
        }
        for (int i = 0; i < this.myPanels.size(); ++i) {
            if (this.myPanels.get(i).getComponent() != this.myDeviceList.getComponent(i)) {
                return false;
            }
            if (this.myPanels.get(i).getMdnsService().equals(services.get(i))) continue;
            return false;
        }
        return true;
    }

    private String getDataStructuresDump(@NotNull List<PairingMdnsService> services) {
        StringBuilder buf = new StringBuilder();
        buf.append("services:");
        String separator = " ";
        for (PairingMdnsService service : services) {
            buf.append(separator);
            buf.append(service);
            separator = ", ";
        }
        buf.append("\npanels:");
        separator = " ";
        for (PairingCodeDevicePanel panel2 : this.myPanels) {
            buf.append(separator);
            buf.append("(");
            buf.append(panel2.getMdnsService());
            buf.append(" ");
            buf.append(TraceUtils.getSimpleId((Object)panel2.getComponent()));
            buf.append(")");
            separator = ", ";
        }
        buf.append("\ndevice components:");
        separator = " ";
        for (Iterator<Object> iterator2 : this.myDeviceList.getComponents()) {
            buf.append(separator);
            buf.append(TraceUtils.getSimpleId(iterator2));
            separator = ", ";
        }
        return buf.toString();
    }

    private void setupUI() {
        this.createUIComponents();
        this.myRootComponent = new JPanel();
        this.myRootComponent.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myDevicesPanel = new JPanel();
        this.myDevicesPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myRootComponent.add((Component)this.myDevicesPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myDevicesPanel.add((Component)this.myDeviceListScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myDeviceList = new JPanel();
        this.myDeviceList.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.myDeviceListScrollPane.setViewportView((Component)this.myDeviceList);
        this.myEmptyPanel = new JPanel();
        this.myEmptyPanel.setLayout(new GridBagLayout());
        this.myRootComponent.add((Component)this.myEmptyPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, false));
        this.myDeviceLineupLabel = new JBLabel();
        this.myDeviceLineupLabel.setHorizontalTextPosition(0);
        this.myDeviceLineupLabel.setIconTextGap(0);
        if (this.mdnsServiceUnderPairing == null) {
            this.myDeviceLineupLabel.setText("Searching for devices...");
        } else {
            this.myDeviceLineupLabel.setText(String.format("Waiting for %s to enter pairing mode...", this.mdnsServiceUnderPairing.getDisplayString()));
        }
        this.myDeviceLineupLabel.setVerticalTextPosition(3);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.myEmptyPanel.add((Component)this.myDeviceLineupLabel, gbc);
        if (this.mdnsServiceUnderPairing != null) {
            AsyncProcessIcon asyncProcessIcon = new AsyncProcessIcon("Pairing server");
            gbc.gridy = 1;
            gbc.insets = new Insets(JBUI.scale((int)4), 0, 0, 0);
            this.myEmptyPanel.add((Component)asyncProcessIcon, gbc);
        }
    }

    private static boolean isPanelDeleted(@NotNull List<PairingMdnsService> services, @NotNull PairingCodeDevicePanel panel2) {
        return services.stream().noneMatch(service -> service.equals(panel2.getMdnsService()));
    }

    private static boolean isPanelPresent(@NotNull List<PairingCodeDevicePanel> panels, @NotNull PairingMdnsService device2) {
        return panels.stream().anyMatch(panel2 -> panel2.getMdnsService().equals(device2));
    }

    private void createUIComponents() {
        this.myDeviceListScrollPane = new JBScrollPane(0);
    }
}

