/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb;

import com.android.adblib.AdbSession;
import com.android.adblib.CoroutineScopeCache;
import com.android.adblib.ddmlibcompatibility.AdbLibIDeviceManagerFactory;
import com.android.adblib.ddmlibcompatibility.debugging.AdbLibClientManagerFactory;
import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.AdbDelegateUsageTracker;
import com.android.ddmlib.AdbInitOptions;
import com.android.ddmlib.AdbVersion;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IDeviceUsageTracker;
import com.android.ddmlib.Log;
import com.android.ddmlib.TimeoutRemainder;
import com.android.ddmlib.clientmanager.ClientManager;
import com.android.ddmlib.idevicemanager.IDeviceManagerFactory;
import com.android.tools.idea.adb.AdbDelegateUsageTrackerImpl;
import com.android.tools.idea.adb.AdbFileProvider;
import com.android.tools.idea.adb.AdbLogOutput;
import com.android.tools.idea.adb.AdbOptionsService;
import com.android.tools.idea.adb.AdbServerLogLevel;
import com.android.tools.idea.adb.AdbServerMdnsBackend;
import com.android.tools.idea.adb.IDeviceUsageTrackerImpl;
import com.android.tools.idea.adb.StudioAdbLibJdwpTracerFactory;
import com.android.tools.idea.adb.StudioAdbLibSCacheJdwpSessionPipelineFactory;
import com.android.tools.idea.adb.StudioDDMLibJdwpTracer;
import com.android.tools.idea.adb.StudioDDMLibSCache;
import com.android.tools.idea.adb.StudioSCacheLogger;
import com.android.tools.idea.adblib.AdbLibApplicationService;
import com.android.tools.idea.flags.StudioFlags;
import com.google.common.io.Files;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service
public final class AdbService
implements Disposable {
    @TestOnly
    public static boolean disabled = false;
    private static final Logger LOG = Logger.getInstance(AdbService.class);
    private static final int ADB_DEFAULT_TIMEOUT_MILLIS = (int)TimeUnit.MINUTES.toMillis(50L);
    private static final long ADB_TERMINATE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    @NotNull
    private final ListeningExecutorService mySequentialExecutor = MoreExecutors.listeningDecorator((ExecutorService)SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"AdbService Executor"));
    @NotNull
    private final Implementation myImplementation = new Implementation();
    private boolean myAllowMdnsOpenscreen = true;
    private static final String MDNS_OPENSCREEN_FIX_ADB_VERSION = "1.0.42";
    @NotNull
    private final MyDebugBridgeChangeListener myDebugBridgeChangeListener = new MyDebugBridgeChangeListener();
    @NotNull
    private final MyDeviceChangeListener myDeviceChangeListener = new MyDeviceChangeListener();
    @NotNull
    private final MyAdbOptionsListener myAdbOptionsListener = new MyAdbOptionsListener();
    @NotNull
    private static final CoroutineScopeCache.Key<ClientManager> CLIENT_MANAGER_KEY = new CoroutineScopeCache.Key("client manager for ddmlib compatibility");
    @NotNull
    private static final CoroutineScopeCache.Key<IDeviceManagerFactory> IDEVICE_MANAGER_FACTORY_KEY = new CoroutineScopeCache.Key("IDevice manager for ddmlib compatibility");
    @NotNull
    private static final CoroutineScopeCache.Key<IDeviceUsageTracker> IDEVICE_TRACKER_USAGE_KEY = new CoroutineScopeCache.Key("IDevice usage tracker for ddmlib compatibility");
    @NotNull
    private static final CoroutineScopeCache.Key<AdbDelegateUsageTracker> ADB_DELEGATE_USAGE_TRACKER_KEY = new CoroutineScopeCache.Key("AdbDelegateUsageTracker for AndroidDebugBridge migration to adblib");

    private void logDeviceConnectionStatus(@NotNull IDevice device2) {
        if (device2.isOnline()) {
            LOG.info(String.format("Device [%s] has come online", device2.getSerialNumber()));
        } else {
            LOG.info(String.format("Device [%s] is offline (device state is `%s`)", device2.getSerialNumber(), device2.getState()));
        }
    }

    public static AdbService getInstance() {
        return (AdbService)ApplicationManager.getApplication().getService(AdbService.class);
    }

    @NotNull
    public static String getDebugBridgeDiagnosticErrorMessage(@NotNull Throwable t, @NotNull File adb) {
        String msg = t.getMessage() != null ? t.getMessage() : String.format("Unable to establish a connection to adb.\n\nCheck the Event Log for possible issues.\nThis can happen if you have an incompatible version of adb running already,\nor if localhost is pointing to the wrong address.\nTry re-opening %1$s after killing any existing adb daemons and verifying that your\nlocalhost entry is pointing to 127.0.0.1 or ::1 for IPv4 or IPv6, respectively.\n\nIf this happens repeatedly, please file a bug at http://b.android.com including the following:\n  1. Output of the command: '%2$s devices'\n  2. Your idea.log file (Help | Show Log in Explorer)\n", ApplicationNamesInfo.getInstance().getProductName(), adb.getAbsolutePath());
        return msg;
    }

    @NotNull
    public ListenableFuture<AndroidDebugBridge> getDebugBridge(@NotNull File adb) {
        if (disabled) {
            return Futures.immediateFuture(null);
        }
        return this.mySequentialExecutor.submit(() -> this.myImplementation.getAndroidDebugBridge(adb));
    }

    @NotNull
    public ListenableFuture<AndroidDebugBridge> getDebugBridge(@NotNull Project project) {
        File adbFile = AdbFileProvider.fromProject(project).get();
        if (adbFile == null) {
            LOG.warn("The path to the ADB command is not available");
            return Futures.immediateFailedFuture((Throwable)new FileNotFoundException("The path to the ADB command is not available"));
        }
        return this.getDebugBridge(adbFile);
    }

    public void terminateDdmlib() throws TimeoutException {
        if (disabled) {
            return;
        }
        try {
            this.mySequentialExecutor.submit(this.myImplementation::terminate).get(ADB_TERMINATE_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Failed to terminate ADB", (Throwable)e);
        }
    }

    public void dispose() {
        LOG.info("Disposing AdbService");
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this.myDebugBridgeChangeListener);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myDeviceChangeListener);
        AdbOptionsService.getInstance().removeListener(this.myAdbOptionsListener);
        try {
            this.mySequentialExecutor.submit(() -> {
                this.myImplementation.terminate();
                this.mySequentialExecutor.shutdownNow();
            }).get(ADB_TERMINATE_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            LOG.warn("Failed to dispose AdbService within specified timeout", (Throwable)e);
            return;
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Error while disposing AdbService");
            return;
        }
        try {
            if (!this.mySequentialExecutor.awaitTermination(ADB_TERMINATE_TIMEOUT_MILLIS, TimeUnit.MILLISECONDS)) {
                LOG.warn("Failed to shut down executor within specified timeout.");
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Executor shutdown interrupted.", (Throwable)e);
        }
    }

    private AdbService() {
        String defaultLogLevel = AdbLogOutput.SystemLogRedirecter.getLogger().isTraceEnabled() ? Log.LogLevel.VERBOSE.getStringValue() : (AdbLogOutput.SystemLogRedirecter.getLogger().isDebugEnabled() ? Log.LogLevel.DEBUG.getStringValue() : Log.LogLevel.INFO.getStringValue());
        DdmPreferences.setLogLevel((String)defaultLogLevel);
        DdmPreferences.setTimeOut((int)ADB_DEFAULT_TIMEOUT_MILLIS);
        Log.addLogger((Log.ILogOutput)new AdbLogOutput.SystemLogRedirecter());
        AdbOptionsService.getInstance().addListener(this.myAdbOptionsListener);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this.myDebugBridgeChangeListener);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this.myDeviceChangeListener);
        AndroidDebugBridge.setJdwpTracerFactory(() -> new StudioDDMLibJdwpTracer(this, (Boolean)StudioFlags.JDWP_TRACER.get()){});
        StudioAdbLibJdwpTracerFactory.install(AdbLibApplicationService.getInstance().getSession(), (Function0<Boolean>)((Function0)() -> (Boolean)StudioFlags.JDWP_TRACER.get() != false && (Boolean)StudioFlags.JDWP_SCACHE.get() == false));
        AndroidDebugBridge.setJdwpProcessorFactory(() -> new StudioDDMLibSCache((Boolean)StudioFlags.JDWP_SCACHE.get(), new StudioSCacheLogger()));
        StudioAdbLibSCacheJdwpSessionPipelineFactory.install(AdbLibApplicationService.getInstance().getSession());
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(){

            public void projectClosed(@NotNull Project project) {
                if (disabled) {
                    return;
                }
                if (ProjectManager.getInstance().getOpenProjects().length == 0) {
                    LOG.info("Ddmlib can be terminated as all projects have been closed");
                    ListenableFuture terminateAdb = AdbService.this.mySequentialExecutor.submit(AdbService.this.myImplementation::terminate);
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        try {
                            terminateAdb.get(30L, TimeUnit.SECONDS);
                        }
                        catch (Throwable e) {
                            LOG.warn("Failed to terminate ddmlib.", e);
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        });
    }

    @NotNull
    private static AdbInitOptions getAdbInitOptions() {
        AdbInitOptions.Builder options = AdbInitOptions.builder();
        options.setClientSupportEnabled(true);
        options.useJdwpProxyService(((Boolean)StudioFlags.ENABLE_JDWP_PROXY_SERVICE.get()).booleanValue());
        options.useDdmlibCommandService(((Boolean)StudioFlags.ENABLE_DDMLIB_COMMAND_SERVICE.get()).booleanValue());
        switch (AdbOptionsService.getInstance().getAdbServerUsbBackend()) {
            case LIBUSB: {
                options.withEnv("ADB_LIBUSB", "1");
                break;
            }
            case NATIVE: {
                options.withEnv("ADB_LIBUSB", "0");
                break;
            }
        }
        if (AdbService.getInstance().myAllowMdnsOpenscreen) {
            switch (AdbOptionsService.getInstance().getAdbServerMdnsBackend()) {
                case OPENSCREEN: {
                    options.withEnv("ADB_MDNS_OPENSCREEN", "1");
                    break;
                }
                case BONJOUR: {
                    options.withEnv("ADB_MDNS_OPENSCREEN", "0");
                    break;
                }
                case DISABLED: {
                    options.withEnv("ADB_MDNS", "0");
                    break;
                }
            }
        }
        switch (AdbOptionsService.getInstance().getAdbServerBurstMode()) {
            case ENABLED: {
                options.withEnv("ADB_BURST_MODE", "1");
                break;
            }
            case DISABLED: {
                options.withEnv("ADB_BURST_MODE", "0");
                break;
            }
        }
        AdbService.setUpAdbServerTraceLogs(options);
        AdbService.getInstance().myAllowMdnsOpenscreen = true;
        if (ApplicationManager.getApplication() == null || ApplicationManager.getApplication().isUnitTestMode()) {
            options.withEnv("HOME", Files.createTempDir().getAbsolutePath());
        }
        if (AdbOptionsService.getInstance().shouldUseUserManagedAdb()) {
            options.enableUserManagedAdbMode(AdbOptionsService.getInstance().getUserManagedAdbPort());
        }
        options.setClientManager((ClientManager)((Boolean)StudioFlags.ADBLIB_MIGRATION_DDMLIB_CLIENT_MANAGER.get() != false ? AdbService.getClientManager() : null));
        if (((Boolean)StudioFlags.ADBLIB_MIGRATION_DDMLIB_IDEVICE_MANAGER.get()).booleanValue()) {
            LOG.info("'adblib.migration.ddmlib.idevicemanager' flag is set to true");
            options.setIDeviceManagerFactory(AdbService.getIDeviceManagerFactory());
        }
        options.setIDeviceUsageTracker((IDeviceUsageTracker)((Boolean)StudioFlags.ADBLIB_MIGRATION_DDMLIB_IDEVICE_USAGE_TRACKER.get() != false ? AdbService.getIDeviceUsageTracker() : null));
        if (((Boolean)StudioFlags.ADBLIB_MIGRATION_DDMLIB_ADB_DELEGATE_USAGE_TRACKER.get()).booleanValue()) {
            options.setAdbDelegateUsageTracker(AdbService.getAdbDelegateUsageTracker());
        }
        return options.build();
    }

    private static void setUpAdbServerTraceLogs(AdbInitOptions.Builder initOptions) {
        AdbOptionsService adbOptions = AdbOptionsService.getInstance();
        if (((Boolean)StudioFlags.ADB_HOST_LOGS_ENABLED.get()).booleanValue()) {
            initOptions.withEnv("ADB_TRACE", adbOptions.getAdbServerLogLevel().getEnabledTags());
        } else {
            AdbService.setUpAdbServerTraceLogsFromServerLogEnabled(adbOptions, initOptions);
        }
    }

    private static void setUpAdbServerTraceLogsFromServerLogEnabled(AdbOptionsService adbOptions, AdbInitOptions.Builder initOptions) {
        if (adbOptions.getAdbServerLogsEnabled()) {
            initOptions.withEnv("ADB_TRACE", AdbServerLogLevel.FULL.getEnabledTags());
        } else {
            initOptions.withEnv("ADB_TRACE", AdbServerLogLevel.DISABLED.getEnabledTags());
        }
    }

    @NotNull
    private static ClientManager getClientManager() {
        AdbSession session2 = AdbLibApplicationService.getInstance().getSession();
        return (ClientManager)session2.getCache().getOrPut(CLIENT_MANAGER_KEY, () -> AdbLibClientManagerFactory.createClientManager((AdbSession)session2));
    }

    @NotNull
    private static IDeviceManagerFactory getIDeviceManagerFactory() {
        AdbSession session2 = AdbLibApplicationService.getInstance().getSession();
        return (IDeviceManagerFactory)session2.getCache().getOrPut(IDEVICE_MANAGER_FACTORY_KEY, () -> new AdbLibIDeviceManagerFactory(session2));
    }

    @NotNull
    private static IDeviceUsageTracker getIDeviceUsageTracker() {
        AdbSession session2 = AdbLibApplicationService.getInstance().getSession();
        return (IDeviceUsageTracker)session2.getCache().getOrPut(IDEVICE_TRACKER_USAGE_KEY, () -> (Boolean)StudioFlags.ADBLIB_MIGRATION_DDMLIB_IDEVICE_MANAGER.get() != false ? IDeviceUsageTrackerImpl.Companion.forAdblibIDeviceWrapper(session2) : IDeviceUsageTrackerImpl.Companion.forDeviceImpl(session2));
    }

    @NotNull
    private static AdbDelegateUsageTracker getAdbDelegateUsageTracker() {
        AdbSession session2 = AdbLibApplicationService.getInstance().getSession();
        return (AdbDelegateUsageTracker)session2.getCache().getOrPut(ADB_DELEGATE_USAGE_TRACKER_KEY, () -> (Boolean)StudioFlags.ADBLIB_MIGRATION_DDMLIB_ADB_DELEGATE.get() != false ? AdbDelegateUsageTrackerImpl.Companion.forAdbLibAndroidDebugBridge(session2) : AdbDelegateUsageTrackerImpl.Companion.forAndroidDebugBridgeImpl(session2));
    }

    private static class Implementation {
        @Nullable
        private File myAdbExecutableFile = null;

        private Implementation() {
        }

        @WorkerThread
        @Nullable
        private AndroidDebugBridge getAndroidDebugBridge(@NotNull File adb) {
            AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
            if (bridge == null || !bridge.isConnected()) {
                try {
                    bridge = this.createBridge(adb);
                }
                catch (Exception e) {
                    LOG.warn("Error creating adb", (Throwable)e);
                }
            }
            return bridge;
        }

        @WorkerThread
        public void terminate() {
            LOG.info("Terminating ADB connection");
            if (!AndroidDebugBridge.disconnectBridge((long)ADB_TERMINATE_TIMEOUT_MILLIS, (TimeUnit)TimeUnit.MILLISECONDS)) {
                LOG.warn("`ADB.disconnectBridge` did not complete within specified timeout. adb server may still be running");
            }
            AndroidDebugBridge.terminate();
            LOG.info("ADB connection successfully terminated");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        @NotNull
        private AndroidDebugBridge createBridge(@NotNull File adb) throws Exception {
            this.terminate();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                try {
                    Class<?> c = Class.forName("com.intellij.testFramework.common.ThreadLeakTracker");
                    Method method2 = c.getDeclaredMethod("longRunningThreadCreated", Disposable.class, String[].class);
                    method2.invoke(null, ApplicationManager.getApplication(), new String[]{"Monitor"});
                }
                catch (Exception exception) {
                    LOG.warn("Failed to register Monitor thread as long-running, leaks may be coming.", (Throwable)exception);
                }
            }
            TimeoutRemainder rem = new TimeoutRemainder(20000L, TimeUnit.MILLISECONDS);
            LOG.info("Initializing adb using: " + adb.getAbsolutePath());
            AdbLogOutput.ToStringLogger toStringLogger = new AdbLogOutput.ToStringLogger();
            Log.addLogger((Log.ILogOutput)toStringLogger);
            try {
                AndroidDebugBridge.init((AdbInitOptions)AdbService.getAdbInitOptions());
                AndroidDebugBridge bridge = AndroidDebugBridge.createBridge((String)adb.getPath(), (boolean)false, (long)rem.getRemainingNanos(), (TimeUnit)TimeUnit.MILLISECONDS);
                if (bridge == null) {
                    throw new Exception("Unable to start adb server: " + toStringLogger.getOutput());
                }
                while (!bridge.isConnected()) {
                    if (rem.getRemainingNanos() <= 0L) {
                        throw new Exception("Timed out attempting to connect to adb: " + toStringLogger.getOutput());
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        throw new Exception("Timed out attempting to connect to adb: " + toStringLogger.getOutput());
                    }
                }
                this.myAdbExecutableFile = adb;
                LOG.info("Successfully connected to adb");
                AndroidDebugBridge androidDebugBridge = bridge;
                return androidDebugBridge;
            }
            finally {
                Log.removeLogger((Log.ILogOutput)toStringLogger);
            }
        }

        @WorkerThread
        private void optionsChanged() {
            if (this.myAdbExecutableFile == null) {
                return;
            }
            LOG.info("Terminating adb server");
            this.terminate();
            LOG.info("Restart adb server");
            this.getAndroidDebugBridge(this.myAdbExecutableFile);
        }
    }

    private class MyDebugBridgeChangeListener
    implements AndroidDebugBridge.IDebugBridgeChangeListener {
        private boolean myInitializationErrorShown = false;

        private MyDebugBridgeChangeListener() {
        }

        public void bridgeChanged(@Nullable AndroidDebugBridge bridge) {
        }

        public void initializationError(@NotNull Exception exception) {
            if (!(SystemInfo.isWindows && AdbOptionsService.getInstance().getAdbServerMdnsBackend() == AdbServerMdnsBackend.OPENSCREEN && exception instanceof IOException && exception.getMessage().startsWith("An existing connection was forcibly closed by the remote host"))) {
                return;
            }
            AndroidDebugBridge bridge = AndroidDebugBridge.getBridge();
            if (bridge == null) {
                return;
            }
            AdbVersion version2 = bridge.getCurrentAdbVersion();
            if (version2 == null || version2.compareTo(AdbVersion.parseFrom((String)AdbService.MDNS_OPENSCREEN_FIX_ADB_VERSION)) >= 0) {
                return;
            }
            Log.w((String)"Remote shutdown of adb host was detected, attempting to restart server without MDNS Openscreen.", (Throwable)exception);
            String helpMessage = String.format("Error initializing adb with MDNS Openscreen enabled.\nAttempting restart adb with option disabled.\nTry updating to a newer version of ADB (%s or later).", AdbService.MDNS_OPENSCREEN_FIX_ADB_VERSION);
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Adb Service");
            if (notificationGroup != null) {
                Notification notification = notificationGroup.createNotification(helpMessage, NotificationType.WARNING).setImportant(true);
                Arrays.stream(ProjectManager.getInstance().getOpenProjects()).forEach(arg_0 -> ((Notification)notification).notify(arg_0));
            }
            AdbService.this.myAllowMdnsOpenscreen = false;
            if (!this.myInitializationErrorShown) {
                PopupUtil.showBalloonForActiveComponent((String)helpMessage, (MessageType)MessageType.WARNING);
                this.myInitializationErrorShown = true;
            }
            try {
                AdbService.this.terminateDdmlib();
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
    }

    private class MyDeviceChangeListener
    implements AndroidDebugBridge.IDeviceChangeListener {
        private MyDeviceChangeListener() {
        }

        public void deviceConnected(@NotNull IDevice device2) {
            AdbService.this.logDeviceConnectionStatus(device2);
        }

        public void deviceDisconnected(@NotNull IDevice device2) {
            AdbService.this.logDeviceConnectionStatus(device2);
        }

        public void deviceChanged(@NotNull IDevice device2, int changeMask) {
            if ((changeMask & 1) != 0) {
                AdbService.this.logDeviceConnectionStatus(device2);
            }
        }
    }

    private class MyAdbOptionsListener
    implements AdbOptionsService.AdbOptionsListener {
        private MyAdbOptionsListener() {
        }

        @Override
        public void optionsChanged() {
            if (disabled) {
                return;
            }
            AdbService.this.mySequentialExecutor.execute(AdbService.this.myImplementation::optionsChanged);
        }
    }
}

