/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions.license;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class LicensesLocator {
    private final Path myIdeHome;
    private final boolean myOnMac;
    private final List<String> myGooglePlugins = Arrays.asList("android", "firebase", "firebase-testing", "google-appindexing", "google-cloud-tools", "google-cloud-tools-core", "google-login", "google-services", "test-recorder");

    public LicensesLocator(@NotNull Path ideHome, boolean isMacLayout) {
        this.myIdeHome = ideHome;
        this.myOnMac = isMacLayout;
    }

    @NotNull
    public List<Path> getLicenseFiles() {
        ArrayList<Path> licenses = new ArrayList<Path>();
        licenses.addAll(this.getIdeLicenseAndNotice());
        licenses.addAll(this.getIdeWideThirdPartyLibLicenses());
        for (String plugin : this.myGooglePlugins) {
            licenses.addAll(this.getThirdPartyLibrariesForPlugin(plugin));
        }
        return licenses;
    }

    @NotNull
    private List<Path> getIdeLicenseAndNotice() {
        Path root = this.myIdeHome;
        if (this.myOnMac) {
            root = root.resolve("Resources");
        }
        return ImmutableList.of((Object)root.resolve("NOTICE.txt"), (Object)root.resolve("LICENSE.txt"));
    }

    @NotNull
    private List<Path> getIdeWideThirdPartyLibLicenses() {
        List<Path> list2;
        block8: {
            Stream<Path> stream = Files.list(this.myIdeHome.resolve("license"));
            try {
                list2 = stream.sorted().collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logger.getInstance(LicensesLocator.class).error((Throwable)e);
                    return ImmutableList.of();
                }
            }
            stream.close();
        }
        return list2;
    }

    @NotNull
    private List<Path> getThirdPartyLibrariesForPlugin(@NotNull String plugin) {
        Path pluginLicenseFolder = Paths.get(this.myIdeHome.toString(), "plugins", plugin, "lib", "licenses");
        if (Files.isDirectory(pluginLicenseFolder, new LinkOption[0])) {
            List<Path> list2;
            block9: {
                Stream<Path> stream = Files.list(pluginLicenseFolder);
                try {
                    list2 = stream.sorted().collect(Collectors.toList());
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        Logger.getInstance(LicensesLocator.class).warn((Throwable)e);
                        return ImmutableList.of();
                    }
                }
                stream.close();
            }
            return list2;
        }
        return ImmutableList.of();
    }
}

