/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions.license;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class LicenseTextCollector {
    private final Path myHome;
    private final List<Path> myLicenses;

    public LicenseTextCollector(@NotNull Path ideHome, @NotNull List<Path> licenses) {
        this.myHome = ideHome;
        this.myLicenses = licenses;
    }

    @NotNull
    public CompletableFuture<String> getLicenseText() {
        return CompletableFuture.supplyAsync(this::getLicenseTextSync);
    }

    private String getLicenseTextSync() {
        StringBuilder sb = new StringBuilder(10240);
        for (Path license : this.myLicenses) {
            sb.append("------------ License file: ");
            sb.append(this.myHome.relativize(license));
            sb.append("------------");
            sb.append("\n\n");
            sb.append(LicenseTextCollector.getLicenseText(license));
            sb.append("\n\n");
        }
        return sb.toString();
    }

    @NotNull
    private static String getLicenseText(@NotNull Path path) {
        try {
            return Files.readString(path, Charsets.UTF_8).replaceAll("(?s)<style(\\s*)>.*?</style(\\s*)>", "").replaceAll("<.*?>", "");
        }
        catch (IOException e) {
            return "";
        }
    }
}

