/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions.annotations;

import com.android.ide.common.repository.GoogleMavenArtifactId;
import com.android.tools.idea.actions.annotations.InferAnnotationsToken;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.android.tools.idea.projectsystem.GradleToken;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystem;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J+\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ'\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0002\u0010\u0015J,\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/actions/annotations/InferAnnotationsGradleToken;", "Lcom/android/tools/idea/actions/annotations/InferAnnotationsToken;", "Lcom/android/tools/idea/projectsystem/gradle/GradleProjectSystem;", "Lcom/android/tools/idea/projectsystem/GradleToken;", "<init>", "()V", "checkDependencies", "", "project", "Lcom/intellij/openapi/project/Project;", "usageInfos", "", "Lcom/intellij/usageView/UsageInfo;", "runnable", "Ljava/lang/Runnable;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/usageView/UsageInfo;Ljava/lang/Runnable;)Z", "findModulesFromUsage", "", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/psi/PsiFile;", "infos", "([Lcom/intellij/usageView/UsageInfo;)Ljava/util/Map;", "checkModules", "modules", "getAnnotationsMavenArtifact", "Lcom/android/ide/common/repository/GoogleMavenArtifactId;", "intellij.android.projectSystem.gradle"})
@SourceDebugExtension(value={"SMAP\nInferAnnotationsGradleToken.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InferAnnotationsGradleToken.kt\ncom/android/tools/idea/actions/annotations/InferAnnotationsGradleToken\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n774#2:105\n865#2,2:106\n*S KotlinDebug\n*F\n+ 1 InferAnnotationsGradleToken.kt\ncom/android/tools/idea/actions/annotations/InferAnnotationsGradleToken\n*L\n58#1:105\n58#1:106,2\n*E\n"})
public final class InferAnnotationsGradleToken
implements InferAnnotationsToken<GradleProjectSystem>,
GradleToken {
    @Override
    public boolean checkDependencies(@NotNull Project project, @NotNull UsageInfo[] usageInfos, @NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)usageInfos, (String)"usageInfos");
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        Map<Module, PsiFile> modules = this.findModulesFromUsage(usageInfos);
        return this.checkModules(project, modules, runnable2);
    }

    private final Map<Module, PsiFile> findModulesFromUsage(UsageInfo[] infos) {
        Map modules = new HashMap();
        for (UsageInfo info : infos) {
            Module module;
            PsiElement element;
            if (info.getElement() == null || ModuleUtilCore.findModuleForPsiElement((PsiElement)element) == null) continue;
            PsiFile file = element.getContainingFile();
            modules.put(module, file);
        }
        return modules;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkModules(Project project, Map<Module, ? extends PsiFile> modules, Runnable runnable2) {
        void $this$filterTo$iv$iv;
        GoogleMavenArtifactId artifact = this.getAnnotationsMavenArtifact(project);
        Iterable $this$filter$iv = modules.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Module module = (Module)element$iv$iv;
            boolean bl = false;
            if (!(!DependencyManagementUtil.dependsOn(module, artifact))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set modulesWithoutAnnotations = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (modulesWithoutAnnotations.isEmpty()) {
            return true;
        }
        String string = StringUtil.join((Collection)modulesWithoutAnnotations, arg_0 -> InferAnnotationsGradleToken.checkModules$lambda$2(InferAnnotationsGradleToken::checkModules$lambda$1, arg_0), (String)", ");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        String moduleNames = string;
        int count = modulesWithoutAnnotations.size();
        String $i$f$filterTo22 = "The %1$s %2$s %3$sn't refer to the existing '%4$s' library with Android annotations.\n\nWould you like to add the %5$s now?";
        Object object = new Object[]{StringUtil.pluralize((String)"module", (int)count), moduleNames, count > 1 ? "do" : "does", artifact.getMavenArtifactId(), StringUtil.pluralize((String)"dependency", (int)count)};
        String string2 = String.format($i$f$filterTo22, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String message = string2;
        if (Messages.showOkCancelDialog((Project)project, (String)message, (String)"Infer Annotations", (String)"OK", (String)"Cancel", (Icon)Messages.getErrorIcon()) == 0) {
            RepositoryUrlManager manager = RepositoryUrlManager.Companion.get();
            String string3 = artifact.getMavenGroupId();
            String string4 = artifact.getMavenArtifactId();
            FileSystem fileSystem = FileSystems.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"getDefault(...)");
            String revision = manager.getLibraryRevision(string3, string4, null, false, fileSystem);
            if (revision != null) {
                Module module;
                Set notAdded;
                object = modulesWithoutAnnotations.iterator();
                while (object.hasNext() && !(!((Collection)(notAdded = DependencyManagementUtil.addDependenciesWithUiConfirmation$default(module = (Module)object.next(), SetsKt.setOf((Object)artifact), false, false, null, 8, null))).isEmpty())) {
                }
                runnable2.run();
            }
        }
        return false;
    }

    private final GoogleMavenArtifactId getAnnotationsMavenArtifact(Project project) {
        return GoogleMavenArtifactId.ANDROIDX_ANNOTATION;
    }

    private static final String checkModules$lambda$1(Module obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.getName();
    }

    private static final String checkModules$lambda$2(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

