/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.annotations.concurrency.Slow;
import com.android.tools.idea.actions.SubmitBugReportActionShim;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.URLUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubmitBugReportAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(SubmitBugReportAction.class);

    public void actionPerformed(@NotNull AnActionEvent e) {
        SubmitBugReportAction.submit(e.getProject());
    }

    public static void submit(@Nullable Project project) {
        SubmitBugReportAction.submit(project, "");
    }

    public static void submit(final @Nullable Project project, final @Nullable String extraDescriptionDetails) {
        new Task.Modal(project, "Collecting Data", false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setText("Collecting feedback information");
                indicator.setIndeterminate(true);
                String feedbackUrlTemplate = SubmitBugReportAction.getBugReportTemplate();
                String version2 = ApplicationInfo.getInstance().getStrictVersion();
                String description2 = SubmitBugReportAction.getDescription(project) + extraDescriptionDetails;
                String feedbackUrl = feedbackUrlTemplate.replace("$STUDIO_VERSION", URLUtil.encodeURIComponent((String)version2)).replace("$DESCR", URLUtil.encodeURIComponent((String)description2));
                BrowserUtil.browse((String)feedbackUrl, (Project)project);
            }
        }.setCancelText("Cancel").queue();
    }

    @Slow
    public static String getDescription(@Nullable Project project) {
        return SubmitBugReportAction.safeCall(() -> {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("AS: %1$s\n", ApplicationInfo.getInstance().getFullVersion()));
            sb.append(StringUtil.trimLeading((String)SubmitBugReportActionShim.INSTANCE.getDescription(project)));
            return sb.toString();
        });
    }

    public static String safeCall(@NotNull Supplier<String> runnable2) {
        try {
            return runnable2.get();
        }
        catch (Throwable e) {
            LOG.info("Unable to prepopulate additional version information - proceeding with sending feedback anyway. ", e);
            return "(unable to retrieve additional version information)";
        }
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        if (e.getPresentation().isEnabled()) {
            e.getPresentation().setEnabled(SystemInfo.isMac || SystemInfo.isLinux || SystemInfo.isWindows);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static String getBugReportTemplate() {
        String instructions = "####################################################\n\nPlease provide all of the following information, otherwise we may not be able to route your bug report.\n\n####################################################\n\n\n1. Describe the bug or issue that you're seeing.\n\n\n\n2. Attach log files from Android Studio\n  2A. In the IDE, select the Help..Collect Logs and Diagnostic Data menu option.\n  2B. Create a diagnostic report and save it to your local computer.\n  2C. Attach the report to this bug using the Add attachments button.\n\n3. If you know what they are, write the steps to reproduce:\n\n   3A.\n   3B.\n   3C.\n\nIn addition to logs, please attach a screenshot or recording that illustrates the problem.\n\nFor more information on how to get your bug routed quickly, see https://developer.android.com/studio/report-bugs.html\n";
        ApplicationInfo app = ApplicationInfo.getInstance();
        String buildNumber = app.getBuild().asString();
        Date date = app.getBuildDate().getTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm", Locale.US);
        String strDate = dateFormat.format(date);
        return "https://issuetracker.google.com/issues/new?component=192708&template=840533&foundIn=$STUDIO_VERSION&format=MARKDOWN&description=%60%60%60%0A" + URLUtil.encodeURIComponent((String)instructions) + "%0ABuild%3A%20" + buildNumber + "%2C%20" + strDate + "%0A$DESCR%60%60%60";
    }
}

