/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.concurrency.AndroidIoManager;
import com.android.utils.concurrency.CachedAsyncSupplier;
import com.google.common.collect.Maps;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IconUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class OpenProjectFileChooserDescriptorWithAsyncIcon
extends OpenProjectFileChooserDescriptor
implements Disposable {
    private final Map<VirtualFile, Icon> myIconCache = Maps.newConcurrentMap();

    public OpenProjectFileChooserDescriptorWithAsyncIcon() {
        super(true);
    }

    public Icon getIcon(VirtualFile file) {
        return this.myIconCache.computeIfAbsent(file, key -> {
            Icon placeholder = OpenProjectFileChooserDescriptorWithAsyncIcon.dressIcon((VirtualFile)key, (Icon)IconUtil.getIcon((VirtualFile)key, (int)2, null));
            CachedAsyncSupplier asyncIconSupplier = new CachedAsyncSupplier(() -> Disposer.isDisposed((Disposable)this) ? placeholder : super.getIcon(key), AndroidIoManager.getInstance().getBackgroundDiskIoExecutor());
            AsyncIcon icon = new AsyncIcon(placeholder, (CachedAsyncSupplier<Icon>)asyncIconSupplier);
            return icon;
        });
    }

    public void dispose() {
        this.myIconCache.clear();
    }

    private static class AsyncIcon
    implements Icon {
        @NotNull
        private final Icon myPlaceholderIcon;
        @NotNull
        private final CachedAsyncSupplier<Icon> myIconAsyncSupplier;

        AsyncIcon(@NotNull Icon placeholderIcon, @NotNull CachedAsyncSupplier<Icon> iconAsyncSupplier) {
            this.myPlaceholderIcon = placeholderIcon;
            this.myIconAsyncSupplier = iconAsyncSupplier;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.getIcon().paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.getIcon().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.getIcon().getIconHeight();
        }

        @NotNull
        private final Icon getIcon() {
            Icon icon = (Icon)this.myIconAsyncSupplier.getNow();
            return icon != null ? icon : this.myPlaceholderIcon;
        }
    }
}

