/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea;

import com.android.tools.idea.diagnostics.InstallationId;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.updateSettings.impl.ExternalUpdateManager;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.ide.customization.ExternalProductResourceUrls;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 (2\u00020\u0001:\u0001(B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J(\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013H\u0007R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0017\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000bR\u0014\u0010\u0019\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000bR\u0014\u0010\u001b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000bR\u0014\u0010\u001d\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000bR1\u0010\u001f\u001a\u001f\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0004\u0012\u00020\t\u0018\u00010 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000b\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/AndroidStudioResourceUrls;", "Lcom/intellij/platform/ide/customization/ExternalProductResourceUrls;", "<init>", "()V", "parameters", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "updateMetadataUrl", "Lcom/intellij/util/Url;", "getUpdateMetadataUrl", "()Lcom/intellij/util/Url;", "computePatchUrl", "from", "Lcom/intellij/openapi/util/BuildNumber;", "to", "getPatchFileName", "getPatchSuffix", "isMac", "", "isWindows", "isUnix", "isAarch64", "downloadPageUrl", "getDownloadPageUrl", "gettingStartedPageUrl", "getGettingStartedPageUrl", "whatIsNewPageUrl", "getWhatIsNewPageUrl", "youTubeChannelUrl", "getYouTubeChannelUrl", "helpPageUrl", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "topicId", "getHelpPageUrl", "()Lkotlin/jvm/functions/Function1;", "keyboardShortcutsPdfUrl", "getKeyboardShortcutsPdfUrl", "Companion", "intellij.android.core"})
public final class AndroidStudioResourceUrls
implements ExternalProductResourceUrls {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<String, String> parameters = new HashMap();
    @NotNull
    private static final String UPDATE_BASE_URL;

    public AndroidStudioResourceUrls() {
        ((Map)this.parameters).put("build", ApplicationInfo.getInstance().getBuild().asString());
        ((Map)this.parameters).put("uid", InstallationId.get());
        ((Map)this.parameters).put("os", SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION);
        ExternalUpdateManager updateManager = ExternalUpdateManager.ACTUAL;
        if (updateManager != null) {
            String name2 = updateManager == ExternalUpdateManager.TOOLBOX ? "Toolbox" : updateManager.toolName;
            ((Map)this.parameters).put("manager", name2);
        }
        if (ApplicationInfoEx.getInstanceEx().isEAP()) {
            ((Map)this.parameters).put("eap", "");
        }
    }

    @NotNull
    public Url getUpdateMetadataUrl() {
        Url url = Urls.newFromEncoded((String)UPDATE_BASE_URL).resolve("updates.xml").addParameters((Map)this.parameters);
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"addParameters(...)");
        return url;
    }

    @NotNull
    public Url computePatchUrl(@NotNull BuildNumber from2, @NotNull BuildNumber to) {
        Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Url url = Urls.newFromEncoded((String)UPDATE_BASE_URL).resolve(this.getPatchFileName(from2, to));
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"resolve(...)");
        return url;
    }

    private final String getPatchFileName(BuildNumber from2, BuildNumber to) {
        String suffix = this.getPatchSuffix(SystemInfo.isMac, SystemInfo.isWindows, SystemInfo.isUnix, SystemInfo.isAarch64);
        return "AI-" + from2.asStringWithoutProductCode() + "-" + to.asStringWithoutProductCode() + "-patch-" + suffix;
    }

    @VisibleForTesting
    @NotNull
    public final String getPatchSuffix(boolean isMac, boolean isWindows, boolean isUnix, boolean isAarch64) {
        String string;
        if (isMac) {
            string = isAarch64 ? "mac_arm.jar" : "mac.jar";
        } else if (isWindows) {
            string = "win.jar";
        } else if (isUnix) {
            string = "unix.jar";
        } else {
            throw new IllegalStateException(("Unrecognized os: " + SystemInfo.OS_NAME + " and architecture: " + SystemInfo.OS_ARCH + ")").toString());
        }
        return string;
    }

    @NotNull
    public Url getDownloadPageUrl() {
        return Urls.newFromEncoded((String)"https://developer.android.com/r/studio-ui/download-stable");
    }

    @NotNull
    public Url getGettingStartedPageUrl() {
        return Urls.newFromEncoded((String)"http://developer.android.com/r/studio-ui/menu-start.html");
    }

    @NotNull
    public Url getWhatIsNewPageUrl() {
        return Urls.newFromEncoded((String)"https://developer.android.com/r/studio-ui/menu-whats-new.html");
    }

    @NotNull
    public Url getYouTubeChannelUrl() {
        return Urls.newFromEncoded((String)"https://www.youtube.com/c/AndroidDevelopers");
    }

    @Nullable
    public Function1<String, Url> getHelpPageUrl() {
        return AndroidStudioResourceUrls::_get_helpPageUrl_$lambda$0;
    }

    @NotNull
    public Url getKeyboardShortcutsPdfUrl() {
        String suffix = SystemInfo.isMac ? "_Mac" : "";
        return Urls.newFromEncoded((String)("https://www.jetbrains.com/idea/docs/IntelliJIDEA_ReferenceCard" + suffix + ".pdf"));
    }

    private static final Url _get_helpPageUrl_$lambda$0(String topicId) {
        Intrinsics.checkNotNullParameter((Object)topicId, (String)"topicId");
        String shortVersion = ApplicationInfo.getInstance().getShortVersion();
        return Urls.newFromEncoded((String)("https://www.jetbrains.com/help/idea/" + shortVersion + "/")).addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)topicId, (Object)"")));
    }

    static {
        String string = System.getenv("AS_UPDATE_URL");
        if (string == null) {
            string = "https://dl.google.com/android/studio/patches";
        }
        UPDATE_BASE_URL = string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/AndroidStudioResourceUrls$Companion;", "", "<init>", "()V", "UPDATE_BASE_URL", "", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

