/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.configurations;

import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRatio;
import com.android.resources.ScreenSize;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.State;
import com.android.tools.configurations.Configuration;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007\u00a8\u0006\b"}, d2={"updateScreenSize", "", "Lcom/android/tools/configurations/Configuration;", "xDimension", "", "yDimension", "original", "Lcom/android/sdklib/devices/Device;", "intellij.android.render-resources"})
@JvmName(name="Configurations")
public final class Configurations {
    @JvmOverloads
    public static final void updateScreenSize(@NotNull Configuration $this$updateScreenSize, int xDimension, int yDimension, @Nullable Device original) {
        Intrinsics.checkNotNullParameter((Object)$this$updateScreenSize, (String)"<this>");
        if (original == null) {
            return;
        }
        Device.Builder deviceBuilder = new Device.Builder(original);
        deviceBuilder.setName("Custom");
        deviceBuilder.setId("Custom");
        Device device2 = deviceBuilder.build();
        for (State state2 : device2.getAllStates()) {
            Screen screen = state2.getHardware().getScreen();
            screen.setXDimension(xDimension);
            screen.setYDimension(yDimension);
            double dpi = screen.getPixelDensity().getDpiValue();
            double width = (double)xDimension / dpi;
            double height = (double)yDimension / dpi;
            double diagonalLength = Math.hypot(width, height);
            screen.setDiagonalLength(diagonalLength);
            screen.setSize(ScreenSize.getScreenSize((Double)diagonalLength));
            screen.setRatio(ScreenRatio.create((int)xDimension, (int)yDimension));
            screen.setScreenRound(device2.getDefaultHardware().getScreen().getScreenRound());
            screen.setChin(device2.getDefaultHardware().getScreen().getChin());
        }
        State state3 = device2.getDefaultState().deepCopy();
        state3.setOrientation(xDimension < yDimension ? ScreenOrientation.PORTRAIT : ScreenOrientation.LANDSCAPE);
        $this$updateScreenSize.setEffectiveDevice(device2, state3);
    }

    public static /* synthetic */ void updateScreenSize$default(Configuration configuration2, int n, int n2, Device device2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            device2 = configuration2.getCachedDevice();
        }
        Configurations.updateScreenSize(configuration2, n, n2, device2);
    }

    @JvmOverloads
    public static final void updateScreenSize(@NotNull Configuration $this$updateScreenSize, int xDimension, int yDimension) {
        Intrinsics.checkNotNullParameter((Object)$this$updateScreenSize, (String)"<this>");
        Configurations.updateScreenSize$default($this$updateScreenSize, xDimension, yDimension, null, 4, null);
    }
}

