/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.configurations;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceItemResolver;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.DeviceConfigHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.resources.configuration.NightModeQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.UiModeQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.Density;
import com.android.resources.LayoutDirection;
import com.android.resources.NightMode;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenSize;
import com.android.resources.UiMode;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.configurations.AdaptiveIconShape;
import com.android.tools.configurations.ConfigurationListener;
import com.android.tools.configurations.ConfigurationModelModule;
import com.android.tools.configurations.ConfigurationSettings;
import com.android.tools.configurations.DeviceState;
import com.android.tools.configurations.ResourceResolverCache;
import com.android.tools.configurations.Wallpaper;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.tools.layoutlib.LayoutlibContext;
import com.android.tools.res.FrameworkOverlay;
import com.android.tools.res.ResourceRepositoryManager;
import com.android.tools.res.ResourceUtils;
import com.android.tools.sdk.AndroidPlatform;
import com.android.tools.sdk.CompatibilityRenderTarget;
import com.android.tools.sdk.LayoutlibFactory;
import com.google.common.base.Enums;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Configuration {
    public static final String CUSTOM_DEVICE_ID = "Custom";
    public static final int UI_MODE_TYPE_MASK = 15;
    private static final int UI_MODE_TYPE_APPLIANCE = 5;
    private static final int UI_MODE_TYPE_CAR = 3;
    private static final int UI_MODE_TYPE_DESK = 2;
    private static final int UI_MODE_TYPE_NORMAL = 1;
    private static final int UI_MODE_TYPE_TELEVISION = 4;
    private static final int UI_MODE_TYPE_VR_HEADSET = 7;
    private static final int UI_MODE_TYPE_WATCH = 6;
    private static final int UI_MODE_NIGHT_MASK = 48;
    public static final int UI_MODE_NIGHT_YES = 32;
    public static final int UI_MODE_NIGHT_NO = 16;
    private static final ResourceReference postSplashAttrReference = ResourceReference.attr((ResourceNamespace)ResourceNamespace.RES_AUTO, (String)"postSplashScreenTheme");
    @NotNull
    protected final FolderConfiguration myFullConfig = new FolderConfiguration();
    @NotNull
    protected final ConfigurationSettings mySettings;
    @NotNull
    protected final FolderConfiguration myEditedConfig;
    @Nullable
    private IAndroidTarget myTarget;
    @Nullable
    private String myTheme;
    @Nullable
    private Device mySpecificDevice;
    @Nullable
    private State myState;
    @Nullable
    private Device myDevice;
    @Nullable
    private String myStateName;
    @Nullable
    private String myActivity;
    @Nullable
    private com.android.ide.common.resources.Locale myLocale = null;
    @NotNull
    private UiMode myUiMode = UiMode.NORMAL;
    @NotNull
    private NightMode myNightMode = NightMode.NOTNIGHT;
    private String myDisplayName;
    private int myBulkEditingCount;
    private final List<ConfigurationListener> myListeners = new ArrayList<ConfigurationListener>();
    protected int myNotifyDirty;
    protected int myFolderConfigDirty = 246;
    protected int myProjectStateVersion;
    private long myModificationCount;
    private float myFontScale = 1.0f;
    private int myUiModeFlagValue;
    @NotNull
    private AdaptiveIconShape myAdaptiveShape = AdaptiveIconShape.getDefaultShape();
    private boolean myUseThemedIcon = false;
    private Wallpaper myWallpaper = null;
    private final EnumMap<ImageTransformationType, Consumer<BufferedImage>> myImageTransformations = new EnumMap(ImageTransformationType.class);
    private boolean myGestureNav = true;
    private boolean myEdgeToEdge = true;
    private FrameworkOverlay myCutoutOverlay = FrameworkOverlay.CUTOUT_NONE;
    private FrameworkOverlay myDeviceOverlay = null;
    private final ResourceItemResolver.ResourceProvider myResourceProvider = new ResourceItemResolver.ResourceProvider(){

        @Nullable
        public ResourceResolver getResolver(boolean createIfNecessary) {
            if (createIfNecessary) {
                return Configuration.this.getResourceResolver();
            }
            return Configuration.this.mySettings.getResolverCache().getCachedResourceResolver(Configuration.this.getTarget(), Configuration.this.getTheme(), Configuration.this.getFullConfig(), Configuration.this.getOverlays());
        }

        @Nullable
        public ResourceRepository getFrameworkResources() {
            ResourceRepositoryManager resourceRepositoryManager = Configuration.this.getConfigModule().getResourceRepositoryManager();
            return resourceRepositoryManager != null ? resourceRepositoryManager.getFrameworkResources((Set<String>)resourceRepositoryManager.getLanguagesInProject(), (List<? extends FrameworkOverlay>)Configuration.this.getOverlays()) : null;
        }

        @Nullable
        public ResourceRepository getAppResources() {
            ResourceRepositoryManager resourceRepositoryManager = Configuration.this.getConfigModule().getResourceRepositoryManager();
            return resourceRepositoryManager != null ? resourceRepositoryManager.getAppResources() : null;
        }
    };
    private static final String NO_ACTIVITY = new String();

    protected Configuration(@NotNull ConfigurationSettings settings, @NotNull FolderConfiguration editedConfig) {
        this.mySettings = settings;
        this.myEditedConfig = editedConfig;
        if (this.isLocaleSpecificLayout()) {
            this.myLocale = com.android.ide.common.resources.Locale.create((FolderConfiguration)editedConfig);
        }
        if (this.isOrientationSpecificLayout()) {
            ScreenOrientationQualifier qualifier = editedConfig.getScreenOrientationQualifier();
            assert (qualifier != null);
            ScreenOrientation orientation = qualifier.getValue();
            if (orientation != null) {
                this.myStateName = orientation.getShortDisplayValue();
            }
        }
    }

    @NotNull
    public static Configuration create(@NotNull ConfigurationSettings settings, @NotNull FolderConfiguration editedConfig) {
        return new Configuration(settings, editedConfig);
    }

    protected void copyFrom(@NotNull Configuration from2) {
        this.myFullConfig.set(from2.myFullConfig);
        this.myFolderConfigDirty = from2.myFolderConfigDirty;
        this.myProjectStateVersion = from2.myProjectStateVersion;
        this.myTarget = from2.myTarget;
        this.myLocale = from2.myLocale;
        this.myTheme = from2.getTheme();
        this.mySpecificDevice = from2.mySpecificDevice;
        this.myDevice = from2.myDevice;
        this.myStateName = from2.myStateName;
        this.myState = from2.myState;
        this.myActivity = from2.getActivity();
        this.myUiMode = from2.getUiMode();
        this.myNightMode = from2.getNightMode();
        this.myDisplayName = from2.getDisplayName();
        this.myFontScale = from2.myFontScale;
        this.myUiModeFlagValue = from2.myUiModeFlagValue;
        this.myAdaptiveShape = from2.myAdaptiveShape;
        this.myUseThemedIcon = from2.myUseThemedIcon;
        this.myWallpaper = from2.myWallpaper;
        this.myDeviceOverlay = from2.myDeviceOverlay;
        this.myGestureNav = from2.myGestureNav;
        this.myCutoutOverlay = from2.myCutoutOverlay;
        this.myEdgeToEdge = from2.myEdgeToEdge;
    }

    public Configuration clone() {
        Configuration copy = new Configuration(this.mySettings, FolderConfiguration.copyOf((FolderConfiguration)this.getEditedConfig()));
        copy.copyFrom(this);
        return copy;
    }

    @Nullable
    protected String getStateName() {
        return this.myStateName;
    }

    public void save() {
    }

    @NotNull
    public ConfigurationSettings getSettings() {
        return this.mySettings;
    }

    @Nullable
    protected String calculateActivity() {
        return null;
    }

    @Nullable
    public final String getActivity() {
        if (this.myActivity == NO_ACTIVITY) {
            return null;
        }
        if (this.myActivity == null) {
            this.myActivity = this.calculateActivity();
            if (this.myActivity == null) {
                this.myActivity = NO_ACTIVITY;
                return null;
            }
        }
        return this.myActivity;
    }

    @Slow
    @Nullable
    public Device getDevice() {
        Device cached = this.getCachedDevice();
        if (cached != null) {
            return cached;
        }
        this.myDevice = this.mySpecificDevice != null ? this.mySpecificDevice : this.computeBestDevice();
        this.updateDeviceOverlay();
        return this.myDevice;
    }

    @Nullable
    public Device getCachedDevice() {
        return this.myDevice;
    }

    @Nullable
    public static FolderConfiguration getFolderConfig(@NotNull ConfigurationModelModule module, @NotNull State state2, @NotNull com.android.ide.common.resources.Locale locale, @Nullable IAndroidTarget target2) {
        FolderConfiguration currentConfig = DeviceConfigHelper.getFolderConfig((State)state2);
        if (currentConfig != null && locale.hasLanguage()) {
            currentConfig.setLocaleQualifier(locale.qualifier);
            LayoutLibrary layoutLib = Configuration.getLayoutLibrary(target2, module.getAndroidPlatform(), module.getLayoutlibContext());
            if (layoutLib != null && layoutLib.isRtl(locale.toLocaleId())) {
                currentConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.RTL));
            }
        }
        return currentConfig;
    }

    private static LayoutLibrary getLayoutLibrary(@Nullable IAndroidTarget target2, @Nullable AndroidPlatform platform, @NotNull LayoutlibContext context) {
        if (target2 == null || platform == null) {
            return null;
        }
        try {
            return LayoutlibFactory.getLayoutLibrary(target2, platform, context);
        }
        catch (RenderingException ignored) {
            return null;
        }
    }

    @Slow
    @Nullable
    protected Device computeBestDevice() {
        return this.mySettings.getDefaultDevice();
    }

    @Nullable
    public State getDeviceState() {
        if (this.myState == null) {
            Device device2 = this.getDevice();
            this.myState = DeviceState.getDeviceState(device2, this.myStateName);
        }
        return this.myState;
    }

    @NotNull
    public com.android.ide.common.resources.Locale getLocale() {
        if (this.myLocale == null) {
            return this.mySettings.getLocale();
        }
        return this.myLocale;
    }

    @NotNull
    public UiMode getUiMode() {
        return this.myUiMode;
    }

    @NotNull
    public NightMode getNightMode() {
        return this.myNightMode;
    }

    @NotNull
    public String getTheme() {
        if (this.myTheme == null) {
            return this.getPreferredTheme();
        }
        return this.myTheme;
    }

    @Nullable
    public IAndroidTarget getTarget() {
        if (this.myTarget == null) {
            IAndroidTarget target2 = this.mySettings.getTarget();
            VersionQualifier version2 = this.myEditedConfig.getVersionQualifier();
            if (target2 != null && version2 != null && version2.getVersion() > target2.getVersion().getFeatureLevel()) {
                target2 = this.mySettings.getTarget(version2.getVersion());
            }
            return Configuration.getTargetForRendering(target2, this.mySettings.getConfigModule());
        }
        return this.myTarget;
    }

    @Nullable
    public IAndroidTarget getRealTarget() {
        IAndroidTarget target2 = this.getTarget();
        if (target2 instanceof CompatibilityRenderTarget) {
            CompatibilityRenderTarget compatTarget = (CompatibilityRenderTarget)target2;
            return compatTarget.getRealTarget();
        }
        return target2;
    }

    @Nullable
    public String getDisplayName() {
        return this.myDisplayName;
    }

    public boolean isLocaleSpecificLayout() {
        return this.myEditedConfig.getLocaleQualifier() != null;
    }

    public boolean isTargetSpecificLayout() {
        return this.myEditedConfig.getVersionQualifier() != null;
    }

    public boolean isOrientationSpecificLayout() {
        return this.myEditedConfig.getScreenOrientationQualifier() != null;
    }

    @NotNull
    public FolderConfiguration getFullConfig() {
        if ((this.myFolderConfigDirty & 0xF6) != 0 || this.myProjectStateVersion != this.mySettings.getStateVersion()) {
            this.syncFolderConfig();
        }
        return this.myFullConfig;
    }

    @NotNull
    public FolderConfiguration getEditedConfig() {
        return this.myEditedConfig;
    }

    public void setActivity(@Nullable String activity) {
        if (!Objects.equals(this.myActivity, activity)) {
            this.myActivity = activity;
            this.updated(256);
        }
    }

    public void setDevice(Device device2, boolean preserveState) {
        if (this.mySpecificDevice == device2) {
            this.myDevice = null;
            return;
        }
        Device prevDevice = this.mySpecificDevice;
        State prevState = this.myState;
        this.myDevice = this.mySpecificDevice = device2;
        this.updateDeviceOverlay();
        int updateFlags = 2;
        if (device2 != null) {
            State state2 = null;
            if (preserveState && prevDevice != null) {
                if (prevState != null) {
                    FolderConfiguration oldConfig = DeviceConfigHelper.getFolderConfig((State)prevState);
                    if (oldConfig != null) {
                        String stateName = Configuration.getClosestMatch(oldConfig, device2.getAllStates());
                        state2 = device2.getState(stateName);
                    } else {
                        state2 = device2.getState(prevState.getName());
                    }
                }
            } else if (preserveState && this.myStateName != null) {
                state2 = device2.getState(this.myStateName);
            }
            if (state2 == null) {
                state2 = device2.getDefaultState();
            }
            if (this.myState != state2) {
                this.setDeviceStateName(state2.getName());
                this.myState = state2;
                updateFlags |= 4;
            }
        }
        this.updated(updateFlags);
    }

    @Nullable
    private static String getClosestMatch(@NotNull FolderConfiguration oldConfig, @NotNull List<State> states) {
        ArrayList<Object> list1 = new ArrayList<Object>(states.size());
        ArrayList<State> list2 = new ArrayList<State>(states.size());
        list1.addAll(states);
        int count = FolderConfiguration.getQualifierCount();
        for (int i = 0; i < count; ++i) {
            for (State state2 : list1) {
                ResourceQualifier newQualifier;
                ResourceQualifier oldQualifier = oldConfig.getQualifier(i);
                FolderConfiguration folderConfig = DeviceConfigHelper.getFolderConfig((State)state2);
                ResourceQualifier resourceQualifier = newQualifier = folderConfig != null ? folderConfig.getQualifier(i) : null;
                if (oldQualifier == null) {
                    if (newQualifier != null) continue;
                    list2.add(state2);
                    continue;
                }
                if (!oldQualifier.equals((Object)newQualifier)) continue;
                list2.add(state2);
            }
            if (list2.size() == 1) {
                return ((State)list2.get(0)).getName();
            }
            if (list2.isEmpty()) continue;
            list1.clear();
            list1.addAll(list2);
            list2.clear();
        }
        if (!list1.isEmpty()) {
            return ((State)list1.get(0)).getName();
        }
        return null;
    }

    public void setDeviceState(State state2) {
        if (this.myState != state2) {
            if (state2 != null) {
                this.setDeviceStateName(state2.getName());
            } else {
                this.myStateName = null;
            }
            this.myState = state2;
            this.updated(4);
        }
    }

    public void setDeviceStateName(@Nullable String stateName) {
        ScreenOrientation orientation;
        ScreenOrientationQualifier qualifier = this.myEditedConfig.getScreenOrientationQualifier();
        if (qualifier != null && (orientation = qualifier.getValue()) != null) {
            stateName = orientation.getShortDisplayValue();
        }
        if (!Objects.equals(stateName, this.myStateName)) {
            this.myStateName = stateName;
            this.myState = null;
            this.updated(4);
        }
    }

    public void setLocale(@NotNull com.android.ide.common.resources.Locale locale) {
        if (!Objects.equals(this.myLocale, locale)) {
            this.myLocale = locale;
            this.updated(16);
        }
    }

    public void setTarget(@Nullable IAndroidTarget target2) {
        if (this.myTarget != target2) {
            this.myTarget = Configuration.getTargetForRendering(target2, this.mySettings.getConfigModule());
            this.updated(32);
        }
    }

    public void setDisplayName(@Nullable String displayName) {
        if (!Objects.equals(this.myDisplayName, displayName)) {
            this.myDisplayName = displayName;
            this.updated(512);
        }
    }

    public void setNightMode(@NotNull NightMode night) {
        if (this.myNightMode != night) {
            if (night == NightMode.NIGHT) {
                this.setUiModeFlagValue(this.getUiModeFlagValue() & 0xF | 0x20);
            } else {
                this.setUiModeFlagValue(this.getUiModeFlagValue() & 0xF | 0x10);
            }
        }
    }

    public void setUiMode(@NotNull UiMode uiMode) {
        if (this.myUiMode != uiMode) {
            int newUiTypeFlags = 0;
            switch (uiMode) {
                case NORMAL: {
                    newUiTypeFlags = 1;
                    break;
                }
                case DESK: {
                    newUiTypeFlags = 2;
                    break;
                }
                case WATCH: {
                    newUiTypeFlags = 6;
                    break;
                }
                case TELEVISION: {
                    newUiTypeFlags = 4;
                    break;
                }
                case APPLIANCE: {
                    newUiTypeFlags = 5;
                    break;
                }
                case CAR: {
                    newUiTypeFlags = 3;
                    break;
                }
                case VR_HEADSET: {
                    newUiTypeFlags = 7;
                }
            }
            this.setUiModeFlagValue(this.getUiModeFlagValue() & 0x30 | newUiTypeFlags);
        }
    }

    public void setUiModeFlagValue(int uiMode) {
        int modifiedElements = this.myUiModeFlagValue ^ uiMode;
        this.myUiModeFlagValue = uiMode;
        int updatedFlags = 0;
        if ((modifiedElements & 0x30) != 0) {
            this.myNightMode = (uiMode & 0x30) == 32 ? NightMode.NIGHT : NightMode.NOTNIGHT;
            updatedFlags |= 0x40;
        }
        if ((modifiedElements & 0xF) != 0) {
            switch (uiMode & 0xF) {
                case 5: {
                    this.myUiMode = UiMode.APPLIANCE;
                    break;
                }
                case 3: {
                    this.myUiMode = UiMode.CAR;
                    break;
                }
                case 4: {
                    this.myUiMode = UiMode.TELEVISION;
                    break;
                }
                case 6: {
                    this.myUiMode = UiMode.WATCH;
                    break;
                }
                case 2: {
                    this.myUiMode = UiMode.DESK;
                    break;
                }
                case 7: {
                    this.myUiMode = UiMode.VR_HEADSET;
                    break;
                }
                default: {
                    this.myUiMode = UiMode.NORMAL;
                }
            }
            updatedFlags |= 0x80;
        }
        if (updatedFlags != 0) {
            this.updated(updatedFlags);
        }
    }

    public int getUiModeFlagValue() {
        return this.myUiModeFlagValue;
    }

    public void setTheme(@Nullable String theme) {
        if (!Objects.equals(this.myTheme, theme)) {
            this.myTheme = theme;
            this.checkThemePrefix();
            this.updated(8);
        }
    }

    public void setFontScale(float fontScale) {
        assert (fontScale > 0.0f) : "fontScale must be greater than 0";
        if (this.myFontScale != fontScale) {
            this.myFontScale = fontScale;
            this.updated(1024);
        }
    }

    public float getFontScale() {
        return this.myFontScale;
    }

    public void setAdaptiveShape(@NotNull AdaptiveIconShape adaptiveShape) {
        if (this.myAdaptiveShape != adaptiveShape) {
            this.myAdaptiveShape = adaptiveShape;
            this.updated(2048);
        }
    }

    @NotNull
    public AdaptiveIconShape getAdaptiveShape() {
        return this.myAdaptiveShape;
    }

    public void setWallpaper(@Nullable Wallpaper wallpaper) {
        if (!Objects.equals((Object)this.myWallpaper, (Object)wallpaper)) {
            this.myWallpaper = wallpaper;
            this.myUseThemedIcon = wallpaper != null;
            this.updated(8);
        }
    }

    @Nullable
    public String getWallpaperPath() {
        return this.myWallpaper != null ? this.myWallpaper.getResourcePath() : null;
    }

    public void setEdgeToEdge(boolean edgeToEdge) {
        this.myEdgeToEdge = edgeToEdge;
    }

    public boolean isEdgeToEdge() {
        return this.myEdgeToEdge;
    }

    public void setGestureNav(boolean gestureNav) {
        this.myGestureNav = gestureNav;
    }

    public boolean isGestureNav() {
        return this.myGestureNav;
    }

    public void setCutoutOverlay(FrameworkOverlay overlay) {
        this.myCutoutOverlay = overlay;
    }

    public FrameworkOverlay getCutoutOverlay() {
        return this.myCutoutOverlay;
    }

    public void setImageTransformation(@NotNull ImageTransformationType type, @Nullable Consumer<BufferedImage> imageTransformation) {
        if (imageTransformation == null) {
            this.myImageTransformations.remove((Object)type);
        } else {
            this.myImageTransformations.put(type, imageTransformation);
        }
    }

    @Nullable
    public Consumer<BufferedImage> getImageTransformation() {
        if (this.myImageTransformations.isEmpty()) {
            return null;
        }
        return image -> this.myImageTransformations.values().forEach(c -> c.accept(image));
    }

    public boolean getUseThemedIcon() {
        return this.myUseThemedIcon;
    }

    protected void syncFolderConfig() {
        Device device2 = this.getDevice();
        if (device2 == null) {
            return;
        }
        State deviceState2 = this.getDeviceState();
        if (deviceState2 == null) {
            deviceState2 = device2.getDefaultState();
        }
        FolderConfiguration config = Configuration.getFolderConfig(this.mySettings.getConfigModule(), deviceState2, this.getLocale(), this.getTarget());
        this.myFullConfig.set(config);
        com.android.ide.common.resources.Locale locale = this.getLocale();
        this.myFullConfig.setLocaleQualifier(locale.qualifier);
        LayoutDirectionQualifier layoutDirectionQualifier = this.myEditedConfig.getLayoutDirectionQualifier();
        if (layoutDirectionQualifier != null && layoutDirectionQualifier != layoutDirectionQualifier.getNullQualifier()) {
            this.myFullConfig.setLayoutDirectionQualifier(layoutDirectionQualifier);
        } else if (!locale.hasLanguage()) {
            this.myFullConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.LTR));
        } else {
            ConfigurationModelModule configModule = this.mySettings.getConfigModule();
            LayoutLibrary layoutLib = Configuration.getLayoutLibrary(this.getTarget(), configModule.getAndroidPlatform(), configModule.getLayoutlibContext());
            if (layoutLib != null) {
                if (layoutLib.isRtl(locale.toLocaleId())) {
                    this.myFullConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.RTL));
                } else {
                    this.myFullConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.LTR));
                }
            }
        }
        UiMode uiMode = this.getUiMode();
        this.myFullConfig.setUiModeQualifier(new UiModeQualifier(uiMode));
        NightMode nightMode = this.getNightMode();
        this.myFullConfig.setNightModeQualifier(new NightModeQualifier(nightMode));
        IAndroidTarget target2 = this.getTarget();
        if (target2 != null) {
            int apiLevel = target2.getVersion().getFeatureLevel();
            this.myFullConfig.setVersionQualifier(new VersionQualifier(apiLevel));
        }
        this.myFolderConfigDirty = 0;
        this.myProjectStateVersion = this.mySettings.getStateVersion();
    }

    @Nullable
    public ScreenSize getScreenSize() {
        FolderConfiguration folderConfig;
        State deviceState2 = this.getDeviceState();
        if (deviceState2 != null && (folderConfig = DeviceConfigHelper.getFolderConfig((State)deviceState2)) != null) {
            ScreenSizeQualifier qualifier = folderConfig.getScreenSizeQualifier();
            assert (qualifier != null);
            return qualifier.getValue();
        }
        ScreenSize screenSize = null;
        Device device2 = this.getDevice();
        if (device2 != null) {
            List states = device2.getAllStates();
            for (State state2 : states) {
                FolderConfiguration folderConfig2 = DeviceConfigHelper.getFolderConfig((State)state2);
                if (folderConfig2 == null) continue;
                ScreenSizeQualifier qualifier = folderConfig2.getScreenSizeQualifier();
                assert (qualifier != null);
                screenSize = qualifier.getValue();
                break;
            }
        }
        return screenSize;
    }

    private void checkThemePrefix() {
        if (this.myTheme != null && !this.myTheme.startsWith("@")) {
            if (this.myTheme.isEmpty()) {
                this.myTheme = this.getPreferredTheme();
                return;
            }
            this.myTheme = ResourceUtils.getStyleResourceUrl(this.myTheme);
        }
    }

    @NotNull
    public Density getDensity() {
        Density d;
        DensityQualifier qualifier = this.getFullConfig().getDensityQualifier();
        if (qualifier != null && (d = qualifier.getValue()) != null && d.isValidValueForDevice()) {
            return d;
        }
        return Density.MEDIUM;
    }

    @Nullable
    public State getNextDeviceState(@Nullable State from2) {
        Device device2 = this.getDevice();
        if (device2 == null) {
            return null;
        }
        List states = device2.getAllStates();
        for (int i = 0; i < states.size(); ++i) {
            if (states.get(i) != from2) continue;
            return (State)states.get((i + 1) % states.size());
        }
        if (from2 != null) {
            String name2 = from2.getName();
            for (int i = 0; i < states.size(); ++i) {
                if (!((State)states.get(i)).getName().equals(name2)) continue;
                return (State)states.get((i + 1) % states.size());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBulkEditing() {
        Configuration configuration2 = this;
        synchronized (configuration2) {
            ++this.myBulkEditingCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishBulkEditing() {
        boolean notify = false;
        Configuration configuration2 = this;
        synchronized (configuration2) {
            --this.myBulkEditingCount;
            if (this.myBulkEditingCount == 0) {
                notify = true;
            }
        }
        if (notify) {
            this.updated(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(int flags) {
        this.myNotifyDirty |= flags;
        this.myFolderConfigDirty |= flags;
        ++this.myModificationCount;
        if (this.myBulkEditingCount == 0) {
            ImmutableList listeners;
            int changed = this.myNotifyDirty;
            UnmodifiableIterator unmodifiableIterator = this.myListeners;
            synchronized (unmodifiableIterator) {
                listeners = ImmutableList.copyOf(this.myListeners);
            }
            for (ConfigurationListener listener2 : listeners) {
                listener2.changed(changed);
            }
            this.myNotifyDirty = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NotNull ConfigurationListener listener2) {
        List<ConfigurationListener> list2 = this.myListeners;
        synchronized (list2) {
            this.myListeners.add(listener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NotNull ConfigurationListener listener2) {
        List<ConfigurationListener> list2 = this.myListeners;
        synchronized (list2) {
            this.myListeners.remove(listener2);
        }
    }

    public void useDeviceForCutout(@NotNull String deviceId) {
        Optional deviceOverlay = Enums.getIfPresent(FrameworkOverlay.class, (String)deviceId.toUpperCase(Locale.ROOT));
        this.myDeviceOverlay = deviceOverlay.isPresent() ? (FrameworkOverlay)((Object)deviceOverlay.get()) : null;
    }

    private void updateDeviceOverlay() {
        if (this.myDevice == null) {
            this.myDeviceOverlay = null;
        } else {
            this.useDeviceForCutout(this.myDevice.getId());
        }
    }

    @Slow
    @NotNull
    public ResourceResolver getResourceResolver() {
        String theme = this.getTheme();
        Device device2 = this.getDevice();
        List<FrameworkOverlay> overlays = this.getOverlays();
        ResourceResolverCache resolverCache = this.mySettings.getResolverCache();
        if (device2 != null && CUSTOM_DEVICE_ID.equals(device2.getId())) {
            resolverCache.replaceCustomConfig(theme, this.getFullConfig(), overlays);
        }
        return resolverCache.getResourceResolver(this.getTarget(), theme, this.getFullConfig(), overlays);
    }

    @NotNull
    public ResourceItemResolver getResourceItemResolver() {
        return new ResourceItemResolver(this.getFullConfig(), this.myResourceProvider, null);
    }

    @NotNull
    public List<FrameworkOverlay> getOverlays() {
        ArrayList<FrameworkOverlay> overlays = new ArrayList<FrameworkOverlay>(3);
        overlays.add(this.myGestureNav ? FrameworkOverlay.NAV_GESTURE : FrameworkOverlay.NAV_3_BUTTONS);
        if (this.myDeviceOverlay != null) {
            overlays.add(this.myDeviceOverlay);
        }
        overlays.add(this.myCutoutOverlay);
        return overlays;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("display", (Object)this.myDisplayName).add("theme", (Object)this.myTheme).add("activity", (Object)this.myActivity).add("device", (Object)this.myDevice).add("state", (Object)this.myState).add("locale", (Object)this.myLocale).add("target", (Object)this.myTarget).add("uimode", (Object)this.myUiMode).add("nightmode", (Object)this.myNightMode).add("fontScale", this.myFontScale).add("adaptiveShape", (Object)this.myAdaptiveShape).add("useThemedIcon", this.myUseThemedIcon).add("wallpaper", (Object)this.myWallpaper).add("deviceOverlay", (Object)this.myDeviceOverlay).add("gestureNav", this.myGestureNav).add("cutoutOverlay", (Object)this.myCutoutOverlay).add("edgeToEdge", this.myEdgeToEdge).toString();
    }

    @NotNull
    public ConfigurationModelModule getConfigModule() {
        return this.mySettings.getConfigModule();
    }

    public void setEffectiveDevice(@Nullable Device device2, @Nullable State state2) {
        int updateFlags = 0;
        if (this.myDevice != device2) {
            updateFlags = 2;
            this.myDevice = device2;
            this.updateDeviceOverlay();
        }
        if (this.myState != state2) {
            this.myState = state2;
            this.myStateName = state2 != null ? state2.getName() : null;
            updateFlags |= 4;
        }
        if (updateFlags != 0) {
            this.updated(updateFlags);
        }
    }

    public long getModificationCount() {
        return this.myModificationCount;
    }

    @Nullable
    private static IAndroidTarget getTargetForRendering(@Nullable IAndroidTarget target2, @NotNull ConfigurationModelModule module) {
        if (target2 == null) {
            return null;
        }
        return module.getCompatibilityTarget(target2);
    }

    @NotNull
    public String getPreferredTheme() {
        return this.mySettings.getConfigModule().getThemeInfoProvider().getDefaultTheme(this);
    }

    public static enum ImageTransformationType {
        COLOR_BLIND_MODE,
        GLASSES_BACKGROUND_IMAGE;

    }
}

