/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.componenttree.treetable;

import com.android.tools.componenttree.api.IntColumn;
import com.android.tools.componenttree.treetable.IntTableCellRendererKt;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0014\u0010\u0013\u001a\u00020\u0014*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/componenttree/treetable/IntTableCellRenderer;", "Ljavax/swing/table/TableCellRenderer;", "Lcom/intellij/ui/components/JBLabel;", "columnInfo", "Lcom/android/tools/componenttree/api/IntColumn;", "<init>", "(Lcom/android/tools/componenttree/api/IntColumn;)V", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "", "column", "withUnderline", "Ljava/awt/Font;", "underline", "intellij.android.layout-ui"})
@SourceDebugExtension(value={"SMAP\nIntTableCellRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntTableCellRenderer.kt\ncom/android/tools/componenttree/treetable/IntTableCellRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public final class IntTableCellRenderer
extends JBLabel
implements TableCellRenderer {
    @NotNull
    private final IntColumn columnInfo;

    public IntTableCellRenderer(@NotNull IntColumn columnInfo) {
        Intrinsics.checkNotNullParameter((Object)columnInfo, (String)"columnInfo");
        this.columnInfo = columnInfo;
        this.setHorizontalAlignment(0);
        this.setBorder(IntTableCellRendererKt.createBorder(this.columnInfo));
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@NotNull JTable table2, @NotNull Object value2, boolean isSelected, boolean hasFocus, int row, int column2) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Integer n = this.columnInfo.getInt(value2);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer intValue = it != 0 ? n : null;
        boolean focused = table2.hasFocus();
        boolean asLink = this.columnInfo.isActionEnabled(value2);
        Object object = intValue;
        if (object == null || (object = String.valueOf((Integer)object)) == null) {
            object = "";
        }
        this.setText((String)object);
        this.setBackground(UIUtil.getTableBackground((boolean)isSelected, (boolean)focused));
        if (asLink) {
            color = JBUI.CurrentTheme.Link.Foreground.ENABLED;
        } else if (isSelected && focused) {
            color = UIUtil.getTableForeground((boolean)true, (boolean)true);
        } else {
            color = this.columnInfo.getForeground();
            if (color == null) {
                Color color2 = UIUtil.getTableForeground((boolean)isSelected, (boolean)focused);
                color = color2;
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getTableForeground(...)");
            }
        }
        this.setForeground(color);
        Font font = UIUtil.getLabelFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getLabelFont(...)");
        this.setFont(this.withUnderline(font, asLink));
        this.setToolTipText(this.columnInfo.getTooltipText(value2));
        return (Component)((Object)this);
    }

    private final Font withUnderline(Font $this$withUnderline, boolean underline) {
        if (!underline) {
            return $this$withUnderline;
        }
        Map<TextAttribute, ?> map2 = $this$withUnderline.getAttributes();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getAttributes(...)");
        Font font = $this$withUnderline.deriveFont(MapsKt.plus(map2, (Pair)TuplesKt.to((Object)TextAttribute.UNDERLINE, (Object)TextAttribute.UNDERLINE_ON)));
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"deriveFont(...)");
        return font;
    }
}

