/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.componenttree.treetable;

import com.android.tools.adtui.RangeScrollBarUI;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.componenttree.treetable.TreeTableImpl;
import com.android.tools.componenttree.treetable.TreeTableImplKt;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.plaf.ScrollBarUI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\u0012\u0010\u0011\u001a\u00020\r2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/componenttree/treetable/ColumnTreeScrollPanel;", "Ljavax/swing/JPanel;", "tree", "Lcom/intellij/ui/treeStructure/treetable/TreeTableTree;", "table", "Lcom/android/tools/componenttree/treetable/TreeTableImpl;", "<init>", "(Lcom/intellij/ui/treeStructure/treetable/TreeTableTree;Lcom/android/tools/componenttree/treetable/TreeTableImpl;)V", "scrollbar", "Lcom/android/tools/componenttree/treetable/ColumnTreeScrollPanel$ColumnTreeScrollBar;", "getModel", "Ljavax/swing/BoundedRangeModel;", "getUnitIncrement", "", "updateScrollBar", "", "maxValue", "getTreeColumnWidth", "Ljavax/swing/JTable;", "ColumnTreeScrollBar", "intellij.android.layout-ui"})
public final class ColumnTreeScrollPanel
extends JPanel {
    @NotNull
    private final TreeTableTree tree;
    @NotNull
    private final TreeTableImpl table;
    @NotNull
    private final ColumnTreeScrollBar scrollbar;

    public ColumnTreeScrollPanel(@NotNull TreeTableTree tree, @NotNull TreeTableImpl table2) {
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        super((LayoutManager)new TabularLayout("Fit-,*"));
        this.tree = tree;
        this.table = table2;
        this.scrollbar = new ColumnTreeScrollBar((JTable)((Object)this.table));
        this.add((Component)((Object)this.scrollbar), new TabularLayout.Constraint(0, 0, 0, 4, null));
        this.add((Component)new JPanel(), new TabularLayout.Constraint(0, 1, 0, 4, null));
    }

    @NotNull
    public final BoundedRangeModel getModel() {
        BoundedRangeModel boundedRangeModel = this.scrollbar.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)boundedRangeModel, (String)"getModel(...)");
        return boundedRangeModel;
    }

    public final int getUnitIncrement() {
        return this.scrollbar.getUnitIncrement();
    }

    public final void updateScrollBar(int maxValue) {
        int extent;
        int max = maxValue;
        int value2 = TreeTableImplKt.getTreeOffset((JTree)this.tree);
        if (value2 + (extent = this.getTreeColumnWidth((JTable)((Object)this.table))) > max) {
            value2 = max - extent;
        }
        this.scrollbar.getModel().setMaximum(max);
        this.scrollbar.getModel().setValue(value2);
        this.scrollbar.getModel().setExtent(extent);
        this.scrollbar.revalidate();
        this.setVisible(extent < max);
    }

    private final int getTreeColumnWidth(JTable table2) {
        if (table2 == null || table2.getColumnModel().getColumnCount() == 0) {
            return 0;
        }
        return table2.getColumnModel().getColumn(0).getWidth();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/componenttree/treetable/ColumnTreeScrollPanel$ColumnTreeScrollBar;", "Lcom/intellij/ui/components/JBScrollBar;", "table", "Ljavax/swing/JTable;", "<init>", "(Lcom/android/tools/componenttree/treetable/ColumnTreeScrollPanel;Ljavax/swing/JTable;)V", "updateUI", "", "getMinimumSize", "Ljava/awt/Dimension;", "getTreeColumnWidth", "", "intellij.android.layout-ui"})
    private final class ColumnTreeScrollBar
    extends JBScrollBar {
        @NotNull
        private final JTable table;

        public ColumnTreeScrollBar(JTable table2) {
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            super(0);
            this.table = table2;
            this.updateUI();
            this.unitIncrement = 10;
        }

        public void updateUI() {
            this.setUI((ScrollBarUI)new RangeScrollBarUI());
        }

        @NotNull
        public Dimension getMinimumSize() {
            Dimension dim = super.getMinimumSize();
            return new Dimension(this.getTreeColumnWidth(this.table), dim.height);
        }

        private final int getTreeColumnWidth(JTable table2) {
            return table2.getColumnModel().getColumnCount() == 0 ? 0 : table2.getColumnModel().getColumn(0).getWidth();
        }
    }
}

