/*
 * Decompiled with CFR 0.152.
 */
package com.android.sync.analyzer;

import com.android.build.attribution.analyzers.DownloadsAnalyzer;
import com.android.build.output.DownloadInfoDataModel;
import com.android.build.output.LongDownloadsNotifier;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\nJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\nJ\b\u0010\u0015\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R(\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/android/sync/analyzer/SyncAnalyzerDataManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "idToData", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "Lcom/android/sync/analyzer/SyncAnalyzerDataManager$DataHolder;", "getIdToData$annotations", "()V", "getIdToData", "()Ljava/util/concurrent/ConcurrentHashMap;", "getOrCreateDataForTask", "id", "getDataForTaskIfExists", "clearDataForTask", "", "dispose", "DataHolder", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nSyncAnalyzerManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyncAnalyzerManagerImpl.kt\ncom/android/sync/analyzer/SyncAnalyzerDataManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,124:1\n1#2:125\n216#3,2:126\n*S KotlinDebug\n*F\n+ 1 SyncAnalyzerManagerImpl.kt\ncom/android/sync/analyzer/SyncAnalyzerDataManager\n*L\n95#1:126,2\n*E\n"})
public final class SyncAnalyzerDataManager
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<ExternalSystemTaskId, DataHolder> idToData;

    public SyncAnalyzerDataManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.idToData = new ConcurrentHashMap();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ConcurrentHashMap<ExternalSystemTaskId, DataHolder> getIdToData() {
        return this.idToData;
    }

    @VisibleForTesting
    public static /* synthetic */ void getIdToData$annotations() {
    }

    @NotNull
    public final DataHolder getOrCreateDataForTask(@NotNull ExternalSystemTaskId id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        DataHolder dataHolder = this.idToData.computeIfAbsent(id2, arg_0 -> SyncAnalyzerDataManager.getOrCreateDataForTask$lambda$1(arg_0 -> SyncAnalyzerDataManager.getOrCreateDataForTask$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dataHolder, (String)"computeIfAbsent(...)");
        return dataHolder;
    }

    @Nullable
    public final DataHolder getDataForTaskIfExists(@NotNull ExternalSystemTaskId id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return this.idToData.get(id2);
    }

    public final void clearDataForTask(@NotNull ExternalSystemTaskId id2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            DataHolder dataHolder = this.idToData.remove(id2);
            if (dataHolder == null) break block0;
            DataHolder it = dataHolder;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it.getBuildDisposable()));
        }
    }

    public void dispose() {
        Map $this$forEach$iv = this.idToData;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)((DataHolder)it.getValue()).getBuildDisposable()));
        }
        this.idToData.clear();
    }

    private static final DataHolder getOrCreateDataForTask$lambda$0(SyncAnalyzerDataManager this$0, ExternalSystemTaskId it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new DataHolder(it, this$0.project);
    }

    private static final DataHolder getOrCreateDataForTask$lambda$1(Function1 $tmp0, Object p0) {
        return (DataHolder)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/android/sync/analyzer/SyncAnalyzerDataManager$DataHolder;", "", "id", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;Lcom/intellij/openapi/project/Project;)V", "getId", "()Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "buildStartTimestampMs", "", "getBuildStartTimestampMs", "()J", "buildDisposable", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lorg/jetbrains/annotations/NotNull;", "getBuildDisposable", "()Lcom/intellij/openapi/util/CheckedDisposable;", "downloadsStatsAccumulator", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadStatsAccumulator;", "getDownloadsStatsAccumulator", "()Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadStatsAccumulator;", "downloadsInfoDataModel", "Lcom/android/build/output/DownloadInfoDataModel;", "getDownloadsInfoDataModel", "()Lcom/android/build/output/DownloadInfoDataModel;", "intellij.android.build-attribution"})
    public static final class DataHolder {
        @NotNull
        private final ExternalSystemTaskId id;
        private final long buildStartTimestampMs;
        @NotNull
        private final CheckedDisposable buildDisposable;
        @NotNull
        private final DownloadsAnalyzer.DownloadStatsAccumulator downloadsStatsAccumulator;
        @NotNull
        private final DownloadInfoDataModel downloadsInfoDataModel;

        public DataHolder(@NotNull ExternalSystemTaskId id2, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.id = id2;
            this.buildStartTimestampMs = System.currentTimeMillis();
            CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable((String)("SyncAnalyzer disposable for " + this.id));
            Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
            this.buildDisposable = checkedDisposable;
            this.downloadsStatsAccumulator = new DownloadsAnalyzer.DownloadStatsAccumulator();
            this.downloadsInfoDataModel = new DownloadInfoDataModel((Disposable)this.buildDisposable, new LongDownloadsNotifier(this.id, project, this.buildDisposable, this.buildStartTimestampMs, null, null, 48, null));
        }

        @NotNull
        public final ExternalSystemTaskId getId() {
            return this.id;
        }

        public final long getBuildStartTimestampMs() {
            return this.buildStartTimestampMs;
        }

        @NotNull
        public final CheckedDisposable getBuildDisposable() {
            return this.buildDisposable;
        }

        @NotNull
        public final DownloadsAnalyzer.DownloadStatsAccumulator getDownloadsStatsAccumulator() {
            return this.downloadsStatsAccumulator;
        }

        @NotNull
        public final DownloadInfoDataModel getDownloadsInfoDataModel() {
            return this.downloadsInfoDataModel;
        }
    }
}

