/*
 * Decompiled with CFR 0.152.
 */
package com.android.emulator;

import com.android.emulator.SnapshotProtoException;
import com.android.emulator.snapshot.SnapshotOuterClass;
import com.android.io.CancellableFileIo;
import com.intellij.util.text.StringKt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/android/emulator/SnapshotProtoParser;", "", "snapshotProtobufFile", "Ljava/nio/file/Path;", "fileName", "", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;)V", "snapshot", "Lcom/android/emulator/snapshot/SnapshotOuterClass$Snapshot;", "logicalName", "getLogicalName", "()Ljava/lang/String;", "creationTime", "", "getCreationTime", "()J", "intellij.android.core"})
public final class SnapshotProtoParser {
    @NotNull
    private final String fileName;
    @NotNull
    private final SnapshotOuterClass.Snapshot snapshot;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnapshotProtoParser(@NotNull Path snapshotProtobufFile, @NotNull String fileName) throws SnapshotProtoException {
        Intrinsics.checkNotNullParameter((Object)snapshotProtobufFile, (String)"snapshotProtobufFile");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.fileName = fileName;
        try {
            SnapshotOuterClass.Snapshot snapshot;
            Closeable closeable = CancellableFileIo.newInputStream((Path)snapshotProtobufFile, (OpenOption[])new OpenOption[0]);
            SnapshotProtoParser snapshotProtoParser = this;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                snapshot = SnapshotOuterClass.Snapshot.parseFrom((InputStream)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            SnapshotOuterClass.Snapshot snapshot2 = snapshot;
            Intrinsics.checkNotNullExpressionValue((Object)snapshot2, (String)"use(...)");
            snapshotProtoParser.snapshot = snapshot2;
        }
        catch (IOException exception) {
            if (!CancellableFileIo.isRegularFile((Path)snapshotProtobufFile, (LinkOption[])new LinkOption[0])) {
                throw new SnapshotProtoException("Snapshot file " + snapshotProtobufFile.toAbsolutePath() + " does not exist", null, 2, null);
            }
            throw exception;
        }
        if (this.snapshot.getImagesCount() <= 0) {
            throw new SnapshotProtoException("Snapshot protobuf is empty.", null, 2, null);
        }
    }

    @NotNull
    public final String getLogicalName() {
        String string = StringKt.nullize$default((String)this.snapshot.getLogicalName(), (boolean)false, (int)1, null);
        if (string == null) {
            string = this.fileName;
        }
        return string;
    }

    public final long getCreationTime() {
        return this.snapshot.getCreationTime();
    }
}

