/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.output;

import com.android.build.attribution.analyzers.DownloadsAnalyzer;
import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.output.DownloadRequestItem;
import com.android.build.output.RepositoriesTableModel;
import com.android.build.output.RepositoryTableItem;
import com.intellij.openapi.util.text.Formats;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010R\u0011\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/android/build/output/RepositoriesTableModel;", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/android/build/output/RepositoryTableItem;", "<init>", "()V", "summaryItem", "getSummaryItem", "()Lcom/android/build/output/RepositoryTableItem;", "reposData", "", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;", "getReposData", "()Ljava/util/Map;", "bulkUpdate", "", "downloadRequests", "", "Lcom/android/build/output/DownloadRequestItem;", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nDownloadsInfoUIModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadsInfoUIModel.kt\ncom/android/build/output/RepositoriesTableModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,285:1\n1491#2:286\n1516#2,3:287\n1519#2,3:297\n360#2,7:301\n382#3,7:290\n216#4:300\n217#4:308\n*S KotlinDebug\n*F\n+ 1 DownloadsInfoUIModel.kt\ncom/android/build/output/RepositoriesTableModel\n*L\n179#1:286\n179#1:287,3\n179#1:297,3\n184#1:301,7\n179#1:290,7\n179#1:300\n179#1:308\n*E\n"})
public final class RepositoriesTableModel
extends ListTableModel<RepositoryTableItem> {
    @NotNull
    private final RepositoryTableItem summaryItem = new RepositoryTableItem(null);
    @NotNull
    private final Map<DownloadsAnalyzer.Repository, RepositoryTableItem> reposData = new LinkedHashMap();

    public RepositoriesTableModel() {
        super(new ColumnInfo[0]);
        ColoredTableCellRenderer cellRenderer2 = new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(JTable table2, Object value2, boolean selected, boolean hasFocus, int row, int column2) {
                Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
                if (value2 instanceof String) {
                    if (row == 0) {
                        this.append((String)value2, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else {
                        this.append((String)value2, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                }
            }
        };
        column.1[] nullArray = new column.1[]{RepositoriesTableModel._init_$column$default(cellRenderer2, "Repository", null, RepositoriesTableModel::_init_$lambda$0, 4, null), RepositoriesTableModel._init_$column(cellRenderer2, "Requests", "Total number of requests.", (Function1<? super RepositoryTableItem, String>)((Function1)RepositoriesTableModel::_init_$lambda$1)), RepositoriesTableModel._init_$column(cellRenderer2, "Data", "Total amount of data downloaded.", (Function1<? super RepositoryTableItem, String>)((Function1)RepositoriesTableModel::_init_$lambda$2)), RepositoriesTableModel._init_$column(cellRenderer2, "Time", "Total amount of time taken to execute requests.", (Function1<? super RepositoryTableItem, String>)((Function1)RepositoriesTableModel::_init_$lambda$3)), RepositoriesTableModel._init_$column(cellRenderer2, "Avg Speed", "Average download speed.", (Function1<? super RepositoryTableItem, String>)((Function1)RepositoriesTableModel::_init_$lambda$4)), RepositoriesTableModel._init_$column(cellRenderer2, "Failed Requests", "Number of failed requests.", (Function1<? super RepositoryTableItem, String>)((Function1)RepositoriesTableModel::_init_$lambda$5)), RepositoriesTableModel._init_$column(cellRenderer2, "Failed Requests Time", "Total amount of time taken to execute failed requests.", (Function1<? super RepositoryTableItem, String>)((Function1)RepositoriesTableModel::_init_$lambda$6))};
        this.setColumnInfos(nullArray);
    }

    @NotNull
    public final RepositoryTableItem getSummaryItem() {
        return this.summaryItem;
    }

    @NotNull
    public final Map<DownloadsAnalyzer.Repository, RepositoryTableItem> getReposData() {
        return this.reposData;
    }

    /*
     * WARNING - void declaration
     */
    public final void bulkUpdate(@NotNull List<DownloadRequestItem> downloadRequests) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(downloadRequests, (String)"downloadRequests");
        if (this.getItems().isEmpty()) {
            this.addRow(this.summaryItem);
        }
        this.summaryItem.updateRequests(downloadRequests);
        this.fireTableCellUpdated(0, -1);
        Iterable $this$groupBy$iv = downloadRequests;
        boolean $i$f$groupBy = false;
        Object object = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            DownloadRequestItem it = (DownloadRequestItem)element$iv$iv;
            boolean bl = false;
            DownloadsAnalyzer.Repository key$iv$iv = it.getRepository();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            int updatedRepoRowIndex;
            RepositoryTableItem repoTableItem;
            block8: {
                int n;
                List $this$indexOfFirst$iv;
                Map.Entry element$iv;
                Map.Entry entry = element$iv = (Map.Entry)object.next();
                boolean bl = false;
                DownloadsAnalyzer.Repository repository2 = (DownloadsAnalyzer.Repository)entry.getKey();
                List requests2 = (List)entry.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)this.reposData.computeIfAbsent(repository2, arg_0 -> RepositoriesTableModel.bulkUpdate$lambda$1$1(RepositoriesTableModel::bulkUpdate$lambda$1$0, arg_0)), (String)"computeIfAbsent(...)");
                repoTableItem.updateRequests(requests2);
                Intrinsics.checkNotNullExpressionValue((Object)this.getItems(), (String)"getItems(...)");
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    RepositoryTableItem it = (RepositoryTableItem)item$iv;
                    boolean bl3 = false;
                    if (Intrinsics.areEqual((Object)it.getRepository(), (Object)repository2)) {
                        n = index$iv;
                        break block8;
                    }
                    ++index$iv;
                }
                n = updatedRepoRowIndex = -1;
            }
            if (updatedRepoRowIndex == -1) {
                this.addRow(repoTableItem);
                continue;
            }
            this.fireTableCellUpdated(updatedRepoRowIndex, -1);
        }
    }

    private static final column.1 _init_$column(cellRenderer.1 cellRenderer2, String title2, String tooltip, Function1<? super RepositoryTableItem, String> valueOf) {
        return new ColumnInfo<RepositoryTableItem, String>(title2, valueOf, tooltip, cellRenderer2){
            final /* synthetic */ String $title;
            final /* synthetic */ Function1<RepositoryTableItem, String> $valueOf;
            final /* synthetic */ String $tooltip;
            final /* synthetic */ cellRenderer.1 $cellRenderer;
            {
                this.$title = $title;
                this.$valueOf = $valueOf;
                this.$tooltip = $tooltip;
                this.$cellRenderer = $cellRenderer;
                super($title);
            }

            public String valueOf(RepositoryTableItem found) {
                Intrinsics.checkNotNullParameter((Object)found, (String)"found");
                return (String)this.$valueOf.invoke((Object)found);
            }

            public String getPreferredStringValue() {
                return this.$title;
            }

            public String getTooltipText() {
                return this.$tooltip;
            }

            public TableCellRenderer getRenderer(RepositoryTableItem item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return (TableCellRenderer)((Object)this.$cellRenderer);
            }
        };
    }

    static /* synthetic */ column.1 _init_$column$default(cellRenderer.1 var0, String string, String string2, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return RepositoriesTableModel._init_$column(var0, string, string2, (Function1<? super RepositoryTableItem, String>)function1);
    }

    private static final String _init_$lambda$0(RepositoryTableItem repoItem) {
        String string;
        Intrinsics.checkNotNullParameter((Object)repoItem, (String)"repoItem");
        if (repoItem.getRepository() == null) {
            string = "Total";
        } else if (repoItem.getRepository() instanceof DownloadsAnalyzer.KnownRepository) {
            string = ((DownloadsAnalyzer.KnownRepository)repoItem.getRepository()).getPresentableName();
        } else if (repoItem.getRepository() instanceof DownloadsAnalyzer.OtherRepository) {
            string = ((DownloadsAnalyzer.OtherRepository)repoItem.getRepository()).getHost();
        } else {
            throw new IllegalStateException("Unexpected repository table item.".toString());
        }
        return string;
    }

    private static final String _init_$lambda$1(RepositoryTableItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int runningRequests = it.getRunningNumberOfRequests();
        int totalRequests = it.getTotalNumberOfRequests();
        return runningRequests > 0 ? totalRequests + " (" + runningRequests + " running)" : String.valueOf(totalRequests);
    }

    private static final String _init_$lambda$2(RepositoryTableItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = Formats.formatFileSize((long)it.getTotalAmountOfData());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(...)");
        return string;
    }

    private static final String _init_$lambda$3(RepositoryTableItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = StringUtil.formatDuration((long)it.getTotalAmountOfTime());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDuration(...)");
        return string;
    }

    private static final String _init_$lambda$4(RepositoryTableItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return BuildAttributionUIUtilKt.formatAvgDownloadSpeed(it.getTotalAmountOfData(), it.getTotalAmountOfTime());
    }

    private static final String _init_$lambda$5(RepositoryTableItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return String.valueOf(it.getNumberOfFailed());
    }

    private static final String _init_$lambda$6(RepositoryTableItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = StringUtil.formatDuration((long)it.getTimeOfFailed());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDuration(...)");
        return string;
    }

    private static final RepositoryTableItem bulkUpdate$lambda$1$0(DownloadsAnalyzer.Repository it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new RepositoryTableItem(it);
    }

    private static final RepositoryTableItem bulkUpdate$lambda$1$1(Function1 $tmp0, Object p0) {
        return (RepositoryTableItem)$tmp0.invoke(p0);
    }
}

