/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.analyzers.DownloadsAnalyzer;
import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.intellij.openapi.util.text.Formats;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0005\u0006\u0007B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\b"}, d2={"Lcom/android/build/attribution/ui/model/RequestsListTableModel;", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadResult;", "<init>", "()V", "StatusColumnData", "MyStatusColumnCellRenderer", "MyCellRenderer", "intellij.android.build-attribution"})
public final class RequestsListTableModel
extends ListTableModel<DownloadsAnalyzer.DownloadResult> {
    public RequestsListTableModel() {
        super(new ColumnInfo[0]);
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new ColumnInfo<DownloadsAnalyzer.DownloadResult, StatusColumnData>(){
            private final MyStatusColumnCellRenderer cellRenderer = new MyStatusColumnCellRenderer();

            public final MyStatusColumnCellRenderer getCellRenderer() {
                return this.cellRenderer;
            }

            public StatusColumnData valueOf(DownloadsAnalyzer.DownloadResult item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                String string = item.getFailureMessage();
                String formattedTooltip = string != null ? StringsKt.replace$default((String)string, (String)"\n", (String)"<br/>", (boolean)false, (int)4, null) : null;
                return switch (WhenMappings.$EnumSwitchMapping$0[item.getStatus().ordinal()]) {
                    case 1 -> new StatusColumnData("Ok", null, formattedTooltip);
                    case 2 -> new StatusColumnData("Not Found", BuildAttributionUIUtilKt.warningIcon(), formattedTooltip);
                    case 3 -> new StatusColumnData("Error", BuildAttributionUIUtilKt.warningIcon(), formattedTooltip);
                    default -> throw new NoWhenBranchMatchedException();
                };
            }

            public TableCellRenderer getRenderer(DownloadsAnalyzer.DownloadResult item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return (TableCellRenderer)((Object)this.cellRenderer);
            }

            public String getPreferredStringValue() {
                return "Not Found";
            }

            public String getMaxStringValue() {
                return this.getPreferredStringValue();
            }

            public int getAdditionalWidth() {
                return BuildAttributionUIUtilKt.warningIcon().getIconWidth();
            }

            public Comparator<DownloadsAnalyzer.DownloadResult> getComparator() {
                Comparator<Object> comparator = Comparator.comparing(arg_0 -> 1.getComparator$lambda$1(1::getComparator$lambda$0, arg_0));
                Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
                return comparator;
            }

            private static final DownloadsAnalyzer.DownloadStatus getComparator$lambda$0(DownloadsAnalyzer.DownloadResult it) {
                return it.getStatus();
            }

            private static final DownloadsAnalyzer.DownloadStatus getComparator$lambda$1(Function1 $tmp0, Object p0) {
                return (DownloadsAnalyzer.DownloadStatus)((Object)$tmp0.invoke(p0));
            }

            @Metadata(mv={2, 0, 0}, k=3, xi=48)
            public static final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[DownloadsAnalyzer.DownloadStatus.values().length];
                    try {
                        nArray[DownloadsAnalyzer.DownloadStatus.SUCCESS.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DownloadsAnalyzer.DownloadStatus.MISSED.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[DownloadsAnalyzer.DownloadStatus.FAILURE.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }, new ColumnInfo<DownloadsAnalyzer.DownloadResult, String>(){
            private final MyCellRenderer cellRenderer;
            {
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
                this.cellRenderer = new MyCellRenderer(simpleTextAttributes);
            }

            public final MyCellRenderer getCellRenderer() {
                return this.cellRenderer;
            }

            public String valueOf(DownloadsAnalyzer.DownloadResult item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return item.getUrl();
            }

            public TableCellRenderer getRenderer(DownloadsAnalyzer.DownloadResult item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return (TableCellRenderer)((Object)this.cellRenderer);
            }

            public Comparator<DownloadsAnalyzer.DownloadResult> getComparator() {
                Comparator<Object> comparator = Comparator.comparing(arg_0 -> 2.getComparator$lambda$1(2::getComparator$lambda$0, arg_0));
                Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
                return comparator;
            }

            private static final String getComparator$lambda$0(DownloadsAnalyzer.DownloadResult it) {
                return it.getUrl();
            }

            private static final String getComparator$lambda$1(Function1 $tmp0, Object p0) {
                return (String)$tmp0.invoke(p0);
            }
        }, new ColumnInfo<DownloadsAnalyzer.DownloadResult, String>(){
            private final MyCellRenderer cellRenderer;
            {
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAYED_ATTRIBUTES");
                this.cellRenderer = new MyCellRenderer(simpleTextAttributes);
            }

            public final MyCellRenderer getCellRenderer() {
                return this.cellRenderer;
            }

            public String valueOf(DownloadsAnalyzer.DownloadResult item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return BuildAttributionUIUtilKt.durationString(item.getDuration());
            }

            public TableCellRenderer getRenderer(DownloadsAnalyzer.DownloadResult item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return (TableCellRenderer)((Object)this.cellRenderer);
            }

            public String getPreferredStringValue() {
                return "###.#s";
            }

            public String getMaxStringValue() {
                return this.getPreferredStringValue();
            }

            public Comparator<DownloadsAnalyzer.DownloadResult> getComparator() {
                Comparator<Object> comparator = Comparator.comparing(arg_0 -> 3.getComparator$lambda$1(3::getComparator$lambda$0, arg_0));
                Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
                return comparator;
            }

            private static final Long getComparator$lambda$0(DownloadsAnalyzer.DownloadResult it) {
                return it.getDuration();
            }

            private static final Long getComparator$lambda$1(Function1 $tmp0, Object p0) {
                return (Long)$tmp0.invoke(p0);
            }
        }, new ColumnInfo<DownloadsAnalyzer.DownloadResult, String>(){
            private final MyCellRenderer cellRenderer;
            {
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAYED_ATTRIBUTES");
                this.cellRenderer = new MyCellRenderer(simpleTextAttributes);
            }

            public final MyCellRenderer getCellRenderer() {
                return this.cellRenderer;
            }

            public String valueOf(DownloadsAnalyzer.DownloadResult item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                String string = Formats.formatFileSize((long)item.getBytes());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(...)");
                return string;
            }

            public TableCellRenderer getRenderer(DownloadsAnalyzer.DownloadResult item) {
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                return (TableCellRenderer)((Object)this.cellRenderer);
            }

            public String getPreferredStringValue() {
                return "123.45MB";
            }

            public String getMaxStringValue() {
                return this.getPreferredStringValue();
            }

            public Comparator<DownloadsAnalyzer.DownloadResult> getComparator() {
                Comparator<Object> comparator = Comparator.comparing(arg_0 -> 4.getComparator$lambda$1(4::getComparator$lambda$0, arg_0));
                Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
                return comparator;
            }

            private static final Long getComparator$lambda$0(DownloadsAnalyzer.DownloadResult it) {
                return it.getBytes();
            }

            private static final Long getComparator$lambda$1(Function1 $tmp0, Object p0) {
                return (Long)$tmp0.invoke(p0);
            }
        }};
        this.setColumnInfos(columnInfoArray);
        this.setSortable(true);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J:\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/android/build/attribution/ui/model/RequestsListTableModel$MyCellRenderer;", "Lcom/intellij/ui/ColoredTableCellRenderer;", "textAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "<init>", "(Lcom/intellij/ui/SimpleTextAttributes;)V", "getTextAttributes", "()Lcom/intellij/ui/SimpleTextAttributes;", "customizeCellRenderer", "", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "hasFocus", "row", "", "column", "intellij.android.build-attribution"})
    private static final class MyCellRenderer
    extends ColoredTableCellRenderer {
        @NotNull
        private final SimpleTextAttributes textAttributes;

        public MyCellRenderer(@NotNull SimpleTextAttributes textAttributes) {
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            this.textAttributes = textAttributes;
        }

        @NotNull
        public final SimpleTextAttributes getTextAttributes() {
            return this.textAttributes;
        }

        protected void customizeCellRenderer(@NotNull JTable table2, @Nullable Object value2, boolean selected, boolean hasFocus, int row, int column2) {
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            if (value2 instanceof String) {
                this.append((String)value2, this.textAttributes);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/android/build/attribution/ui/model/RequestsListTableModel$MyStatusColumnCellRenderer;", "Lcom/intellij/ui/ColoredTableCellRenderer;", "<init>", "()V", "customizeCellRenderer", "", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "hasFocus", "row", "", "column", "intellij.android.build-attribution"})
    private static final class MyStatusColumnCellRenderer
    extends ColoredTableCellRenderer {
        protected void customizeCellRenderer(@NotNull JTable table2, @Nullable Object value2, boolean selected, boolean hasFocus, int row, int column2) {
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            if (value2 instanceof StatusColumnData) {
                this.setIcon(((StatusColumnData)value2).getIcon());
                this.setTransparentIconBackground(true);
                this.append(((StatusColumnData)value2).getText(), SimpleTextAttributes.GRAY_SMALL_ATTRIBUTES);
                this.setToolTipText(((StatusColumnData)value2).getTooltip());
            }
            this.setTextAlign(4);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/android/build/attribution/ui/model/RequestsListTableModel$StatusColumnData;", "", "text", "", "icon", "Ljavax/swing/Icon;", "tooltip", "<init>", "(Ljava/lang/String;Ljavax/swing/Icon;Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "getIcon", "()Ljavax/swing/Icon;", "getTooltip", "toString", "intellij.android.build-attribution"})
    private static final class StatusColumnData {
        @NotNull
        private final String text;
        @Nullable
        private final Icon icon;
        @Nullable
        private final String tooltip;

        public StatusColumnData(@NotNull String text2, @Nullable Icon icon, @Nullable String tooltip) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.text = text2;
            this.icon = icon;
            this.tooltip = tooltip;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @Nullable
        public final Icon getIcon() {
            return this.icon;
        }

        @Nullable
        public final String getTooltip() {
            return this.tooltip;
        }

        @NotNull
        public String toString() {
            return this.text;
        }
    }
}

