/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.data.builder;

import com.android.build.attribution.analyzers.BuildEventsAnalysisResult;
import com.android.build.attribution.data.AlwaysRunTaskData;
import com.android.build.attribution.data.PluginData;
import com.android.build.attribution.data.TaskData;
import com.android.build.attribution.data.TasksSharingOutputData;
import com.android.build.attribution.ui.BuildAnalyzerBrowserLinks;
import com.android.build.attribution.ui.data.InterTaskIssueUiData;
import com.android.build.attribution.ui.data.TaskIssueType;
import com.android.build.attribution.ui.data.TaskIssueUiData;
import com.android.build.attribution.ui.data.TaskIssuesGroup;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.data.TimeWithPercentage;
import com.android.build.attribution.ui.data.builder.TaskIssueUiDataContainerKt;
import com.android.build.attribution.ui.data.builder.TaskUiDataContainer;
import com.android.buildanalyzer.common.TaskCategory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0003#$%B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\nH\u0002J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\u0006\u0010\u0016\u001a\u00020\bJ\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0019J\u001e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u0019H\u0002J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010 \u001a\u00020\u000eJ\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\"\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/android/build/attribution/ui/data/builder/TaskIssueUiDataContainer;", "", "buildAnalysisResult", "Lcom/android/build/attribution/analyzers/BuildEventsAnalysisResult;", "<init>", "(Lcom/android/build/attribution/analyzers/BuildEventsAnalysisResult;)V", "issuesByTask", "", "Lcom/android/build/attribution/data/TaskData;", "", "Lcom/android/build/attribution/ui/data/TaskIssueUiData;", "issuesByType", "Lcom/android/build/attribution/ui/data/TaskIssueType;", "issuesByPlugin", "Lcom/android/build/attribution/data/PluginData;", "issuesByTaskCategory", "Lcom/android/buildanalyzer/common/TaskCategory;", "populate", "", "tasksUiDataContainer", "Lcom/android/build/attribution/ui/data/builder/TaskUiDataContainer;", "addNewIssue", "taskData", "issueUiData", "issuesForTask", "", "allIssueGroups", "Lcom/android/build/attribution/ui/data/TaskIssuesGroup;", "toTaskIssueGroup", "issueType", "issuesList", "pluginIssueGroups", "pluginData", "taskCategoryIssueGroups", "taskCategoryData", "TaskSetupIssue", "AlwaysRunNoOutputIssue", "AlwaysRunUpToDateOverride", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nTaskIssueUiDataContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskIssueUiDataContainer.kt\ncom/android/build/attribution/ui/data/builder/TaskIssueUiDataContainer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,169:1\n1869#2,2:170\n1869#2:172\n1869#2:173\n230#2,2:174\n1870#2:176\n1870#2:177\n1056#2:182\n1491#2:183\n1516#2,3:184\n1519#2,3:194\n1056#2:201\n1491#2:202\n1516#2,3:203\n1519#2,3:213\n1056#2:220\n126#3:178\n153#3,3:179\n126#3:197\n153#3,3:198\n126#3:216\n153#3,3:217\n382#4,7:187\n382#4,7:206\n*S KotlinDebug\n*F\n+ 1 TaskIssueUiDataContainer.kt\ncom/android/build/attribution/ui/data/builder/TaskIssueUiDataContainer\n*L\n49#1:170,2\n60#1:172\n61#1:173\n66#1:174,2\n61#1:176\n60#1:177\n87#1:182\n102#1:183\n102#1:184,3\n102#1:194,3\n104#1:201\n108#1:202\n108#1:203,3\n108#1:213,3\n110#1:220\n86#1:178\n86#1:179,3\n103#1:197\n103#1:198,3\n109#1:216\n109#1:217,3\n102#1:187,7\n108#1:206,7\n*E\n"})
public final class TaskIssueUiDataContainer {
    @NotNull
    private final BuildEventsAnalysisResult buildAnalysisResult;
    @NotNull
    private final Map<TaskData, List<TaskIssueUiData>> issuesByTask;
    @NotNull
    private final Map<TaskIssueType, List<TaskIssueUiData>> issuesByType;
    @NotNull
    private final Map<PluginData, List<TaskIssueUiData>> issuesByPlugin;
    @NotNull
    private final Map<TaskCategory, List<TaskIssueUiData>> issuesByTaskCategory;

    public TaskIssueUiDataContainer(@NotNull BuildEventsAnalysisResult buildAnalysisResult) {
        Intrinsics.checkNotNullParameter((Object)buildAnalysisResult, (String)"buildAnalysisResult");
        this.buildAnalysisResult = buildAnalysisResult;
        this.issuesByTask = new HashMap();
        this.issuesByType = new EnumMap(TaskIssueType.class);
        this.issuesByPlugin = new HashMap();
        this.issuesByTaskCategory = new EnumMap(TaskCategory.class);
    }

    /*
     * WARNING - void declaration
     */
    public final void populate(@NotNull TaskUiDataContainer tasksUiDataContainer) {
        Intrinsics.checkNotNullParameter((Object)tasksUiDataContainer, (String)"tasksUiDataContainer");
        Iterable $this$forEach$iv = this.buildAnalysisResult.getAlwaysRunTasks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AlwaysRunTaskData it = (AlwaysRunTaskData)element$iv;
            boolean bl = false;
            this.addNewIssue(it.getTaskData(), it.getRerunReason() == AlwaysRunTaskData.Reason.UP_TO_DATE_WHEN_FALSE ? (TaskIssueUiData)new AlwaysRunUpToDateOverride(tasksUiDataContainer.getByTaskData(it.getTaskData())) : (TaskIssueUiData)new AlwaysRunNoOutputIssue(tasksUiDataContainer.getByTaskData(it.getTaskData())));
        }
        $this$forEach$iv = this.buildAnalysisResult.getTasksSharingOutput();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TasksSharingOutputData taskSharingIssue = (TasksSharingOutputData)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = taskSharingIssue.getTaskList();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object element$iv32;
                TaskIssueUiDataContainer taskIssueUiDataContainer;
                TaskData taskData;
                TaskUiData taskUiData;
                TaskUiDataContainer taskUiDataContainer;
                block4: {
                    void $this$first$iv;
                    TaskData task2 = (TaskData)element$iv2;
                    boolean bl2 = false;
                    Iterable iterable = taskSharingIssue.getTaskList();
                    taskUiDataContainer = tasksUiDataContainer;
                    taskUiData = tasksUiDataContainer.getByTaskData(task2);
                    taskData = task2;
                    taskIssueUiDataContainer = this;
                    boolean $i$f$first = false;
                    for (Object element$iv32 : $this$first$iv) {
                        TaskData it = (TaskData)element$iv32;
                        boolean bl3 = false;
                        if (!(!Intrinsics.areEqual((Object)it, (Object)task2))) continue;
                        break block4;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                Object t = element$iv32;
                String string = taskSharingIssue.getOutputFilePath();
                TaskUiData taskUiData2 = taskUiDataContainer.getByTaskData((TaskData)t);
                TaskUiData taskUiData3 = taskUiData;
                taskIssueUiDataContainer.addNewIssue(taskData, new TaskSetupIssue(taskUiData3, taskUiData2, string));
            }
        }
    }

    private final void addNewIssue(TaskData taskData, TaskIssueUiData issueUiData) {
        this.issuesByTask.computeIfAbsent(taskData, arg_0 -> TaskIssueUiDataContainer.addNewIssue$lambda$1(TaskIssueUiDataContainer::addNewIssue$lambda$0, arg_0)).add(issueUiData);
        this.issuesByPlugin.computeIfAbsent(taskData.getOriginPlugin(), arg_0 -> TaskIssueUiDataContainer.addNewIssue$lambda$3(TaskIssueUiDataContainer::addNewIssue$lambda$2, arg_0)).add(issueUiData);
        this.issuesByType.computeIfAbsent(issueUiData.getType(), arg_0 -> TaskIssueUiDataContainer.addNewIssue$lambda$5(TaskIssueUiDataContainer::addNewIssue$lambda$4, arg_0)).add(issueUiData);
    }

    @NotNull
    public final List<TaskIssueUiData> issuesForTask(@NotNull TaskData taskData) {
        Intrinsics.checkNotNullParameter((Object)taskData, (String)"taskData");
        List list2 = this.issuesByTask.get(taskData);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TaskIssuesGroup> allIssueGroups() {
        void $this$mapTo$iv$iv;
        Map<TaskIssueType, List<TaskIssueUiData>> $this$map$iv = this.issuesByType;
        boolean $i$f$map = false;
        Map<TaskIssueType, List<TaskIssueUiData>> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            TaskIssueType issueType = (TaskIssueType)((Object)entry.getKey());
            List issuesList = (List)entry.getValue();
            collection2.add(this.toTaskIssueGroup(issueType, issuesList));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TaskIssuesGroup it = (TaskIssuesGroup)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getType().ordinal());
                it = (TaskIssuesGroup)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getType().ordinal()));
            }
        });
    }

    private final TaskIssuesGroup toTaskIssueGroup(TaskIssueType issueType, List<? extends TaskIssueUiData> issuesList) {
        return new TaskIssuesGroup(issueType, issuesList, this){
            private final TaskIssueType type;
            private final List<TaskIssueUiData> issues;
            private final TimeWithPercentage timeContribution;
            {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                this.type = $issueType;
                Iterable $this$sortedByDescending$iv = $issuesList;
                boolean $i$f$sortedByDescending = false;
                this.issues = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        TaskIssueUiData it = (TaskIssueUiData)b;
                        boolean bl = false;
                        Comparable comparable = it.getTask().getExecutionTime();
                        it = (TaskIssueUiData)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getTask().getExecutionTime());
                    }
                });
                $this$sortedByDescending$iv = this.getIssues();
                var var13_6 = this;
                boolean $i$f$map = false;
                void var6_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    TaskIssueUiData taskIssueUiData = (TaskIssueUiData)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(it.getTask().getExecutionTime().getTimeMs());
                }
                long l = TaskIssueUiDataContainer.access$getBuildAnalysisResult$p($receiver).getTotalBuildTimeMs();
                long l2 = CollectionsKt.sumOfLong((Iterable)((List)destination$iv$iv));
                var13_6.timeContribution = new TimeWithPercentage(l2, l);
            }

            public TaskIssueType getType() {
                return this.type;
            }

            public List<TaskIssueUiData> getIssues() {
                return this.issues;
            }

            public TimeWithPercentage getTimeContribution() {
                return this.timeContribution;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TaskIssuesGroup> pluginIssueGroups(@NotNull PluginData pluginData) {
        void $this$mapTo$iv$iv;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pluginData, (String)"pluginData");
        Iterable $this$groupBy$iv = this.issuesByPlugin.getOrDefault(pluginData, CollectionsKt.emptyList());
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv = iterator2.next();
            TaskIssueUiData it = (TaskIssueUiData)element$iv$iv;
            boolean bl = false;
            TaskIssueType key$iv$iv = it.getType();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator2.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            TaskIssueType issueType = (TaskIssueType)((Object)entry.getKey());
            List issuesList = (List)entry.getValue();
            object.add(this.toTaskIssueGroup(issueType, issuesList));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TaskIssuesGroup it = (TaskIssuesGroup)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getType().ordinal());
                it = (TaskIssuesGroup)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getType().ordinal()));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TaskIssuesGroup> taskCategoryIssueGroups(@NotNull TaskCategory taskCategoryData) {
        void $this$mapTo$iv$iv;
        Map $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)taskCategoryData, (String)"taskCategoryData");
        Iterable $this$groupBy$iv = this.issuesByTaskCategory.getOrDefault(taskCategoryData, CollectionsKt.emptyList());
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv = iterator2.next();
            TaskIssueUiData it = (TaskIssueUiData)element$iv$iv;
            boolean bl = false;
            TaskIssueType key$iv$iv = it.getType();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator2.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            TaskIssueType issueType = (TaskIssueType)((Object)entry.getKey());
            List issuesList = (List)entry.getValue();
            object.add(this.toTaskIssueGroup(issueType, issuesList));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TaskIssuesGroup it = (TaskIssuesGroup)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getType().ordinal());
                it = (TaskIssuesGroup)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getType().ordinal()));
            }
        });
    }

    private static final List addNewIssue$lambda$0(TaskData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List addNewIssue$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final List addNewIssue$lambda$2(PluginData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final List addNewIssue$lambda$3(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final List addNewIssue$lambda$4(TaskIssueType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return new ArrayList();
    }

    private static final List addNewIssue$lambda$5(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ BuildEventsAnalysisResult access$getBuildAnalysisResult$p(TaskIssueUiDataContainer $this) {
        return $this.buildAnalysisResult;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/android/build/attribution/ui/data/builder/TaskIssueUiDataContainer$AlwaysRunNoOutputIssue;", "Lcom/android/build/attribution/ui/data/TaskIssueUiData;", "task", "Lcom/android/build/attribution/ui/data/TaskUiData;", "<init>", "(Lcom/android/build/attribution/ui/data/TaskUiData;)V", "getTask", "()Lcom/android/build/attribution/ui/data/TaskUiData;", "type", "Lcom/android/build/attribution/ui/data/TaskIssueType;", "getType", "()Lcom/android/build/attribution/ui/data/TaskIssueType;", "bugReportTitle", "", "getBugReportTitle", "()Ljava/lang/String;", "bugReportBriefDescription", "getBugReportBriefDescription", "explanation", "getExplanation", "helpLink", "Lcom/android/build/attribution/ui/BuildAnalyzerBrowserLinks;", "getHelpLink", "()Lcom/android/build/attribution/ui/BuildAnalyzerBrowserLinks;", "buildSrcRecommendation", "getBuildSrcRecommendation", "intellij.android.build-attribution"})
    public static final class AlwaysRunNoOutputIssue
    implements TaskIssueUiData {
        @NotNull
        private final TaskUiData task;
        @NotNull
        private final TaskIssueType type;
        @NotNull
        private final String bugReportTitle;
        @NotNull
        private final String bugReportBriefDescription;
        @NotNull
        private final String explanation;
        @NotNull
        private final BuildAnalyzerBrowserLinks helpLink;
        @NotNull
        private final String buildSrcRecommendation;

        public AlwaysRunNoOutputIssue(@NotNull TaskUiData task2) {
            Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
            this.task = task2;
            this.type = TaskIssueType.ALWAYS_RUN_TASKS;
            this.bugReportTitle = this.getType().getUiName() + " No Output Declared";
            this.bugReportBriefDescription = "Task runs on every build because it declares no outputs.";
            this.explanation = "This task runs on every build because it declares no outputs,\nwhich it must do in order to support incremental builds.";
            this.helpLink = BuildAnalyzerBrowserLinks.NO_OUTPUTS_DECLARED_ISSUE;
            this.buildSrcRecommendation = "Annotate the task output fields with one of:\nOutputDirectory, OutputDirectories, OutputFile, OutputFiles";
        }

        @Override
        @NotNull
        public TaskUiData getTask() {
            return this.task;
        }

        @Override
        @NotNull
        public TaskIssueType getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getBugReportTitle() {
            return this.bugReportTitle;
        }

        @Override
        @NotNull
        public String getBugReportBriefDescription() {
            return this.bugReportBriefDescription;
        }

        @Override
        @NotNull
        public String getExplanation() {
            return this.explanation;
        }

        @Override
        @NotNull
        public BuildAnalyzerBrowserLinks getHelpLink() {
            return this.helpLink;
        }

        @Override
        @NotNull
        public String getBuildSrcRecommendation() {
            return this.buildSrcRecommendation;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/android/build/attribution/ui/data/builder/TaskIssueUiDataContainer$AlwaysRunUpToDateOverride;", "Lcom/android/build/attribution/ui/data/TaskIssueUiData;", "task", "Lcom/android/build/attribution/ui/data/TaskUiData;", "<init>", "(Lcom/android/build/attribution/ui/data/TaskUiData;)V", "getTask", "()Lcom/android/build/attribution/ui/data/TaskUiData;", "type", "Lcom/android/build/attribution/ui/data/TaskIssueType;", "getType", "()Lcom/android/build/attribution/ui/data/TaskIssueType;", "bugReportTitle", "", "getBugReportTitle", "()Ljava/lang/String;", "bugReportBriefDescription", "getBugReportBriefDescription", "explanation", "getExplanation", "helpLink", "Lcom/android/build/attribution/ui/BuildAnalyzerBrowserLinks;", "getHelpLink", "()Lcom/android/build/attribution/ui/BuildAnalyzerBrowserLinks;", "buildSrcRecommendation", "getBuildSrcRecommendation", "intellij.android.build-attribution"})
    public static final class AlwaysRunUpToDateOverride
    implements TaskIssueUiData {
        @NotNull
        private final TaskUiData task;
        @NotNull
        private final TaskIssueType type;
        @NotNull
        private final String bugReportTitle;
        @NotNull
        private final String bugReportBriefDescription;
        @NotNull
        private final String explanation;
        @NotNull
        private final BuildAnalyzerBrowserLinks helpLink;
        @NotNull
        private final String buildSrcRecommendation;

        public AlwaysRunUpToDateOverride(@NotNull TaskUiData task2) {
            Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
            this.task = task2;
            this.type = TaskIssueType.ALWAYS_RUN_TASKS;
            this.bugReportTitle = this.getType().getUiName() + " Up-To-Date Override";
            this.bugReportBriefDescription = "This task might be setting its up-to-date check to always return false.";
            this.explanation = "This task might be setting its up-to-date check to always return <code>false</code>,\nwhich means that it must regenerate its output during every build.\nFor example, the task might set the following: <code>outputs.upToDateWhen { false }</code>.\nTo optimize task execution with up-to-date checks, remove the <code>upToDateWhen</code> enclosure.";
            this.helpLink = BuildAnalyzerBrowserLinks.UP_TO_DATE_EQUALS_FALSE_ISSUE;
            this.buildSrcRecommendation = "Ensure that you don't automatically override up-to-date checks.";
        }

        @Override
        @NotNull
        public TaskUiData getTask() {
            return this.task;
        }

        @Override
        @NotNull
        public TaskIssueType getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getBugReportTitle() {
            return this.bugReportTitle;
        }

        @Override
        @NotNull
        public String getBugReportBriefDescription() {
            return this.bugReportBriefDescription;
        }

        @Override
        @NotNull
        public String getExplanation() {
            return this.explanation;
        }

        @Override
        @NotNull
        public BuildAnalyzerBrowserLinks getHelpLink() {
            return this.helpLink;
        }

        @Override
        @NotNull
        public String getBuildSrcRecommendation() {
            return this.buildSrcRecommendation;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0014\u0010\u0014\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0014\u0010\u0016\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/android/build/attribution/ui/data/builder/TaskIssueUiDataContainer$TaskSetupIssue;", "Lcom/android/build/attribution/ui/data/InterTaskIssueUiData;", "task", "Lcom/android/build/attribution/ui/data/TaskUiData;", "connectedTask", "outputFolder", "", "<init>", "(Lcom/android/build/attribution/ui/data/TaskUiData;Lcom/android/build/attribution/ui/data/TaskUiData;Ljava/lang/String;)V", "getTask", "()Lcom/android/build/attribution/ui/data/TaskUiData;", "getConnectedTask", "getOutputFolder", "()Ljava/lang/String;", "type", "Lcom/android/build/attribution/ui/data/TaskIssueType;", "getType", "()Lcom/android/build/attribution/ui/data/TaskIssueType;", "bugReportTitle", "getBugReportTitle", "bugReportBriefDescription", "getBugReportBriefDescription", "explanation", "getExplanation", "helpLink", "Lcom/android/build/attribution/ui/BuildAnalyzerBrowserLinks;", "getHelpLink", "()Lcom/android/build/attribution/ui/BuildAnalyzerBrowserLinks;", "buildSrcRecommendation", "getBuildSrcRecommendation", "intellij.android.build-attribution"})
    public static final class TaskSetupIssue
    implements InterTaskIssueUiData {
        @NotNull
        private final TaskUiData task;
        @NotNull
        private final TaskUiData connectedTask;
        @NotNull
        private final String outputFolder;
        @NotNull
        private final TaskIssueType type;
        @NotNull
        private final String bugReportTitle;
        @NotNull
        private final String bugReportBriefDescription;
        @NotNull
        private final String explanation;
        @NotNull
        private final BuildAnalyzerBrowserLinks helpLink;
        @NotNull
        private final String buildSrcRecommendation;

        public TaskSetupIssue(@NotNull TaskUiData task2, @NotNull TaskUiData connectedTask, @NotNull String outputFolder) {
            Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
            Intrinsics.checkNotNullParameter((Object)connectedTask, (String)"connectedTask");
            Intrinsics.checkNotNullParameter((Object)outputFolder, (String)"outputFolder");
            this.task = task2;
            this.connectedTask = connectedTask;
            this.outputFolder = outputFolder;
            this.type = TaskIssueType.TASK_SETUP_ISSUE;
            this.bugReportTitle = this.getType().getUiName();
            this.bugReportBriefDescription = "Task declares the same output directory as task " + this.getConnectedTask().getName() + " from " + TaskIssueUiDataContainerKt.access$pluginUiName(this.getConnectedTask()) + ": '" + this.outputFolder + "'.";
            this.explanation = StringsKt.trimIndent((String)("\nThis task declares the same output directory as task '" + this.getConnectedTask().getTaskPath() + "':\n" + this.outputFolder + "\nAs a result, these tasks are not able to take advantage of incremental\nbuild optimizations and might need to run with each subsequent build.\n"));
            this.helpLink = BuildAnalyzerBrowserLinks.DUPLICATE_OUTPUT_FOLDER_ISSUE;
            this.buildSrcRecommendation = "Edit the plugin(s) to ensure each task specifies a unique output directory.";
        }

        @Override
        @NotNull
        public TaskUiData getTask() {
            return this.task;
        }

        @Override
        @NotNull
        public TaskUiData getConnectedTask() {
            return this.connectedTask;
        }

        @NotNull
        public final String getOutputFolder() {
            return this.outputFolder;
        }

        @Override
        @NotNull
        public TaskIssueType getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getBugReportTitle() {
            return this.bugReportTitle;
        }

        @Override
        @NotNull
        public String getBugReportBriefDescription() {
            return this.bugReportBriefDescription;
        }

        @Override
        @NotNull
        public String getExplanation() {
            return this.explanation;
        }

        @Override
        @NotNull
        public BuildAnalyzerBrowserLinks getHelpLink() {
            return this.helpLink;
        }

        @Override
        @NotNull
        public String getBuildSrcRecommendation() {
            return this.buildSrcRecommendation;
        }
    }
}

