/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.data.builder;

import com.android.build.attribution.analyzers.BuildEventsAnalysisResult;
import com.android.build.attribution.data.PluginConfigurationData;
import com.android.build.attribution.data.ProjectConfigurationData;
import com.android.build.attribution.ui.data.ConfigurationUiData;
import com.android.build.attribution.ui.data.PluginConfigurationUiData;
import com.android.build.attribution.ui.data.ProjectConfigurationUiData;
import com.android.build.attribution.ui.data.TimeWithPercentage;
import com.android.build.attribution.ui.data.builder.ConfigurationTimesUiDataBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/android/build/attribution/ui/data/builder/ConfigurationTimesUiDataBuilder;", "", "analyzersProxy", "Lcom/android/build/attribution/analyzers/BuildEventsAnalysisResult;", "<init>", "(Lcom/android/build/attribution/analyzers/BuildEventsAnalysisResult;)V", "getAnalyzersProxy", "()Lcom/android/build/attribution/analyzers/BuildEventsAnalysisResult;", "totalConfigurationTimeMs", "", "getTotalConfigurationTimeMs", "()J", "build", "Lcom/android/build/attribution/ui/data/ConfigurationUiData;", "createConfigurationUiData", "createProjectConfigurationUiData", "Lcom/android/build/attribution/ui/data/ProjectConfigurationUiData;", "projectData", "Lcom/android/build/attribution/data/ProjectConfigurationData;", "createPluginConfigurationUiData", "Lcom/android/build/attribution/ui/data/PluginConfigurationUiData;", "pluginData", "Lcom/android/build/attribution/data/PluginConfigurationData;", "intellij.android.build-attribution"})
public final class ConfigurationTimesUiDataBuilder {
    @NotNull
    private final BuildEventsAnalysisResult analyzersProxy;
    private final long totalConfigurationTimeMs;

    public ConfigurationTimesUiDataBuilder(@NotNull BuildEventsAnalysisResult analyzersProxy) {
        Intrinsics.checkNotNullParameter((Object)analyzersProxy, (String)"analyzersProxy");
        this.analyzersProxy = analyzersProxy;
        this.totalConfigurationTimeMs = this.analyzersProxy.getConfigurationPhaseTimeMs();
    }

    @NotNull
    public final BuildEventsAnalysisResult getAnalyzersProxy() {
        return this.analyzersProxy;
    }

    public final long getTotalConfigurationTimeMs() {
        return this.totalConfigurationTimeMs;
    }

    @NotNull
    public final ConfigurationUiData build() {
        return this.createConfigurationUiData();
    }

    private final ConfigurationUiData createConfigurationUiData() {
        return new ConfigurationUiData(this){
            private final TimeWithPercentage totalConfigurationTime;
            private final List<ProjectConfigurationUiData> projects;
            private final int totalIssueCount;
            {
                int n;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                this.totalConfigurationTime = new TimeWithPercentage($receiver.getTotalConfigurationTimeMs(), $receiver.getAnalyzersProxy().getTotalBuildTimeMs());
                Iterable iterable = $receiver.getAnalyzersProxy().getProjectsConfigurationData();
                var var11_3 = this;
                boolean $i$f$map = false;
                Iterator<T> iterator2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ProjectConfigurationData projectConfigurationData = (ProjectConfigurationData)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(ConfigurationTimesUiDataBuilder.access$createProjectConfigurationUiData($receiver, (ProjectConfigurationData)it));
                }
                Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
                boolean $i$f$sortedByDescending = false;
                var11_3.projects = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        ProjectConfigurationUiData it = (ProjectConfigurationUiData)b;
                        boolean bl = false;
                        Comparable comparable = it.getConfigurationTime();
                        it = (ProjectConfigurationUiData)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getConfigurationTime());
                    }
                });
                iterable = this.getProjects();
                var11_3 = this;
                int n2 = 0;
                for (T t : iterable) {
                    void it;
                    ProjectConfigurationUiData $i$f$mapTo2 = (ProjectConfigurationUiData)t;
                    int n3 = n2;
                    boolean bl = false;
                    int n4 = it.getIssueCount();
                    n2 = n3 + n4;
                }
                var11_3.totalIssueCount = n = n2;
            }

            public TimeWithPercentage getTotalConfigurationTime() {
                return this.totalConfigurationTime;
            }

            public List<ProjectConfigurationUiData> getProjects() {
                return this.projects;
            }

            public int getTotalIssueCount() {
                return this.totalIssueCount;
            }
        };
    }

    private final ProjectConfigurationUiData createProjectConfigurationUiData(ProjectConfigurationData projectData) {
        return new ProjectConfigurationUiData(projectData, this){
            private final String project;
            private final TimeWithPercentage configurationTime;
            private final List<PluginConfigurationUiData> plugins;
            private final int issueCount;
            {
                int n;
                int n2;
                void $this$count$iv;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                this.project = $projectData.getProjectPath();
                this.configurationTime = new TimeWithPercentage($projectData.getTotalConfigurationTimeMs(), $receiver.getTotalConfigurationTimeMs());
                Iterable iterable = $projectData.getPluginsConfigurationData();
                var var12_4 = this;
                boolean $i$f$map = false;
                Iterator<T> iterator2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PluginConfigurationData pluginConfigurationData = (PluginConfigurationData)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(ConfigurationTimesUiDataBuilder.access$createPluginConfigurationUiData($receiver, (PluginConfigurationData)it));
                }
                Iterable $this$sortedByDescending$iv = (List)destination$iv$iv;
                boolean $i$f$sortedByDescending = false;
                var12_4.plugins = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        PluginConfigurationUiData it = (PluginConfigurationUiData)b;
                        boolean bl = false;
                        Comparable comparable = it.getConfigurationTime();
                        it = (PluginConfigurationUiData)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getConfigurationTime());
                    }
                });
                $this$sortedByDescending$iv = this.getPlugins();
                var12_4 = this;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n2 = 0;
                } else {
                    int count$iv = 0;
                    for (T element$iv : $this$count$iv) {
                        PluginConfigurationUiData it = (PluginConfigurationUiData)element$iv;
                        boolean bl = false;
                        if (!it.getSlowsConfiguration() || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n2 = count$iv;
                }
                int n3 = n2;
                iterable = this.getPlugins();
                int n4 = 0;
                for (Iterator<T> iterator3 : iterable) {
                    void it;
                    PluginConfigurationUiData element$iv = (PluginConfigurationUiData)((Object)iterator3);
                    n = n4;
                    boolean bl = false;
                    int n5 = it.getNestedIssueCount();
                    n4 = n + n5;
                }
                n = n4;
                var12_4.issueCount = n3 + n;
            }

            public String getProject() {
                return this.project;
            }

            public TimeWithPercentage getConfigurationTime() {
                return this.configurationTime;
            }

            public List<PluginConfigurationUiData> getPlugins() {
                return this.plugins;
            }

            public int getIssueCount() {
                return this.issueCount;
            }
        };
    }

    private final PluginConfigurationUiData createPluginConfigurationUiData(PluginConfigurationData pluginData) {
        return new PluginConfigurationUiData(pluginData, this){
            private final String pluginName;
            private final TimeWithPercentage configurationTime;
            private final boolean slowsConfiguration;
            private final List<PluginConfigurationUiData> nestedPlugins;
            private final int nestedIssueCount;
            {
                int n;
                int n2;
                void $this$count$iv;
                this.pluginName = $pluginData.getPlugin().getDisplayName();
                this.configurationTime = new TimeWithPercentage($pluginData.getConfigurationTimeMs(), $receiver.getTotalConfigurationTimeMs());
                this.nestedPlugins = CollectionsKt.emptyList();
                Iterable iterable = this.getNestedPlugins();
                createPluginConfigurationUiData.1 var10_4 = this;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n2 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        PluginConfigurationUiData it = (PluginConfigurationUiData)element$iv;
                        boolean bl = false;
                        if (!it.getSlowsConfiguration() || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n2 = count$iv;
                }
                int n3 = n2;
                iterable = this.getNestedPlugins();
                int n4 = 0;
                for (Iterator<T> iterator2 : iterable) {
                    void it;
                    Object element$iv;
                    element$iv = (PluginConfigurationUiData)((Object)iterator2);
                    n = n4;
                    boolean bl = false;
                    int n5 = it.getNestedIssueCount();
                    n4 = n + n5;
                }
                n = n4;
                var10_4.nestedIssueCount = n3 + n;
            }

            public String getPluginName() {
                return this.pluginName;
            }

            public TimeWithPercentage getConfigurationTime() {
                return this.configurationTime;
            }

            public boolean getSlowsConfiguration() {
                return this.slowsConfiguration;
            }

            public List<PluginConfigurationUiData> getNestedPlugins() {
                return this.nestedPlugins;
            }

            public int getNestedIssueCount() {
                return this.nestedIssueCount;
            }
        };
    }

    public static final /* synthetic */ ProjectConfigurationUiData access$createProjectConfigurationUiData(ConfigurationTimesUiDataBuilder $this, ProjectConfigurationData projectData) {
        return $this.createProjectConfigurationUiData(projectData);
    }

    public static final /* synthetic */ PluginConfigurationUiData access$createPluginConfigurationUiData(ConfigurationTimesUiDataBuilder $this, PluginConfigurationData pluginData) {
        return $this.createPluginConfigurationUiData(pluginData);
    }
}

