/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.data;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.data.BuildAttributionReportUiData;
import com.android.build.attribution.ui.data.TaskIssueUiData;
import com.android.build.attribution.ui.data.TaskIssuesGroup;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.data.TimeWithPercentage;
import com.android.ide.common.repository.AgpVersion;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.LineSeparator;
import com.intellij.util.text.DateFormatUtil;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006H\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0012\u001a\u00020\u0006H\u0002J\b\u0010\u0013\u001a\u00020\u0006H\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0015\u001a\u00020\u0006H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\f\u0010\u0017\u001a\u00020\u0006*\u00020\u0018H\u0002J\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/build/attribution/ui/data/TaskIssueReportGenerator;", "", "reportData", "Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "platformInformationProvider", "Lkotlin/Function0;", "", "agpVersionsProvider", "", "Lcom/android/ide/common/repository/AgpVersion;", "<init>", "(Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "generateReportText", "taskData", "Lcom/android/build/attribution/ui/data/TaskUiData;", "generateHeaderText", "pluginName", "generateFoundIssuesText", "generateBuildInformationText", "generatePlatformInformationText", "generateTaskExecutionText", "generateAgpVersionsString", "findOtherTaskOccurrencesWithIssues", "commonString", "Lcom/android/build/attribution/ui/data/TimeWithPercentage;", "isSameTask", "", "other", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nTaskIssueReportGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskIssueReportGenerator.kt\ncom/android/build/attribution/ui/data/TaskIssueReportGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,116:1\n1#2:117\n622#3:118\n*S KotlinDebug\n*F\n+ 1 TaskIssueReportGenerator.kt\ncom/android/build/attribution/ui/data/TaskIssueReportGenerator\n*L\n104#1:118\n*E\n"})
public final class TaskIssueReportGenerator {
    @NotNull
    private final BuildAttributionReportUiData reportData;
    @NotNull
    private final Function0<String> platformInformationProvider;
    @NotNull
    private final Function0<List<AgpVersion>> agpVersionsProvider;

    public TaskIssueReportGenerator(@NotNull BuildAttributionReportUiData reportData, @NotNull Function0<String> platformInformationProvider, @NotNull Function0<? extends List<AgpVersion>> agpVersionsProvider) {
        Intrinsics.checkNotNullParameter((Object)reportData, (String)"reportData");
        Intrinsics.checkNotNullParameter(platformInformationProvider, (String)"platformInformationProvider");
        Intrinsics.checkNotNullParameter(agpVersionsProvider, (String)"agpVersionsProvider");
        this.reportData = reportData;
        this.platformInformationProvider = platformInformationProvider;
        this.agpVersionsProvider = agpVersionsProvider;
    }

    @NotNull
    public final String generateReportText(@NotNull TaskUiData taskData) {
        Intrinsics.checkNotNullParameter((Object)taskData, (String)"taskData");
        String string = Strings.convertLineSeparators((String)((Object)StringsKt.trim((CharSequence)("\n" + this.generateHeaderText(taskData.getPluginName()) + "\n\n" + this.generateFoundIssuesText(taskData) + "\n\nPlugin: " + taskData.getPluginName() + "\nTask: " + taskData.getName() + "\nTask type: " + taskData.getTaskType() + "\n" + this.generateTaskExecutionText(taskData) + "\n====Build information:====\n" + this.generateBuildInformationText() + "\n====Platform information:====\n" + this.generatePlatformInformationText() + "\n"))).toString(), (String)LineSeparator.getSystemLineSeparator().getSeparatorString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
        return string;
    }

    private final String generateHeaderText(String pluginName) {
        String date = new SimpleDateFormat("HH:mm, MMM dd, yyyy", Locale.US).format(new Date(this.reportData.getBuildSummary().getBuildFinishedTimestamp()));
        return "At " + date + ", Android Studio detected the following issue(s) with Gradle plugin " + pluginName;
    }

    private final String generateFoundIssuesText(TaskUiData taskData) {
        return CollectionsKt.joinToString$default((Iterable)taskData.getIssues(), (CharSequence)"\n\n", null, null, (int)0, null, TaskIssueReportGenerator::generateFoundIssuesText$lambda$0, (int)30, null);
    }

    private final String generateBuildInformationText() {
        return ((Object)StringsKt.trim((CharSequence)("\nExecution date: " + DateFormatUtil.formatDateTime((long)this.reportData.getBuildSummary().getBuildFinishedTimestamp()) + "\nTotal build duration: " + BuildAttributionUIUtilKt.durationString(this.reportData.getBuildSummary().getTotalBuildDuration()) + "\nConfiguration time: " + this.commonString(this.reportData.getBuildSummary().getConfigurationDuration()) + "\nCritical path tasks time: " + this.commonString(this.reportData.getBuildSummary().getCriticalPathDuration()) + "\nCritical path tasks size: " + this.reportData.getCriticalPathTasks().getSize() + "\nAGP versions: " + this.generateAgpVersionsString() + "\n"))).toString();
    }

    private final String generatePlatformInformationText() {
        return ((Object)StringsKt.trim((CharSequence)((String)this.platformInformationProvider.invoke()))).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final String generateTaskExecutionText(TaskUiData taskData) {
        StringBuilder stringBuilder;
        StringBuilder $this$generateTaskExecutionText_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        List<TaskUiData> occurrences = this.findOtherTaskOccurrencesWithIssues(taskData);
        Iterable iterable = occurrences;
        long l = 0L;
        Iterator iterator2 = iterable.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object t = iterator2.next();
            TaskUiData taskUiData = (TaskUiData)t;
            long l2 = l;
            boolean bl2 = false;
            long l3 = it.getExecutionTime().getTimeMs();
            l = l2 + l3;
        }
        long l4 = this.reportData.getBuildSummary().getCriticalPathDuration().getTimeMs();
        long l5 = l;
        TimeWithPercentage timeSum = new TimeWithPercentage(l5, l4);
        $this$generateTaskExecutionText_u24lambda_u240.append("Issues for the same task were detected in " + occurrences.size() + " module(s), total execution time was " + this.commonString(timeSum) + ", by module:").append('\n');
        for (TaskUiData task2 : occurrences) {
            String line = "Execution mode: " + task2.getExecutionMode() + ", time: " + this.commonString(task2.getExecutionTime()) + ", determines build duration: " + task2.getOnExtendedCriticalPath() + ", on critical path: " + task2.getOnLogicalCriticalPath() + ", " + CollectionsKt.joinToString$default((Iterable)task2.getIssues(), null, (CharSequence)"issues: ", null, (int)0, null, TaskIssueReportGenerator::generateTaskExecutionText$lambda$0$1, (int)29, null);
            $this$generateTaskExecutionText_u24lambda_u240.append("  " + line).append('\n');
        }
        return stringBuilder.toString();
    }

    private final String generateAgpVersionsString() {
        Iterable iterable = (Iterable)this.agpVersionsProvider.invoke();
        Comparator comparator = Comparator.reverseOrder();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"reverseOrder(...)");
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.toSortedSet((Iterable)iterable, comparator), null, null, null, (int)5, null, TaskIssueReportGenerator::generateAgpVersionsString$lambda$0, (int)23, null);
    }

    private final List<TaskUiData> findOtherTaskOccurrencesWithIssues(TaskUiData taskData) {
        Sequence $this$sortedByDescending$iv = SequencesKt.distinct((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)this.reportData.getIssues()), TaskIssueReportGenerator::findOtherTaskOccurrencesWithIssues$lambda$0), TaskIssueReportGenerator::findOtherTaskOccurrencesWithIssues$lambda$1), arg_0 -> TaskIssueReportGenerator.findOtherTaskOccurrencesWithIssues$lambda$2(this, taskData, arg_0)));
        boolean $i$f$sortedByDescending = false;
        return SequencesKt.toList((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TaskUiData it = (TaskUiData)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getExecutionTime().getTimeMs());
                it = (TaskUiData)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getExecutionTime().getTimeMs()));
            }
        }));
    }

    private final String commonString(TimeWithPercentage $this$commonString) {
        return BuildAttributionUIUtilKt.durationString($this$commonString) + " (" + BuildAttributionUIUtilKt.percentageString($this$commonString) + ")";
    }

    private final boolean isSameTask(TaskUiData $this$isSameTask, TaskUiData other) {
        return Intrinsics.areEqual((Object)$this$isSameTask.getName(), (Object)other.getName()) && Intrinsics.areEqual((Object)$this$isSameTask.getPluginName(), (Object)other.getPluginName());
    }

    private static final CharSequence generateFoundIssuesText$lambda$0(TaskIssueUiData taskIssue) {
        Intrinsics.checkNotNullParameter((Object)taskIssue, (String)"taskIssue");
        return taskIssue.getType().getUiName() + "\n" + taskIssue.getBugReportBriefDescription();
    }

    private static final CharSequence generateTaskExecutionText$lambda$0$1(TaskIssueUiData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getType().getUiName();
    }

    private static final CharSequence generateAgpVersionsString$lambda$0(AgpVersion it) {
        return it.toString();
    }

    private static final Sequence findOtherTaskOccurrencesWithIssues$lambda$0(TaskIssuesGroup issuesGroup) {
        Intrinsics.checkNotNullParameter((Object)issuesGroup, (String)"issuesGroup");
        return CollectionsKt.asSequence((Iterable)issuesGroup.getIssues());
    }

    private static final TaskUiData findOtherTaskOccurrencesWithIssues$lambda$1(TaskIssueUiData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTask();
    }

    private static final boolean findOtherTaskOccurrencesWithIssues$lambda$2(TaskIssueReportGenerator this$0, TaskUiData $taskData, TaskUiData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isSameTask(it, $taskData);
    }
}

