/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.controllers;

import com.android.annotations.concurrency.UiThread;
import com.android.build.attribution.ui.BuildAttributionIssueReportingDialog;
import com.android.build.attribution.ui.analytics.BuildAttributionUiAnalytics;
import com.android.build.attribution.ui.controllers.TaskIssueReporter;
import com.android.build.attribution.ui.controllers.TaskIssueReporterImpl;
import com.android.build.attribution.ui.data.BuildAttributionReportUiData;
import com.android.build.attribution.ui.data.TaskIssueReportGenerator;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.actions.SubmitBugReportAction;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/build/attribution/ui/controllers/TaskIssueReporterImpl;", "Lcom/android/build/attribution/ui/controllers/TaskIssueReporter;", "reportData", "Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "project", "Lcom/intellij/openapi/project/Project;", "analytics", "Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics;", "<init>", "(Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;Lcom/intellij/openapi/project/Project;Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics;)V", "generator", "Lcom/android/build/attribution/ui/data/TaskIssueReportGenerator;", "reportIssue", "", "taskData", "Lcom/android/build/attribution/ui/data/TaskUiData;", "intellij.android.build-attribution"})
public final class TaskIssueReporterImpl
implements TaskIssueReporter {
    @NotNull
    private final Project project;
    @NotNull
    private final BuildAttributionUiAnalytics analytics;
    @NotNull
    private final TaskIssueReportGenerator generator;

    public TaskIssueReporterImpl(@NotNull BuildAttributionReportUiData reportData, @NotNull Project project, @NotNull BuildAttributionUiAnalytics analytics) {
        Intrinsics.checkNotNullParameter((Object)reportData, (String)"reportData");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        this.project = project;
        this.analytics = analytics;
        this.generator = new TaskIssueReportGenerator(reportData, (Function0<String>)((Function0)() -> TaskIssueReporterImpl.generator$lambda$0(this)), (Function0<? extends List<AgpVersion>>)((Function0)() -> TaskIssueReporterImpl.generator$lambda$1(this)));
    }

    @Override
    @UiThread
    public void reportIssue(@NotNull TaskUiData taskData) {
        Intrinsics.checkNotNullParameter((Object)taskData, (String)"taskData");
        Project project = this.project;
        Task.Modal task2 = new Task.Modal(this, taskData, project){
            final /* synthetic */ TaskIssueReporterImpl this$0;
            final /* synthetic */ TaskUiData $taskData;
            {
                this.this$0 = $receiver;
                this.$taskData = $taskData;
                super($super_call_param$1, "Collecting Data", false);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setText("Collecting Feedback Information");
                indicator.setIndeterminate(true);
                String reportText = TaskIssueReporterImpl.access$getGenerator$p(this.this$0).generateReportText(this.$taskData);
                ApplicationManager.getApplication().invokeLater(() -> reportIssue.task.1.run$lambda$0(this, this.this$0, this.$taskData, reportText));
            }

            private static final void run$lambda$0(reportIssue.task.1 this$0, TaskIssueReporterImpl this$1, TaskUiData $taskData, String $reportText) {
                Project project = this$0.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                new BuildAttributionIssueReportingDialog(project, TaskIssueReporterImpl.access$getAnalytics$p(this$1), $taskData.getPluginName(), $reportText).show();
            }
        };
        task2.queue();
    }

    private static final String generator$lambda$0(TaskIssueReporterImpl this$0) {
        String string = SubmitBugReportAction.getDescription(this$0.project);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
        return string;
    }

    private static final List generator$lambda$1(TaskIssueReporterImpl this$0) {
        List<AgpVersion> list2 = ProjectStructure.getInstance(this$0.project).getAndroidPluginVersions().getAllVersions();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getAllVersions(...)");
        return list2;
    }

    public static final /* synthetic */ TaskIssueReportGenerator access$getGenerator$p(TaskIssueReporterImpl $this) {
        return $this.generator;
    }

    public static final /* synthetic */ BuildAttributionUiAnalytics access$getAnalytics$p(TaskIssueReporterImpl $this) {
        return $this.analytics;
    }
}

