/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.controllers;

import com.android.build.attribution.BuildAttributionWarningsFilter;
import com.android.build.attribution.analyzers.ConfigurationCachingCompatibilityProjectResult;
import com.android.build.attribution.analyzers.IncompatiblePluginWarning;
import com.android.build.attribution.analyzers.NoIncompatiblePlugins;
import com.android.build.attribution.data.StudioProvidedInfo;
import com.android.build.attribution.ui.BuildAnalyzerBrowserLinks;
import com.android.build.attribution.ui.analytics.BuildAttributionUiAnalytics;
import com.android.build.attribution.ui.controllers.BuildAnalyzerViewControllerKt;
import com.android.build.attribution.ui.controllers.ConfigurationCacheTestBuildFlowRunner;
import com.android.build.attribution.ui.controllers.FindSelectedLibVersionDeclarationAction;
import com.android.build.attribution.ui.controllers.PluginVersionDeclarationFinder;
import com.android.build.attribution.ui.controllers.TaskIssueReporter;
import com.android.build.attribution.ui.controllers.WindowsDefenderPageHandlerImpl;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.model.BuildAnalyzerViewModel;
import com.android.build.attribution.ui.model.TasksDataPageModel;
import com.android.build.attribution.ui.model.TasksFilter;
import com.android.build.attribution.ui.model.TasksPageId;
import com.android.build.attribution.ui.model.TasksTreeNode;
import com.android.build.attribution.ui.model.WarningsFilter;
import com.android.build.attribution.ui.model.WarningsPageId;
import com.android.build.attribution.ui.model.WarningsTreeNode;
import com.android.build.attribution.ui.view.ViewActionHandlers;
import com.android.build.attribution.ui.view.WindowsDefenderPageHandler;
import com.android.build.attribution.ui.view.details.JetifierWarningDetailsView;
import com.android.build.diagnostic.WindowsDefenderCheckService;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.upgrade.AssistantInvoker;
import com.android.tools.idea.memorysettings.MemorySettingsConfigurable;
import com.google.common.base.Stopwatch;
import com.google.wireless.android.sdk.stats.BuildAttributionUiEvent;
import com.intellij.ide.BrowserUtil;
import com.intellij.lang.properties.IProperty;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.RangeBlinker;
import java.time.Duration;
import java.util.function.Supplier;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\u0012\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0012\u0010\u001f\u001a\u00020\u000f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u0010\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u000fH\u0016J\u0010\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020\u000fH\u0016J\b\u00102\u001a\u00020\u000fH\u0016J\b\u00103\u001a\u00020\u000fH\u0016J\b\u00104\u001a\u00020\u000fH\u0016J\u0010\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u000200H\u0016J\b\u00107\u001a\u00020\u000fH\u0016J\u0010\u00108\u001a\u00020\u000f2\u0006\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020\u000fH\u0016J\u0016\u0010<\u001a\u00020\u000f2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>H\u0016J\u0018\u0010@\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DH\u0002J\u001d\u0010E\u001a\u00070F\u00a2\u0006\u0002\bG2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0002J\u0018\u0010L\u001a\u00020M2\u000e\u0010N\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010O0>H\u0016J\u0010\u0010P\u001a\u00020\u000f2\u0006\u0010Q\u001a\u00020RH\u0016J\b\u0010S\u001a\u00020TH\u0016J\u0016\u0010U\u001a\u00020V2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020\u000f0XH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lcom/android/build/attribution/ui/controllers/BuildAnalyzerViewController;", "Lcom/android/build/attribution/ui/view/ViewActionHandlers;", "model", "Lcom/android/build/attribution/ui/model/BuildAnalyzerViewModel;", "project", "Lcom/intellij/openapi/project/Project;", "analytics", "Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics;", "issueReporter", "Lcom/android/build/attribution/ui/controllers/TaskIssueReporter;", "<init>", "(Lcom/android/build/attribution/ui/model/BuildAnalyzerViewModel;Lcom/intellij/openapi/project/Project;Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics;Lcom/android/build/attribution/ui/controllers/TaskIssueReporter;)V", "getModel", "()Lcom/android/build/attribution/ui/model/BuildAnalyzerViewModel;", "dataSetComboBoxSelectionUpdated", "", "newSelectedData", "Lcom/android/build/attribution/ui/model/BuildAnalyzerViewModel$DataSet;", "changeViewToTasksLinkClicked", "targetGrouping", "Lcom/android/build/attribution/ui/model/TasksDataPageModel$Grouping;", "changeViewToWarningsLinkClicked", "changeViewToDownloadsLinkClicked", "tasksGroupingSelectionUpdated", "grouping", "tasksTreeNodeSelected", "tasksTreeNode", "Lcom/android/build/attribution/ui/model/TasksTreeNode;", "tasksDetailsLinkClicked", "taskPageId", "Lcom/android/build/attribution/ui/model/TasksPageId;", "warningsTreeNodeSelected", "warningTreeNode", "Lcom/android/build/attribution/ui/model/WarningsTreeNode;", "helpLinkClicked", "linkTarget", "Lcom/android/build/attribution/ui/BuildAnalyzerBrowserLinks;", "generateReportClicked", "taskData", "Lcom/android/build/attribution/ui/data/TaskUiData;", "openMemorySettings", "applyTasksFilter", "filter", "Lcom/android/build/attribution/ui/model/TasksFilter;", "applyWarningsFilter", "Lcom/android/build/attribution/ui/model/WarningsFilter;", "warningsGroupingSelectionUpdated", "groupByPlugin", "", "dontShowAgainNoGCSettingWarningClicked", "openConfigurationCacheWarnings", "runAgpUpgrade", "runTestConfigurationCachingBuild", "turnConfigurationCachingOnInProperties", "isFeatureConsideredStable", "migrateToNonTransitiveRClass", "updatePluginClicked", "pluginWarningData", "Lcom/android/build/attribution/analyzers/IncompatiblePluginWarning;", "runCheckJetifierTask", "turnJetifierOffInProperties", "sourceRelativePointSupplier", "Ljava/util/function/Supplier;", "Lcom/intellij/ui/awt/RelativePoint;", "blinkPropertyTextInEditor", "editor", "Lcom/intellij/openapi/editor/Editor;", "property", "Lcom/intellij/lang/properties/IProperty;", "createPropertyRemovalFeedbackBalloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "Lorg/jetbrains/annotations/NotNull;", "messageHtml", "", "type", "Lcom/intellij/openapi/ui/MessageType;", "createFindSelectedLibVersionDeclarationAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "selectionSupplier", "Lcom/android/build/attribution/ui/view/details/JetifierWarningDetailsView$DirectDependencyDescriptor;", "redirectToTaskCategoryWarningsPage", "taskCategory", "Lcom/android/buildanalyzer/common/TaskCategory;", "windowsDefenderPageHandler", "Lcom/android/build/attribution/ui/view/WindowsDefenderPageHandler;", "runAndMeasureDuration", "Ljava/time/Duration;", "action", "Lkotlin/Function0;", "intellij.android.build-attribution"})
public final class BuildAnalyzerViewController
implements ViewActionHandlers {
    @NotNull
    private final BuildAnalyzerViewModel model;
    @NotNull
    private final Project project;
    @NotNull
    private final BuildAttributionUiAnalytics analytics;
    @NotNull
    private final TaskIssueReporter issueReporter;

    public BuildAnalyzerViewController(@NotNull BuildAnalyzerViewModel model, @NotNull Project project, @NotNull BuildAttributionUiAnalytics analytics, @NotNull TaskIssueReporter issueReporter) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        Intrinsics.checkNotNullParameter((Object)issueReporter, (String)"issueReporter");
        this.model = model;
        this.project = project;
        this.analytics = analytics;
        this.issueReporter = issueReporter;
        this.analytics.initFirstPage(this.model);
    }

    @NotNull
    public final BuildAnalyzerViewModel getModel() {
        return this.model;
    }

    @Override
    public void dataSetComboBoxSelectionUpdated(@NotNull BuildAnalyzerViewModel.DataSet newSelectedData) {
        Intrinsics.checkNotNullParameter((Object)((Object)newSelectedData), (String)"newSelectedData");
        BuildAttributionUiEvent.Page currentAnalyticsPage = this.analytics.getStateFromModel(this.model);
        Duration duration = this.runAndMeasureDuration((Function0<Unit>)((Function0)() -> BuildAnalyzerViewController.dataSetComboBoxSelectionUpdated$lambda$0(this, newSelectedData)));
        BuildAttributionUiEvent.Page newAnalyticsPage = this.analytics.getStateFromModel(this.model);
        this.analytics.pageChange(currentAnalyticsPage, newAnalyticsPage, BuildAttributionUiEvent.EventType.DATA_VIEW_COMBO_SELECTED, duration);
    }

    @Override
    public void changeViewToTasksLinkClicked(@Nullable TasksDataPageModel.Grouping targetGrouping) {
        BuildAttributionUiEvent.Page currentAnalyticsPage = this.analytics.getStateFromModel(this.model);
        Duration duration = this.runAndMeasureDuration((Function0<Unit>)((Function0)() -> BuildAnalyzerViewController.changeViewToTasksLinkClicked$lambda$0(this, targetGrouping)));
        BuildAttributionUiEvent.Page newAnalyticsPage = this.analytics.getStateFromModel(this.model);
        this.analytics.pageChange(currentAnalyticsPage, newAnalyticsPage, BuildAttributionUiEvent.EventType.PAGE_CHANGE_LINK_CLICK, duration);
    }

    @Override
    public void changeViewToWarningsLinkClicked() {
        BuildAttributionUiEvent.Page currentAnalyticsPage = this.analytics.getStateFromModel(this.model);
        Duration duration = this.runAndMeasureDuration((Function0<Unit>)((Function0)() -> BuildAnalyzerViewController.changeViewToWarningsLinkClicked$lambda$0(this)));
        BuildAttributionUiEvent.Page newAnalyticsPage = this.analytics.getStateFromModel(this.model);
        this.analytics.pageChange(currentAnalyticsPage, newAnalyticsPage, BuildAttributionUiEvent.EventType.PAGE_CHANGE_LINK_CLICK, duration);
    }

    @Override
    public void changeViewToDownloadsLinkClicked() {
        BuildAttributionUiEvent.Page currentAnalyticsPage = this.analytics.getStateFromModel(this.model);
        Duration duration = this.runAndMeasureDuration((Function0<Unit>)((Function0)() -> BuildAnalyzerViewController.changeViewToDownloadsLinkClicked$lambda$0(this)));
        BuildAttributionUiEvent.Page newAnalyticsPage = this.analytics.getStateFromModel(this.model);
        this.analytics.pageChange(currentAnalyticsPage, newAnalyticsPage, BuildAttributionUiEvent.EventType.PAGE_CHANGE_LINK_CLICK, duration);
    }

    @Override
    public void tasksGroupingSelectionUpdated(@NotNull TasksDataPageModel.Grouping grouping) {
        Intrinsics.checkNotNullParameter((Object)((Object)grouping), (String)"grouping");
        BuildAttributionUiEvent.Page currentAnalyticsPage = this.analytics.getStateFromModel(this.model);
        Duration duration = this.runAndMeasureDuration((Function0<Unit>)((Function0)() -> BuildAnalyzerViewController.tasksGroupingSelectionUpdated$lambda$0(this, grouping)));
        BuildAttributionUiEvent.Page newAnalyticsPage = this.analytics.getStateFromModel(this.model);
        this.analytics.pageChange(currentAnalyticsPage, newAnalyticsPage, BuildAttributionUiEvent.EventType.GROUPING_CHANGED, duration);
    }

    @Override
    public void tasksTreeNodeSelected(@Nullable TasksTreeNode tasksTreeNode) {
        BuildAttributionUiEvent.Page currentAnalyticsPage = this.analytics.getStateFromModel(this.model);
        Duration duration = this.runAndMeasureDuration((Function0<Unit>)((Function0)() -> BuildAnalyzerViewController.tasksTreeNodeSelected$lambda$0(this, tasksTreeNode)));
        BuildAttributionUiEvent.Page newAnalyticsPage = this.analytics.getStateFromModel(this.model);
        this.analytics.pageChange(currentAnalyticsPage, newAnalyticsPage, BuildAttributionUiEvent.EventType.PAGE_CHANGE_TREE_CLICK, duration);
    }

    @Override
    public void tasksDetailsLinkClicked(@NotNull TasksPageId taskPageId) {
        Intrinsics.checkNotNullParameter((Object)taskPageId, (String)"taskPageId");
        BuildAttributionUiEvent.Page currentAnalyticsPage = this.analytics.getStateFromModel(this.model);
        Duration duration = this.runAndMeasureDuration((Function0<Unit>)((Function0)() -> BuildAnalyzerViewController.tasksDetailsLinkClicked$lambda$0(this, taskPageId)));
        BuildAttributionUiEvent.Page newAnalyticsPage = this.analytics.getStateFromModel(this.model);
        this.analytics.pageChange(currentAnalyticsPage, newAnalyticsPage, BuildAttributionUiEvent.EventType.PAGE_CHANGE_LINK_CLICK, duration);
    }

    @Override
    public void warningsTreeNodeSelected(@Nullable WarningsTreeNode warningTreeNode) {
        BuildAttributionUiEvent.Page currentAnalyticsPage = this.analytics.getStateFromModel(this.model);
        Duration duration = this.runAndMeasureDuration((Function0<Unit>)((Function0)() -> BuildAnalyzerViewController.warningsTreeNodeSelected$lambda$0(this, warningTreeNode)));
        BuildAttributionUiEvent.Page newAnalyticsPage = this.analytics.getStateFromModel(this.model);
        this.analytics.pageChange(currentAnalyticsPage, newAnalyticsPage, BuildAttributionUiEvent.EventType.PAGE_CHANGE_TREE_CLICK, duration);
    }

    @Override
    public void helpLinkClicked(@NotNull BuildAnalyzerBrowserLinks linkTarget) {
        Intrinsics.checkNotNullParameter((Object)((Object)linkTarget), (String)"linkTarget");
        BrowserUtil.browse((String)linkTarget.getUrlTarget());
        BuildAttributionUiEvent.Page currentAnalyticsPage = this.analytics.getStateFromModel(this.model);
        this.analytics.helpLinkClicked(currentAnalyticsPage, linkTarget);
    }

    @Override
    public void generateReportClicked(@NotNull TaskUiData taskData) {
        Intrinsics.checkNotNullParameter((Object)taskData, (String)"taskData");
        BuildAttributionUiEvent.Page currentAnalyticsPage = this.analytics.getStateFromModel(this.model);
        this.analytics.bugReportLinkClicked(currentAnalyticsPage);
        this.issueReporter.reportIssue(taskData);
    }

    @Override
    public void openMemorySettings() {
        this.analytics.memorySettingsOpened();
        ShowSettingsUtil.getInstance().showSettingsDialog(this.project, MemorySettingsConfigurable.class);
    }

    @Override
    public void applyTasksFilter(@NotNull TasksFilter filter2) {
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Duration duration = this.runAndMeasureDuration((Function0<Unit>)((Function0)() -> BuildAnalyzerViewController.applyTasksFilter$lambda$0(this, filter2)));
        this.analytics.tasksFilterApplied(filter2, duration);
    }

    @Override
    public void applyWarningsFilter(@NotNull WarningsFilter filter2) {
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Duration duration = this.runAndMeasureDuration((Function0<Unit>)((Function0)() -> BuildAnalyzerViewController.applyWarningsFilter$lambda$0(this, filter2)));
        this.analytics.warningsFilterApplied(filter2, duration);
    }

    @Override
    public void warningsGroupingSelectionUpdated(boolean groupByPlugin) {
        BuildAttributionUiEvent.Page currentAnalyticsPage = this.analytics.getStateFromModel(this.model);
        Duration duration = this.runAndMeasureDuration((Function0<Unit>)((Function0)() -> BuildAnalyzerViewController.warningsGroupingSelectionUpdated$lambda$0(this, groupByPlugin)));
        BuildAttributionUiEvent.Page newAnalyticsPage = this.analytics.getStateFromModel(this.model);
        this.analytics.pageChange(currentAnalyticsPage, newAnalyticsPage, BuildAttributionUiEvent.EventType.GROUPING_CHANGED, duration);
    }

    @Override
    public void dontShowAgainNoGCSettingWarningClicked() {
        BuildAttributionWarningsFilter.Companion.getInstance(this.project).setSuppressNoGCSettingWarning(true);
        this.analytics.noGCSettingWarningSuppressed();
    }

    @Override
    public void openConfigurationCacheWarnings() {
        BuildAttributionUiEvent.Page currentAnalyticsPage = this.analytics.getStateFromModel(this.model);
        Duration duration = this.runAndMeasureDuration((Function0<Unit>)((Function0)() -> BuildAnalyzerViewController.openConfigurationCacheWarnings$lambda$0(this)));
        BuildAttributionUiEvent.Page newAnalyticsPage = this.analytics.getStateFromModel(this.model);
        this.analytics.pageChange(currentAnalyticsPage, newAnalyticsPage, BuildAttributionUiEvent.EventType.PAGE_CHANGE_LINK_CLICK, duration);
    }

    @Override
    public void runAgpUpgrade() {
        ((AssistantInvoker)this.project.getService(AssistantInvoker.class)).performRecommendedPluginUpgrade(this.project);
        this.analytics.runAgpUpgradeClicked();
    }

    @Override
    public void runTestConfigurationCachingBuild() {
        ConfigurationCachingCompatibilityProjectResult configurationCachingCompatibilityProjectResult = this.model.getReportUiData().getConfCachingData();
        NoIncompatiblePlugins noIncompatiblePlugins = configurationCachingCompatibilityProjectResult instanceof NoIncompatiblePlugins ? (NoIncompatiblePlugins)configurationCachingCompatibilityProjectResult : null;
        if (noIncompatiblePlugins == null) {
            return;
        }
        NoIncompatiblePlugins configurationCacheData = noIncompatiblePlugins;
        ConfigurationCacheTestBuildFlowRunner.Companion.getInstance(this.project).startTestBuildsFlow(this.model.getReportUiData().getBuildRequestData(), configurationCacheData.getConfigurationCacheIsStableFeature());
        this.analytics.rerunBuildWithConfCacheClicked();
    }

    @Override
    public void turnConfigurationCachingOnInProperties(boolean isFeatureConsideredStable) {
        StudioProvidedInfo.Companion.turnOnConfigurationCacheInProperties(this.project, this.model.getReportUiData().getBuildRequestData(), isFeatureConsideredStable);
        this.analytics.turnConfigurationCacheOnInPropertiesClicked();
    }

    @Override
    public void migrateToNonTransitiveRClass() {
        ActionManager.getInstance().tryToExecute(ActionManager.getInstance().getAction("AndroidMigrateToNonTransitiveRClassesAction"), null, null, null, true);
        this.analytics.migrateToNonTransitiveRClassesClicked();
    }

    @Override
    public void updatePluginClicked(@NotNull IncompatiblePluginWarning pluginWarningData) {
        Intrinsics.checkNotNullParameter((Object)pluginWarningData, (String)"pluginWarningData");
        Duration duration = this.runAndMeasureDuration((Function0<Unit>)((Function0)() -> BuildAnalyzerViewController.updatePluginClicked$lambda$0(this, pluginWarningData)));
        this.analytics.updatePluginButtonClicked(duration);
    }

    @Override
    public void runCheckJetifierTask() {
        Duration duration = this.runAndMeasureDuration((Function0<Unit>)((Function0)() -> BuildAnalyzerViewController.runCheckJetifierTask$lambda$0(this)));
        this.analytics.runCheckJetifierTaskClicked(duration);
    }

    @Override
    public void turnJetifierOffInProperties(@NotNull Supplier<RelativePoint> sourceRelativePointSupplier) {
        Intrinsics.checkNotNullParameter(sourceRelativePointSupplier, (String)"sourceRelativePointSupplier");
        Duration duration = this.runAndMeasureDuration((Function0<Unit>)((Function0)() -> BuildAnalyzerViewController.turnJetifierOffInProperties$lambda$0(this, sourceRelativePointSupplier)));
        this.analytics.turnJetifierOffClicked(duration);
    }

    private final void blinkPropertyTextInEditor(Editor editor, IProperty property2) {
        TextAttributes blinkingAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.BLINKING_HIGHLIGHTS_ATTRIBUTES);
        Intrinsics.checkNotNull((Object)blinkingAttributes);
        RangeBlinker rangeBlinker = new RangeBlinker(editor, blinkingAttributes, 6, null);
        rangeBlinker.resetMarkers(CollectionsKt.listOf((Object)property2.getPsiElement().getTextRange()));
        rangeBlinker.startBlinking();
    }

    private final Balloon createPropertyRemovalFeedbackBalloon(String messageHtml, MessageType type) {
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(messageHtml, type, BuildAnalyzerViewController::createPropertyRemovalFeedbackBalloon$lambda$0).setHideOnClickOutside(true).setHideOnAction(false).setHideOnFrameResize(false).setHideOnKeyOutside(false).createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
        return balloon;
    }

    @Override
    @NotNull
    public AnAction createFindSelectedLibVersionDeclarationAction(@NotNull Supplier<JetifierWarningDetailsView.DirectDependencyDescriptor> selectionSupplier) {
        Intrinsics.checkNotNullParameter(selectionSupplier, (String)"selectionSupplier");
        return new FindSelectedLibVersionDeclarationAction(selectionSupplier, this.project, this.analytics);
    }

    @Override
    public void redirectToTaskCategoryWarningsPage(@NotNull TaskCategory taskCategory) {
        Intrinsics.checkNotNullParameter((Object)taskCategory, (String)"taskCategory");
        if (this.model.getSelectedData() == BuildAnalyzerViewModel.DataSet.TASKS && this.model.getTasksPageModel().getSelectedGrouping() == TasksDataPageModel.Grouping.BY_TASK_CATEGORY) {
            this.model.getTasksPageModel().selectPageById(TasksPageId.Companion.taskCategory(taskCategory));
        } else {
            this.model.setSelectedData(BuildAnalyzerViewModel.DataSet.WARNINGS);
            if (taskCategory != TaskCategory.JAVA) {
                this.model.getWarningsPageModel().selectPageById(WarningsPageId.Companion.taskCategory(taskCategory));
            } else {
                this.model.getWarningsPageModel().selectPageById(WarningsPageId.Companion.getAnnotationProcessorRoot());
            }
        }
    }

    @Override
    @NotNull
    public WindowsDefenderPageHandler windowsDefenderPageHandler() {
        return new WindowsDefenderPageHandlerImpl(WindowsDefenderCheckService.Companion.getInstance(this.project));
    }

    private final Duration runAndMeasureDuration(Function0<Unit> action2) {
        Stopwatch watch = Stopwatch.createStarted();
        action2.invoke();
        Duration duration = watch.elapsed();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"elapsed(...)");
        return duration;
    }

    private static final Unit dataSetComboBoxSelectionUpdated$lambda$0(BuildAnalyzerViewController this$0, BuildAnalyzerViewModel.DataSet $newSelectedData) {
        this$0.model.setSelectedData($newSelectedData);
        return Unit.INSTANCE;
    }

    private static final Unit changeViewToTasksLinkClicked$lambda$0(BuildAnalyzerViewController this$0, TasksDataPageModel.Grouping $targetGrouping) {
        this$0.model.setSelectedData(BuildAnalyzerViewModel.DataSet.TASKS);
        TasksDataPageModel tasksDataPageModel = this$0.model.getTasksPageModel();
        TasksDataPageModel.Grouping grouping = $targetGrouping;
        if (grouping == null) {
            grouping = this$0.model.getTasksPageModel().getDefaultGrouping();
        }
        tasksDataPageModel.selectGrouping(grouping);
        return Unit.INSTANCE;
    }

    private static final Unit changeViewToWarningsLinkClicked$lambda$0(BuildAnalyzerViewController this$0) {
        this$0.model.setSelectedData(BuildAnalyzerViewModel.DataSet.WARNINGS);
        return Unit.INSTANCE;
    }

    private static final Unit changeViewToDownloadsLinkClicked$lambda$0(BuildAnalyzerViewController this$0) {
        this$0.model.setSelectedData(BuildAnalyzerViewModel.DataSet.DOWNLOADS);
        return Unit.INSTANCE;
    }

    private static final Unit tasksGroupingSelectionUpdated$lambda$0(BuildAnalyzerViewController this$0, TasksDataPageModel.Grouping $grouping) {
        this$0.model.getTasksPageModel().selectGrouping($grouping);
        return Unit.INSTANCE;
    }

    private static final Unit tasksTreeNodeSelected$lambda$0(BuildAnalyzerViewController this$0, TasksTreeNode $tasksTreeNode) {
        this$0.model.getTasksPageModel().selectNode($tasksTreeNode);
        return Unit.INSTANCE;
    }

    private static final Unit tasksDetailsLinkClicked$lambda$0(BuildAnalyzerViewController this$0, TasksPageId $taskPageId) {
        this$0.model.setSelectedData(BuildAnalyzerViewModel.DataSet.TASKS);
        this$0.model.getTasksPageModel().selectPageById($taskPageId);
        return Unit.INSTANCE;
    }

    private static final Unit warningsTreeNodeSelected$lambda$0(BuildAnalyzerViewController this$0, WarningsTreeNode $warningTreeNode) {
        this$0.model.getWarningsPageModel().selectNode($warningTreeNode);
        return Unit.INSTANCE;
    }

    private static final Unit applyTasksFilter$lambda$0(BuildAnalyzerViewController this$0, TasksFilter $filter) {
        this$0.model.getTasksPageModel().applyFilter($filter);
        return Unit.INSTANCE;
    }

    private static final Unit applyWarningsFilter$lambda$0(BuildAnalyzerViewController this$0, WarningsFilter $filter) {
        this$0.model.getWarningsPageModel().setFilter($filter);
        return Unit.INSTANCE;
    }

    private static final Unit warningsGroupingSelectionUpdated$lambda$0(BuildAnalyzerViewController this$0, boolean $groupByPlugin) {
        this$0.model.getWarningsPageModel().setGroupByPlugin($groupByPlugin);
        return Unit.INSTANCE;
    }

    private static final Unit openConfigurationCacheWarnings$lambda$0(BuildAnalyzerViewController this$0) {
        this$0.model.setSelectedData(BuildAnalyzerViewModel.DataSet.WARNINGS);
        this$0.model.getWarningsPageModel().selectPageById(WarningsPageId.Companion.getConfigurationCachingRoot());
        return Unit.INSTANCE;
    }

    private static final Unit updatePluginClicked$lambda$0(BuildAnalyzerViewController this$0, IncompatiblePluginWarning $pluginWarningData) {
        OpenFileDescriptor openFile2;
        OpenFileDescriptor openFileDescriptor = openFile2 = new PluginVersionDeclarationFinder(this$0.project).findFileToOpen($pluginWarningData.getPluginInfo().getPluginArtifact(), $pluginWarningData.getPlugin().displayNames());
        boolean bl = openFileDescriptor != null ? openFileDescriptor.canNavigate() : false;
        if (bl) {
            openFile2.navigate(true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit runCheckJetifierTask$lambda$0(BuildAnalyzerViewController this$0) {
        GradleBuildInvoker.Request request = BuildAnalyzerViewControllerKt.createCheckJetifierTaskRequest(this$0.project, this$0.model.getReportUiData().getBuildRequestData());
        GradleBuildInvoker.Companion.getInstance(this$0.project).executeTasks(request);
        return Unit.INSTANCE;
    }

    private static final Unit turnJetifierOffInProperties$lambda$0(BuildAnalyzerViewController this$0, Supplier $sourceRelativePointSupplier) {
        StudioProvidedInfo.Companion.disableJetifier(this$0.project, this$0.model.getReportUiData().getBuildRequestData(), (Function1<? super IProperty, Unit>)((Function1)arg_0 -> BuildAnalyzerViewController.turnJetifierOffInProperties$lambda$0$0((Supplier)$sourceRelativePointSupplier, this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit turnJetifierOffInProperties$lambda$0$0(Supplier $sourceRelativePointSupplier, BuildAnalyzerViewController this$0, IProperty property2) {
        if (property2 == null) {
            ActionsKt.invokeLater$default(null, () -> BuildAnalyzerViewController.turnJetifierOffInProperties$lambda$0$0$0((Supplier)$sourceRelativePointSupplier, this$0), (int)1, null);
        } else {
            ActionsKt.invokeLater$default(null, () -> BuildAnalyzerViewController.turnJetifierOffInProperties$lambda$0$0$1(this$0, property2), (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit turnJetifierOffInProperties$lambda$0$0$0(Supplier $sourceRelativePointSupplier, BuildAnalyzerViewController this$0) {
        Object t = $sourceRelativePointSupplier.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        RelativePoint feedbackBalloonRelativePoint = (RelativePoint)t;
        String message = "'android.enableJetifier' property is not found in 'gradle.properties'. Was it already removed?";
        MessageType messageType = MessageType.ERROR;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"ERROR");
        this$0.createPropertyRemovalFeedbackBalloon(message, messageType).show(feedbackBalloonRelativePoint, Balloon.Position.below);
        return Unit.INSTANCE;
    }

    private static final Unit turnJetifierOffInProperties$lambda$0$0$1(BuildAnalyzerViewController this$0, IProperty $property) {
        block0: {
            OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(this$0.project, $property.getPropertiesFile().getVirtualFile(), $property.getPsiElement().getTextRange().getEndOffset());
            Editor editor = FileEditorManager.getInstance((Project)this$0.project).openTextEditor(openFileDescriptor, true);
            if (editor == null) break block0;
            Editor editor2 = editor;
            boolean bl = false;
            this$0.blinkPropertyTextInEditor(editor2, $property);
            RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(editor2);
            Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"guessBestPopupLocation(...)");
            RelativePoint pointInEditor = relativePoint;
            String message = "'android.enableJetifier' property is now set to false.<br/>Please, remove it after reviewing any associated comments.";
            MessageType messageType = MessageType.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
            this$0.createPropertyRemovalFeedbackBalloon(message, messageType).show(pointInEditor, Balloon.Position.atRight);
        }
        return Unit.INSTANCE;
    }

    private static final void createPropertyRemovalFeedbackBalloon$lambda$0(HyperlinkEvent it) {
    }
}

