/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.analyzers;

import com.android.build.attribution.analyzers.AnalyzerResult;
import com.android.build.attribution.analyzers.BaseAnalyzer;
import com.android.build.attribution.analyzers.BuildEventsAnalyzer;
import com.android.build.attribution.analyzers.BuildEventsAnalyzersProxy;
import com.android.build.attribution.analyzers.PostBuildProcessAnalyzer;
import com.android.build.attribution.data.PluginBuildData;
import com.android.build.attribution.data.PluginContainer;
import com.android.build.attribution.data.PluginData;
import com.android.build.attribution.data.StudioProvidedInfo;
import com.android.build.attribution.data.TaskContainer;
import com.android.build.attribution.data.TaskData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationDescriptor;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010*\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0001:B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J$\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\r2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00190\"H\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\u0011H\u0002J&\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00192\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010(\u001a\u00020%H\u0002J\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0\u0011H\u0002J,\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u00192\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\r0.H\u0002J,\u0010/\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u00192\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\r0.H\u0002J\u0016\u00100\u001a\u00020\u001c2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\r0\u0011H\u0002J\b\u00102\u001a\u00020\u001cH\u0002J\b\u00103\u001a\u00020\u001cH\u0016J\u0018\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020\u0002H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u000f\u001a*\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00110\u0010j\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u0011`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\r0\u0014j\b\u0012\u0004\u0012\u00020\r`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00170\u0014j\b\u0012\u0004\u0012\u00020\u0017`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/android/build/attribution/analyzers/CriticalPathAnalyzer;", "Lcom/android/build/attribution/analyzers/BaseAnalyzer;", "Lcom/android/build/attribution/analyzers/CriticalPathAnalyzer$Result;", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzer;", "Lcom/android/build/attribution/analyzers/PostBuildProcessAnalyzer;", "taskContainer", "Lcom/android/build/attribution/data/TaskContainer;", "pluginContainer", "Lcom/android/build/attribution/data/PluginContainer;", "<init>", "(Lcom/android/build/attribution/data/TaskContainer;Lcom/android/build/attribution/data/PluginContainer;)V", "tasksSet", "Ljava/util/HashSet;", "Lcom/android/build/attribution/data/TaskData;", "Lkotlin/collections/HashSet;", "dependenciesMap", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "tasksDeterminingBuildDuration", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "pluginsDeterminingBuildDuration", "Lcom/android/build/attribution/data/PluginBuildData;", "buildStartedTimestamp", "", "buildFinishedTimestamp", "receiveEvent", "", "event", "Lorg/gradle/tooling/events/ProgressEvent;", "calculateCriticalPathStartingFromTask", "startTask", "criticalPathFromTaskMap", "", "calculateTasksCriticalPathBasedOnDependencies", "getIndexOfFirstTaskStartingAtOrAfterTimestamp", "", "timestamp", "tasks", "searchStartIndex", "calculateTasksCriticalPathBasedOnExecution", "getTasksStrictlyInTimeRange", "startTime", "endTime", "taskListSortedByStartTimeIterator", "", "getCriticalPathOfTasksStrictlyInTimeRange", "calculateTasksDeterminingBuildDuration", "tasksCriticalPath", "calculatePluginsDeterminingBuildDuration", "cleanupTempState", "runPostBuildAnalysis", "analyzersResult", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzersProxy;", "studioProvidedInfo", "Lcom/android/build/attribution/data/StudioProvidedInfo;", "calculateResult", "Result", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nCriticalPathAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CriticalPathAnalyzer.kt\ncom/android/build/attribution/analyzers/CriticalPathAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,382:1\n1869#2,2:383\n1869#2,2:386\n1869#2,2:388\n1869#2,2:390\n1563#2:392\n1634#2,3:393\n1056#2:396\n827#2:397\n855#2,2:398\n1869#2,2:400\n827#2:402\n855#2,2:403\n1869#2,2:405\n1021#2,2:409\n1#3:385\n216#4,2:407\n*S KotlinDebug\n*F\n+ 1 CriticalPathAnalyzer.kt\ncom/android/build/attribution/analyzers/CriticalPathAnalyzer\n*L\n65#1:383,2\n89#1:386,2\n115#1:388,2\n130#1:390,2\n193#1:392\n193#1:393,3\n294#1:396\n302#1:397\n302#1:398,2\n306#1:400,2\n334#1:402\n334#1:403,2\n340#1:405,2\n348#1:409,2\n345#1:407,2\n*E\n"})
public final class CriticalPathAnalyzer
extends BaseAnalyzer<Result>
implements BuildEventsAnalyzer,
PostBuildProcessAnalyzer {
    @NotNull
    private final TaskContainer taskContainer;
    @NotNull
    private final PluginContainer pluginContainer;
    @NotNull
    private final HashSet<TaskData> tasksSet;
    @NotNull
    private final HashMap<TaskData, List<TaskData>> dependenciesMap;
    @NotNull
    private final ArrayList<TaskData> tasksDeterminingBuildDuration;
    @NotNull
    private final ArrayList<PluginBuildData> pluginsDeterminingBuildDuration;
    private long buildStartedTimestamp;
    private long buildFinishedTimestamp;

    public CriticalPathAnalyzer(@NotNull TaskContainer taskContainer, @NotNull PluginContainer pluginContainer) {
        Intrinsics.checkNotNullParameter((Object)taskContainer, (String)"taskContainer");
        Intrinsics.checkNotNullParameter((Object)pluginContainer, (String)"pluginContainer");
        this.taskContainer = taskContainer;
        this.pluginContainer = pluginContainer;
        this.tasksSet = new HashSet();
        this.dependenciesMap = new HashMap();
        this.tasksDeterminingBuildDuration = new ArrayList();
        this.pluginsDeterminingBuildDuration = new ArrayList();
        this.buildStartedTimestamp = Long.MAX_VALUE;
        this.buildFinishedTimestamp = Long.MIN_VALUE;
    }

    @Override
    public void receiveEvent(@NotNull ProgressEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof FinishEvent) {
            this.buildStartedTimestamp = RangesKt.coerceAtMost((long)this.buildStartedTimestamp, (long)((FinishEvent)event).getResult().getStartTime());
            this.buildFinishedTimestamp = RangesKt.coerceAtLeast((long)this.buildFinishedTimestamp, (long)((FinishEvent)event).getResult().getEndTime());
        }
        if (event instanceof TaskFinishEvent && ((TaskFinishEvent)event).getResult() instanceof TaskSuccessResult) {
            TaskData task2 = this.taskContainer.getTask((TaskFinishEvent)event, this.pluginContainer);
            ArrayList<TaskData> dependenciesList = new ArrayList<TaskData>();
            Set set2 = ((TaskFinishEvent)event).getDescriptor().getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getDependencies(...)");
            Iterable $this$forEach$iv = set2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TaskData it;
                OperationDescriptor dependency = (OperationDescriptor)element$iv;
                boolean bl = false;
                if (!(dependency instanceof TaskOperationDescriptor)) continue;
                String string = ((TaskOperationDescriptor)dependency).getTaskPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTaskPath(...)");
                if (this.taskContainer.getTask(string) == null) continue;
                boolean bl2 = false;
                dependenciesList.add(it);
            }
            this.tasksSet.add(task2);
            ((Map)this.dependenciesMap).put(task2, dependenciesList);
        }
    }

    private final long calculateCriticalPathStartingFromTask(TaskData startTask, Map<TaskData, Long> criticalPathFromTaskMap) {
        Long l = criticalPathFromTaskMap.get(startTask);
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            return it;
        }
        long criticalPathDuration = 0L;
        List<TaskData> list2 = this.dependenciesMap.get(startTask);
        Intrinsics.checkNotNull(list2);
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TaskData dependency = (TaskData)element$iv;
            boolean bl = false;
            criticalPathDuration = Math.max(criticalPathDuration, this.calculateCriticalPathStartingFromTask(dependency, criticalPathFromTaskMap));
        }
        criticalPathFromTaskMap.put(startTask, criticalPathDuration += startTask.getExecutionTime());
        return criticalPathDuration;
    }

    private final List<TaskData> calculateTasksCriticalPathBasedOnDependencies() {
        ArrayList<TaskData> tasksCriticalPath = new ArrayList<TaskData>();
        HashMap criticalPathFromTaskMap = new HashMap();
        TaskData startTask = null;
        long currentCriticalPathDuration = 0L;
        currentCriticalPathDuration = -1L;
        Iterable $this$forEach$iv = this.tasksSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TaskData it = (TaskData)element$iv;
            boolean bl = false;
            long criticalPathFromTask = this.calculateCriticalPathStartingFromTask(it, criticalPathFromTaskMap);
            if (currentCriticalPathDuration >= criticalPathFromTask) continue;
            currentCriticalPathDuration = criticalPathFromTask;
            startTask = it;
        }
        while (startTask != null) {
            tasksCriticalPath.add(startTask);
            TaskData nextTask = null;
            currentCriticalPathDuration = -1L;
            List<TaskData> list2 = this.dependenciesMap.get(startTask);
            Intrinsics.checkNotNull(list2);
            Iterable $this$forEach$iv2 = list2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                TaskData dependency = (TaskData)element$iv;
                boolean bl = false;
                Object v = criticalPathFromTaskMap.get(dependency);
                Intrinsics.checkNotNull(v);
                long criticalPathFromTask = ((Number)v).longValue();
                if (currentCriticalPathDuration >= criticalPathFromTask) continue;
                currentCriticalPathDuration = criticalPathFromTask;
                nextTask = dependency;
            }
            startTask = nextTask;
        }
        CollectionsKt.reverse((List)tasksCriticalPath);
        return tasksCriticalPath;
    }

    private final int getIndexOfFirstTaskStartingAtOrAfterTimestamp(long timestamp, List<TaskData> tasks, int searchStartIndex) {
        if (((TaskData)CollectionsKt.last(tasks)).getExecutionStartTime() < timestamp) {
            return -1;
        }
        int left2 = searchStartIndex;
        int right = tasks.size() - 1;
        while (left2 < right) {
            int middle = left2 + (right - left2) / 2;
            if (tasks.get(middle).getExecutionStartTime() < timestamp) {
                left2 = middle + 1;
                continue;
            }
            right = middle;
        }
        return left2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TaskData> calculateTasksCriticalPathBasedOnExecution(List<TaskData> tasks) {
        int n;
        ArrayList<Long> arrayList;
        ArrayList<Long> $this$mapTo$iv$iv232;
        if (tasks.isEmpty()) {
            return tasks;
        }
        Iterable $this$map$iv = tasks;
        int $i$f$map = 0;
        Iterable iterable = $this$map$iv;
        ArrayList<Long> destination$iv$iv32422 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv232) {
            void it;
            TaskData taskData = (TaskData)t;
            arrayList = destination$iv$iv32422;
            boolean bl = false;
            arrayList.add(it.getExecutionTime());
        }
        List criticalPathFromTask = CollectionsKt.toMutableList((Collection)destination$iv$iv32422);
        $i$f$map = tasks.size();
        $this$mapTo$iv$iv232 = new ArrayList<Long>($i$f$map);
        int destination$iv$iv32422 = 0;
        while (destination$iv$iv32422 < $i$f$map) {
            void it;
            int n2 = n = destination$iv$iv32422++;
            arrayList = $this$mapTo$iv$iv232;
            boolean bl = false;
            arrayList.add((Long)((int)it));
        }
        List maxCriticalPathStartIndexInSuffix = CollectionsKt.toMutableList((Collection)$this$mapTo$iv$iv232);
        int $this$mapTo$iv$iv232 = tasks.size();
        ArrayList destination$iv$iv32422 = new ArrayList($this$mapTo$iv$iv232);
        n = 0;
        while (n < $this$mapTo$iv$iv232) {
            int n3;
            int n2 = n3 = n++;
            arrayList = destination$iv$iv32422;
            boolean bl2 = false;
            arrayList.add((Long)-1);
        }
        List bestChoiceIndex = CollectionsKt.toMutableList((Collection)destination$iv$iv32422);
        for (int i = tasks.size() - 2; -1 < i; --i) {
            int firstTaskIndex = this.getIndexOfFirstTaskStartingAtOrAfterTimestamp(tasks.get(i).getExecutionEndTime(), tasks, i + 1);
            if (firstTaskIndex != -1) {
                bestChoiceIndex.set(i, maxCriticalPathStartIndexInSuffix.get(firstTaskIndex));
                criticalPathFromTask.set(i, tasks.get(i).getExecutionTime() + ((Number)criticalPathFromTask.get(((Number)bestChoiceIndex.get(i)).intValue())).longValue());
            }
            if (((Number)criticalPathFromTask.get(i)).longValue() >= ((Number)criticalPathFromTask.get(((Number)maxCriticalPathStartIndexInSuffix.get(i + 1)).intValue())).longValue()) continue;
            maxCriticalPathStartIndexInSuffix.set(i, maxCriticalPathStartIndexInSuffix.get(i + 1));
        }
        ArrayList<TaskData> criticalPath = new ArrayList<TaskData>();
        int index = ((Number)maxCriticalPathStartIndexInSuffix.get(0)).intValue();
        while (index != -1) {
            criticalPath.add(tasks.get(index));
            index = ((Number)bestChoiceIndex.get(index)).intValue();
        }
        return criticalPath;
    }

    private final List<TaskData> getTasksStrictlyInTimeRange(long startTime, long endTime, ListIterator<TaskData> taskListSortedByStartTimeIterator) {
        ArrayList<TaskData> tasksInBetween = new ArrayList<TaskData>();
        while (taskListSortedByStartTimeIterator.hasNext()) {
            TaskData currentTask = taskListSortedByStartTimeIterator.next();
            if (currentTask.getExecutionStartTime() < startTime) continue;
            if (currentTask.getExecutionStartTime() >= endTime) {
                taskListSortedByStartTimeIterator.previous();
                break;
            }
            if (currentTask.getExecutionEndTime() > endTime || currentTask.isOnTheCriticalPath()) continue;
            tasksInBetween.add(currentTask);
        }
        return tasksInBetween;
    }

    private final List<TaskData> getCriticalPathOfTasksStrictlyInTimeRange(long startTime, long endTime, ListIterator<TaskData> taskListSortedByStartTimeIterator) {
        return this.calculateTasksCriticalPathBasedOnExecution(this.getTasksStrictlyInTimeRange(startTime, endTime, taskListSortedByStartTimeIterator));
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateTasksDeterminingBuildDuration(List<TaskData> tasksCriticalPath) {
        void $this$filterNot$iv;
        TaskData previousCriticalPathTask;
        ArrayList<Object> tasksDeterminingBuildDurationList = new ArrayList<Object>();
        Iterable $this$sortedBy$iv = this.tasksSet;
        boolean $i$f$sortedBy2 = false;
        List taskListSortedByStartTime = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                TaskData it = (TaskData)a;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getExecutionStartTime());
                it = (TaskData)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getExecutionStartTime()));
            }
        });
        ListIterator<TaskData> listIterator = taskListSortedByStartTime.listIterator();
        if (tasksCriticalPath.isEmpty()) {
            void $this$filterNotTo$iv$iv;
            void $this$filterNot$iv2;
            Iterable $i$f$sortedBy2 = this.calculateTasksCriticalPathBasedOnExecution(taskListSortedByStartTime);
            ArrayList<TaskData> arrayList = this.tasksDeterminingBuildDuration;
            boolean $i$f$filterNot = false;
            void var7_14 = $this$filterNot$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                TaskData it = (TaskData)element$iv$iv;
                boolean bl = false;
                if (it.getExecutionMode() == TaskData.TaskExecutionMode.UP_TO_DATE) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            arrayList.addAll((List)destination$iv$iv);
            return;
        }
        Iterable $this$forEach$iv = tasksCriticalPath;
        int $i$f$forEach = 0;
        Iterator $this$filterNotTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$filterNotTo$iv$iv.hasNext()) {
            Object element$iv = $this$filterNotTo$iv$iv.next();
            TaskData task2 = (TaskData)element$iv;
            boolean bl = false;
            task2.setOnTheCriticalPath(true);
        }
        tasksDeterminingBuildDurationList.addAll((Collection)this.getCriticalPathOfTasksStrictlyInTimeRange(0L, ((TaskData)CollectionsKt.first(tasksCriticalPath)).getExecutionStartTime(), listIterator));
        $i$f$forEach = tasksCriticalPath.size() - 1;
        for (int i = 0; i < $i$f$forEach; ++i) {
            previousCriticalPathTask = tasksCriticalPath.get(i);
            TaskData nextCriticalPathTask = tasksCriticalPath.get(i + 1);
            tasksDeterminingBuildDurationList.add(previousCriticalPathTask);
            tasksDeterminingBuildDurationList.addAll((Collection)this.getCriticalPathOfTasksStrictlyInTimeRange(previousCriticalPathTask.getExecutionEndTime(), nextCriticalPathTask.getExecutionStartTime(), listIterator));
        }
        tasksDeterminingBuildDurationList.add(CollectionsKt.last(tasksCriticalPath));
        tasksDeterminingBuildDurationList.addAll((Collection)this.getCriticalPathOfTasksStrictlyInTimeRange(((TaskData)CollectionsKt.last(tasksCriticalPath)).getExecutionEndTime(), Long.MAX_VALUE, listIterator));
        Iterable i = tasksDeterminingBuildDurationList;
        ArrayList<TaskData> arrayList = this.tasksDeterminingBuildDuration;
        boolean $i$f$filterNot = false;
        previousCriticalPathTask = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Iterator iterator2 = $this$filterNotTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            TaskData it = (TaskData)element$iv$iv;
            boolean bl = false;
            if (it.getExecutionMode() == TaskData.TaskExecutionMode.UP_TO_DATE) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        arrayList.addAll((List)destination$iv$iv);
    }

    private final void calculatePluginsDeterminingBuildDuration() {
        Object element$iv;
        HashMap pluginBuildDurationMap = new HashMap();
        Object $this$forEach$iv = this.tasksDeterminingBuildDuration;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            TaskData task2 = (TaskData)element$iv;
            boolean bl = false;
            Long l = pluginBuildDurationMap.getOrDefault(task2.getOriginPlugin(), 0L);
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getOrDefault(...)");
            long currentDuration = ((Number)l).longValue();
            ((Map)pluginBuildDurationMap).put(task2.getOriginPlugin(), currentDuration + task2.getExecutionTime());
        }
        $this$forEach$iv = pluginBuildDurationMap;
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object = element$iv = (Map.Entry)iterator2.next();
            boolean bl = false;
            PluginData plugin = (PluginData)object.getKey();
            long duration = ((Number)object.getValue()).longValue();
            this.pluginsDeterminingBuildDuration.add(new PluginBuildData(plugin, duration));
        }
        List $this$sortByDescending$iv = this.pluginsDeterminingBuildDuration;
        boolean $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    PluginBuildData it = (PluginBuildData)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getBuildDuration());
                    it = (PluginBuildData)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getBuildDuration()));
                }
            });
        }
    }

    @Override
    public void cleanupTempState() {
        this.tasksSet.clear();
        this.dependenciesMap.clear();
        this.tasksDeterminingBuildDuration.clear();
        this.pluginsDeterminingBuildDuration.clear();
        this.buildStartedTimestamp = Long.MAX_VALUE;
        this.buildFinishedTimestamp = Long.MIN_VALUE;
    }

    @Override
    public void runPostBuildAnalysis(@NotNull BuildEventsAnalyzersProxy analyzersResult, @NotNull StudioProvidedInfo studioProvidedInfo) {
        Intrinsics.checkNotNullParameter((Object)analyzersResult, (String)"analyzersResult");
        Intrinsics.checkNotNullParameter((Object)studioProvidedInfo, (String)"studioProvidedInfo");
        this.ensureResultCalculated();
    }

    @Override
    @NotNull
    protected Result calculateResult() {
        this.calculateTasksDeterminingBuildDuration(this.calculateTasksCriticalPathBasedOnDependencies());
        this.calculatePluginsDeterminingBuildDuration();
        return new Result(CollectionsKt.toList((Iterable)this.tasksDeterminingBuildDuration), CollectionsKt.toList((Iterable)this.pluginsDeterminingBuildDuration), this.buildStartedTimestamp, this.buildFinishedTimestamp);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J=\u0010\u0016\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lcom/android/build/attribution/analyzers/CriticalPathAnalyzer$Result;", "Lcom/android/build/attribution/analyzers/AnalyzerResult;", "tasksDeterminingBuildDuration", "", "Lcom/android/build/attribution/data/TaskData;", "pluginsDeterminingBuildDuration", "Lcom/android/build/attribution/data/PluginBuildData;", "buildStartedTimestamp", "", "buildFinishedTimestamp", "<init>", "(Ljava/util/List;Ljava/util/List;JJ)V", "getTasksDeterminingBuildDuration", "()Ljava/util/List;", "getPluginsDeterminingBuildDuration", "getBuildStartedTimestamp", "()J", "getBuildFinishedTimestamp", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.android.build-attribution"})
    public static final class Result
    implements AnalyzerResult {
        @NotNull
        private final List<TaskData> tasksDeterminingBuildDuration;
        @NotNull
        private final List<PluginBuildData> pluginsDeterminingBuildDuration;
        private final long buildStartedTimestamp;
        private final long buildFinishedTimestamp;

        public Result(@NotNull List<TaskData> tasksDeterminingBuildDuration, @NotNull List<PluginBuildData> pluginsDeterminingBuildDuration, long buildStartedTimestamp, long buildFinishedTimestamp) {
            Intrinsics.checkNotNullParameter(tasksDeterminingBuildDuration, (String)"tasksDeterminingBuildDuration");
            Intrinsics.checkNotNullParameter(pluginsDeterminingBuildDuration, (String)"pluginsDeterminingBuildDuration");
            this.tasksDeterminingBuildDuration = tasksDeterminingBuildDuration;
            this.pluginsDeterminingBuildDuration = pluginsDeterminingBuildDuration;
            this.buildStartedTimestamp = buildStartedTimestamp;
            this.buildFinishedTimestamp = buildFinishedTimestamp;
        }

        @NotNull
        public final List<TaskData> getTasksDeterminingBuildDuration() {
            return this.tasksDeterminingBuildDuration;
        }

        @NotNull
        public final List<PluginBuildData> getPluginsDeterminingBuildDuration() {
            return this.pluginsDeterminingBuildDuration;
        }

        public final long getBuildStartedTimestamp() {
            return this.buildStartedTimestamp;
        }

        public final long getBuildFinishedTimestamp() {
            return this.buildFinishedTimestamp;
        }

        @NotNull
        public final List<TaskData> component1() {
            return this.tasksDeterminingBuildDuration;
        }

        @NotNull
        public final List<PluginBuildData> component2() {
            return this.pluginsDeterminingBuildDuration;
        }

        public final long component3() {
            return this.buildStartedTimestamp;
        }

        public final long component4() {
            return this.buildFinishedTimestamp;
        }

        @NotNull
        public final Result copy(@NotNull List<TaskData> tasksDeterminingBuildDuration, @NotNull List<PluginBuildData> pluginsDeterminingBuildDuration, long buildStartedTimestamp, long buildFinishedTimestamp) {
            Intrinsics.checkNotNullParameter(tasksDeterminingBuildDuration, (String)"tasksDeterminingBuildDuration");
            Intrinsics.checkNotNullParameter(pluginsDeterminingBuildDuration, (String)"pluginsDeterminingBuildDuration");
            return new Result(tasksDeterminingBuildDuration, pluginsDeterminingBuildDuration, buildStartedTimestamp, buildFinishedTimestamp);
        }

        public static /* synthetic */ Result copy$default(Result result2, List list2, List list3, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = result2.tasksDeterminingBuildDuration;
            }
            if ((n & 2) != 0) {
                list3 = result2.pluginsDeterminingBuildDuration;
            }
            if ((n & 4) != 0) {
                l = result2.buildStartedTimestamp;
            }
            if ((n & 8) != 0) {
                l2 = result2.buildFinishedTimestamp;
            }
            return result2.copy(list2, list3, l, l2);
        }

        @NotNull
        public String toString() {
            return "Result(tasksDeterminingBuildDuration=" + this.tasksDeterminingBuildDuration + ", pluginsDeterminingBuildDuration=" + this.pluginsDeterminingBuildDuration + ", buildStartedTimestamp=" + this.buildStartedTimestamp + ", buildFinishedTimestamp=" + this.buildFinishedTimestamp + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.tasksDeterminingBuildDuration).hashCode();
            result2 = result2 * 31 + ((Object)this.pluginsDeterminingBuildDuration).hashCode();
            result2 = result2 * 31 + Long.hashCode(this.buildStartedTimestamp);
            result2 = result2 * 31 + Long.hashCode(this.buildFinishedTimestamp);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            if (!Intrinsics.areEqual(this.tasksDeterminingBuildDuration, result2.tasksDeterminingBuildDuration)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.pluginsDeterminingBuildDuration, result2.pluginsDeterminingBuildDuration)) {
                return false;
            }
            if (this.buildStartedTimestamp != result2.buildStartedTimestamp) {
                return false;
            }
            return this.buildFinishedTimestamp == result2.buildFinishedTimestamp;
        }
    }
}

