/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.analyzers;

import com.android.build.attribution.BuildAnalyzerStorageManager;
import com.android.build.attribution.analyzers.AlwaysRunTasksAnalyzer;
import com.android.build.attribution.analyzers.AnnotationProcessorsAnalyzer;
import com.android.build.attribution.analyzers.BaseAnalyzer;
import com.android.build.attribution.analyzers.ConfigurationCachingCompatibilityAnalyzer;
import com.android.build.attribution.analyzers.CriticalPathAnalyzer;
import com.android.build.attribution.analyzers.DownloadsAnalyzer;
import com.android.build.attribution.analyzers.GarbageCollectionAnalyzer;
import com.android.build.attribution.analyzers.JetifierUsageAnalyzer;
import com.android.build.attribution.analyzers.ProjectConfigurationAnalyzer;
import com.android.build.attribution.analyzers.TaskCategoryWarningsAnalyzer;
import com.android.build.attribution.analyzers.TasksConfigurationIssuesAnalyzer;
import com.android.build.attribution.data.PluginContainer;
import com.android.build.attribution.data.TaskContainer;
import com.android.tools.idea.flags.StudioFlags;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u00106\u001a\u000207R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0013\u0010.\u001a\u0004\u0018\u00010/\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u00102\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u001b\u00108\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030:098F\u00a2\u0006\u0006\u001a\u0004\b;\u0010<\u00a8\u0006="}, d2={"Lcom/android/build/attribution/analyzers/BuildEventsAnalyzersProxy;", "", "taskContainer", "Lcom/android/build/attribution/data/TaskContainer;", "pluginContainer", "Lcom/android/build/attribution/data/PluginContainer;", "storageManager", "Lcom/android/build/attribution/BuildAnalyzerStorageManager;", "<init>", "(Lcom/android/build/attribution/data/TaskContainer;Lcom/android/build/attribution/data/PluginContainer;Lcom/android/build/attribution/BuildAnalyzerStorageManager;)V", "getTaskContainer", "()Lcom/android/build/attribution/data/TaskContainer;", "getPluginContainer", "()Lcom/android/build/attribution/data/PluginContainer;", "alwaysRunTasksAnalyzer", "Lcom/android/build/attribution/analyzers/AlwaysRunTasksAnalyzer;", "getAlwaysRunTasksAnalyzer", "()Lcom/android/build/attribution/analyzers/AlwaysRunTasksAnalyzer;", "annotationProcessorsAnalyzer", "Lcom/android/build/attribution/analyzers/AnnotationProcessorsAnalyzer;", "getAnnotationProcessorsAnalyzer", "()Lcom/android/build/attribution/analyzers/AnnotationProcessorsAnalyzer;", "criticalPathAnalyzer", "Lcom/android/build/attribution/analyzers/CriticalPathAnalyzer;", "getCriticalPathAnalyzer", "()Lcom/android/build/attribution/analyzers/CriticalPathAnalyzer;", "garbageCollectionAnalyzer", "Lcom/android/build/attribution/analyzers/GarbageCollectionAnalyzer;", "getGarbageCollectionAnalyzer", "()Lcom/android/build/attribution/analyzers/GarbageCollectionAnalyzer;", "projectConfigurationAnalyzer", "Lcom/android/build/attribution/analyzers/ProjectConfigurationAnalyzer;", "getProjectConfigurationAnalyzer", "()Lcom/android/build/attribution/analyzers/ProjectConfigurationAnalyzer;", "tasksConfigurationIssuesAnalyzer", "Lcom/android/build/attribution/analyzers/TasksConfigurationIssuesAnalyzer;", "getTasksConfigurationIssuesAnalyzer", "()Lcom/android/build/attribution/analyzers/TasksConfigurationIssuesAnalyzer;", "configurationCachingCompatibilityAnalyzer", "Lcom/android/build/attribution/analyzers/ConfigurationCachingCompatibilityAnalyzer;", "getConfigurationCachingCompatibilityAnalyzer", "()Lcom/android/build/attribution/analyzers/ConfigurationCachingCompatibilityAnalyzer;", "jetifierUsageAnalyzer", "Lcom/android/build/attribution/analyzers/JetifierUsageAnalyzer;", "getJetifierUsageAnalyzer", "()Lcom/android/build/attribution/analyzers/JetifierUsageAnalyzer;", "downloadsAnalyzer", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer;", "getDownloadsAnalyzer", "()Lcom/android/build/attribution/analyzers/DownloadsAnalyzer;", "taskCategoryWarningsAnalyzer", "Lcom/android/build/attribution/analyzers/TaskCategoryWarningsAnalyzer;", "getTaskCategoryWarningsAnalyzer", "()Lcom/android/build/attribution/analyzers/TaskCategoryWarningsAnalyzer;", "getBuildFinishedTimestamp", "", "buildAnalyzers", "", "Lcom/android/build/attribution/analyzers/BaseAnalyzer;", "getBuildAnalyzers", "()Ljava/util/List;", "intellij.android.build-attribution"})
public final class BuildEventsAnalyzersProxy {
    @NotNull
    private final TaskContainer taskContainer;
    @NotNull
    private final PluginContainer pluginContainer;
    @NotNull
    private final AlwaysRunTasksAnalyzer alwaysRunTasksAnalyzer;
    @NotNull
    private final AnnotationProcessorsAnalyzer annotationProcessorsAnalyzer;
    @NotNull
    private final CriticalPathAnalyzer criticalPathAnalyzer;
    @NotNull
    private final GarbageCollectionAnalyzer garbageCollectionAnalyzer;
    @NotNull
    private final ProjectConfigurationAnalyzer projectConfigurationAnalyzer;
    @NotNull
    private final TasksConfigurationIssuesAnalyzer tasksConfigurationIssuesAnalyzer;
    @NotNull
    private final ConfigurationCachingCompatibilityAnalyzer configurationCachingCompatibilityAnalyzer;
    @NotNull
    private final JetifierUsageAnalyzer jetifierUsageAnalyzer;
    @Nullable
    private final DownloadsAnalyzer downloadsAnalyzer;
    @NotNull
    private final TaskCategoryWarningsAnalyzer taskCategoryWarningsAnalyzer;

    public BuildEventsAnalyzersProxy(@NotNull TaskContainer taskContainer, @NotNull PluginContainer pluginContainer, @NotNull BuildAnalyzerStorageManager storageManager) {
        Intrinsics.checkNotNullParameter((Object)taskContainer, (String)"taskContainer");
        Intrinsics.checkNotNullParameter((Object)pluginContainer, (String)"pluginContainer");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        this.taskContainer = taskContainer;
        this.pluginContainer = pluginContainer;
        this.alwaysRunTasksAnalyzer = new AlwaysRunTasksAnalyzer(this.taskContainer, this.pluginContainer);
        this.annotationProcessorsAnalyzer = new AnnotationProcessorsAnalyzer(this.taskContainer, this.pluginContainer);
        this.criticalPathAnalyzer = new CriticalPathAnalyzer(this.taskContainer, this.pluginContainer);
        this.garbageCollectionAnalyzer = new GarbageCollectionAnalyzer();
        this.projectConfigurationAnalyzer = new ProjectConfigurationAnalyzer(this.pluginContainer);
        this.tasksConfigurationIssuesAnalyzer = new TasksConfigurationIssuesAnalyzer(this.taskContainer);
        this.configurationCachingCompatibilityAnalyzer = new ConfigurationCachingCompatibilityAnalyzer();
        this.jetifierUsageAnalyzer = new JetifierUsageAnalyzer(storageManager.getCachedCheckJetifierResultData());
        this.downloadsAnalyzer = (Boolean)StudioFlags.BUILD_ANALYZER_DOWNLOADS_ANALYSIS.get() != false ? new DownloadsAnalyzer() : null;
        this.taskCategoryWarningsAnalyzer = new TaskCategoryWarningsAnalyzer();
    }

    @NotNull
    public final TaskContainer getTaskContainer() {
        return this.taskContainer;
    }

    @NotNull
    public final PluginContainer getPluginContainer() {
        return this.pluginContainer;
    }

    @NotNull
    public final AlwaysRunTasksAnalyzer getAlwaysRunTasksAnalyzer() {
        return this.alwaysRunTasksAnalyzer;
    }

    @NotNull
    public final AnnotationProcessorsAnalyzer getAnnotationProcessorsAnalyzer() {
        return this.annotationProcessorsAnalyzer;
    }

    @NotNull
    public final CriticalPathAnalyzer getCriticalPathAnalyzer() {
        return this.criticalPathAnalyzer;
    }

    @NotNull
    public final GarbageCollectionAnalyzer getGarbageCollectionAnalyzer() {
        return this.garbageCollectionAnalyzer;
    }

    @NotNull
    public final ProjectConfigurationAnalyzer getProjectConfigurationAnalyzer() {
        return this.projectConfigurationAnalyzer;
    }

    @NotNull
    public final TasksConfigurationIssuesAnalyzer getTasksConfigurationIssuesAnalyzer() {
        return this.tasksConfigurationIssuesAnalyzer;
    }

    @NotNull
    public final ConfigurationCachingCompatibilityAnalyzer getConfigurationCachingCompatibilityAnalyzer() {
        return this.configurationCachingCompatibilityAnalyzer;
    }

    @NotNull
    public final JetifierUsageAnalyzer getJetifierUsageAnalyzer() {
        return this.jetifierUsageAnalyzer;
    }

    @Nullable
    public final DownloadsAnalyzer getDownloadsAnalyzer() {
        return this.downloadsAnalyzer;
    }

    @NotNull
    public final TaskCategoryWarningsAnalyzer getTaskCategoryWarningsAnalyzer() {
        return this.taskCategoryWarningsAnalyzer;
    }

    public final long getBuildFinishedTimestamp() {
        return ((CriticalPathAnalyzer.Result)this.criticalPathAnalyzer.getResult()).getBuildFinishedTimestamp();
    }

    @NotNull
    public final List<BaseAnalyzer<?>> getBuildAnalyzers() {
        Object[] objectArray = new BaseAnalyzer[]{this.alwaysRunTasksAnalyzer, this.annotationProcessorsAnalyzer, this.criticalPathAnalyzer, this.garbageCollectionAnalyzer, this.projectConfigurationAnalyzer, this.tasksConfigurationIssuesAnalyzer, this.configurationCachingCompatibilityAnalyzer, this.jetifierUsageAnalyzer, this.downloadsAnalyzer, this.taskCategoryWarningsAnalyzer};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }
}

