/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.analyzers;

import com.android.build.attribution.analyzers.AnalyzerResult;
import com.android.build.attribution.data.TaskData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.tasks.Delete;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\r\u0010\u000f\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0010\u001a\u00020\u000eH&J\u0006\u0010\u0011\u001a\u00020\u000eJ\u0006\u0010\u0012\u001a\u00020\u000eJ\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0004R\u0012\u0010\u0006\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00028\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/android/build/attribution/analyzers/BaseAnalyzer;", "T", "Lcom/android/build/attribution/analyzers/AnalyzerResult;", "", "<init>", "()V", "_result", "Lcom/android/build/attribution/analyzers/AnalyzerResult;", "calculatingResult", "", "result", "getResult", "()Lcom/android/build/attribution/analyzers/AnalyzerResult;", "ensureResultCalculated", "", "calculateResult", "cleanupTempState", "onBuildStart", "onBuildFailure", "applyIgnoredTasksFilter", "task", "Lcom/android/build/attribution/data/TaskData;", "ResultComputationLoopException", "intellij.android.build-attribution"})
public abstract class BaseAnalyzer<T extends AnalyzerResult> {
    @Nullable
    private T _result;
    private boolean calculatingResult;

    @NotNull
    public final T getResult() {
        this.ensureResultCalculated();
        T t = this._result;
        Intrinsics.checkNotNull(t);
        return t;
    }

    public final void ensureResultCalculated() {
        if (this.calculatingResult) {
            throw new ResultComputationLoopException();
        }
        if (this._result == null) {
            this.calculatingResult = true;
            this._result = this.calculateResult();
            this.cleanupTempState();
            this.calculatingResult = false;
        }
    }

    @NotNull
    protected abstract T calculateResult();

    public abstract void cleanupTempState();

    public final void onBuildStart() {
        this._result = null;
        this.calculatingResult = false;
        this.cleanupTempState();
    }

    public final void onBuildFailure() {
        this.cleanupTempState();
    }

    protected final boolean applyIgnoredTasksFilter(@NotNull TaskData task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        return !task2.getOriginPlugin().isAndroidPlugin() && !task2.getOriginPlugin().isGradlePlugin() && (!Intrinsics.areEqual((Object)task2.getTaskName(), (Object)"clean") || !Intrinsics.areEqual((Object)task2.getOriginPlugin().getIdName(), (Object)LifecycleBasePlugin.class.getCanonicalName())) && !Intrinsics.areEqual((Object)task2.getTaskType(), (Object)Delete.class.getCanonicalName()) && !Intrinsics.areEqual((Object)task2.getTaskType(), (Object)"org.jetbrains.kotlin.gradle.plugin.diagnostics.CheckKotlinGradlePluginConfigurationErrors") && !task2.isAndroidTask() && !task2.isGradleTask();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lcom/android/build/attribution/analyzers/BaseAnalyzer$ResultComputationLoopException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "<init>", "()V", "intellij.android.build-attribution"})
    public static final class ResultComputationLoopException
    extends Exception {
        public ResultComputationLoopException() {
            super("Loop detected in build analyzer computation dependencies, see stacktrace.");
        }
    }
}

