/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution;

import com.android.build.attribution.AtomicFileSize;
import com.android.build.attribution.BuildAnalyzerSettings;
import com.android.build.attribution.BuildAnalyzerStorageManager;
import com.android.build.attribution.ui.view.ClearBuildResultsAction;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.options.BoundSearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.TextFieldKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/build/attribution/BuildAnalyzerConfigurable;", "Lcom/intellij/openapi/options/BoundSearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "buildAnalyzerSettings", "Lcom/android/build/attribution/BuildAnalyzerSettings;", "fileSizeFormatted", "Lcom/android/build/attribution/AtomicFileSize;", "apply", "", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "intellij.android.build-attribution"})
final class BuildAnalyzerConfigurable
extends BoundSearchableConfigurable {
    @NotNull
    private final Project project;
    @NotNull
    private final BuildAnalyzerSettings buildAnalyzerSettings;
    @NotNull
    private final AtomicFileSize fileSizeFormatted;

    public BuildAnalyzerConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super("Build Analyzer", "build.analyzer", null, 4, null);
        this.project = project;
        this.buildAnalyzerSettings = BuildAnalyzerSettings.Companion.getInstance(this.project);
        this.fileSizeFormatted = new AtomicFileSize(BuildAnalyzerStorageManager.Companion.getInstance(this.project).getStorageDescriptor().getCurrentBuildHistoryDataSize());
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void apply() {
        super.apply();
        BuildAnalyzerStorageManager.Companion.getInstance(this.project).onSettingsChange();
    }

    @NotNull
    public DialogPanel createPanel() {
        return BuilderKt.panel(arg_0 -> BuildAnalyzerConfigurable.createPanel$lambda$0(this, arg_0));
    }

    private static final Unit createPanel$lambda$0(BuildAnalyzerConfigurable this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        if (((Boolean)StudioFlags.BUILD_ANALYZER_HISTORY.get()).booleanValue()) {
            Panel.row$default((Panel)$this$panel, null, arg_0 -> BuildAnalyzerConfigurable.createPanel$lambda$0$0(this$0, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> BuildAnalyzerConfigurable.createPanel$lambda$0$1(this$0, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> BuildAnalyzerConfigurable.createPanel$lambda$0$2(this$0, arg_0), (int)1, null);
            Panel.row$default((Panel)$this$panel, null, arg_0 -> BuildAnalyzerConfigurable.createPanel$lambda$0$3(this$0, arg_0), (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$0(BuildAnalyzerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell.label$default((Cell)TextFieldKt.bindIntText((Cell)Row.text$default((Row)$this$row, (String)"", (int)0, null, (int)6, null), (ObservableMutableProperty)((ObservableMutableProperty)BuildAnalyzerStorageManager.Companion.getInstance(this$0.project).getStorageDescriptor().getNumberOfBuildResultsStored())), (String)"Number of build results stored: ", null, (int)2, null);
        Cell.label$default((Cell)TextFieldKt.bindText((Cell)Row.text$default((Row)$this$row, (String)"", (int)0, null, (int)6, null), (ObservableMutableProperty)this$0.fileSizeFormatted), (String)"File size taken up by stored build results: ", null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1(BuildAnalyzerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default((Row)$this$row, (String)"Maximum number of build results stored", (int)0, null, (int)6, null);
        TextFieldKt.bindIntText((Cell)Row.intTextField$default((Row)$this$row, (IntRange)new IntRange(0, 100), null, (int)2, null), () -> BuildAnalyzerConfigurable.createPanel$lambda$0$1$0(this$0), arg_0 -> BuildAnalyzerConfigurable.createPanel$lambda$0$1$1(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final int createPanel$lambda$0$1$0(BuildAnalyzerConfigurable this$0) {
        return this$0.buildAnalyzerSettings.getSettingsState().getMaxNumberOfBuildsStored();
    }

    private static final Unit createPanel$lambda$0$1$1(BuildAnalyzerConfigurable this$0, int it) {
        this$0.buildAnalyzerSettings.getSettingsState().setMaxNumberOfBuildsStored(it);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2(BuildAnalyzerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.text$default((Row)$this$row, (String)"Maximum storage capacity in kilobytes", (int)0, null, (int)6, null);
        TextFieldKt.bindIntText((Cell)Row.intTextField$default((Row)$this$row, (IntRange)new IntRange(0, 100000), null, (int)2, null), () -> BuildAnalyzerConfigurable.createPanel$lambda$0$2$0(this$0), arg_0 -> BuildAnalyzerConfigurable.createPanel$lambda$0$2$1(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final int createPanel$lambda$0$2$0(BuildAnalyzerConfigurable this$0) {
        return this$0.buildAnalyzerSettings.getSettingsState().getMaxStorageSpaceKilobytes();
    }

    private static final Unit createPanel$lambda$0$2$1(BuildAnalyzerConfigurable this$0, int it) {
        this$0.buildAnalyzerSettings.getSettingsState().setMaxStorageSpaceKilobytes(it);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3(BuildAnalyzerConfigurable this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Row.button$default((Row)$this$row, (String)"Clear Build Results Data", (AnAction)new ClearBuildResultsAction((Function0<Unit>)((Function0)new Function0<Unit>((Object)this$0){

            public final void invoke() {
                ((BuildAnalyzerConfigurable)((Object)this.receiver)).reset();
            }
        })), null, (int)4, null);
        return Unit.INSTANCE;
    }
}

