/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl;

import com.android.ide.common.repository.AgpVersion;
import com.android.sdklib.AndroidMajorVersion;
import com.android.sdklib.AndroidVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001e\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u000b"}, d2={"compileSdk", "", "androidVersion", "Lcom/android/sdklib/AndroidVersion;", "agpVersion", "Lcom/android/ide/common/repository/AgpVersion;", "minSdk", "Lcom/android/sdklib/AndroidMajorVersion;", "targetSdk", "toAndroidFieldVersion", "fieldNameBase", "intellij.android.wizardTemplate.impl"})
public final class SharedMacrosKt {
    @NotNull
    public static final String compileSdk(@NotNull AndroidVersion androidVersion, @NotNull AgpVersion agpVersion) {
        Intrinsics.checkNotNullParameter((Object)androidVersion, (String)"androidVersion");
        Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"agpVersion");
        boolean isNewAGP = agpVersion.compareIgnoringQualifiers("7.0.0") >= 0;
        int apiLevelMajor = androidVersion.getAndroidApiLevel().getMajorVersion();
        return isNewAGP && androidVersion.isPreview() ? "compileSdkPreview \"" + androidVersion.getApiStringWithExtension() + "\"" : (isNewAGP ? "compileSdk " + apiLevelMajor : (androidVersion.isPreview() ? "compileSdkVersion \"" + androidVersion.getApiStringWithExtension() + "\"" : "compileSdkVersion " + apiLevelMajor));
    }

    @NotNull
    public static final String minSdk(@NotNull AndroidMajorVersion androidVersion, @NotNull AgpVersion agpVersion) {
        Intrinsics.checkNotNullParameter((Object)androidVersion, (String)"androidVersion");
        Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"agpVersion");
        return SharedMacrosKt.toAndroidFieldVersion("minSdk", androidVersion, agpVersion);
    }

    @NotNull
    public static final String targetSdk(@NotNull AndroidMajorVersion androidVersion, @NotNull AgpVersion agpVersion) {
        Intrinsics.checkNotNullParameter((Object)androidVersion, (String)"androidVersion");
        Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"agpVersion");
        return SharedMacrosKt.toAndroidFieldVersion("targetSdk", androidVersion, agpVersion);
    }

    @NotNull
    public static final String toAndroidFieldVersion(@NotNull String fieldNameBase, @NotNull AndroidMajorVersion androidVersion, @NotNull AgpVersion agpVersion) {
        Intrinsics.checkNotNullParameter((Object)fieldNameBase, (String)"fieldNameBase");
        Intrinsics.checkNotNullParameter((Object)androidVersion, (String)"androidVersion");
        Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"agpVersion");
        boolean isNewAGP = agpVersion.compareIgnoringQualifiers("7.0.0") >= 0;
        Object fieldName = isNewAGP && androidVersion.isPreview() ? fieldNameBase + "Preview" : (isNewAGP ? fieldNameBase : fieldNameBase + "Version");
        Object fieldValue = androidVersion.isPreview() ? "\"" + androidVersion.getApiString() + "\"" : androidVersion.getApiString();
        return (String)fieldName + " " + (String)fieldValue;
    }
}

