/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.fus;

import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModel;
import org.jetbrains.plugins.terminal.block.reworked.TerminalOutputModelListener;
import org.jetbrains.plugins.terminal.fus.ReworkedTerminalUsageCollector;
import org.jetbrains.plugins.terminal.fus.TerminalStartupFusInfo;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\u000f\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/terminal/frontend/fus/TerminalFusFirstOutputListener;", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModelListener;", "startupFusInfo", "Lorg/jetbrains/plugins/terminal/fus/TerminalStartupFusInfo;", "<init>", "(Lorg/jetbrains/plugins/terminal/fus/TerminalStartupFusInfo;)V", "reported", "", "afterContentChanged", "", "model", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalOutputModel;", "startOffset", "", "hasAnyMeaningfulText", "reportFirstOutputReceived", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalFusFirstOutputListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalFusFirstOutputListener.kt\ncom/intellij/terminal/frontend/fus/TerminalFusFirstOutputListener\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,30:1\n1088#2,2:31\n24#3:33\n*S KotlinDebug\n*F\n+ 1 TerminalFusFirstOutputListener.kt\ncom/intellij/terminal/frontend/fus/TerminalFusFirstOutputListener\n*L\n22#1:31,2\n28#1:33\n*E\n"})
public final class TerminalFusFirstOutputListener
implements TerminalOutputModelListener {
    @NotNull
    private final TerminalStartupFusInfo startupFusInfo;
    private boolean reported;

    public TerminalFusFirstOutputListener(@NotNull TerminalStartupFusInfo startupFusInfo) {
        Intrinsics.checkNotNullParameter((Object)startupFusInfo, (String)"startupFusInfo");
        this.startupFusInfo = startupFusInfo;
    }

    @Override
    public void afterContentChanged(@NotNull TerminalOutputModel model, int startOffset) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        if (!this.reported && this.hasAnyMeaningfulText(model)) {
            this.reportFirstOutputReceived();
            this.reported = true;
        }
    }

    private final boolean hasAnyMeaningfulText(TerminalOutputModel model) {
        boolean bl;
        block1: {
            CharSequence charSequence = model.getDocument().getCharsSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
            CharSequence $this$any$iv = charSequence;
            boolean $i$f$any = false;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl2 = false;
                if (!(!CharsKt.isWhitespace((char)it) && it != '%')) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final void reportFirstOutputReceived() {
        long latency = this.startupFusInfo.getTriggerTime().elapsedNow-UwyO8pc();
        ReworkedTerminalUsageCollector.INSTANCE.logStartupFirstOutputLatency-HG0u8IE(this.startupFusInfo.getWay(), latency);
        TerminalFusFirstOutputListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(TerminalFusFirstOutputListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("Reworked terminal startup first output latency: " + Duration.getInWholeMilliseconds-impl((long)latency) + " ms");
    }
}

