/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldContainCharSequence;
import org.assertj.core.error.ShouldEndWith;
import org.assertj.core.error.ShouldHaveCause;
import org.assertj.core.error.ShouldHaveCauseExactlyInstance;
import org.assertj.core.error.ShouldHaveCauseInstance;
import org.assertj.core.error.ShouldHaveCauseReference;
import org.assertj.core.error.ShouldHaveMessage;
import org.assertj.core.error.ShouldHaveMessageFindingMatchRegex;
import org.assertj.core.error.ShouldHaveMessageMatchingRegex;
import org.assertj.core.error.ShouldHaveNoCause;
import org.assertj.core.error.ShouldHaveNoSuppressedExceptions;
import org.assertj.core.error.ShouldHaveRootCause;
import org.assertj.core.error.ShouldHaveRootCauseExactlyInstance;
import org.assertj.core.error.ShouldHaveRootCauseInstance;
import org.assertj.core.error.ShouldHaveSuppressedException;
import org.assertj.core.error.ShouldNotContainCharSequence;
import org.assertj.core.error.ShouldStartWith;
import org.assertj.core.internal.CommonErrors;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.VisibleForTesting;

public class Throwables {
    private static final Throwables INSTANCE = new Throwables();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Throwables instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Throwables() {
    }

    public void assertHasMessage(AssertionInfo info, Throwable actual, String expectedMessage) {
        Throwables.assertNotNull(info, actual);
        if (java.util.Objects.equals(actual.getMessage(), expectedMessage)) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveMessage.shouldHaveMessage(actual, expectedMessage), actual.getMessage(), expectedMessage);
    }

    public void assertHasCause(AssertionInfo info, Throwable actual, Throwable expectedCause) {
        Throwables.assertNotNull(info, actual);
        Throwable actualCause = actual.getCause();
        if (actualCause == expectedCause) {
            return;
        }
        if (null == expectedCause) {
            this.assertHasNoCause(info, actual);
            return;
        }
        if (actualCause == null) {
            throw this.failures.failure(info, ShouldHaveCause.shouldHaveCause(actual, expectedCause));
        }
        if (!Throwables.compareThrowable(actualCause, expectedCause)) {
            throw this.failures.failure(info, ShouldHaveCause.shouldHaveCause(actual, expectedCause));
        }
    }

    public void assertHasCauseReference(AssertionInfo info, Throwable actual, Throwable expectedCause) {
        Throwables.assertNotNull(info, actual);
        Throwable actualCause = actual.getCause();
        if (actualCause != expectedCause) {
            throw this.failures.failure(info, ShouldHaveCauseReference.shouldHaveCauseReference(actualCause, expectedCause));
        }
    }

    public void assertHasRootCause(AssertionInfo info, Throwable actual, Throwable expectedRootCause) {
        Throwables.assertNotNull(info, actual);
        Throwable actualRootCause = org.assertj.core.util.Throwables.getRootCause(actual);
        if (actualRootCause == expectedRootCause) {
            return;
        }
        if (null == expectedRootCause) {
            this.assertHasNoCause(info, actual);
            return;
        }
        if (actualRootCause == null) {
            throw this.failures.failure(info, ShouldHaveRootCause.shouldHaveRootCause(actual, null, expectedRootCause));
        }
        if (!Throwables.compareThrowable(actualRootCause, expectedRootCause)) {
            throw this.failures.failure(info, ShouldHaveRootCause.shouldHaveRootCause(actual, actualRootCause, expectedRootCause));
        }
    }

    public void assertHasRootCauseMessage(AssertionInfo info, Throwable actual, String expectedMessage) {
        Throwables.assertNotNull(info, actual);
        Throwable rootCause = org.assertj.core.util.Throwables.getRootCause(actual);
        if (null == rootCause) {
            throw this.failures.failure(info, ShouldHaveRootCause.shouldHaveRootCauseWithMessage(actual, rootCause, expectedMessage));
        }
        if (java.util.Objects.equals(rootCause.getMessage(), expectedMessage)) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveRootCause.shouldHaveRootCauseWithMessage(actual, rootCause, expectedMessage), rootCause.getMessage(), expectedMessage);
    }

    public void assertHasNoCause(AssertionInfo info, Throwable actual) {
        Throwables.assertNotNull(info, actual);
        Throwable actualCause = actual.getCause();
        if (actualCause == null) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveNoCause.shouldHaveNoCause(actual));
    }

    public void assertHasCause(AssertionInfo info, Throwable actual) {
        Throwables.assertNotNull(info, actual);
        Throwable actualCause = actual.getCause();
        if (actualCause != null) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveCause.shouldHaveCause(actual));
    }

    public void assertHasRootCause(AssertionInfo info, Throwable actual) {
        Throwables.assertNotNull(info, actual);
        Throwable rootCause = org.assertj.core.util.Throwables.getRootCause(actual);
        if (rootCause != null) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveRootCause.shouldHaveRootCause(actual));
    }

    public void assertHasMessageStartingWith(AssertionInfo info, Throwable actual, String description) {
        Throwables.assertNotNull(info, actual);
        if (actual.getMessage() != null && actual.getMessage().startsWith(description)) {
            return;
        }
        throw this.failures.failure(info, ShouldStartWith.shouldStartWith(actual.getMessage(), description));
    }

    public void assertHasMessageContaining(AssertionInfo info, Throwable actual, String description) {
        Throwables.assertNotNull(info, actual);
        if (actual.getMessage() != null && actual.getMessage().contains(description)) {
            return;
        }
        throw this.failures.failure(info, ShouldContainCharSequence.shouldContain(actual, (CharSequence)description));
    }

    public void assertHasMessageContainingAll(AssertionInfo info, Throwable actual, CharSequence ... values) {
        Throwables.doCommonCheckForMessages(info, actual, values);
        Throwables.assertNotNull(info, actual);
        String actualMessage = actual.getMessage();
        Set notFound = Arrays.stream(values).filter(value2 -> actualMessage == null || !actualMessage.contains((CharSequence)value2)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (notFound.isEmpty()) {
            return;
        }
        if (notFound.size() == 1 && values.length == 1) {
            throw this.failures.failure(info, ShouldContainCharSequence.shouldContain(actual, values[0]), actual, values[0]);
        }
        throw this.failures.failure(info, ShouldContainCharSequence.shouldContain(actual, values, (Set<? extends CharSequence>)notFound), actual, values);
    }

    public void assertHasMessageNotContaining(AssertionInfo info, Throwable actual, String content) {
        Throwables.assertNotNull(info, actual);
        if (actual.getMessage() == null || !actual.getMessage().contains(content)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotContainCharSequence.shouldNotContain(actual, (CharSequence)content), actual.getMessage(), content);
    }

    public void assertHasMessageNotContainingAny(AssertionInfo info, Throwable actual, CharSequence ... values) {
        Throwables.doCommonCheckForMessages(info, actual, values);
        String actualMessage = actual.getMessage();
        Set found = Arrays.stream(values).filter(value2 -> actualMessage != null && actualMessage.contains((CharSequence)value2)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (found.isEmpty()) {
            return;
        }
        if (found.size() == 1 && values.length == 1) {
            throw this.failures.failure(info, ShouldNotContainCharSequence.shouldNotContain(actual, values[0]), actualMessage, values[0]);
        }
        throw this.failures.failure(info, ShouldNotContainCharSequence.shouldNotContain(actual, values, found), actualMessage, values);
    }

    public void assertHasStackTraceContaining(AssertionInfo info, Throwable actual, String description) {
        Throwables.assertNotNull(info, actual);
        String stackTrace = org.assertj.core.util.Throwables.getStackTrace(actual);
        if (stackTrace != null && stackTrace.contains(description)) {
            return;
        }
        throw this.failures.failure(info, ShouldContainCharSequence.shouldContain(stackTrace, (CharSequence)description));
    }

    public void assertHasMessageMatching(AssertionInfo info, Throwable actual, Pattern regex) {
        java.util.Objects.requireNonNull(regex, "regex must not be null");
        Throwables.assertNotNull(info, actual);
        if (actual.getMessage() != null && regex.matcher(actual.getMessage()).matches()) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveMessageMatchingRegex.shouldHaveMessageMatchingRegex(actual, regex.pattern()));
    }

    public void assertHasMessageMatching(AssertionInfo info, Throwable actual, String regex) {
        java.util.Objects.requireNonNull(regex, "regex must not be null");
        this.assertHasMessageMatching(info, actual, Pattern.compile(regex));
    }

    public void assertHasMessageFindingMatch(AssertionInfo info, Throwable actual, String regex) {
        java.util.Objects.requireNonNull(regex, "regex must not be null");
        Throwables.assertNotNull(info, actual);
        Objects.instance().assertNotNull(info, actual.getMessage(), "exception message of actual");
        if (Pattern.compile(regex, 32).asPredicate().test(actual.getMessage())) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveMessageFindingMatchRegex.shouldHaveMessageFindingMatchRegex(actual, regex));
    }

    public void assertHasMessageEndingWith(AssertionInfo info, Throwable actual, String description) {
        Throwables.assertNotNull(info, actual);
        if (actual.getMessage() != null && actual.getMessage().endsWith(description)) {
            return;
        }
        throw this.failures.failure(info, ShouldEndWith.shouldEndWith(actual.getMessage(), description));
    }

    public void assertHasCauseInstanceOf(AssertionInfo info, Throwable actual, Class<? extends Throwable> type) {
        Throwables.assertNotNull(info, actual);
        CommonValidations.checkTypeIsNotNull(type);
        if (type.isInstance(actual.getCause())) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveCauseInstance.shouldHaveCauseInstance(actual, type));
    }

    public void assertHasCauseExactlyInstanceOf(AssertionInfo info, Throwable actual, Class<? extends Throwable> type) {
        Throwables.assertNotNull(info, actual);
        CommonValidations.checkTypeIsNotNull(type);
        Throwable cause = actual.getCause();
        if (cause != null && type.equals(cause.getClass())) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveCauseExactlyInstance.shouldHaveCauseExactlyInstance(actual, type));
    }

    public void assertHasRootCauseInstanceOf(AssertionInfo info, Throwable actual, Class<? extends Throwable> type) {
        Throwables.assertNotNull(info, actual);
        CommonValidations.checkTypeIsNotNull(type);
        if (type.isInstance(org.assertj.core.util.Throwables.getRootCause(actual))) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveRootCauseInstance.shouldHaveRootCauseInstance(actual, type));
    }

    public void assertHasRootCauseExactlyInstanceOf(AssertionInfo info, Throwable actual, Class<? extends Throwable> type) {
        Throwables.assertNotNull(info, actual);
        CommonValidations.checkTypeIsNotNull(type);
        Throwable rootCause = org.assertj.core.util.Throwables.getRootCause(actual);
        if (rootCause != null && type.equals(rootCause.getClass())) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveRootCauseExactlyInstance.shouldHaveRootCauseExactlyInstance(actual, type));
    }

    public void assertHasNoSuppressedExceptions(AssertionInfo info, Throwable actual) {
        Throwables.assertNotNull(info, actual);
        Throwable[] suppressed = actual.getSuppressed();
        if (suppressed.length != 0) {
            throw this.failures.failure(info, ShouldHaveNoSuppressedExceptions.shouldHaveNoSuppressedExceptions(actual));
        }
    }

    public void assertHasSuppressedException(AssertionInfo info, Throwable actual, Throwable expectedSuppressedException) {
        Throwable[] suppressed;
        Throwables.assertNotNull(info, actual);
        java.util.Objects.requireNonNull(expectedSuppressedException, "The expected suppressed exception should not be null");
        for (Throwable throwable : suppressed = actual.getSuppressed()) {
            if (!Throwables.compareThrowable(throwable, expectedSuppressedException)) continue;
            return;
        }
        throw this.failures.failure(info, ShouldHaveSuppressedException.shouldHaveSuppressedException(actual, expectedSuppressedException));
    }

    private static void doCommonCheckForMessages(AssertionInfo info, Throwable actual, CharSequence[] values) {
        Throwables.assertNotNull(info, actual);
        Throwables.checkIsNotNull(values);
        Throwables.checkIsNotEmpty(values);
        Throwables.checkCharSequenceArrayDoesNotHaveNullElements(values);
    }

    private static void assertNotNull(AssertionInfo info, Throwable actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    private static void checkIsNotNull(CharSequence ... values) {
        if (values == null) {
            throw CommonErrors.arrayOfValuesToLookForIsNull();
        }
    }

    private static void checkIsNotEmpty(CharSequence ... values) {
        if (values.length == 0) {
            throw CommonErrors.arrayOfValuesToLookForIsEmpty();
        }
    }

    private static void checkCharSequenceArrayDoesNotHaveNullElements(CharSequence[] values) {
        if (values.length == 1) {
            Throwables.checkCharSequenceIsNotNull(values[0]);
        } else {
            for (int i2 = 0; i2 < values.length; ++i2) {
                java.util.Objects.requireNonNull(values[i2], "Expecting CharSequence elements not to be null but found one at index " + i2);
            }
        }
    }

    private static void checkCharSequenceIsNotNull(CharSequence sequence) {
        java.util.Objects.requireNonNull(sequence, "The char sequence to look for should not be null");
    }

    private static boolean compareThrowable(Throwable actual, Throwable expected) {
        return java.util.Objects.equals(actual.getMessage(), expected.getMessage()) && java.util.Objects.equals(actual.getClass(), expected.getClass());
    }
}

